/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.logging.Log;

class NMEAParser {
    private static final String DOLLAR_SIGN_GPGSA = "$GPGSA";
    private static final String DOLLAR_SIGN_GPGGA = "$GPGGA";
    private static final String DOLLAR_SIGN_GPRMC = "$GPRMC";
    public static final short OUTPUT_BUFFER_MAX_SIZE = 2048;
    private static final short MAX_SENTENCE_SIZE = 128;
    private static final byte SENTENCE_START = 36;
    private static final byte CHECKSUM_START = 42;
    private static final byte SENTENCE_END = 10;
    private static final byte DELIMITER = 44;
    public static final short TYPE_NOTHING_TO_PROCESS = -1;
    public static final short TYPE_NONE = 0;
    public static final short TYPE_GPRMC = 1;
    public static final short TYPE_GPGGA = 2;
    public static final short TYPE_GPGSA = 4;
    public static final short ALL_TYPES_MASK = 7;
    private byte[] data = new byte[2048];
    private int dataLength = 0;
    private GPSRecord record = new GPSRecord();
    private GPSRecord recordBuffer = null;

    private void append(byte[] output, int size) {
        if (this.dataLength + size >= this.data.length) {
            this.flush();
        }
        int start = 0;
        int length = size;
        if (size > this.data.length) {
            start = size - this.data.length;
            length = size - start;
        }
        System.arraycopy(output, start, this.data, this.dataLength, length);
        this.dataLength += size;
    }

    public void flush() {
        this.dataLength = 0;
    }

    public int parse(byte[] output, int size) {
        this.append(output, size);
        return this.doParse();
    }

    private int doParse() {
        int sentenceStart;
        int parsedSentenceTypes = 0;
        if (this.dataLength < 40) {
            return 0;
        }
        int currentIndex = this.dataLength - 1;
        boolean isLastSentence = true;
        int lastSentenceStart = -1;
        while (currentIndex > 0 && (sentenceStart = NMEAParser.lastIndexOf(this.data, (byte)36, currentIndex)) != -1) {
            int sentenceEnd = NMEAParser.indexOf(this.data, (byte)10, sentenceStart, this.dataLength);
            if (sentenceEnd != -1) {
                int sentenceTypeEnd = NMEAParser.indexOf(this.data, (byte)44, sentenceStart, sentenceEnd);
                if (sentenceTypeEnd != -1 && sentenceEnd <= currentIndex) {
                    try {
                        String type = new String(this.data, sentenceStart, sentenceTypeEnd - sentenceStart);
                        if (type.equals(DOLLAR_SIGN_GPRMC) && (parsedSentenceTypes & 1) == 0) {
                            parsedSentenceTypes |= this.processSentence(this.data, sentenceStart, sentenceEnd, (short)1);
                        } else if (type.equals(DOLLAR_SIGN_GPGGA) && (parsedSentenceTypes & 2) == 0) {
                            parsedSentenceTypes |= this.processSentence(this.data, sentenceStart, sentenceEnd, (short)2);
                        } else if (type.equals(DOLLAR_SIGN_GPGSA) && (parsedSentenceTypes & 4) == 0) {
                            parsedSentenceTypes |= this.processSentence(this.data, sentenceStart, sentenceEnd, (short)4);
                        }
                    }
                    catch (Throwable t) {
                        Log.warn("processSentence: dataLength=" + this.dataLength + ", Start=" + sentenceStart + ", End=" + sentenceEnd, t);
                        this.flush();
                        return parsedSentenceTypes;
                    }
                    currentIndex = sentenceStart - 1;
                    if (parsedSentenceTypes == 7) {
                        break;
                    }
                } else {
                    currentIndex = sentenceStart - 1;
                }
            } else {
                if (isLastSentence) {
                    lastSentenceStart = sentenceStart;
                }
                currentIndex = sentenceStart - 1;
            }
            isLastSentence = false;
        }
        if (lastSentenceStart < 0) {
            this.flush();
        } else {
            this.dataLength -= lastSentenceStart;
            System.arraycopy(this.data, lastSentenceStart, this.data, 0, this.dataLength);
        }
        if (parsedSentenceTypes != 0) {
            this.setRecordBuffer(this.record);
            this.record = new GPSRecord(this.record);
        }
        return parsedSentenceTypes;
    }

    protected static int indexOf(byte[] array, byte b, int fromIndex, int stopIndex) {
        for (int position = fromIndex; position < stopIndex; ++position) {
            if (array[position] != b) continue;
            return position;
        }
        return -1;
    }

    protected static int lastIndexOf(byte[] array, byte b, int fromIndex) {
        for (int position = fromIndex; position >= 0; --position) {
            if (array[position] != b) continue;
            return position;
        }
        return -1;
    }

    public synchronized GPSRecord getRecordBuffer() {
        return this.recordBuffer;
    }

    private synchronized void setRecordBuffer(GPSRecord record) {
        this.recordBuffer = record;
    }

    private short processSentence(byte[] data, int offset, int stop, short type) {
        short tokenIndex = 0;
        int tokenStart = 0;
        int checksum = 0;
        int sentChecksum = 0;
        if (stop - offset <= 128) {
            SentenceData sentenceData = this.contructSentenceData(type);
            for (int i = offset; i < stop; ++i) {
                byte character = data[i];
                if (character == 36) continue;
                if (character == 42) {
                    sentenceData.processToken(tokenIndex, data, tokenStart, i - tokenStart);
                    try {
                        String transmittedChecksum = new String(data, i + 1, 2);
                        sentChecksum = Integer.valueOf(transmittedChecksum, 16);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        return 0;
                    }
                }
                checksum ^= character;
                if (character != 44) continue;
                sentenceData.processToken(tokenIndex, data, tokenStart, i - tokenStart);
                tokenIndex = (short)(tokenIndex + 1);
                tokenStart = i + 1;
            }
            if (checksum == sentChecksum) {
                sentenceData.applySentenceData(this.record);
                return type;
            }
        }
        return 0;
    }

    private SentenceData contructSentenceData(int type) {
        switch (type) {
            case 1: {
                return new GPRMCRecord();
            }
            case 2: {
                return new GPGGARecord();
            }
            case 4: {
                return new GPGSARecord();
            }
        }
        return null;
    }

    private static final class GPRMCRecord
    implements SentenceData {
        public String date = null;
        public String secondsSinceMidnight = null;
        public String lattitude = null;
        public char lattitudeDirection;
        public String longitude = null;
        public char longitudeDirection;
        private String speed = null;
        private String course = null;

        private GPRMCRecord() {
        }

        public void processToken(short tokenIndex, byte[] data, int offset, int length) {
            switch (tokenIndex) {
                case 1: {
                    this.secondsSinceMidnight = new String(data, offset, length);
                    break;
                }
                case 3: {
                    this.lattitude = new String(data, offset, length);
                    break;
                }
                case 4: {
                    if (length <= 0) break;
                    this.lattitudeDirection = (char)data[offset];
                    break;
                }
                case 5: {
                    this.longitude = new String(data, offset, length);
                    break;
                }
                case 6: {
                    if (length <= 0) break;
                    this.longitudeDirection = (char)data[offset];
                    break;
                }
                case 7: {
                    this.speed = new String(data, offset, length);
                    break;
                }
                case 8: {
                    if (length <= 0) break;
                    this.course = new String(data, offset, length);
                    break;
                }
                case 9: {
                    if (length != 6) break;
                    this.date = new String(data, offset, length);
                }
            }
        }

        public void applySentenceData(GPSRecord record) {
            record.date = this.date;
            record.secondsSinceMidnight = this.secondsSinceMidnight;
            record.lattitude = this.lattitude;
            record.lattitudeDirection = this.lattitudeDirection;
            record.longitude = this.longitude;
            record.longitudeDirection = this.longitudeDirection;
            record.speed = this.speed;
            record.course = this.course;
        }
    }

    private static final class GPGGARecord
    implements SentenceData {
        public String quality = null;
        public String satelliteCount = null;
        public String altitude = null;

        private GPGGARecord() {
        }

        public void processToken(short tokenIndex, byte[] data, int offset, int length) {
            switch (tokenIndex) {
                case 6: {
                    this.quality = new String(data, offset, length);
                    break;
                }
                case 7: {
                    this.satelliteCount = new String(data, offset, length);
                    break;
                }
                case 9: {
                    this.altitude = length > 0 ? new String(data, offset, length) : null;
                }
            }
        }

        public void applySentenceData(GPSRecord record) {
            record.quality = this.quality;
            record.satelliteCount = this.satelliteCount;
            record.altitude = this.altitude;
        }
    }

    private static final class GPGSARecord
    implements SentenceData {
        public String hdop = null;
        public String vdop = null;

        private GPGSARecord() {
        }

        public void processToken(short tokenIndex, byte[] data, int offset, int length) {
            switch (tokenIndex) {
                case 16: {
                    this.hdop = new String(data, offset, length);
                    break;
                }
                case 17: {
                    this.vdop = new String(data, offset, length);
                }
            }
        }

        public void applySentenceData(GPSRecord record) {
            record.hdop = this.hdop;
            record.vdop = this.vdop;
        }
    }

    private static interface SentenceData {
        public void processToken(short var1, byte[] var2, int var3, int var4);

        public void applySentenceData(GPSRecord var1);
    }
}

