/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Menu;
import org.j4me.ui.MenuItem;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;
import org.j4me.ui.components.TextBox;

public class RadioButton
extends Component {
    private Label label;
    protected Vector choices = new Vector();
    protected int selected;
    private TextBox box = new TextBox();

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(label);
        }
        this.invalidate();
    }

    public int size() {
        return this.choices.size();
    }

    public String getString(int elementNum) {
        String value = (String)this.choices.elementAt(elementNum);
        return value;
    }

    public int append(String choice) {
        if (choice == null) {
            throw new IllegalArgumentException("Cannot append null choice");
        }
        this.choices.addElement(choice);
        return this.choices.size() - 1;
    }

    public void insert(int elementNum, String choice) {
        if (choice == null) {
            throw new IllegalArgumentException("Cannot insert null choice");
        }
        this.choices.insertElementAt(choice, elementNum);
    }

    public void delete(int elementNum) {
        this.choices.removeElementAt(elementNum);
    }

    public void deleteAll() {
        this.choices.removeAllElements();
    }

    public void set(int elementNum, String choice) {
        if (choice == null) {
            throw new IllegalArgumentException("Cannot set null choice");
        }
        this.choices.setElementAt(choice, elementNum);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public String getSelectedValue() {
        return this.getString(this.selected);
    }

    public void setSelectedIndex(int elementNum) {
        if (elementNum < 0 || elementNum >= this.choices.size()) {
            throw new IndexOutOfBoundsException("elementNum not a possible choice");
        }
        this.selected = elementNum;
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        this.box.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        this.box.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        if (this.size() == 0) {
            throw new IllegalStateException("RadioButton has no values");
        }
        int y = 0;
        if (this.label != null) {
            int labelHeight;
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(g, theme, this.getScreen(), 0, 0, width, height, selected);
            y = labelHeight = this.label.getHeight();
            height -= labelHeight;
        }
        String value = this.getSelectedValue();
        this.box.setString(value);
        this.box.paint(g, theme, this.getScreen(), 0, y, width, height, selected);
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int[] dimensions = this.box.getPreferredSize(theme, viewportWidth, viewportHeight);
        if (this.label != null) {
            int[] labelDimensions = this.label.getPreferredComponentSize(theme, viewportWidth, viewportHeight);
            dimensions[1] = dimensions[1] + labelDimensions[1];
        }
        return dimensions;
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -1 || keyCode == -6) {
            super.keyPressed(keyCode);
        } else {
            this.select();
        }
    }

    public void pointerPressed(int x, int y) {
        this.select();
    }

    protected void select() {
        Menu list = new Menu(this.getLabel(), this.getScreen());
        Enumeration e = this.choices.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            RadioItem item = new RadioItem(name, index);
            list.appendMenuOption(item);
            ++index;
        }
        int highlight = this.getSelectedIndex();
        list.setSelected(highlight);
        list.show();
    }

    private final class RadioItem
    implements MenuItem {
        private final String text;
        private final int index;

        public RadioItem(String choice, int index) {
            this.text = choice;
            this.index = index;
        }

        public String getText() {
            return this.text;
        }

        public void onSelection() {
            RadioButton.this.setSelectedIndex(this.index);
            DeviceScreen screen = RadioButton.this.getScreen();
            screen.show();
            screen.repaint();
        }
    }
}

