/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;

public class TextStyle {
    public Font font;
    public Color foreground;
    public Color background;
    public boolean underline;
    public boolean strikeout;
    public GlyphMetrics metrics;
    public int rise;

    public TextStyle(Font font, Color color, Color color2) {
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.foreground = color;
        this.background = color2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TextStyle)) {
            return false;
        }
        TextStyle textStyle = (TextStyle)object;
        if (this.foreground != null ? !this.foreground.equals(textStyle.foreground) : textStyle.foreground != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(textStyle.background) : textStyle.background != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(textStyle.font) : textStyle.font != null) {
            return false;
        }
        if (this.metrics != null || textStyle.metrics != null) {
            return false;
        }
        if (this.underline != textStyle.underline) {
            return false;
        }
        if (this.strikeout != textStyle.strikeout) {
            return false;
        }
        return this.rise == textStyle.rise;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.foreground != null) {
            n2 ^= this.foreground.hashCode();
        }
        if (this.background != null) {
            n2 ^= this.background.hashCode();
        }
        if (this.font != null) {
            n2 ^= this.font.hashCode();
        }
        if (this.metrics != null) {
            n2 ^= this.metrics.hashCode();
        }
        if (this.underline) {
            n2 ^= n2;
        }
        if (this.strikeout) {
            n2 ^= n2;
        }
        return n2 ^= this.rise;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TextStyle {");
        int n2 = stringBuffer.length();
        if (this.font != null) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("font=");
            stringBuffer.append(this.font);
        }
        if (this.foreground != null) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("foreground=");
            stringBuffer.append(this.foreground);
        }
        if (this.background != null) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("background=");
            stringBuffer.append(this.background);
        }
        if (this.underline) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("underlined");
        }
        if (this.strikeout) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("striked out");
        }
        if (this.rise != 0) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("rise=");
            stringBuffer.append(this.rise);
        }
        if (this.metrics != null) {
            if (stringBuffer.length() > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("metrics=");
            stringBuffer.append(this.metrics);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

