/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPLACEMENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class Decorations
extends Canvas {
    Image image;
    Image smallImage;
    Image largeImage;
    Image[] images;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int swFlags;
    int hAccel;
    int nAccel;
    boolean moved;
    boolean resized;
    boolean opened;
    int oldX = Integer.MIN_VALUE;
    int oldY = Integer.MIN_VALUE;
    int oldWidth = Integer.MIN_VALUE;
    int oldHeight = Integer.MIN_VALUE;

    Decorations() {
    }

    public Decorations(Composite composite, int n2) {
        super(composite, Decorations.checkStyle(n2));
    }

    void _setMaximized(boolean bl2) {
        int n2 = this.swFlags = bl2 ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        if (OS.IsWinCE) {
            if (bl2) {
                int n3;
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                int n4 = rECT.right - rECT.left;
                int n5 = rECT.bottom - rECT.top;
                if (OS.IsPPC && this.menuBar != null) {
                    n3 = this.menuBar.hwndCB;
                    RECT rECT2 = new RECT();
                    OS.GetWindowRect(n3, rECT2);
                    n5 -= rECT2.bottom - rECT2.top;
                }
                n3 = 52;
                this.SetWindowPos(this.handle, 0, rECT.left, rECT.top, n4, n5, n3);
            }
        } else {
            if (!OS.IsWindowVisible(this.handle)) {
                return;
            }
            if (bl2 == OS.IsZoomed(this.handle)) {
                return;
            }
            OS.ShowWindow(this.handle, this.swFlags);
            OS.UpdateWindow(this.handle);
        }
    }

    void _setMinimized(boolean bl2) {
        if (OS.IsWinCE) {
            return;
        }
        int n2 = this.swFlags = bl2 ? 7 : OS.SW_RESTORE;
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl2 == OS.IsIconic(this.handle)) {
            return;
        }
        int n3 = this.swFlags;
        if (n3 == 7 && this.handle == OS.GetActiveWindow()) {
            n3 = 6;
        }
        OS.ShowWindow(this.handle, n3);
        OS.UpdateWindow(this.handle);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int n2 = 0;
        while (n2 < this.menus.length) {
            if (this.menus[n2] == null) {
                this.menus[n2] = menu;
                return;
            }
            ++n2;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void bringToTop() {
        OS.BringWindowToTop(this.handle);
    }

    static int checkStyle(int n2) {
        if ((n2 & 8) != 0) {
            n2 &= 0xFFFFF30F;
        }
        if (OS.IsWinCE) {
            if ((n2 & 0x80) != 0) {
                n2 &= 0xFFFFFF7F;
            }
            if ((n2 & 0x400) != 0) {
                n2 &= 0xFFFFFBFF;
            }
            return n2;
        }
        if ((n2 & 0x4C0) != 0) {
            n2 |= 0x20;
        }
        if ((n2 & 0x480) != 0) {
            n2 |= 0x40;
        }
        if ((n2 & 0x40) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    void checkBorder() {
    }

    void checkOpened() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefMDIChildProc(n2, n3, n4, n5);
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    int compare(ImageData imageData, ImageData imageData2, int n2, int n3, int n4) {
        int n5;
        int n6 = Math.abs(imageData.width - n2);
        if (n6 == (n5 = Math.abs(imageData2.width - n2))) {
            int n7;
            int n8 = imageData.getTransparencyType();
            if (n8 == (n7 = imageData2.getTransparencyType())) {
                if (imageData.depth == imageData2.depth) {
                    return 0;
                }
                return imageData.depth > imageData2.depth && imageData.depth <= n4 ? -1 : 1;
            }
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                if (n8 == 1) {
                    return -1;
                }
                if (n7 == 1) {
                    return 1;
                }
            }
            if (n8 == 2) {
                return -1;
            }
            if (n7 == 2) {
                return 1;
            }
            if (n8 == 4) {
                return -1;
            }
            if (n7 == 4) {
                return 1;
            }
            return 0;
        }
        return n6 < n5 ? -1 : 1;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n6 = OS.GetWindowLong(this.handle, -16);
        int n7 = OS.GetWindowLong(this.handle, -20);
        boolean bl2 = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
        OS.AdjustWindowRectEx(rECT, n6, bl2, n7);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        if (bl2) {
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
            OS.SendMessage(this.handle, 131, 0, rECT2);
            while (rECT2.bottom - rECT2.top < n5) {
                if (rECT2.bottom - rECT2.top == 0) break;
                rECT.top -= OS.GetSystemMetrics(15) - OS.GetSystemMetrics(6);
                OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
                OS.SendMessage(this.handle, 131, 0, rECT2);
            }
        }
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    void createAccelerators() {
        this.nAccel = 0;
        this.hAccel = 0;
        int n2 = 0;
        MenuItem[] menuItemArray = this.display.items;
        if (this.menuBar == null || menuItemArray == null) {
            if (!OS.IsPPC) {
                return;
            }
            n2 = 1;
        } else {
            n2 = OS.IsPPC ? menuItemArray.length + 1 : menuItemArray.length;
        }
        ACCEL aCCEL = new ACCEL();
        byte[] byArray = new byte[ACCEL.sizeof];
        byte[] byArray2 = new byte[n2 * ACCEL.sizeof];
        if (this.menuBar != null && menuItemArray != null) {
            int n3 = 0;
            while (n3 < menuItemArray.length) {
                MenuItem menuItem = menuItemArray[n3];
                if (menuItem != null && menuItem.accelerator != 0) {
                    Menu menu = menuItem.parent;
                    if (menu.parent == this) {
                        while (menu != null && menu != this.menuBar) {
                            menu = menu.getParentMenu();
                        }
                        if (menu == this.menuBar) {
                            menuItem.fillAccel(aCCEL);
                            OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
                            System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
                            ++this.nAccel;
                        }
                    }
                }
                ++n3;
            }
        }
        if (OS.IsPPC) {
            aCCEL.fVirt = (byte)9;
            aCCEL.key = (short)81;
            aCCEL.cmd = 1;
            OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
            System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
            ++this.nAccel;
        }
        if (this.nAccel != 0) {
            this.hAccel = OS.CreateAcceleratorTable(byArray2, this.nAccel);
        }
    }

    void createHandle() {
        super.createHandle();
        if (this.parent != null || (this.style & 4) != 0) {
            this.setParent();
            this.setSystemMenu();
        }
        if ((this.state & 0x4000) == 0 && !OS.IsWinCE) {
            int n2 = OS.LoadIcon(0, 32512);
            OS.SendMessage(this.handle, 128, 0, n2);
        }
    }

    void createWidget() {
        super.createWidget();
        this.swFlags = OS.IsWinCE ? OS.SW_SHOWMAXIMIZED : 4;
        this.hAccel = -1;
    }

    void destroyAccelerators() {
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!(this instanceof Shell)) {
            if (!this.traverseDecorations(true)) {
                Shell shell = this.getShell();
                shell.setFocus();
            }
            this.setVisible(false);
        }
        super.dispose();
    }

    Menu findMenu(int n2) {
        if (this.menus == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.menus.length) {
            Menu menu = this.menus[n3];
            if (menu != null && n2 == menu.handle) {
                return menu;
            }
            ++n3;
        }
        return null;
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int n2 = 0;
            while (n2 < menuArray.length) {
                if (menuArray[n2] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++n2;
            }
            menu.fixMenus(decorations);
            this.destroyAccelerators();
            decorations.destroyAccelerators();
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            int n2 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n3 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Rectangle(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top, n2, n3);
        }
        return super.getBounds();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (OS.IsHPC) {
            Rectangle rectangle = super.getClientArea();
            if (this.menuBar != null) {
                int n2 = this.menuBar.hwndCB;
                int n3 = OS.CommandBar_Height(n2);
                rectangle.y += n3;
                rectangle.height = Math.max(0, rectangle.height - n3);
            }
            return rectangle;
        }
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            int n4 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n5 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            if (this.horizontalBar != null) {
                n4 -= OS.GetSystemMetrics(3);
            }
            if (this.verticalBar != null) {
                n5 -= OS.GetSystemMetrics(2);
            }
            RECT rECT = new RECT();
            int n6 = OS.GetWindowLong(this.handle, -16);
            int n7 = OS.GetWindowLong(this.handle, -20);
            boolean bl2 = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
            OS.AdjustWindowRectEx(rECT, n6, bl2, n7);
            n4 = Math.max(0, n4 - (rECT.right - rECT.left));
            n5 = Math.max(0, n5 - (rECT.bottom - rECT.top));
            return new Rectangle(0, 0, n4, n5);
        }
        return super.getClientArea();
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            return new Point(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top);
        }
        return super.getLocation();
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return this.swFlags == OS.SW_SHOWMAXIMIZED;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsZoomed(this.handle);
        }
        return this.swFlags == OS.SW_SHOWMAXIMIZED;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsIconic(this.handle);
        }
        return this.swFlags == 7;
    }

    String getNameText() {
        return this.getText();
    }

    public Point getSize() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            int n2 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n3 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Point(n2, n3);
        }
        return super.getSize();
    }

    public String getText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(0, n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        return tCHAR.toString(0, n2);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean bl2) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl2);
        if (this.menus != null) {
            int n2 = 0;
            while (n2 < this.menus.length) {
                Menu menu = this.menus[n2];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++n2;
            }
            this.menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.image = null;
        this.largeImage = null;
        this.smallImage = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.menus.length) {
            if (this.menus[n2] == menu) {
                this.menus[n2] = null;
                return;
            }
            ++n2;
        }
    }

    boolean restoreFocus() {
        if (this.display.ignoreRestoreFocus) {
            return true;
        }
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        return this.savedFocus != null && this.savedFocus.setSavedFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    void setBounds(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        if (OS.IsWinCE) {
            this.swFlags = OS.SW_RESTORE;
        } else if (OS.IsIconic(this.handle)) {
            this.setPlacement(n2, n3, n4, n5, n6);
            return;
        }
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        boolean bl3 = true;
        if ((2 & n6) == 0) {
            boolean bl4 = bl3 = rECT.left == n2 && rECT.top == n3;
            if (!bl3) {
                this.moved = true;
            }
        }
        boolean bl5 = true;
        if ((1 & n6) == 0) {
            boolean bl6 = bl5 = rECT.right - rECT.left == n4 && rECT.bottom - rECT.top == n5;
            if (!bl5) {
                this.resized = true;
            }
        }
        if (!OS.IsWinCE && OS.IsZoomed(this.handle)) {
            if (bl3 && bl5) {
                return;
            }
            this.setPlacement(n2, n3, n4, n5, n6);
            this._setMaximized(false);
            return;
        }
        super.setBounds(n2, n3, n4, n5, n6, bl2);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl2) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl2) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (bl2) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.setImages(image, null);
    }

    void setImages(Image image, Image[] imageArray) {
        int n2;
        if (OS.IsWinCE) {
            return;
        }
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.largeImage = null;
        this.smallImage = null;
        int n3 = 0;
        int n4 = 0;
        Image image2 = null;
        Image image3 = null;
        if (image != null) {
            image2 = image3 = image;
        } else if (imageArray != null && imageArray.length > 0) {
            n2 = this.display.getIconDepth();
            ImageData[] imageDataArray = null;
            if (imageArray.length > 1) {
                Image[] imageArray2 = new Image[imageArray.length];
                System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
                imageDataArray = new ImageData[imageArray.length];
                int n5 = 0;
                while (n5 < imageDataArray.length) {
                    imageDataArray[n5] = imageArray[n5].getImageData();
                    ++n5;
                }
                imageArray = imageArray2;
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(49), OS.GetSystemMetrics(50), n2);
            }
            image2 = imageArray[0];
            if (imageArray.length > 1) {
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(11), OS.GetSystemMetrics(12), n2);
            }
            image3 = imageArray[0];
        }
        if (image2 != null) {
            switch (image2.type) {
                case 0: {
                    this.smallImage = Display.createIcon(image2);
                    n3 = this.smallImage.handle;
                    break;
                }
                case 1: {
                    n3 = image2.handle;
                }
            }
        } else if ((this.state & 0x4000) == 0) {
            n3 = OS.LoadIcon(0, 32512);
        }
        OS.SendMessage(this.handle, 128, 0, n3);
        if (image3 != null) {
            switch (image3.type) {
                case 0: {
                    this.largeImage = Display.createIcon(image3);
                    n4 = this.largeImage.handle;
                    break;
                }
                case 1: {
                    n4 = image3.handle;
                }
            }
        }
        OS.SendMessage(this.handle, 128, 1, n4);
        if (!OS.IsWinCE && n3 == 0 && n4 == 0 && (this.style & 0x800) != 0) {
            n2 = 1025;
            OS.RedrawWindow(this.handle, null, 0, n2);
        }
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        int n2 = 0;
        while (n2 < imageArray.length) {
            if (imageArray[n2] == null || imageArray[n2].isDisposed()) {
                this.error(5);
            }
            ++n2;
        }
        this.images = imageArray;
        this.setImages(null, imageArray);
    }

    public void setMaximized(boolean bl2) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMaximized(bl2);
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (OS.IsWinCE) {
            if (OS.IsHPC) {
                boolean bl2;
                boolean bl3 = bl2 = this.menuBar != menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, false);
                }
                this.menuBar = menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, true);
                }
                if (bl2) {
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(true, false);
                    }
                }
            } else {
                if (OS.IsPPC) {
                    boolean bl4;
                    boolean bl5 = bl4 = this.getMaximized() && this.menuBar != menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                    if (bl4) {
                        this._setMaximized(true);
                    }
                }
                if (OS.IsSP) {
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                }
            }
        } else {
            if (menu != null) {
                this.display.removeBar(menu);
            }
            this.menuBar = menu;
            int n2 = this.menuBar != null ? this.menuBar.handle : 0;
            OS.SetMenu(this.handle, n2);
        }
        this.destroyAccelerators();
    }

    public void setMinimized(boolean bl2) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMinimized(bl2);
    }

    void setParent() {
        int n2 = this.parent.handle;
        this.display.lockActiveWindow = true;
        OS.SetParent(this.handle, n2);
        if (!OS.IsWindowVisible(n2)) {
            OS.ShowWindow(this.handle, 8);
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        OS.SetWindowLong(this.handle, -16, (n3 &= 0xBFFFFFFF) | Integer.MIN_VALUE);
        OS.SetWindowLong(this.handle, -12, 0);
        int n4 = 19;
        this.SetWindowPos(this.handle, 1, 0, 0, 0, 0, n4);
        this.display.lockActiveWindow = false;
    }

    void setPlacement(int n2, int n3, int n4, int n5, int n6) {
        WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
        wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
        OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
        wINDOWPLACEMENT.showCmd = 8;
        if (OS.IsIconic(this.handle)) {
            wINDOWPLACEMENT.showCmd = 7;
        } else if (OS.IsZoomed(this.handle)) {
            wINDOWPLACEMENT.showCmd = OS.SW_SHOWMAXIMIZED;
        }
        boolean bl2 = true;
        if ((n6 & 2) == 0) {
            bl2 = wINDOWPLACEMENT.left != n2 || wINDOWPLACEMENT.top != n3;
            wINDOWPLACEMENT.right = n2 + (wINDOWPLACEMENT.right - wINDOWPLACEMENT.left);
            wINDOWPLACEMENT.bottom = n3 + (wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top);
            wINDOWPLACEMENT.left = n2;
            wINDOWPLACEMENT.top = n3;
        }
        boolean bl3 = true;
        if ((n6 & 1) == 0) {
            bl3 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left != n4 || wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top != n5;
            wINDOWPLACEMENT.right = wINDOWPLACEMENT.left + n4;
            wINDOWPLACEMENT.bottom = wINDOWPLACEMENT.top + n5;
        }
        OS.SetWindowPlacement(this.handle, wINDOWPLACEMENT);
        if (OS.IsIconic(this.handle)) {
            SerializableCompatibility serializableCompatibility;
            if (bl2) {
                this.moved = true;
                serializableCompatibility = this.getLocation();
                this.oldX = serializableCompatibility.x;
                this.oldY = serializableCompatibility.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (bl3) {
                this.resized = true;
                serializableCompatibility = this.getClientArea();
                this.oldWidth = ((Rectangle)serializableCompatibility).width;
                this.oldHeight = ((Rectangle)serializableCompatibility).height;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(true, false);
                }
            }
        }
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    void setSystemMenu() {
        if (OS.IsWinCE) {
            return;
        }
        int n2 = OS.GetSystemMenu(this.handle, false);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.GetMenuItemCount(n2);
        if ((this.style & 0x10) == 0) {
            OS.DeleteMenu(n2, 61440, 0);
        }
        if ((this.style & 0x80) == 0) {
            OS.DeleteMenu(n2, 61472, 0);
        }
        if ((this.style & 0x400) == 0) {
            OS.DeleteMenu(n2, 61488, 0);
        }
        if ((this.style & 0x480) == 0) {
            OS.DeleteMenu(n2, 61728, 0);
        }
        int n4 = OS.GetMenuItemCount(n2);
        if ((this.style & 0x40) == 0 || n4 != n3) {
            OS.DeleteMenu(n2, 61744, 0);
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 2;
            int n5 = 0;
            while (n5 < n4) {
                if (OS.GetMenuItemInfo(n2, n5, true, mENUITEMINFO) && mENUITEMINFO.wID == 61536) break;
                ++n5;
            }
            if (n5 != n4) {
                OS.DeleteMenu(n2, n5 - 1, 1024);
                if ((this.style & 0x40) == 0) {
                    OS.DeleteMenu(n2, 61536, 0);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        if (this.drawCount != 0 ? (this.state & 0x10) == 0 == bl2 : bl2 == OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl2) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            if (OS.IsHPC && this.menuBar != null) {
                int n2 = this.menuBar.hwndCB;
                OS.CommandBar_DrawMenuBar(n2, 0);
            }
            if (this.drawCount != 0) {
                this.state &= 0xFFFFFFEF;
            } else {
                if (OS.IsWinCE) {
                    OS.ShowWindow(this.handle, 5);
                } else {
                    STARTUPINFO sTARTUPINFO;
                    if (this.menuBar != null) {
                        this.display.removeBar(this.menuBar);
                        OS.DrawMenuBar(this.handle);
                    }
                    if ((sTARTUPINFO = Display.lpStartupInfo) != null && (sTARTUPINFO.dwFlags & 1) != 0) {
                        OS.ShowWindow(this.handle, sTARTUPINFO.wShowWindow);
                    } else {
                        OS.ShowWindow(this.handle, this.swFlags);
                    }
                }
                if (this.isDisposed()) {
                    return;
                }
                this.opened = true;
                if (!this.moved) {
                    this.moved = true;
                    Point point = this.getLocation();
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
                if (!this.resized) {
                    this.resized = true;
                    Rectangle rectangle = this.getClientArea();
                    this.oldWidth = rectangle.width;
                    this.oldHeight = rectangle.height;
                }
                OS.UpdateWindow(this.handle);
            }
        } else {
            if (!OS.IsWinCE) {
                this.swFlags = OS.IsIconic(this.handle) ? 7 : (OS.IsZoomed(this.handle) ? OS.SW_SHOWMAXIMIZED : (this.handle == OS.GetActiveWindow() ? OS.SW_RESTORE : 4));
            }
            if (this.drawCount != 0) {
                this.state |= 0x10;
            } else {
                OS.ShowWindow(this.handle, 0);
            }
            if (this.isDisposed()) {
                return;
            }
            this.sendEvent(23);
        }
    }

    void sort(Image[] imageArray, ImageData[] imageDataArray, int n2, int n3, int n4) {
        int n5 = imageArray.length;
        if (n5 <= 1) {
            return;
        }
        int n6 = n5 / 2;
        while (n6 > 0) {
            int n7 = n6;
            while (n7 < n5) {
                int n8 = n7 - n6;
                while (n8 >= 0) {
                    if (this.compare(imageDataArray[n8], imageDataArray[n8 + n6], n2, n3, n4) >= 0) {
                        Image image = imageArray[n8];
                        imageArray[n8] = imageArray[n8 + n6];
                        imageArray[n8 + n6] = image;
                        ImageData imageData = imageDataArray[n8];
                        imageDataArray[n8] = imageDataArray[n8 + n6];
                        imageDataArray[n8 + n6] = imageData;
                    }
                    n8 -= n6;
                }
                ++n7;
            }
            n6 /= 2;
        }
    }

    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        if (this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG)) {
            return true;
        }
        Decorations decorations = this.parent.menuShell();
        return decorations.translateAccelerator(mSG);
    }

    boolean translateMenuAccelerator(MSG mSG) {
        if (this.hAccel == -1) {
            this.createAccelerators();
        }
        return this.hAccel != 0 && OS.TranslateAccelerator(this.handle, this.hAccel, mSG) != 0;
    }

    boolean translateMDIAccelerator(MSG mSG) {
        if (!(this instanceof Shell)) {
            Shell shell = this.getShell();
            int n2 = shell.hwndMDIClient;
            if (n2 != 0 && OS.TranslateMDISysAccel(n2, mSG)) {
                return true;
            }
            if (mSG.message == 256) {
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(this.handle, 16, 0, 0);
                        return true;
                    }
                    case 117: {
                        if (!this.traverseDecorations(true)) break;
                        return true;
                    }
                }
                return false;
            }
            if (mSG.message == 260) {
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(shell.handle, 16, 0, 0);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    boolean traverseDecorations(boolean bl2) {
        Control[] controlArray = this.parent._getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (controlArray[n3] == this) break;
            ++n3;
        }
        int n4 = n3;
        int n5 = bl2 ? 1 : -1;
        while ((n3 = (n3 + n5 + n2) % n2) != n4) {
            Control control = controlArray[n3];
            if (control.isDisposed() || !(control instanceof Decorations) || !control.setFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseItem(boolean bl2) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }

    CREATESTRUCT widgetCreateStruct() {
        return new CREATESTRUCT();
    }

    int widgetExtStyle() {
        int n2 = super.widgetExtStyle() | 0x40;
        n2 &= 0xFFFFFDFF;
        if ((this.style & 8) != 0) {
            return n2;
        }
        if (OS.IsPPC && (this.style & 0x40) != 0) {
            n2 |= Integer.MIN_VALUE;
        }
        if ((this.style & 0x10) != 0) {
            return n2;
        }
        if ((this.style & 0x800) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    int widgetParent() {
        Shell shell = this.getShell();
        return shell.hwndMDIClient();
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() & 0xEFFEFFFF;
        n2 &= 0xFF7FFFFF;
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 0x20) != 0) {
            n2 |= 0xC00000;
        }
        if ((this.style & 0x80) != 0) {
            n2 |= OS.WS_MINIMIZEBOX;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= OS.WS_MAXIMIZEBOX;
        }
        if ((this.style & 0x10) != 0) {
            if (!OS.IsPPC) {
                n2 |= 0x40000;
            }
        } else if ((this.style & 0x800) == 0) {
            n2 |= 0x800000;
        }
        if (!OS.IsPPC && !OS.IsSP && (this.style & 0x40) != 0) {
            n2 |= 0x80000;
        }
        return n2;
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32768: 
            case 32769: {
                if (this.hAccel == -1) {
                    this.createAccelerators();
                }
                return n3 == 32768 ? this.nAccel : this.hAccel;
            }
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    LRESULT WM_ACTIVATE(int n2, int n3) {
        Object object;
        LRESULT lRESULT = super.WM_ACTIVATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetParent(n3) == this.handle) {
            object = new TCHAR(0, 128);
            OS.GetClassName(n3, (TCHAR)object, ((TCHAR)object).length());
            String string = ((TCHAR)object).toString(0, ((TCHAR)object).strlen());
            if (string.equals("SunAwtWindow")) {
                return LRESULT.ZERO;
            }
        }
        if ((n2 & 0xFFFF) != 0) {
            if (n2 >> 16 != 0) {
                return lRESULT;
            }
            object = this.display.findControl(n3);
            if ((object == null || object instanceof Shell) && this instanceof Shell) {
                this.sendEvent(26);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            if (this.restoreFocus()) {
                return LRESULT.ZERO;
            }
        } else {
            Control control;
            object = this.display;
            boolean bl2 = ((Display)object).isXMouseActive();
            if (bl2) {
                ((Display)object).lockActiveWindow = true;
            }
            if (((control = ((Display)object).findControl(n3)) == null || control instanceof Shell) && this instanceof Shell) {
                this.sendEvent(27);
                if (!this.isDisposed()) {
                    Shell shell = this.getShell();
                    shell.setActiveControl(null);
                }
            }
            if (bl2) {
                ((Display)object).lockActiveWindow = false;
            }
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.saveFocus();
        }
        return lRESULT;
    }

    LRESULT WM_CLOSE(int n2, int n3) {
        LRESULT lRESULT = super.WM_CLOSE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.isEnabled() && this.isActive()) {
            this.closeWidget();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_HOTKEY(int n2, int n3) {
        LRESULT lRESULT = super.WM_HOTKEY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsSP && (n3 >> 16 & 0xFFFF) == 27) {
            if ((this.style & 0x40) != 0) {
                OS.PostMessage(this.handle, 16, 0, 0);
            } else {
                OS.SHSendBackToFocusWindow(786, n2, n3);
            }
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        this.saveFocus();
        return lRESULT;
    }

    LRESULT WM_MOVE(int n2, int n3) {
        if (this.moved) {
            Point point = this.getLocation();
            if (point.x == this.oldX && point.y == this.oldY) {
                return null;
            }
            this.oldX = point.x;
            this.oldY = point.y;
        }
        return super.WM_MOVE(n2, n3);
    }

    LRESULT WM_NCACTIVATE(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCACTIVATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n2 == 0) {
            if (this.display.lockActiveWindow) {
                return LRESULT.ZERO;
            }
            Control control = this.display.findControl(n3);
            if (control != null) {
                Shell shell = this.getShell();
                Decorations decorations = control.menuShell();
                if (decorations.getShell() == shell) {
                    if (this instanceof Shell) {
                        return LRESULT.ONE;
                    }
                    if (this.display.ignoreRestoreFocus && this.display.lastHittest != 1) {
                        lRESULT = LRESULT.ONE;
                    }
                }
            }
        }
        if (!(this instanceof Shell)) {
            int n4 = this.getShell().handle;
            OS.SendMessage(n4, 134, n2, n3);
        }
        return lRESULT;
    }

    LRESULT WM_QUERYOPEN(int n2, int n3) {
        LRESULT lRESULT = super.WM_QUERYOPEN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.sendEvent(20);
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.savedFocus != this) {
            this.restoreFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = null;
        boolean bl2 = true;
        if (this.resized) {
            int n4 = 0;
            int n5 = 0;
            switch (n2) {
                case 0: 
                case 2: {
                    n4 = n3 & 0xFFFF;
                    n5 = n3 >> 16;
                    break;
                }
                case 1: {
                    Rectangle rectangle = this.getClientArea();
                    n4 = rectangle.width;
                    n5 = rectangle.height;
                }
            }
            boolean bl3 = bl2 = n4 != this.oldWidth || n5 != this.oldHeight;
            if (bl2) {
                this.oldWidth = n4;
                this.oldHeight = n5;
            }
        }
        if (bl2) {
            lRESULT = super.WM_SIZE(n2, n3);
            if (this.isDisposed()) {
                return lRESULT;
            }
        }
        if (n2 == 1) {
            this.sendEvent(19);
        }
        return lRESULT;
    }

    LRESULT WM_SYSCOMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!(this instanceof Shell)) {
            int n4 = n2 & 0xFFF0;
            switch (n4) {
                case 61536: {
                    OS.PostMessage(this.handle, 16, 0, 0);
                    return LRESULT.ZERO;
                }
                case 61504: {
                    this.traverseDecorations(true);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.display.lockActiveWindow) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
            wINDOWPOS.flags |= 4;
            OS.MoveMemory(n3, wINDOWPOS, WINDOWPOS.sizeof);
        }
        return lRESULT;
    }
}

