/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class Label
extends Control {
    String text = "";
    Image image;
    static final int MARGIN = 4;
    static final boolean IMAGE_AND_TEXT = false;
    static final int LabelProc;
    static final TCHAR LabelClass;

    static {
        LabelClass = new TCHAR(0, "STATIC", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, LabelClass, wNDCLASS);
        LabelProc = wNDCLASS.lpfnWndProc;
    }

    public Label(Composite composite, int n2) {
        super(composite, Label.checkStyle(n2));
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(LabelProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        if (((n2 |= 0x80000) & 2) != 0) {
            n2 = Label.checkBits(n2, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n2, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        boolean bl3;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getBorderWidth();
        if ((this.style & 2) != 0) {
            int n7 = OS.GetSystemMetrics(5);
            if ((this.style & 0x100) != 0) {
                n4 = 64;
                n5 = n7 * 2;
            } else {
                n4 = n7 * 2;
                n5 = 64;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            if (n3 != -1) {
                n5 = n3;
            }
            return new Point(n4 += n6 * 2, n5 += n6 * 2);
        }
        int n8 = OS.GetWindowLong(this.handle, -16);
        boolean bl4 = true;
        boolean bl5 = bl3 = (n8 & 0xD) == 13;
        if (bl3 && this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            n4 += rectangle.width;
            n5 += rectangle.height;
            bl4 = false;
        }
        if (bl4) {
            int n9 = OS.GetDC(this.handle);
            int n10 = OS.SendMessage(this.handle, 49, 0, 0);
            int n11 = OS.SelectObject(n9, n10);
            int n12 = OS.GetWindowTextLength(this.handle);
            if (n12 == 0) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n9, tEXTMETRIC);
                n5 = Math.max(n5, tEXTMETRIC.tmHeight);
            } else {
                RECT rECT = new RECT();
                int n13 = 9280;
                if ((this.style & 0x40) != 0 && n2 != -1) {
                    n13 |= 0x10;
                    rECT.right = Math.max(0, n2 - n4);
                }
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n12 + 1);
                OS.GetWindowText(this.handle, tCHAR, n12 + 1);
                OS.DrawText(n9, tCHAR, n12, rECT, n13);
                n4 += rECT.right - rECT.left;
                n5 = Math.max(n5, rECT.bottom - rECT.top);
            }
            if (n10 != 0) {
                OS.SelectObject(n9, n11);
            }
            OS.ReleaseDC(this.handle, n9);
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        n4 += n6 * 2;
        n5 += n6 * 2;
        if (OS.IsWinCE && !bl3) {
            n4 += 2;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean mnemonicHit(char c2) {
        Composite composite = this.parent;
        while (composite != null) {
            Control[] controlArray = composite._getChildren();
            int n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] == this) break;
                ++n2;
            }
            if (++n2 < controlArray.length && controlArray[n2].setFocus()) {
                return true;
            }
            composite = composite.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char c2) {
        char c3 = this.findMnemonic(this.getText());
        if (c3 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0xD) != 13) {
            n3 &= 0xFFFFFFF0;
            if ((this.style & 0x4000) != 0) {
                n3 = (this.style & 0x40) != 0 ? (n3 |= 0) : (n3 |= 0xC);
            }
            if ((this.style & 0x1000000) != 0) {
                n3 |= 1;
            }
            if ((this.style & 0x20000) != 0) {
                n3 |= 2;
            }
            OS.SetWindowLong(this.handle, -16, n3);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0xD) != 13) {
            n2 &= 0xFFFFFFF0;
            OS.SetWindowLong(this.handle, -16, n2 |= 0xD);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (this.image != null) {
            // empty if block
        }
        int n3 = n2 = OS.GetWindowLong(this.handle, -16);
        n3 &= 0xFFFFFFF2;
        if ((this.style & 0x4000) != 0) {
            n3 = (this.style & 0x40) != 0 ? (n3 |= 0) : (n3 |= 0xC);
        }
        if ((this.style & 0x1000000) != 0) {
            n3 |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n3 |= 2;
        }
        if (n2 != n3) {
            OS.SetWindowLong(this.handle, -16, n3);
        }
        string = Display.withCrLf(string);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || this.findImageControl() == null)) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    int widgetExtStyle() {
        int n2 = super.widgetExtStyle() & 0xFFFFFDFF;
        if ((this.style & 0x800) != 0) {
            return n2 | 0x20000;
        }
        return n2;
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x100;
        if ((this.style & 2) != 0) {
            return n2 | 0xD;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(5, 0) && (this.style & 0x40) != 0) {
            n2 |= 0x2000;
        }
        if ((this.style & 0x1000000) != 0) {
            return n2 | 1;
        }
        if ((this.style & 0x20000) != 0) {
            return n2 | 2;
        }
        if ((this.style & 0x40) != 0) {
            return n2;
        }
        return n2 | 0xC;
    }

    TCHAR windowClass() {
        return LabelClass;
    }

    int windowProc() {
        return LabelProc;
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = OS.GetWindowLong(this.handle, -16);
        if ((n4 & 0xD) == 13) {
            return LRESULT.ONE;
        }
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || this.findImageControl() == null)) {
            this.drawBackground(n2);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        int n4 = OS.GetWindowLong(this.handle, -16);
        if ((n4 & 0xD) == 13) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        if ((n4 & 0xC) != 12) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n2, n3);
        boolean bl3 = bl2 = this.findImageControl() != null;
        if (!bl2 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            boolean bl4 = bl2 = this.findThemeControl() != null;
        }
        if (bl2) {
            OS.InvalidateRect(this.handle, null, false);
            int n4 = OS.DefWindowProc(this.handle, 296, n2, n3);
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    LRESULT wmColorChild(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.wmColorChild(n2, n3);
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || ((n4 = OS.GetWindowLong(this.handle, -16)) & 0xD) == 13 || this.findImageControl() == null)) {
            OS.SetBkMode(n2, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return lRESULT;
    }

    LRESULT WM_PAINT(int n2, int n3) {
        if (OS.IsWinCE) {
            boolean bl2;
            boolean bl3 = this.image != null;
            boolean bl4 = bl2 = (this.style & 2) != 0 && (this.style & 0x20) == 0;
            if (bl3 || bl2) {
                LRESULT lRESULT = null;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                GC gC = this.new_GC(gCData);
                if (gC != null) {
                    int n4;
                    Object object;
                    this.drawBackground(gC.handle);
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    if (bl2) {
                        int n5;
                        object = new RECT();
                        n4 = OS.GetSystemMetrics(5);
                        int n6 = n5 = (this.style & 4) != 0 ? 10 : 6;
                        if ((this.style & 0x100) != 0) {
                            int n7 = rECT.top + Math.max(n4 * 2, (rECT.bottom - rECT.top) / 2);
                            OS.SetRect((RECT)object, rECT.left, rECT.top, rECT.right, n7);
                            OS.DrawEdge(gC.handle, (RECT)object, n5, 8);
                        } else {
                            int n8 = rECT.left + Math.max(n4 * 2, (rECT.right - rECT.left) / 2);
                            OS.SetRect((RECT)object, rECT.left, rECT.top, n8, rECT.bottom);
                            OS.DrawEdge(gC.handle, (RECT)object, n5, 4);
                        }
                        lRESULT = LRESULT.ONE;
                    }
                    if (bl3) {
                        object = this.image.getBounds();
                        n4 = 0;
                        if ((this.style & 0x1000000) != 0) {
                            n4 = Math.max(0, (rECT.right - ((Rectangle)object).width) / 2);
                        } else if ((this.style & 0x20000) != 0) {
                            n4 = Math.max(0, rECT.right - ((Rectangle)object).width);
                        }
                        gC.drawImage(this.image, n4, Math.max(0, (rECT.bottom - ((Rectangle)object).height) / 2));
                        lRESULT = LRESULT.ONE;
                    }
                    int n9 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                    n4 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                    if (n9 != 0 && n4 != 0) {
                        Event event = new Event();
                        event.gc = gC;
                        event.x = pAINTSTRUCT.left;
                        event.y = pAINTSTRUCT.top;
                        event.width = n9;
                        event.height = n4;
                        this.sendEvent(9, event);
                        event.gc = null;
                    }
                    gC.dispose();
                }
                return lRESULT;
            }
        }
        return super.WM_PAINT(n2, n3);
    }

    LRESULT wmDrawChild(int n2, int n3) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n3, DRAWITEMSTRUCT.sizeof);
        this.drawBackground(dRAWITEMSTRUCT.hDC);
        if ((this.style & 2) != 0) {
            int n4;
            if ((this.style & 0x20) != 0) {
                return null;
            }
            RECT rECT = new RECT();
            int n5 = OS.GetSystemMetrics(5);
            int n6 = n4 = (this.style & 4) != 0 ? 10 : 6;
            if ((this.style & 0x100) != 0) {
                int n7 = dRAWITEMSTRUCT.top + Math.max(n5 * 2, (dRAWITEMSTRUCT.bottom - dRAWITEMSTRUCT.top) / 2);
                OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, n7);
                OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n4, 8);
            } else {
                int n8 = dRAWITEMSTRUCT.left + Math.max(n5 * 2, (dRAWITEMSTRUCT.right - dRAWITEMSTRUCT.left) / 2);
                OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, n8, dRAWITEMSTRUCT.bottom);
                OS.DrawEdge(dRAWITEMSTRUCT.hDC, rECT, n4, 4);
            }
        } else {
            int n9 = dRAWITEMSTRUCT.right - dRAWITEMSTRUCT.left;
            int n10 = dRAWITEMSTRUCT.bottom - dRAWITEMSTRUCT.top;
            if (n9 != 0 && n10 != 0) {
                Object object;
                boolean bl2 = this.image != null;
                boolean bl3 = false;
                int n11 = bl3 && bl2 ? 4 : 0;
                int n12 = 0;
                int n13 = 0;
                if (bl2) {
                    object = this.image.getBounds();
                    n12 = ((Rectangle)object).width;
                    n13 = ((Rectangle)object).height;
                }
                object = null;
                TCHAR tCHAR = null;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                if (bl3) {
                    object = new RECT();
                    n16 = 9280;
                    if ((this.style & 0x4000) != 0) {
                        n16 |= 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        n16 |= 1;
                    }
                    if ((this.style & 0x20000) != 0) {
                        n16 |= 2;
                    }
                    if ((this.style & 0x40) != 0) {
                        n16 |= 0x10;
                        ((RECT)object).right = Math.max(0, n9 - n12 - n11);
                    }
                    tCHAR = new TCHAR(this.getCodePage(), this.text, true);
                    OS.DrawText(dRAWITEMSTRUCT.hDC, tCHAR, -1, (RECT)object, n16);
                    n14 = ((RECT)object).right - ((RECT)object).left;
                    n15 = ((RECT)object).bottom - ((RECT)object).top;
                }
                int n17 = 0;
                if ((this.style & 0x1000000) != 0) {
                    n17 = Math.max(0, (n9 - n12 - n14 - n11) / 2);
                } else if ((this.style & 0x20000) != 0) {
                    n17 = n9 - n12 - n14 - n11;
                }
                if (bl2) {
                    GCData gCData = new GCData();
                    gCData.device = this.display;
                    GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
                    Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
                    gC.drawImage(image, n17, Math.max(0, (n10 - n13) / 2));
                    if (image != this.image) {
                        image.dispose();
                    }
                    gC.dispose();
                    n17 += n12 + n11;
                }
                if (bl3) {
                    ((RECT)object).left = n17;
                    ((RECT)object).right += ((RECT)object).left;
                    ((RECT)object).top = Math.max(0, (n10 - n15) / 2);
                    ((RECT)object).bottom += ((RECT)object).top;
                    OS.DrawText(dRAWITEMSTRUCT.hDC, tCHAR, -1, (RECT)object, n16 &= 0xFFFFFBFF);
                }
            }
        }
        return null;
    }
}

