/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMUPDOWN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.UDACCEL;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int hwndText;
    int hwndUpDown;
    boolean ignoreModify;
    int pageIncrement;
    int digits;
    static final int EditProc;
    static final TCHAR EditClass;
    static final int UpDownProc;
    static final TCHAR UpDownClass;

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        UpDownClass = new TCHAR(0, "msctls_updown32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, EditClass, wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0, UpDownClass, wNDCLASS);
        UpDownProc = wNDCLASS.lpfnWndProc;
    }

    public Spinner(Composite composite, int n2) {
        super(composite, Spinner.checkStyle(n2));
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 == this.hwndText) {
            return OS.CallWindowProc(EditProc, n2, n3, n4, n5);
        }
        if (n2 == this.hwndUpDown) {
            return OS.CallWindowProc(UpDownProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(this.handle, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return n2 & 0xFFFFFCFF;
    }

    boolean checkHandle(int n2) {
        return n2 == this.handle || n2 == this.hwndText || n2 == this.hwndUpDown;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        int n2 = OS.GetModuleHandle(null);
        int n3 = (this.style & 0x800) != 0 ? 512 : 0;
        int n4 = 1409286272;
        if ((this.style & 8) != 0) {
            n4 |= 0x800;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            n3 |= 0x400000;
        }
        this.hwndText = OS.CreateWindowEx(n3, EditClass, null, n4, 0, 0, 0, 0, this.handle, 0, n2, null);
        if (this.hwndText == 0) {
            this.error(2);
        }
        OS.SetWindowLong(this.hwndText, -12, this.hwndText);
        int n5 = 0x50000010;
        if ((this.style & 0x40) != 0) {
            n5 |= 1;
        }
        if ((this.style & 0x800) != 0) {
            n5 = (this.style & 0x4000000) != 0 ? (n5 |= 8) : (n5 |= 4);
        }
        this.hwndUpDown = OS.CreateWindowEx(0, UpDownClass, null, n5, 0, 0, 0, 0, this.handle, 0, n2, null);
        if (this.hwndUpDown == 0) {
            this.error(2);
        }
        int n6 = 19;
        this.SetWindowPos(this.hwndText, this.hwndUpDown, 0, 0, 0, 0, n6);
        OS.SetWindowLong(this.hwndUpDown, -12, this.hwndUpDown);
        if (OS.IsDBLocale) {
            int n7 = OS.ImmGetContext(this.handle);
            OS.ImmAssociateContext(this.hwndText, n7);
            OS.ImmAssociateContext(this.hwndUpDown, n7);
            OS.ImmReleaseContext(this.handle, n7);
        }
        OS.SendMessage(this.hwndUpDown, 1135, 0, 100);
        OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0, 0);
        this.pageIncrement = 10;
        this.digits = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), "0", true);
        OS.SetWindowText(this.hwndText, tCHAR);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    int borderHandle() {
        return this.hwndText;
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        if (n2 == -1 || n3 == -1) {
            int n7;
            Object object;
            n4 = 0;
            int n8 = OS.GetDC(this.hwndText);
            int n9 = OS.SendMessage(this.hwndText, 49, 0, 0);
            if (n9 != 0) {
                n4 = OS.SelectObject(n8, n9);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n8, tEXTMETRIC);
            n6 = tEXTMETRIC.tmHeight;
            RECT rECT = new RECT();
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
            String string = String.valueOf(nArray[0]);
            if (this.digits > 0) {
                object = new StringBuffer();
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(this.getDecimalSeparator());
                n7 = this.digits - string.length();
                while (n7 >= 0) {
                    ((StringBuffer)object).append("0");
                    --n7;
                }
                string = ((StringBuffer)object).toString();
            }
            object = new TCHAR(this.getCodePage(), string, false);
            n7 = 11264;
            OS.DrawText(n8, (TCHAR)object, ((TCHAR)object).length(), rECT, n7);
            n5 = rECT.right - rECT.left;
            if (n9 != 0) {
                OS.SelectObject(n8, n4);
            }
            OS.ReleaseDC(this.hwndText, n8);
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n6 = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n5, n6);
        if (n3 == -1) {
            n4 = OS.GetSystemMetrics(20) + 2 * this.getBorderWidth();
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n4 += (this.style & 0x800) != 0 ? 1 : 3;
            }
            rectangle.height = Math.max(rectangle.height, n4);
        }
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n6 = OS.GetWindowLong(this.hwndText, -16);
        int n7 = OS.GetWindowLong(this.hwndText, -20);
        OS.AdjustWindowRectEx(rECT, n6, false, n7);
        n4 = rECT.right - rECT.left;
        n5 = rECT.bottom - rECT.top;
        int n8 = OS.SendMessage(this.hwndText, 212, 0, 0);
        n2 -= n8 & 0xFFFF;
        n4 += (n8 & 0xFFFF) + (n8 >> 16 & 0xFFFF);
        if ((this.style & 0x800) != 0) {
            --n2;
            --n3;
            n4 += 2;
            n5 += 2;
        }
        return new Rectangle(n2, n3, n4 += OS.GetSystemMetrics(2), n5);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.hwndText, 769, 0, 0);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        OS.EnableWindow(this.hwndText, bl2);
        OS.EnableWindow(this.hwndUpDown, bl2);
    }

    void deregister() {
        super.deregister();
        this.display.removeControl(this.hwndText);
        this.display.removeControl(this.hwndUpDown);
    }

    boolean hasFocus() {
        int n2 = OS.GetFocus();
        if (n2 == this.handle) {
            return true;
        }
        if (n2 == this.hwndText) {
            return true;
        }
        return n2 == this.hwndUpDown;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n2 = OS.GetLocaleInfo(1024, 14, tCHAR, 4);
        return n2 != 0 ? tCHAR.toString(0, n2 - 1) : ".";
    }

    public int getIncrement() {
        this.checkWidget();
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1, uDACCEL);
        return uDACCEL.nInc;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        return nArray[0];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        return nArray[0];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF;
        }
        return OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
    }

    int getSelectionText() {
        int n2 = OS.GetWindowTextLength(this.hwndText);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.hwndText, tCHAR, n2 + 1);
        String string = tCHAR.toString(0, n2);
        try {
            int n3;
            Object object;
            if (this.digits > 0) {
                object = this.getDecimalSeparator();
                int n4 = string.indexOf((String)object);
                if (n4 != -1) {
                    int n5;
                    int n6;
                    String string2 = string.substring(0, n4);
                    String string3 = string.substring(n4 + 1);
                    if (string3.length() > this.digits) {
                        string3 = string3.substring(0, this.digits);
                    } else {
                        n6 = this.digits - string3.length();
                        n5 = 0;
                        while (n5 < n6) {
                            string3 = String.valueOf(string3) + "0";
                            ++n5;
                        }
                    }
                    n6 = Integer.parseInt(string2);
                    n5 = Integer.parseInt(string3);
                    int n7 = 0;
                    while (n7 < this.digits) {
                        n6 *= 10;
                        ++n7;
                    }
                    n3 = n6 + n5;
                } else {
                    n3 = Integer.parseInt(string);
                }
            } else {
                n3 = Integer.parseInt(string);
            }
            object = new int[1];
            int[] nArray = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray, (int[])object);
            if (nArray[0] <= n3 && n3 <= object[0]) {
                return n3;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    int mbcsToWcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = OS.GetWindowTextLengthA(this.hwndText);
        if (n3 == 0) {
            return 0;
        }
        if (n2 >= n3) {
            return n3;
        }
        byte[] byArray = new byte[n3 + 1];
        OS.GetWindowTextA(this.hwndText, byArray, n3 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n2, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.hwndText, 770, 0, 0);
    }

    void register() {
        super.register();
        this.display.addControl(this.hwndText, this);
        this.display.addControl(this.hwndUpDown, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndUpDown = 0;
        this.hwndText = 0;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n2, n3, n4, n5, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n2 != 1) {
            return true;
        }
        if (n3 != 258 && n3 != 256 && n3 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        char c2 = event.character;
        int n6 = event.stateMask;
        switch (n3) {
            case 258: {
                if (c2 != '\b' && c2 != '\u007f' && c2 != '\r' && c2 != '\t' && c2 != '\n') break;
            }
            case 256: {
                if ((n6 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndText, 176, nArray, nArray2);
        switch (c2) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n7 = OS.GetWindowTextLength(this.hwndText);
                if (nArray[0] == n7) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(this.hwndText, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n7);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c2 != '\t' && c2 < ' ') {
                    return true;
                }
                string = new String(new char[]{c2});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(this.hwndText, 177, nArray[0], nArray2[0]);
        OS.SendMessage(this.hwndText, 194, 0, (TCHAR)object);
        return false;
    }

    void setBackgroundImage(int n2) {
        super.setBackgroundImage(n2);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    void setBackgroundPixel(int n2) {
        super.setBackgroundPixel(n2);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setDigits(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(5);
        }
        if (n2 == this.digits) {
            return;
        }
        this.digits = n2;
        int n3 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        this.setSelection(n3, false, true, false);
    }

    void setForegroundPixel(int n2) {
        super.setForegroundPixel(n2);
        OS.InvalidateRect(this.hwndText, null, true);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = OS.GetProcessHeap();
        int n4 = OS.SendMessage(this.hwndUpDown, 1132, 0, null);
        int n5 = OS.HeapAlloc(n3, 8, UDACCEL.sizeof * n4);
        OS.SendMessage(this.hwndUpDown, 1132, n4, n5);
        int n6 = -1;
        UDACCEL uDACCEL = new UDACCEL();
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * UDACCEL.sizeof;
            OS.MoveMemory(uDACCEL, n8, UDACCEL.sizeof);
            if (n6 == -1) {
                n6 = uDACCEL.nInc;
            }
            uDACCEL.nInc = uDACCEL.nInc * n2 / n6;
            OS.MoveMemory(n8, uDACCEL, UDACCEL.sizeof);
            ++n7;
        }
        OS.SendMessage(this.hwndUpDown, 1131, n4, n5);
        OS.HeapFree(n3, 0, n5);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray, null);
        if (n2 <= nArray[0]) {
            return;
        }
        int n3 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        OS.SendMessage(this.hwndUpDown, 1135, nArray[0], n2);
        if (n3 > n2) {
            this.setSelection(n2, true, true, false);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, null, nArray);
        if (n2 >= nArray[0]) {
            return;
        }
        int n3 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
        OS.SendMessage(this.hwndUpDown, 1135, n2, nArray[0]);
        if (n3 < n2) {
            this.setSelection(n2, true, true, false);
        }
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
        n2 = Math.min(Math.max(nArray2[0], n2), nArray[0]);
        this.setSelection(n2, true, true, false);
    }

    void setSelection(int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            OS.SendMessage(this.hwndUpDown, OS.IsWinCE ? 1127 : 1137, 0, n2);
        }
        if (bl3) {
            int n3;
            Object object;
            String string = String.valueOf(n2);
            if (this.digits > 0) {
                object = this.getDecimalSeparator();
                int n4 = string.length() - this.digits;
                StringBuffer stringBuffer = new StringBuffer();
                if (n4 > 0) {
                    stringBuffer.append(string.substring(0, n4));
                    stringBuffer.append((String)object);
                    stringBuffer.append(string.substring(n4));
                } else {
                    stringBuffer.append("0");
                    stringBuffer.append((String)object);
                    while (n4++ < 0) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                string = stringBuffer.toString();
            }
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n3 = OS.GetWindowTextLength(this.hwndText), null)) == null) {
                return;
            }
            object = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.hwndText, (TCHAR)object);
        }
        if (bl4) {
            this.postEvent(13);
        }
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.hwndText, string);
        shell.setToolTipText(this.hwndUpDown, string);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 <= n3) {
            return;
        }
        if (n5 < 0) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        n2 = Math.min(Math.max(n3, n2), n4);
        this.setIncrement(n6);
        this.pageIncrement = n7;
        this.digits = n5;
        OS.SendMessage(this.hwndUpDown, 1135, n3, n4);
        this.setSelection(n2, true, true, false);
    }

    void subclass() {
        super.subclass();
        int n2 = this.display.windowProc;
        OS.SetWindowLong(this.hwndText, -4, n2);
        OS.SetWindowLong(this.hwndUpDown, -4, n2);
    }

    void unsubclass() {
        super.unsubclass();
        OS.SetWindowLong(this.hwndText, -4, EditProc);
        OS.SetWindowLong(this.hwndUpDown, -4, UpDownProc);
    }

    String verifyText(String string, int n2, int n3, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        int n4 = 0;
        if (this.digits > 0) {
            String string2 = this.getDecimalSeparator();
            n4 = string.indexOf(string2);
            if (n4 != -1) {
                string = String.valueOf(string.substring(0, n4)) + string.substring(n4 + 1);
            }
            n4 = 0;
        }
        while (n4 < string.length()) {
            if (!Character.isDigit(string.charAt(n4))) break;
            ++n4;
        }
        boolean bl2 = event2.doit = n4 == string.length();
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n2);
            event2.end = this.mbcsToWcsPos(n3);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFFFFDFF;
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        if (n2 == this.hwndText || n2 == this.hwndUpDown) {
            LRESULT lRESULT = null;
            switch (n3) {
                case 258: {
                    lRESULT = this.wmChar(n2, n4, n5);
                    break;
                }
                case 646: {
                    lRESULT = this.wmIMEChar(n2, n4, n5);
                    break;
                }
                case 256: {
                    lRESULT = this.wmKeyDown(n2, n4, n5);
                    break;
                }
                case 257: {
                    lRESULT = this.wmKeyUp(n2, n4, n5);
                    break;
                }
                case 262: {
                    lRESULT = this.wmSysChar(n2, n4, n5);
                    break;
                }
                case 260: {
                    lRESULT = this.wmSysKeyDown(n2, n4, n5);
                    break;
                }
                case 261: {
                    lRESULT = this.wmSysKeyUp(n2, n4, n5);
                    break;
                }
                case 533: {
                    lRESULT = this.wmCaptureChanged(n2, n4, n5);
                    break;
                }
                case 515: {
                    lRESULT = this.wmLButtonDblClk(n2, n4, n5);
                    break;
                }
                case 513: {
                    lRESULT = this.wmLButtonDown(n2, n4, n5);
                    break;
                }
                case 514: {
                    lRESULT = this.wmLButtonUp(n2, n4, n5);
                    break;
                }
                case 521: {
                    lRESULT = this.wmMButtonDblClk(n2, n4, n5);
                    break;
                }
                case 519: {
                    lRESULT = this.wmMButtonDown(n2, n4, n5);
                    break;
                }
                case 520: {
                    lRESULT = this.wmMButtonUp(n2, n4, n5);
                    break;
                }
                case 673: {
                    lRESULT = this.wmMouseHover(n2, n4, n5);
                    break;
                }
                case 675: {
                    lRESULT = this.wmMouseLeave(n2, n4, n5);
                    break;
                }
                case 512: {
                    lRESULT = this.wmMouseMove(n2, n4, n5);
                    break;
                }
                case 518: {
                    lRESULT = this.wmRButtonDblClk(n2, n4, n5);
                    break;
                }
                case 516: {
                    lRESULT = this.wmRButtonDown(n2, n4, n5);
                    break;
                }
                case 517: {
                    lRESULT = this.wmRButtonUp(n2, n4, n5);
                    break;
                }
                case 525: {
                    lRESULT = this.wmXButtonDblClk(n2, n4, n5);
                    break;
                }
                case 523: {
                    lRESULT = this.wmXButtonDown(n2, n4, n5);
                    break;
                }
                case 524: {
                    lRESULT = this.wmXButtonUp(n2, n4, n5);
                    break;
                }
                case 7: {
                    lRESULT = this.wmSetFocus(n2, n4, n5);
                    break;
                }
                case 8: {
                    lRESULT = this.wmKillFocus(n2, n4, n5);
                    break;
                }
                case 15: {
                    lRESULT = this.wmPaint(n2, n4, n5);
                    break;
                }
                case 791: {
                    lRESULT = this.wmPrint(n2, n4, n5);
                    break;
                }
                case 123: {
                    lRESULT = this.wmContextMenu(n2, n4, n5);
                    break;
                }
                case 199: 
                case 768: 
                case 770: 
                case 771: 
                case 772: {
                    if (n2 != this.hwndText) break;
                    lRESULT = this.wmClipboard(n2, n3, n4, n5);
                }
            }
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(n2, n3, n4, n5);
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        super.WM_ERASEBKGND(n2, n3);
        this.drawBackground(n2);
        return LRESULT.ONE;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        return null;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        OS.SetFocus(this.hwndText);
        return null;
    }

    LRESULT WM_SETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.SendMessage(this.hwndText, 48, n2, n3);
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n4 = n3 & 0xFFFF;
        int n5 = n3 >> 16;
        int n6 = OS.GetSystemMetrics(2);
        int n7 = n4 - n6;
        int n8 = OS.GetSystemMetrics(45);
        int n9 = 52;
        this.SetWindowPos(this.hwndText, 0, 0, 0, n7 + n8, n5, n9);
        this.SetWindowPos(this.hwndUpDown, 0, n7, 0, n6, n5, n9);
        return lRESULT;
    }

    LRESULT wmChar(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmChar(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n3) {
            case 13: {
                this.postEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n2, int n3, int n4, int n5) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        boolean bl2 = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n3) {
            case 768: 
            case 771: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl2 = true;
                break;
            }
            case 770: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n2, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.SendMessage(n2, 176, nArray, nArray2);
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                int n6 = OS.GetWindowTextLength(n2);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n2, 176, (int[])object, nArray3);
                if (n6 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n6 + 1);
                    OS.GetWindowText(n2, tCHAR, n6 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                this.ignoreModify = false;
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl2) {
                    OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n3 == 12) {
                    int n7 = OS.GetProcessHeap();
                    int n8 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n9 = OS.HeapAlloc(n7, 8, n8);
                    OS.MoveMemory(n9, (TCHAR)object, n8);
                    int n10 = OS.CallWindowProc(EditProc, n2, n3, n4, n9);
                    OS.HeapFree(n7, 0, n9);
                    return new LRESULT(n10);
                }
                OS.SendMessage(n2, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = n2 >> 16;
        switch (n4) {
            case 768: {
                int n5;
                if (this.ignoreModify) break;
                int n6 = this.getSelectionText();
                if (n6 != -1 && (n5 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0)) != n6) {
                    this.setSelection(n6, true, false, true);
                }
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    LRESULT wmKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage(this.hwndUpDown, 1132, 1, uDACCEL);
        int n5 = 0;
        switch (n3) {
            case 38: {
                n5 = uDACCEL.nInc;
                break;
            }
            case 40: {
                n5 = -uDACCEL.nInc;
                break;
            }
            case 33: {
                n5 = this.pageIncrement;
                break;
            }
            case 34: {
                n5 = -this.pageIncrement;
            }
        }
        if (n5 != 0) {
            int n6 = this.getSelectionText();
            if (n6 != -1) {
                n6 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
            }
            int n7 = n6 + n5;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
            if ((this.style & 0x40) != 0) {
                if (n7 < nArray2[0]) {
                    n7 = nArray[0];
                }
                if (n7 > nArray[0]) {
                    n7 = nArray2[0];
                }
            }
            if (n6 != (n7 = Math.min(Math.max(nArray2[0], n7), nArray[0]))) {
                this.setSelection(n7, true, true, true);
            }
        }
        switch (n3) {
            case 38: 
            case 40: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmKillFocus(int n2, int n3, int n4) {
        int n5 = this.getSelectionText();
        if (n5 == -1) {
            n5 = OS.IsWinCE ? OS.SendMessage(this.hwndUpDown, 1128, 0, 0) & 0xFFFF : OS.SendMessage(this.hwndUpDown, 1138, 0, 0);
            this.setSelection(n5, false, true, false);
        }
        return super.wmKillFocus(n2, n3, n4);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -722: {
                NMUPDOWN nMUPDOWN = new NMUPDOWN();
                OS.MoveMemory(nMUPDOWN, n3, NMUPDOWN.sizeof);
                int n4 = nMUPDOWN.iPos + nMUPDOWN.iDelta;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(this.hwndUpDown, 1136, nArray2, nArray);
                if ((this.style & 0x40) != 0) {
                    if (n4 < nArray2[0]) {
                        n4 = nArray[0];
                    }
                    if (n4 > nArray[0]) {
                        n4 = nArray2[0];
                    }
                }
                if ((n4 = Math.min(Math.max(nArray2[0], n4), nArray[0])) != nMUPDOWN.iPos) {
                    this.setSelection(n4, true, true, true);
                }
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    LRESULT wmScrollChild(int n2, int n3) {
        int n4 = n2 & 0xFFFF;
        switch (n4) {
            case 4: {
                this.postEvent(13);
            }
        }
        return super.wmScrollChild(n2, n3);
    }
}

