/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;

    public Synchronizer(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock runnableLock) {
        boolean bl2 = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] runnableLockArray = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, runnableLockArray, 0, this.messageCount);
                this.messages = runnableLockArray;
            }
            this.messages[this.messageCount++] = runnableLock;
            bl2 = this.messageCount == 1;
        }
        if (bl2) {
            this.display.wakeThread();
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCount() {
        Object object = this.messageLock;
        synchronized (object) {
            return this.messageCount;
        }
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            block5: {
                if (this.messageCount != 0) break block5;
                return null;
            }
            RunnableLock runnableLock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 64) {
                this.messages = null;
            }
            return runnableLock;
        }
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runAsyncMessages(boolean bl2) {
        boolean bl3 = false;
        do {
            RunnableLock runnableLock;
            if ((runnableLock = this.removeFirst()) == null) {
                return bl3;
            }
            bl3 = true;
            RunnableLock runnableLock2 = runnableLock;
            synchronized (runnableLock2) {
                Object var6_6;
                this.syncThread = runnableLock.thread;
                try {
                    try {
                        runnableLock.run();
                    }
                    catch (Throwable throwable) {
                        runnableLock.throwable = throwable;
                        SWT.error(46, throwable);
                    }
                    var6_6 = null;
                    this.syncThread = null;
                    runnableLock.notifyAll();
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    this.syncThread = null;
                    runnableLock.notifyAll();
                    throw throwable;
                }
            }
        } while (bl2);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        if (this.display.isValidThread()) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        if (runnable == null) {
            this.display.wake();
            return;
        }
        RunnableLock runnableLock = new RunnableLock(runnable);
        runnableLock.thread = Thread.currentThread();
        RunnableLock runnableLock2 = runnableLock;
        synchronized (runnableLock2) {
            this.addLast(runnableLock);
            boolean bl2 = false;
            while (!runnableLock.done()) {
                try {
                    runnableLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Compatibility.interrupt();
            }
            if (runnableLock.throwable != null) {
                SWT.error(46, runnableLock.throwable);
            }
        }
    }
}

