/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "SliderUI";
    private boolean paintTicks = false;
    private boolean paintTrack = true;
    private boolean paintLabels = false;
    private boolean isInverted = false;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks = false;
    boolean snapToValue = true;
    protected int orientation;
    private Dictionary labelTable;
    protected ChangeListener changeListener = this.createChangeListener();
    protected transient ChangeEvent changeEvent = null;

    public int getExtent() {
        return this.getModel().getExtent();
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public JSlider() {
        this(0, 0, 100, 50);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? JSlider.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    protected void updateLabelUIs() {
        if (this.getLabelTable() == null) {
            return;
        }
        Enumeration enumeration = this.getLabelTable().keys();
        while (enumeration.hasMoreElements()) {
            Object object = this.getLabelTable().get(enumeration.nextElement());
            if (!(object instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)object;
            jComponent.updateUI();
            jComponent.setSize(jComponent.getPreferredSize());
        }
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)UIManager.getUI(this));
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    boolean getSnapToValue() {
        return this.snapToValue;
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public JSlider(int n2) {
        this(n2, 0, 100, 50);
    }

    private void checkOrientation(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void setExtent(int n2) {
        this.getModel().setExtent(n2);
    }

    public void setMajorTickSpacing(int n2) {
        int n3 = this.majorTickSpacing;
        this.majorTickSpacing = n2;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", n3, this.majorTickSpacing);
        if (this.majorTickSpacing != n3 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public void setMaximum(int n2) {
        int n3 = this.getModel().getMaximum();
        this.getModel().setMaximum(n2);
        this.firePropertyChange("maximum", new Integer(n3), new Integer(n2));
    }

    public void setMinimum(int n2) {
        int n3 = this.getModel().getMinimum();
        this.getModel().setMinimum(n2);
        this.firePropertyChange("minimum", new Integer(n3), new Integer(n2));
    }

    public void setMinorTickSpacing(int n2) {
        int n3 = this.minorTickSpacing;
        this.minorTickSpacing = n2;
        this.firePropertyChange("minorTickSpacing", n3, this.minorTickSpacing);
        if (this.minorTickSpacing != n3 && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public void setOrientation(int n2) {
        this.checkOrientation(n2);
        int n3 = this.orientation;
        this.orientation = n2;
        this.firePropertyChange("orientation", n3, n2);
        if (n3 != n2 && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n3 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n2 != n3) {
            this.revalidate();
        }
    }

    public void setValue(int n2) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n3 = boundedRangeModel.getValue();
        if (n3 == n2) {
            return;
        }
        boundedRangeModel.setValue(n2);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n3), new Integer(boundedRangeModel.getValue()));
        }
    }

    public JSlider(int n2, int n3) {
        this(0, n2, n3, (n2 + n3) / 2);
    }

    public JSlider(int n2, int n3, int n4) {
        this(0, n2, n3, n4);
    }

    public JSlider(int n2, int n3, int n4, int n5) {
        this.checkOrientation(n2);
        this.orientation = n2;
        this.sliderModel = new DefaultBoundedRangeModel(n5, 0, n3, n4);
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public void setInverted(boolean bl2) {
        boolean bl3 = this.isInverted;
        this.isInverted = bl2;
        this.firePropertyChange("inverted", bl3, this.isInverted);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    public void setPaintLabels(boolean bl2) {
        boolean bl3 = this.paintLabels;
        this.paintLabels = bl2;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", bl3, this.paintLabels);
        if (this.paintLabels != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setPaintTicks(boolean bl2) {
        boolean bl3 = this.paintTicks;
        this.paintTicks = bl2;
        this.firePropertyChange("paintTicks", bl3, this.paintTicks);
        if (this.paintTicks != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setPaintTrack(boolean bl2) {
        boolean bl3 = this.paintTrack;
        this.paintTrack = bl2;
        this.firePropertyChange("paintTrack", bl3, this.paintTrack);
        if (this.paintTrack != bl3) {
            this.repaint();
        }
    }

    public void setSnapToTicks(boolean bl2) {
        boolean bl3 = this.snapToTicks;
        this.snapToTicks = bl2;
        this.firePropertyChange("snapToTicks", bl3, this.snapToTicks);
    }

    void setSnapToValue(boolean bl2) {
        boolean bl3 = this.snapToValue;
        this.snapToValue = bl2;
        this.firePropertyChange("snapToValue", bl3, this.snapToValue);
    }

    public void setValueIsAdjusting(boolean bl2) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl3 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl2);
        if (bl3 != bl2 && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl3 ? AccessibleState.BUSY : null, bl2 ? AccessibleState.BUSY : null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.paintTicks ? "true" : "false";
        String string2 = this.paintTrack ? "true" : "false";
        String string3 = this.paintLabels ? "true" : "false";
        String string4 = this.isInverted ? "true" : "false";
        String string5 = this.snapToTicks ? "true" : "false";
        String string6 = this.snapToValue ? "true" : "false";
        String string7 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",isInverted=" + string4 + ",majorTickSpacing=" + this.majorTickSpacing + ",minorTickSpacing=" + this.minorTickSpacing + ",orientation=" + string7 + ",paintLabels=" + string3 + ",paintTicks=" + string + ",paintTrack=" + string2 + ",snapToTicks=" + string5 + ",snapToValue=" + string6;
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary dictionary) {
        Dictionary dictionary2 = this.labelTable;
        this.labelTable = dictionary;
        this.updateLabelUIs();
        this.firePropertyChange("labelTable", dictionary2, this.labelTable);
        if (dictionary != dictionary2) {
            this.revalidate();
            this.repaint();
        }
    }

    public Hashtable createStandardLabels(int n2) {
        return this.createStandardLabels(n2, this.getMinimum());
    }

    public Hashtable createStandardLabels(int n2, int n3) {
        if (n3 > this.getMaximum() || n3 < this.getMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Label incremement must be > 0");
        }
        class SmartHashtable
        extends Hashtable
        implements PropertyChangeListener {
            int increment = 0;
            int start = 0;
            boolean startAtMin = false;

            void createLabels() {
                for (int i2 = this.start; i2 <= JSlider.this.getMaximum(); i2 += this.increment) {
                    this.put(new Integer(i2), new 1SmartHashtable.LabelUIResource("" + i2, 0));
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("minimum") && this.startAtMin) {
                    this.start = JSlider.this.getMinimum();
                }
                if (propertyChangeEvent.getPropertyName().equals("minimum") || propertyChangeEvent.getPropertyName().equals("maximum")) {
                    Enumeration enumeration = JSlider.this.getLabelTable().keys();
                    Object object = null;
                    Hashtable hashtable = new Hashtable();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        Object object2 = JSlider.this.getLabelTable().get(object);
                        if (object2 instanceof 1SmartHashtable.LabelUIResource) continue;
                        hashtable.put(object, object2);
                    }
                    this.clear();
                    this.createLabels();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        this.put(object, hashtable.get(object));
                    }
                    ((JSlider)propertyChangeEvent.getSource()).setLabelTable(this);
                }
            }

            public SmartHashtable(int n2, int n3) {
                this.increment = n2;
                this.start = n3;
                this.startAtMin = n3 == JSlider.this.getMinimum();
                this.createLabels();
            }

            class 1SmartHashtable.LabelUIResource
            extends JLabel
            implements UIResource {
                public 1SmartHashtable.LabelUIResource(String string, int n2) {
                    super(string, n2);
                }
            }
        }
        SmartHashtable smartHashtable = new SmartHashtable(n2, n3);
        if (this.getLabelTable() != null && this.getLabelTable() instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)this.getLabelTable()));
        }
        this.addPropertyChangeListener(smartHashtable);
        return smartHashtable;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public JSlider(BoundedRangeModel boundedRangeModel) {
        this.orientation = 0;
        this.setModel(boundedRangeModel);
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this.changeListener);
        }
        this.sliderModel = boundedRangeModel;
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : new Integer(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : new Integer(boundedRangeModel.getValue()));
            }
        }
        this.firePropertyChange("model", boundedRangeModel2, this.sliderModel);
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI sliderUI) {
        super.setUI(sliderUI);
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public Number getCurrentAccessibleValue() {
            return new Integer(JSlider.this.getValue());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSlider.this.getMaximum());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSlider.this.getMinimum());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JSlider.this.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSlider.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JSlider.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        protected AccessibleJSlider() {
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider.this.fireStateChanged();
        }
    }
}

