/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.SunWritableRaster;

public class ByteBandedRaster
extends SunWritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    byte[][] data;
    private int maxX;
    private int maxY;

    public int getPixelStride() {
        return 1;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public byte[][] getDataStorage() {
        return this.data;
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    public byte[] getDataStorage(int n2) {
        return this.data[n2];
    }

    public void putByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[n6];
        int n8 = 0;
        if (this.scanlineStride == n4) {
            System.arraycopy(byArray, 0, this.data[n6], n7, n4 * n5);
        } else {
            int n9 = 0;
            while (n9 < n5) {
                System.arraycopy(byArray, n8, this.data[n6], n7, n4);
                n8 += n4;
                ++n9;
                n7 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n5];
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) + this.dataOffsets[n6];
        if (this.scanlineStride == n4) {
            System.arraycopy(this.data[n6], n7, byArray, 0, n4 * n5);
        } else {
            int n8 = 0;
            int n9 = 0;
            while (n9 < n5) {
                System.arraycopy(this.data[n6], n7, byArray, n8, n4);
                n8 += n4;
                ++n9;
                n7 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void putByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n7 = i2;
            byte[] byArray2 = this.data[i2];
            int n8 = this.dataOffsets[i2];
            int n9 = n6;
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n8 + n9;
                for (int i3 = 0; i3 < n4; ++i3) {
                    byArray2[n11++] = byArray[n7];
                    n7 += this.numDataElements;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n5];
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n7 = i2;
            byte[] byArray2 = this.data[i2];
            int n8 = this.dataOffsets[i2];
            int n9 = n6;
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n8 + n9;
                for (int i3 = 0; i3 < n4; ++i3) {
                    byArray[n7] = byArray2[n11++];
                    n7 += this.numDataElements;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
        }
        return byArray;
    }

    private void verify(boolean bl2) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.dataOffsets.length; ++n3) {
            if (this.dataOffsets[n3] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n3 + "(" + this.dataOffsets[n3] + ") must be >= 0");
        }
        n3 = 0;
        for (n2 = 0; n2 < this.numDataElements; ++n2) {
            int n4 = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[n2];
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (this.data.length == 1) {
            if (this.data[0].length < n3 * this.numDataElements) {
                throw new RasterFormatException("Data array too small (it is " + this.data[0].length + " and should be " + n3 * this.numDataElements + " )");
            }
        } else {
            for (n2 = 0; n2 < this.numDataElements; ++n2) {
                if (this.data[n2].length >= n3) continue;
                throw new RasterFormatException("Data array too small (it is " + this.data[n2].length + " and should be " + n3 + " )");
            }
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        return this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        Object object = null;
        for (int i2 = 0; i2 < n5; ++i2) {
            object = raster.getDataElements(n6, n7 + i2, n4, 1, object);
            this.setDataElements(n2, n3 + i2, n4, 1, object);
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = raster.getMinX() + n2;
        int n5 = raster.getMinY() + n3;
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new ByteBandedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.width + this.minX) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.height + this.minY) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new ByteBandedRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n7 = i2;
            byte[] byArray2 = this.data[i2];
            int n8 = this.dataOffsets[i2];
            int n9 = n6;
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n8 + n9;
                for (int i3 = 0; i3 < n4; ++i3) {
                    byArray2[n11++] = byArray[n7];
                    n7 += this.numDataElements;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            this.data[i2][this.dataOffsets[i2] + n4] = byArray[i2];
        }
        this.notifyChanged();
    }

    public String toString() {
        return new String("ByteBandedRaster: width = " + this.width + " height = " + this.height + " #bands " + this.numDataElements + " minX = " + this.minX + " minY = " + this.minY);
    }

    public ByteBandedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements * n4 * n5] : (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n7 = i2;
            byte[] byArray2 = this.data[i2];
            int n8 = this.dataOffsets[i2];
            int n9 = n6;
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n8 + n9;
                for (int i3 = 0; i3 < n4; ++i3) {
                    byArray[n7] = byArray2[n11++];
                    n7 += this.numDataElements;
                }
                ++n10;
                n9 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            byArray[i2] = this.data[i2][this.dataOffsets[i2] + n4];
        }
        return byArray;
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteBandedRaster byteBandedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteBandedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteBandedRaster must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            this.scanlineStride = bandedSampleModel.getScanlineStride();
            int[] nArray = bandedSampleModel.getBankIndices();
            int[] nArray2 = bandedSampleModel.getBandOffsets();
            int[] nArray3 = dataBufferByte.getOffsets();
            this.dataOffsets = new int[nArray.length];
            this.data = new byte[nArray.length][];
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.data[i2] = dataBufferByte.getData(nArray[i2]);
                this.dataOffsets[i2] = nArray3[nArray[i2]] + n2 + n3 * this.scanlineStride + nArray2[i2];
            }
        } else {
            throw new RasterFormatException("ByteBandedRasters must haveBandedSampleModels");
        }
        this.verify(false);
    }
}

