/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import sun.io.CharToByteConverter;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBoundCol;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcUtils;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcResultSet
extends JdbcOdbcObject
implements JdbcOdbcResultSetInterface {
    protected JdbcOdbc OdbcApi = null;
    protected long hDbc = 0L;
    protected long hStmt = 0L;
    protected SQLWarning lastWarning = null;
    protected boolean keepHSTMT = false;
    protected JdbcOdbcBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols = -1;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected JdbcOdbcPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull = false;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    private JdbcOdbcUtils utils = new JdbcOdbcUtils();
    private boolean ownInsertsAreVisible;
    private boolean ownDeletesAreVisible;
    protected JdbcOdbcStatement ownerStatement;
    protected int numberOfRows;
    protected int rowPosition;
    protected int lastRowPosition;
    protected int[] rowStatusArray;
    protected boolean atInsertRow;
    protected int lastForwardRecord;
    protected int lastColumnData;
    protected int rowSet;
    protected boolean blockCursor;
    protected int fetchCount;
    protected int currentBlockCell;
    protected int lastBlockPosition;
    protected boolean moveUpBlock;
    protected boolean moveDownBlock;
    protected short odbcCursorType;
    protected boolean rowUpdated;
    protected long[] pA;

    public int getColumnCount() throws SQLException {
        this.checkOpen();
        int n2 = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            n2 = this.numResultCols = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n2 = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n2;
    }

    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getResultSetConcurrency();
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchSize();
    }

    public int getRow() throws SQLException {
        this.checkOpen();
        if (this.getType() == 1003) {
            if (this.lastForwardRecord == 0) {
                return this.rowPosition;
            }
            return 0;
        }
        if (this.numberOfRows > 0) {
            if (this.rowPosition <= 0 || this.rowPosition > this.numberOfRows) {
                return 0;
            }
            return this.rowPosition;
        }
        return 0;
    }

    public int getRowCount() throws SQLException {
        this.checkOpen();
        return this.numberOfRows;
    }

    protected int getRowIndex() {
        int n2 = 0;
        if (this.blockCursor) {
            n2 = this.currentBlockCell - 1;
        } else if (this.atInsertRow) {
            n2 = this.rowSet;
        }
        return n2;
    }

    public int getRowNumber() throws SQLException {
        this.checkOpen();
        int n2 = 0;
        this.clearWarnings();
        try {
            n2 = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n2 = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n2;
    }

    public int getType() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement.getResultSetType();
        }
        return 1003;
    }

    public long getHSTMT() {
        return this.hStmt;
    }

    public synchronized void FreeCols() throws NullPointerException {
        try {
            for (int i2 = 0; i2 < this.boundCols.length; ++i2) {
                if (this.boundCols[i2].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i2].pA1, this.boundCols[i2].pA2);
                    this.boundCols[i2].pA1 = 0L;
                    this.boundCols[i2].pA2 = 0L;
                }
                if (this.boundCols[i2].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i2].pB1, this.boundCols[i2].pB2);
                    this.boundCols[i2].pB1 = 0L;
                    this.boundCols[i2].pB2 = 0L;
                }
                if (this.boundCols[i2].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i2].pC1, this.boundCols[i2].pC2);
                    this.boundCols[i2].pC1 = 0L;
                    this.boundCols[i2].pC2 = 0L;
                }
                if (this.boundCols[i2].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundCols[i2].pS1, this.boundCols[i2].pS2);
                this.boundCols[i2].pS1 = 0L;
                this.boundCols[i2].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void afterLast() throws SQLException {
        this.checkOpen();
        boolean bl2 = false;
        if (this.getType() != 1003) {
            bl2 = this.fetchScrollOption(this.numberOfRows + 1, (short)5);
            this.rowPosition = this.numberOfRows + 1;
            this.currentBlockCell = this.rowSet + 1;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bl2 = false;
            bl2 = this.fetchScrollOption(0, (short)5);
            this.rowPosition = 0;
            this.currentBlockCell = 0;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateRowCount() throws SQLException {
        Object object;
        try {
            this.numberOfRows = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            object = (BigDecimal)jdbcOdbcSQLWarning.value;
            this.numberOfRows = ((BigDecimal)object).intValue();
        }
        if (this.numberOfRows > 0) {
            return;
        }
        try {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)3, 0);
            this.numberOfRows = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
        }
        if (this.numberOfRows > 0) {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
            return;
        }
        if (this.ownerStatement != null) {
            Connection connection = this.ownerStatement.getConnection();
            object = this.ownerStatement.getSql();
            String string = null;
            String string2 = this.ownerStatement.getClass().getName();
            int n2 = 0;
            n2 = this.ownerStatement.getParamCount();
            if (n2 > 0) {
                if (string2.indexOf("CallableStatement") > 0) {
                    throw new SQLException("Unable to obtain result set row count. From " + (String)object);
                }
                if (string2.indexOf("PreparedStatement") > 0) {
                    if (((String)object).toLowerCase().indexOf("select") == -1) {
                        throw new SQLException("Cannot obtain result set row count for " + (String)object);
                    }
                    string = this.reWordAsCountQuery((String)object);
                    if (string.indexOf("?") > 0) {
                        this.numberOfRows = this.parameterQuery(connection.prepareStatement(string));
                    } else {
                        n2 = 0;
                    }
                }
            }
            if (string2.indexOf("Statement") > 0 && n2 == 0) {
                Statement statement = connection.createStatement();
                if (object != null && ((String)object).startsWith("SELECT")) {
                    if (string == null) {
                        string = this.reWordAsCountQuery((String)object);
                    }
                    ResultSet resultSet = statement.executeQuery(string);
                    resultSet.next();
                    this.numberOfRows = resultSet.getInt(1);
                    if (string.indexOf("COUNT(*)") < 0 && this.numberOfRows > 0) {
                        this.numberOfRows = 1;
                        this.setWarning(new SQLWarning("ResultSet is not updatable."));
                    }
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (this.numberOfRows > 0) {
            return;
        }
        this.setWarning(new SQLWarning("Can not determine result set row count."));
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        if (this.atInsertRow) {
            throw new SQLException("Cursor position on insert row");
        }
        this.resetColumnState();
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.close");
        }
        this.closeInputStreams();
        this.clearWarnings();
        this.lastColumnNull = false;
        if (this.OdbcApi != null && this.hStmt != 0L) {
            if (!this.keepHSTMT) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0L;
            }
            this.closed = true;
            this.FreeCols();
            if (this.pA != null && this.pA[0] != 0L) {
                JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                this.pA[0] = 0L;
                this.pA[1] = 0L;
            }
            if (this.ownerStatement != null) {
                this.ownerStatement.myResultSet = null;
            }
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("*ResultSet has been closed");
            }
        }
    }

    protected void closeInputStreams() {
        for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
            this.boundCols[i2].closeInputStream();
        }
    }

    public void deleteRow() throws SQLException {
        this.checkOpen();
        if (this.blockCursor) {
            this.setPos(this.currentBlockCell, 3);
        } else {
            this.setPos(this.rowSet, 3);
        }
        if (this.ownDeletesAreVisible) {
            --this.numberOfRows;
        }
    }

    protected void finalize() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("ResultSet.finalize " + this);
        }
        try {
            if (!this.closed) {
                this.hStmt = 0L;
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void insertRow() throws SQLException {
        this.checkOpen();
        for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
            int n2 = this.boundCols[i2].getType();
            this.bindCol(i2 + 1, n2);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 4);
            } else {
                this.setPos(this.rowSet, 4);
            }
            this.FreeCols();
            if (this.ownInsertsAreVisible) {
                ++this.numberOfRows;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.resetColumnState();
        this.resetInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        boolean bl2 = false;
        if (this.atInsertRow) {
            this.resetInsertRow();
            this.rowPosition = this.lastRowPosition;
            this.currentBlockCell = this.lastBlockPosition;
            bl2 = this.absolute(this.rowPosition);
            if (bl2) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
            }
            this.atInsertRow = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("Invalid Cursor Type: " + this.getType());
        }
        this.checkOpen();
        this.atInsertRow = true;
        this.lastRowPosition = this.rowPosition;
        this.lastBlockPosition = this.currentBlockCell;
        if (this.blockCursor) {
            this.currentBlockCell = this.rowSet + 1;
        }
        this.resetInsertRow();
    }

    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.atInsertRow || this.getRow() <= 0) {
                throw new SQLException("Cursor position is invalid");
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.fetchScrollOption(0, (short)6);
    }

    protected void resetColumnState() throws SQLException {
        this.checkOpen();
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 2);
        }
        for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
            this.boundCols[i2].resetColumnToIgnoreData();
        }
    }

    protected void resetInsertRow() throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (this.atInsertRow) {
            for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
                this.boundCols[i2].resetColumnToIgnoreData();
            }
        }
    }

    protected void setCursorType() throws SQLException {
        this.clearWarnings();
        try {
            long l2 = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)6);
            this.odbcCursorType = (short)l2;
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            this.odbcCursorType = bigDecimal.shortValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
    }

    private void setResultSetVisibilityIndicators() throws SQLException {
        int n2 = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 6);
        short s2 = 0;
        switch (n2) {
            case 1: {
                s2 = 151;
                break;
            }
            case 2: {
                s2 = 145;
                break;
            }
            case 3: {
                s2 = 168;
            }
        }
        if (s2 > 0) {
            try {
                int n3 = this.OdbcApi.SQLGetInfo(this.hDbc, s2);
                if ((n3 & 0x20) > 0) {
                    this.ownDeletesAreVisible = true;
                }
                if ((n3 & 0x10) > 0) {
                    this.ownInsertsAreVisible = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void setRowStatusPtr() throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.rowStatusArray = new int[this.rowSet + 1];
        this.pA = new long[2];
        this.pA[0] = 0L;
        this.pA[1] = 0L;
        this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 25, this.rowStatusArray, 0, this.pA);
    }

    public void updateRow() throws SQLException {
        this.checkOpen();
        for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
            int n2 = this.boundCols[i2].getType();
            this.bindCol(i2 + 1, n2);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 2);
            } else {
                this.setPos(this.rowSet, 2);
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.FreeCols();
        this.resetColumnState();
        this.rowUpdated = true;
    }

    public boolean first() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (this.blockCursor && !(bl2 = this.blockFetch(1, (short)2))) {
                    bl3 = true;
                }
                if (!this.blockCursor || bl2) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bl3 = this.fetchScrollOption(this.rowPosition, (short)2);
                }
                if (bl3) {
                    this.currentBlockCell = this.rowPosition = 1;
                }
                return bl3;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition > this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 0;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 1;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isLast() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean last() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                this.moveToCurrentRow();
                boolean bl2 = false;
                boolean bl3 = false;
                if (this.blockCursor) {
                    bl2 = this.blockFetch(this.numberOfRows, (short)3);
                    if (!bl2) {
                        this.setPos(this.currentBlockCell, 0);
                        bl3 = true;
                    } else {
                        bl3 = true;
                    }
                }
                if (!this.blockCursor || bl2) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bl3 = bl2 ? this.fetchScrollOption(this.numberOfRows, (short)5) : this.fetchScrollOption(this.numberOfRows, (short)3);
                    if (bl3) {
                        this.rowPosition = this.numberOfRows;
                    }
                    this.currentBlockCell = 1;
                }
                return bl3;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.getFetchDirection() == 1000) {
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                if (this.blockCursor) {
                    bl2 = this.relative(1, false);
                } else {
                    ++this.rowPosition;
                    bl2 = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            } else {
                if (this.rowPosition == 1) {
                    this.beforeFirst();
                    return false;
                }
                if (this.blockCursor) {
                    bl2 = this.relative(-1, false);
                } else {
                    --this.rowPosition;
                    bl2 = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            }
            return bl2;
        }
        boolean bl4 = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        try {
            bl4 = this.OdbcApi.SQLFetch(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        if (bl4) {
            ++this.rowPosition;
        } else if (!bl4) {
            if (this.lastForwardRecord == 0) {
                this.lastForwardRecord = this.rowPosition;
                this.rowPosition = 0;
            } else {
                this.rowPosition = 0;
            }
        }
        return bl4;
    }

    public boolean previous() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            int n2 = 0;
            if (this.numberOfRows > 0) {
                if (this.atInsertRow) {
                    n2 = this.lastRowPosition;
                }
                this.moveToCurrentRow();
                if (this.getFetchDirection() == 1000) {
                    if (n2 > 0) {
                        return this.absolute(n2 - 1);
                    }
                    if (this.rowPosition > 1) {
                        return this.absolute(this.rowPosition - 1);
                    }
                    if (this.rowPosition == 1) {
                        this.beforeFirst();
                        return false;
                    }
                    if (this.isBeforeFirst()) {
                        return false;
                    }
                    return false;
                }
                if (n2 > 0) {
                    return this.absolute(n2 + 1);
                }
                if (this.rowPosition < this.numberOfRows) {
                    return this.absolute(this.rowPosition + 1);
                }
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                if (this.isAfterLast()) {
                    return false;
                }
                return false;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n2 = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n2] == 1;
            }
            return this.rowStatusArray[this.rowSet - 1] == 1;
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n2 = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n2] == 4;
            }
            return this.rowStatusArray[this.rowSet - 1] == 4;
        }
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n2 = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n2] == 2;
            }
            return this.rowStatusArray[this.rowSet - 1] == 2;
        }
        return false;
    }

    protected boolean setRowArraySize() {
        int n2 = 0;
        try {
            this.clearWarnings();
            if (this.rowSet > 1) {
                if (this.numberOfRows < this.rowSet) {
                    this.rowSet = this.numberOfRows;
                }
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 5, 0, 0);
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 27, this.rowSet, 0);
                n2 = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 27);
                if (n2 > 1 && n2 < this.rowSet) {
                    this.rowSet = n2;
                    return true;
                }
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        return n2 == this.rowSet;
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    public byte getByte(int n2) throws SQLException {
        this.checkOpen();
        byte by = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            by = (byte)this.getInt(n2);
        } else {
            this.lastColumnNull = true;
        }
        return by;
    }

    public double getDouble(int n2) throws SQLException {
        this.checkOpen();
        double d2 = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            Double d3 = this.getDataDouble(n2);
            if (d3 != null) {
                d2 = d3;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d2;
    }

    public float getFloat(int n2) throws SQLException {
        return (float)this.getDouble(n2);
    }

    public int getColumnLength(int n2) throws SQLException {
        int n3 = -1;
        if (n2 > 0 && n2 <= this.numberOfCols) {
            n3 = this.boundCols[n2 - 1].getLength();
        }
        if (n3 == -1) {
            n3 = this.getColAttribute(n2, 3);
            if (n2 > 0 && n2 <= this.numberOfCols) {
                this.boundCols[n2 - 1].setLength(n3);
            }
        }
        return n3;
    }

    public int getColumnType(int n2) throws SQLException {
        int n3 = 9999;
        if (n2 > 0 && n2 <= this.numberOfCols) {
            n3 = this.boundCols[n2 - 1].getType();
        }
        if (n3 == 9999) {
            n3 = this.getColAttribute(n2, 2);
            n3 = OdbcDef.odbcTypeToJdbc(n3);
            if (n2 > 0 && n2 <= this.numberOfCols) {
                this.boundCols[n2 - 1].setType(n3);
            }
        }
        return n3;
    }

    public int getInt(int n2) throws SQLException {
        this.checkOpen();
        int n3 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            Integer n4 = this.getDataInteger(n2);
            if (n4 != null) {
                n3 = n4;
            }
        } else {
            this.lastColumnNull = true;
        }
        return n3;
    }

    protected int getMaxBinaryLen(int n2) throws SQLException {
        int n3 = this.getColumnLength(n2);
        if (n3 != -1 && (n3 <= 0 || n3 > Short.MAX_VALUE)) {
            n3 = Short.MAX_VALUE;
        }
        return n3;
    }

    protected int getMaxCharLen(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        int n4 = this.getColumnLength(n2);
        if (n4 != -1) {
            switch (n3) {
                case -4: 
                case -3: 
                case -2: {
                    n4 *= 2;
                    break;
                }
                case 91: {
                    n4 = 10;
                    break;
                }
                case 92: {
                    n4 = 8;
                    break;
                }
                case 93: {
                    n4 = 29;
                    break;
                }
                case 2: 
                case 3: {
                    n4 += 2;
                    break;
                }
                case -7: {
                    n4 = 1;
                    break;
                }
                case -6: {
                    n4 = 4;
                    break;
                }
                case 5: {
                    n4 = 6;
                    break;
                }
                case 4: {
                    n4 = 11;
                    break;
                }
                case -5: {
                    n4 = 20;
                    break;
                }
                case 7: {
                    n4 = 13;
                    break;
                }
                case 6: 
                case 8: {
                    n4 = 22;
                }
            }
            if (n4 <= 0 || n4 > Short.MAX_VALUE) {
                n4 = Short.MAX_VALUE;
            }
        }
        return n4;
    }

    public int getScale(int n2) throws SQLException {
        int n3;
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            n3 = 0;
        } else {
            n3 = this.getColAttribute(n2, 5);
        }
        return n3;
    }

    public int mapColumn(int n2) {
        int n3 = n2;
        if (this.colMappings != null) {
            n3 = n2 > 0 && n2 <= this.colMappings.length ? this.colMappings[n2 - 1] : -1;
        }
        return n3;
    }

    public long getLong(int n2) throws SQLException {
        this.checkOpen();
        long l2 = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            Double d2 = this.getDataDouble(n2);
            if (d2 != null) {
                l2 = d2.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l2;
    }

    public short getShort(int n2) throws SQLException {
        this.checkOpen();
        short s2 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            s2 = (short)this.getInt(n2);
        } else {
            this.lastColumnNull = true;
        }
        return s2;
    }

    protected void consecutiveFetch(int n2) throws SQLException {
        boolean bl2 = false;
        if (this.blockCursor && this.rowUpdated) {
            bl2 = true;
        }
        if (this.rowSet != 1) {
            if (this.lastColumnData == n2 || bl2) {
                try {
                    this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, this.getRow());
                    this.lastColumnData = 0;
                    if (this.blockCursor) {
                        this.currentBlockCell = 1;
                    }
                }
                catch (SQLWarning sQLWarning) {
                    this.setWarning(sQLWarning);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.rowUpdated = false;
            } else {
                this.lastColumnData = n2;
            }
        }
    }

    protected void putColumnData(int n2) throws SQLException, JdbcOdbcSQLWarning {
        int n3 = 2000;
        byte[] byArray = new byte[n3];
        boolean bl2 = false;
        if (n2 < 1 || n2 > this.numberOfCols) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Invalid index for putColumnData()");
            }
            return;
        }
        InputStream inputStream = null;
        int n4 = this.getRowIndex();
        try {
            inputStream = (InputStream)this.boundCols[n2 - 1].getRowValue(n4);
        }
        catch (Exception exception) {
            throw new SQLException("Invalid data for columnIndex(" + n2 + "): " + exception.getMessage());
        }
        int n5 = this.boundCols[n2 - 1].getLength();
        int n6 = this.boundCols[n2 - 1].getStreamType();
        while (!bl2) {
            int n7;
            try {
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Reading from input stream");
                }
                n7 = inputStream.read(byArray);
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Bytes read: " + n7);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n7 == -1) {
                if (n5 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl2 = true;
                break;
            }
            if (n7 > n5) {
                n7 = n5;
                bl2 = true;
            }
            int n8 = n7;
            try {
                this.OdbcApi.SQLPutData(this.hStmt, byArray, n8);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            n5 -= n7;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("" + n5 + " bytes remaining");
            }
            if (n5 != 0) continue;
            bl2 = true;
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchDirection(n2);
    }

    public void setFetchSize(int n2) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchSize(n2);
    }

    public void setSQLTypeColumn(int n2) {
        this.sqlTypeColumn = n2;
    }

    public void updateNull(int n2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != 9999) {
                this.boundCols[n2 - 1].setRowValues(n3, null, -1);
            } else {
                throw new SQLException("Unknown Data Type for column [#" + n2 + "]");
            }
        }
    }

    public boolean absolute(int n2) throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (n2 != 0) {
                    if (this.blockCursor) {
                        if (this.atInsertRow) {
                            this.rowPosition = this.lastRowPosition;
                            this.currentBlockCell = this.lastBlockPosition;
                            this.atInsertRow = false;
                        }
                        if (bl3 = this.blockFetch(n2, (short)5)) {
                            this.currentBlockCell = 1;
                        } else {
                            this.setPos(this.currentBlockCell, 0);
                            bl2 = true;
                        }
                    }
                    if (!this.blockCursor || bl3) {
                        this.rowPosition = n2 >= 0 ? n2 : this.numberOfRows + 1 + n2;
                        if (this.rowPosition > this.numberOfRows) {
                            this.afterLast();
                            return false;
                        }
                        if (this.rowPosition < 1) {
                            this.beforeFirst();
                            return false;
                        }
                        this.lastColumnNull = false;
                        this.closeInputStreams();
                        this.clearWarnings();
                        bl2 = this.fetchScrollOption(n2, (short)5);
                    }
                    return bl2;
                }
                throw new SQLException("Cursor position (" + n2 + ") is invalid");
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkOpen();
        boolean bl2 = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            bl2 = this.getInt(n2) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return bl2;
    }

    protected boolean isRowWithinTheBlock(int n2) {
        boolean bl2 = false;
        if (this.rowPosition != 0) {
            int n3 = this.rowPosition - (this.currentBlockCell - 1);
            int n4 = this.rowPosition + (this.rowSet - this.currentBlockCell);
            if (n4 < n2 || n3 > n2) {
                bl2 = false;
            } else if (n2 > this.rowPosition) {
                bl2 = true;
                this.moveUpBlock = false;
                this.moveDownBlock = true;
            } else if (n2 < this.rowPosition) {
                bl2 = true;
                this.moveUpBlock = true;
                this.moveDownBlock = false;
            }
        }
        return bl2;
    }

    public boolean relative(int n2) throws SQLException {
        this.checkOpen();
        return this.relative(n2, true);
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        int n3;
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n4 = this.getMaxBinaryLen(n2);
        if (n4 == -1) {
            this.lastColumnNull = true;
            return null;
        }
        int n5 = this.getColumnLength(n2);
        if (n5 > Short.MAX_VALUE) {
            JdbcOdbcInputStream jdbcOdbcInputStream = (JdbcOdbcInputStream)this.getBinaryStream(n2);
            try {
                return jdbcOdbcInputStream.readAllData();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        int n6 = this.getColumnType(n2);
        byte[] byArray = new byte[n4];
        try {
            n3 = this.OdbcApi.SQLGetDataBinary(this.hStmt, n2, byArray);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n7 = (Integer)jdbcOdbcSQLWarning.value;
            n3 = n7;
        }
        if (n3 == -1) {
            this.lastColumnNull = true;
            byArray = null;
        }
        if (n6 != -2 && n3 != n4 && byArray != null) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != -6) {
                this.boundCols[n2 - 1].setType(-6);
            }
            this.boundCols[n2 - 1].setRowValues(n3, new Integer(by), 4);
        }
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != 8) {
                this.boundCols[n2 - 1].setType(8);
            }
            this.boundCols[n2 - 1].setRowValues(n3, new Double(d2), 8);
        }
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != 6) {
                this.boundCols[n2 - 1].setType(6);
            }
            this.boundCols[n2 - 1].setRowValues(n3, new Float(f2), 4);
        }
    }

    public int getColAttribute(int n2, int n3) throws SQLException {
        int n4 = 0;
        this.clearWarnings();
        try {
            n4 = this.OdbcApi.SQLColAttributes(this.hStmt, n2, n3);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n4 = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n4;
    }

    protected void bindCol(int n2, int n3) throws SQLException {
        boolean bl2 = false;
        int n4 = 0;
        Object var5_5 = null;
        Object[] objectArray = this.boundCols[n2 - 1].getRowValues();
        byte[] byArray = this.boundCols[n2 - 1].getRowLengths();
        if (!this.blockCursor && this.atInsertRow) {
            n4 = 0;
        }
        if (this.blockCursor) {
            n4 = this.currentBlockCell - 1;
        }
        Object object = this.boundCols[n2 - 1].getRowValue(n4);
        int n5 = this.boundCols[n2 - 1].getLength();
        if (n5 < 0) {
            n5 = this.getColumnLength(n2);
        }
        try {
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    if ((n3 == 2 || n3 == 3) && object != null) {
                        Object object2 = object;
                        String string = object2.toString();
                        n5 = string.length();
                        BigDecimal bigDecimal = new BigDecimal(string);
                        int n6 = bigDecimal.scale();
                        if (n6 <= 0) {
                            ++n5;
                        }
                    }
                    this.bindStringCol(n2, n3, objectArray, byArray, n5);
                    break;
                }
                case -1: {
                    int n7 = JdbcOdbcStatement.getTypeFromObject(object);
                    if (n7 == -4 || n7 == 0) {
                        this.bindAtExecCol(n2, n3, byArray);
                        break;
                    }
                    if (n7 != -2) break;
                    this.bindBinaryCol(n2, objectArray, byArray, n5);
                    break;
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    this.bindIntegerCol(n2, objectArray, byArray);
                    break;
                }
                case 8: {
                    this.bindDoubleCol(n2, objectArray, byArray);
                    break;
                }
                case -5: 
                case 6: 
                case 7: {
                    this.bindFloatCol(n2, objectArray, byArray);
                    break;
                }
                case 91: {
                    this.bindDateCol(n2, objectArray, byArray);
                    break;
                }
                case 92: {
                    this.bindTimeCol(n2, objectArray, byArray);
                    break;
                }
                case 93: {
                    this.bindTimestampCol(n2, objectArray, byArray);
                    break;
                }
                case -3: 
                case -2: {
                    this.bindBinaryCol(n2, objectArray, byArray, n5);
                    break;
                }
                case -4: {
                    this.bindAtExecCol(n2, n3, byArray);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("SQLBinCol (" + n2 + ") SQLType = " + n3 + ". " + sQLException.getMessage());
        }
    }

    protected void setPos(int n2, int n3) throws SQLException {
        SQLWarning sQLWarning = null;
        boolean bl2 = false;
        try {
            this.clearWarnings();
            bl2 = this.OdbcApi.SQLSetPos(this.hStmt, n2, n3, 0);
            int n4 = 0;
            while (bl2) {
                int n5 = this.getRowIndex();
                String string = this.OdbcApi.odbcDriverName;
                n4 = this.blockCursor && string.indexOf("(IV") == -1 ? this.OdbcApi.SQLParamDataInBlock(this.hStmt, n5) : this.OdbcApi.SQLParamData(this.hStmt);
                if (n4 == -1) {
                    bl2 = false;
                    continue;
                }
                this.putColumnData(n4);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.checkOpen();
        int n4 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n5 = this.getColumnType(n2);
            if (n5 != 4) {
                this.boundCols[n2 - 1].setType(4);
            }
            this.boundCols[n2 - 1].setRowValues(n4, new Integer(n3), 4);
        }
    }

    protected void bindAtExecCol(int n2, int n3, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(4);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColAtExec(this.hStmt, n2, n3, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.checkOpen();
        this.updateFloat(n2, (float)l2);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != 5) {
                this.boundCols[n2 - 1].setType(5);
            }
            this.boundCols[n2 - 1].setRowValues(n3, new Integer(s2), 4);
        }
    }

    protected boolean blockFetch(int n2, short s2) throws SQLException {
        boolean bl2 = false;
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return true;
        }
        switch (s2) {
            case 2: {
                if (this.rowPosition == 1) break;
                if (!this.isRowWithinTheBlock(1)) {
                    bl2 = true;
                    break;
                }
                this.currentBlockCell = this.rowPosition = 1;
                break;
            }
            case 3: {
                if (this.rowPosition < this.numberOfRows) {
                    if (!this.isRowWithinTheBlock(this.numberOfRows)) {
                        bl2 = true;
                        break;
                    }
                    while (this.rowPosition != this.numberOfRows) {
                        ++this.rowPosition;
                        ++this.currentBlockCell;
                    }
                    bl2 = false;
                    break;
                }
                if (this.rowPosition != this.numberOfRows) break;
                bl2 = false;
                break;
            }
            case 5: {
                if (this.rowPosition == n2) break;
                if (n2 < 0 || n2 > this.numberOfRows) {
                    bl2 = true;
                    break;
                }
                if (!this.isRowWithinTheBlock(n2)) {
                    bl2 = true;
                    break;
                }
                while (this.rowPosition != n2) {
                    if (this.moveUpBlock) {
                        --this.rowPosition;
                        --this.currentBlockCell;
                        continue;
                    }
                    if (!this.moveDownBlock) continue;
                    ++this.rowPosition;
                    ++this.currentBlockCell;
                }
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    protected boolean fetchScrollOption(int n2, short s2) throws SQLException {
        if (this.numberOfRows > 0) {
            try {
                this.OdbcApi.SQLFetchScroll(this.hStmt, s2, n2);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
                return true;
            }
            catch (SQLException sQLException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.checkOpen();
        int n3 = 0;
        if (bl2) {
            n3 = 1;
        }
        this.updateInt(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean relative(int n2, boolean bl2) throws SQLException {
        int n3;
        boolean bl3;
        boolean bl4;
        block13: {
            block12: {
                this.checkOpen();
                if (this.getType() == 1003) throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
                if (this.numberOfRows <= 0) throw new SQLException("Call to relative(" + n2 + ") when there is no current row.");
                this.moveToCurrentRow();
                bl4 = false;
                bl3 = false;
                n3 = -1;
                if (bl2) {
                    if (this.rowPosition == 0) {
                        throw new SQLException("Cursor is positioned before the ResultSet");
                    }
                    if (this.rowPosition > this.numberOfRows) {
                        throw new SQLException("Cursor is positioned after the ResultSet");
                    }
                }
                if (!this.blockCursor) break block12;
                bl3 = this.blockFetch(this.rowPosition + n2, (short)5);
                if (bl3) {
                    n3 = this.rowPosition;
                    n3 += n2;
                    break block13;
                } else if (n2 == 0) {
                    n3 = n2;
                    bl3 = true;
                }
                break block13;
            }
            n3 = this.rowPosition;
            n3 += n2;
        }
        if (n3 <= 1 && n2 < 0) {
            this.beforeFirst();
            if (bl2) {
                return false;
            }
            if (n3 != 1) return false;
            return true;
        }
        if (n3 >= this.numberOfRows && n2 > 0) {
            this.afterLast();
            if (bl2) {
                return false;
            }
            if (n3 != this.numberOfRows) return false;
            return true;
        }
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        if (!this.blockCursor) {
            bl4 = this.fetchScrollOption(n2, (short)6);
            if (!bl4) return bl4;
            this.rowPosition = n3;
            return bl4;
        }
        if (bl3) {
            bl4 = this.fetchScrollOption(n3, (short)5);
            if (!bl4) return bl4;
            this.rowPosition = n3;
            this.currentBlockCell = 1;
            return bl4;
        }
        this.setPos(this.currentBlockCell, 0);
        return true;
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (byArray != null && byArray.length > 8000) {
            this.updateBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        }
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n4 = this.getColumnType(n2);
            if (n4 != -2 && n4 != -3) {
                this.boundCols[n2 - 1].setType(-2);
                if (byArray != null) {
                    this.boundCols[n2 - 1].setLength(byArray.length);
                }
            }
            if (byArray == null) {
                this.updateNull(n2);
                return;
            }
            if (byArray.length > this.boundCols[n2 - 1].getLength()) {
                this.boundCols[n2 - 1].setLength(byArray.length);
            }
            this.boundCols[n2 - 1].setRowValues(n3, byArray, byArray.length);
        }
    }

    public void setColumnMappings(int[] nArray) {
        this.colMappings = nArray;
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        int n3 = this.getColumnType(n2);
        int n4 = -2;
        switch (n3) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n4 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n2, 1, n4, this.ownerStatement);
        this.setInputStream(n2, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        int n3 = this.getColumnType(n2);
        int n4 = -2;
        switch (n3) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n4 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n2, 3, n4, this.ownerStatement);
        this.setInputStream(n2, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        int n3 = this.getColumnType(n2);
        int n4 = -2;
        switch (n3) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n4 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n2, 2, n4, this.ownerStatement);
        this.setInputStream(n2, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkOpen();
        int n4 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != -1) {
                this.boundCols[n2 - 1].setType(-1);
            }
            if (inputStream == null) {
                this.updateNull(n2);
                return;
            }
            if (n3 != this.boundCols[n2 - 1].getLength()) {
                this.boundCols[n2 - 1].setLength(n3);
            }
            this.boundCols[n2 - 1].setRowValues(n4, inputStream, n3);
            this.boundCols[n2 - 1].setStreamType(1);
        }
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkOpen();
        int n4 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != -4) {
                this.boundCols[n2 - 1].setType(-4);
            }
            if (inputStream == null) {
                this.updateNull(n2);
                return;
            }
            if (n3 != this.boundCols[n2 - 1].getLength()) {
                this.boundCols[n2 - 1].setLength(n3);
            }
            this.boundCols[n2 - 1].setRowValues(n4, inputStream, n3);
            this.boundCols[n2 - 1].setStreamType(3);
        }
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkOpen();
        InputStreamReader inputStreamReader = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        int n3 = this.getColumnType(n2);
        int n4 = -2;
        switch (n3) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n4 = 1;
            }
        }
        String string = this.OdbcApi.charSet;
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n2, 5, n4, this.ownerStatement);
        this.setInputStream(n2, jdbcOdbcInputStream);
        try {
            inputStreamReader = new InputStreamReader((InputStream)jdbcOdbcInputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("getCharacterStream() with Encoding ('encoding') :" + unsupportedEncodingException.getMessage());
        }
        return inputStreamReader;
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkOpen();
        int n4 = this.getRowIndex();
        BufferedReader bufferedReader = null;
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.OdbcApi.charSet;
        int n5 = 300;
        if (n3 < n5) {
            n5 = n3;
        }
        int n6 = 0;
        int n7 = 0;
        try {
            CharToByteConverter charToByteConverter = CharToByteConverter.getConverter(string);
            n7 = charToByteConverter.getMaxBytesPerChar();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (n7 == 0) {
            n7 = 1;
        }
        try {
            if (reader != null) {
                boolean bl2 = false;
                int n8 = 0;
                bufferedReader = new BufferedReader(reader);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                char[] cArray = new char[n5];
                while (n8 != -1) {
                    int n9;
                    byte[] byArray = new byte[]{};
                    n8 = bufferedReader.read(cArray);
                    if (n8 == -1) continue;
                    char[] cArray2 = new char[n8];
                    for (n9 = 0; n9 < n8; ++n9) {
                        cArray2[n9] = cArray[n9];
                    }
                    byArray = this.CharsToBytes(string, cArray2);
                    n9 = byArray.length - 1;
                    bufferedOutputStream.write(byArray, 0, n9);
                    bufferedOutputStream.flush();
                }
                n6 = byteArrayOutputStream.size();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + iOException.getMessage());
        }
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != -1 || this.getColumnType(n2) != 12) {
                this.boundCols[n2 - 1].setType(-1);
            }
            if (reader == null) {
                this.updateNull(n2);
                return;
            }
            if (n6 != this.boundCols[n2 - 1].getLength()) {
                this.boundCols[n2 - 1].setLength(n6);
            }
            this.boundCols[n2 - 1].setRowValues(n4, byteArrayInputStream, n6);
            this.boundCols[n2 - 1].setStreamType(3);
        }
    }

    public Double getDataDouble(int n2) throws SQLException {
        Double d2;
        this.lastColumnNull = false;
        try {
            d2 = this.OdbcApi.SQLGetDataDouble(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            d2 = (Double)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (d2 == null) {
            this.lastColumnNull = true;
        }
        return d2;
    }

    public Float getDataFloat(int n2) throws SQLException {
        Float f2;
        this.lastColumnNull = false;
        try {
            f2 = this.OdbcApi.SQLGetDataFloat(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            f2 = (Float)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (f2 == null) {
            this.lastColumnNull = true;
        }
        return f2;
    }

    public Integer getDataInteger(int n2) throws SQLException {
        Integer n3;
        this.lastColumnNull = false;
        try {
            n3 = this.OdbcApi.SQLGetDataInteger(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            n3 = (Integer)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (n3 == null) {
            this.lastColumnNull = true;
        } else if (n2 == this.sqlTypeColumn) {
            n3 = new Integer(OdbcDef.odbcTypeToJdbc(n3));
        }
        return n3;
    }

    public Long getDataLong(int n2) throws SQLException {
        Long l2 = null;
        Double d2 = this.getDataDouble(n2);
        if (d2 != null) {
            l2 = new Long(d2.longValue());
        }
        return l2;
    }

    public Object getObject(int n2) throws SQLException {
        this.checkOpen();
        Object object = null;
        int n3 = this.getColumnType(n2);
        int n4 = n2;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n2);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n2, this.getScale(n4));
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n2));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n2));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n2));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n2));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n2);
                break;
            }
            case 91: {
                object = this.getDate(n2);
                break;
            }
            case 92: {
                object = this.getTime(n2);
                break;
            }
            case 93: {
                object = this.getTimestamp(n2);
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    protected void bindStringCol(int n2, int n3, Object[] objectArray, byte[] byArray, int n4) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer((n4 + 1) * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColString(this.hStmt, n2, n3, objectArray, n4, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.updateObject(n2, object, 0, this.boundCols[n2 - 1].getType());
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object, n3, this.boundCols[n2 - 1].getType());
    }

    protected void updateObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkOpen();
        if (n4 == 9999 && object != null) {
            n4 = JdbcOdbcStatement.getTypeFromObject(object);
        } else if (object == null) {
            n4 = 0;
        }
        if (n2 > 0 && n2 <= this.numberOfCols) {
            switch (n4) {
                case 1: 
                case 12: {
                    this.updateString(n2, (String)object);
                    break;
                }
                case -1: {
                    if (object instanceof byte[] && (byte[])object != null) {
                        byte[] byArray = (byte[])object;
                        this.updateAsciiStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    if (object instanceof Reader && (Reader)object != null) {
                        throw new SQLException("Unknown length for Reader Object, try updateCharacterStream.");
                    }
                    if (!(object instanceof String) || (String)object == null) break;
                    this.updateString(n2, (String)object);
                    break;
                }
                case 2: 
                case 3: {
                    this.updateBigDecimal(n2, (BigDecimal)object);
                    break;
                }
                case -7: {
                    this.updateBoolean(n2, (boolean)((Boolean)object));
                    break;
                }
                case -6: {
                    this.updateByte(n2, (byte)((Integer)object).intValue());
                    break;
                }
                case 5: {
                    this.updateShort(n2, (short)((Integer)object).intValue());
                    break;
                }
                case 4: {
                    this.updateInt(n2, (int)((Integer)object));
                    break;
                }
                case -5: {
                    this.updateLong(n2, ((Integer)object).longValue());
                    break;
                }
                case 6: 
                case 7: {
                    this.updateFloat(n2, ((Float)object).floatValue());
                    break;
                }
                case 8: {
                    this.updateDouble(n2, (double)((Double)object));
                    break;
                }
                case -2: {
                    if (object instanceof String) {
                        try {
                            this.updateBytes(n2, ((String)object).getBytes(this.OdbcApi.charSet));
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException(unsupportedEncodingException.getMessage());
                        }
                    }
                    this.updateBytes(n2, (byte[])object);
                    break;
                }
                case -4: 
                case -3: {
                    byte[] byArray = null;
                    if (object instanceof String) {
                        try {
                            byArray = ((String)object).getBytes(this.OdbcApi.charSet);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException(unsupportedEncodingException.getMessage());
                        }
                    } else {
                        byArray = (byte[])object;
                    }
                    if (byArray.length > 8000) {
                        this.updateBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    this.updateBytes(n2, byArray);
                    break;
                }
                case 91: {
                    this.updateDate(n2, (Date)object);
                    break;
                }
                case 92: {
                    this.updateTime(n2, (Time)object);
                    break;
                }
                case 93: {
                    this.updateTimestamp(n2, (Timestamp)object);
                    break;
                }
                case 0: {
                    this.updateNull(n2);
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type for ResultSet.updateObject SQL Type = " + n4);
                }
            }
        }
    }

    protected void bindDateCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(10 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDate(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindDoubleCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(8 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDouble(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindFloatCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(8 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColFloat(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindIntegerCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(4 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColInteger(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindTimeCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(9 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTime(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindTimestampCol(int n2, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer(30 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTimestamp(this.hStmt, n2, objectArray, byArray, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    protected void bindBinaryCol(int n2, Object[] objectArray, byte[] byArray, int n3) throws SQLException {
        byte[] byArray2 = this.boundCols[n2 - 1].allocBindDataBuffer((n3 + 1) * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColBinary(this.hStmt, n2, objectArray, byArray, n3, byArray2, lArray);
        this.boundCols[n2 - 1].pA1 = lArray[0];
        this.boundCols[n2 - 1].pA2 = lArray[1];
        this.boundCols[n2 - 1].pC1 = lArray[2];
        this.boundCols[n2 - 1].pC2 = lArray[3];
    }

    public String getCursorName() throws SQLException {
        this.checkOpen();
        String string = "";
        this.clearWarnings();
        try {
            string = this.OdbcApi.SQLGetCursorName(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    public String getDataStringDate(int n2) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringDate(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTime(int n2) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTime(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTimestamp(int n2) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getString(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n3 = this.getMaxCharLen(n2);
        int n4 = this.getColumnLength(n2);
        String string = null;
        if (n4 > Short.MAX_VALUE) {
            JdbcOdbcInputStream jdbcOdbcInputStream = (JdbcOdbcInputStream)this.getAsciiStream(n2);
            try {
                byte[] byArray = jdbcOdbcInputStream.readAllData();
                if (byArray != null) {
                    if (byArray.length > 2 && byArray[1] == 0) {
                        string = this.BytesToChars("UnicodeLittleUnmarked", byArray);
                    }
                    if (byArray.length >= 2 && byArray[0] == 0) {
                        string = this.BytesToChars("UnicodeBigUnmarked", byArray);
                    }
                    string = this.BytesToChars(this.OdbcApi.charSet, byArray);
                }
                this.lastColumnNull = true;
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException(exception.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            if (n3 == -1) {
                this.lastColumnNull = true;
                return null;
            }
            boolean bl2 = true;
            int n5 = this.getColumnType(n2);
            switch (n5) {
                case -1: 
                case 1: 
                case 12: {
                    bl2 = false;
                    break;
                }
            }
            string = this.getDataString(n2, ++n3, bl2);
            if (string == null) {
                this.lastColumnNull = true;
                return string;
            }
            int n6 = string.length();
            if (n6 == n3 - 1 && !bl2) {
                string = string.substring(0, n3 - 1);
            }
            if ((n5 == -1 || n5 == -4) && n6 == n3 - 1) {
                String string2 = string;
                while (string2.length() == Short.MAX_VALUE && (string2 = this.getDataString(n2, n3, bl2)) != null) {
                    if (this.OdbcApi.getTracer().isTracing()) {
                        this.OdbcApi.getTracer().trace("" + string2.length() + " byte(s) read");
                    }
                    if (string2.length() == n3) {
                        string2 = string2.substring(0, n3 - 1);
                    }
                    string = string + string2;
                    if (!this.OdbcApi.getTracer().isTracing()) continue;
                    this.OdbcApi.getTracer().trace("" + string.length() + " bytes total");
                }
            }
        }
        return string;
    }

    protected void updateChar(int n2, int n3, String string) throws SQLException {
        this.checkOpen();
        int n4 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            int n5 = this.getColumnType(n2);
            if (n5 != n3) {
                this.boundCols[n2 - 1].setType(n3);
            }
            if (string == null) {
                this.updateNull(n2);
            } else {
                this.boundCols[n2 - 1].setRowValues(n4, string, -3);
            }
        }
    }

    public String getDataString(int n2, int n3, boolean bl2) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataString(this.hStmt, n2, n3, bl2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        } else if (n2 == this.sqlTypeColumn) {
            try {
                int n4 = OdbcDef.odbcTypeToJdbc(Integer.valueOf(string));
                string = "" + n4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public void updateString(int n2, String string) throws SQLException {
        byte[] byArray;
        this.checkOpen();
        try {
            byArray = string == null ? null : string.getBytes(this.OdbcApi.charSet);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        this.updateBytes(n2, byArray);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        Integer n2;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((n2 = (Integer)this.colNameToNum.get(string)) == null) {
            for (int i2 = 1; i2 <= this.rsmd.getColumnCount(); ++i2) {
                String string2 = (String)this.colNumToName.get(new Integer(i2));
                if (string2 == null) {
                    string2 = this.rsmd.getColumnName(i2);
                    this.colNameToNum.put(string2, new Integer(i2));
                    this.colNumToName.put(new Integer(i2), string2);
                }
                if (!string2.equalsIgnoreCase(string)) continue;
                return i2;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return n2;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateInt(this.findColumn(string), (int)by);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void setAliasColumnName(String string, int n2) {
        if (n2 > 0 && n2 <= this.numberOfCols) {
            this.boundCols[n2 - 1].setAliasName(string);
        }
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateFloat(this.findColumn(string), (float)l2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateInt(this.findColumn(string), (int)s2);
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkOpen();
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            String string = this.getDataString(n2, 300, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkOpen();
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) == null) {
            String string = this.getDataString(n2, 300, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string);
                bigDecimal = bigDecimal.setScale(n3, 6);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        int n3 = this.getColumnType(n2);
        if (n3 == 3 || n3 == 2) {
            if (bigDecimal == null) {
                this.updateChar(n2, n3, null);
            } else {
                this.updateChar(n2, n3, bigDecimal.toString());
            }
        } else if (bigDecimal == null) {
            this.updateChar(n2, 2, null);
        } else {
            this.updateChar(n2, 2, bigDecimal.toString());
        }
    }

    public URL getURL(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(int n2, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringDate(n2);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != 91) {
                this.boundCols[n2 - 1].setType(91);
            }
            if (date == null) {
                this.updateNull(n2);
                return;
            }
            this.boundCols[n2 - 1].setRowValues(n3, date, 6);
        }
    }

    protected int parameterQuery(PreparedStatement preparedStatement) throws SQLException {
        int n2 = 0;
        Object[] objectArray = null;
        int[] nArray = null;
        if (preparedStatement != null) {
            try {
                objectArray = this.ownerStatement.getObjects();
                nArray = this.ownerStatement.getObjectTypes();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    preparedStatement.setObject(i2 + 1, objectArray[i2], nArray[i2]);
                }
            }
            catch (Exception exception) {
                throw new SQLException("while calculating row count: " + exception.getMessage());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n2 = resultSet.getInt(1);
            preparedStatement.close();
        }
        return n2;
    }

    public Ref getRef(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, this);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.lastWarning;
    }

    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.checkOpen();
        this.lastWarning = sQLWarning;
    }

    public Statement getStatement() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement;
        }
        return null;
    }

    public Time getTime(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTime(n2);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != 92) {
                this.boundCols[n2 - 1].setType(92);
            }
            if (time == null) {
                this.updateNull(n2);
                return;
            }
            this.boundCols[n2 - 1].setRowValues(n3, time, 6);
        }
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n2 = this.mapColumn(n2);
        this.consecutiveFetch(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTimestamp(n2);
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = string + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n2 > 0 && n2 <= this.numberOfCols) {
            if (this.getColumnType(n2) != 93) {
                this.boundCols[n2 - 1].setType(93);
            }
            if (timestamp == null) {
                this.updateNull(n2);
                return;
            }
            this.boundCols[n2 - 1].setRowValues(n3, timestamp, 16);
        }
    }

    public long getDataLongDate(int n2, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Date date = null;
        long l2 = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringDate(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            date = Date.valueOf(string);
            l2 = this.utils.convertFromGMT(date, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l2;
    }

    public long getDataLongTime(int n2, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Time time = null;
        long l2 = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringTime(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            time = Time.valueOf(string);
            l2 = this.utils.convertFromGMT(time, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l2;
    }

    public long getDataLongTimestamp(int n2, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Timestamp timestamp = null;
        long l2 = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            timestamp = Timestamp.valueOf(string);
            l2 = this.utils.convertFromGMT(timestamp, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l2;
    }

    protected void setInputStream(int n2, JdbcOdbcInputStream jdbcOdbcInputStream) {
        if (n2 > 0 && n2 <= this.numberOfCols) {
            this.boundCols[n2 - 1].setInputStream(jdbcOdbcInputStream);
        }
    }

    public JdbcOdbcPseudoCol getPseudoCol(int n2) {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol = null;
        if (n2 > 0 && n2 >= this.firstPseudoCol && n2 <= this.lastPseudoCol) {
            jdbcOdbcPseudoCol = this.pseudoCols[n2 - this.firstPseudoCol];
        }
        return jdbcOdbcPseudoCol;
    }

    public void setPseudoCols(int n2, int n3, JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray) {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Setting pseudo columns, first=" + n2 + ", last=" + n3);
        }
        this.firstPseudoCol = n2;
        this.lastPseudoCol = n3;
        this.pseudoCols = jdbcOdbcPseudoColArray;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getCharacterStream(n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    protected String reWordAsCountQuery(String string) {
        int n2 = string.indexOf(" COUNT(*) ");
        int n3 = -1;
        int n4 = string.indexOf(" FROM ");
        int n5 = string.indexOf("'");
        int n6 = -1;
        if (n5 > 0) {
            n6 = string.indexOf("'", n5 + 2);
        }
        if (n4 > n5 && n6 > n4) {
            n4 = string.indexOf(" FROM ", n6);
        }
        if (n2 > n5 && n6 > n2) {
            n2 = -1;
        }
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = string.indexOf("WHERE");
        int n13 = -1;
        if (n12 < n4) {
            n12 = string.indexOf("WHERE", n12 + 2);
        }
        String string2 = "";
        if (n11 < 0) {
            n7 = string.lastIndexOf("ORDER BY");
            if (n7 > n12) {
                n11 = n7;
            }
            string2 = "ORDER BY";
        }
        if (n11 < 0) {
            n8 = string.lastIndexOf("GROUP BY");
            if (n8 > n12 && n8 > n7) {
                n11 = n8;
            }
            string2 = "GROUP BY";
        }
        if (n11 < 0) {
            n9 = string.lastIndexOf("FOR UPDATE");
            if (n9 > n12 && n9 > n8) {
                n11 = n9;
            }
            string2 = "FOR UPDATE";
        }
        if (n11 < 0) {
            n10 = string.lastIndexOf("UNION");
            if (n10 > n12 && n10 > n9) {
                n11 = n10;
            }
            string2 = "UNION";
        }
        if (n11 > 0 && n11 > n4) {
            if (n12 > 0 && n12 > n4) {
                int n14 = string.indexOf("'", n12);
                int n15 = -1;
                if (n14 > 0) {
                    n15 = string.indexOf("'", n14 + 2);
                }
                if (n11 > n14 && n6 > n11) {
                    n11 = string.indexOf(string2, n15);
                }
                if (n11 > n15) {
                    string = string.substring(0, n11);
                }
            } else {
                string = string.substring(0, n11);
            }
        }
        String string3 = string.substring(0, n4);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n2 < 0 && n3 < 0 && (n3 = string3.lastIndexOf(")")) > 0) {
            int n16 = string.indexOf(" (");
            if (n16 > 0) {
                if (n16 < n5 && n16 < n6) {
                    n3 = -1;
                }
            } else if (n16 < 0) {
                n3 = -1;
                n2 = n16;
            }
        }
        if (n3 > 0) {
            stringBuffer.insert(6, " COUNT(*), ");
        } else if (n2 < 0 && n4 > 0) {
            stringBuffer.replace(6, n4, " COUNT(*) ");
        }
        return stringBuffer.toString();
    }

    public String mapColumnName(String string, int n2) {
        if (n2 > 0 && n2 <= this.numberOfCols) {
            return this.boundCols[n2 - 1].mapAliasName(string);
        }
        return string;
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l2 = 0L;
        n2 = this.mapColumn(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l2 = this.getDataLongDate(n2, calendar);
        if (l2 == 0L) {
            return null;
        }
        return new Date(l2);
    }

    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l2 = 0L;
        n2 = this.mapColumn(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l2 = this.getDataLongTime(n2, calendar);
        if (l2 == 0L) {
            return null;
        }
        return new Time(l2);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l2 = 0L;
        n2 = this.mapColumn(n2);
        if (this.getPseudoCol(n2) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l2 = this.getDataLongTimestamp(n2, calendar);
        if (l2 == 0L) {
            return null;
        }
        return new Timestamp(l2);
    }

    public void initialize(JdbcOdbc jdbcOdbc, long l2, long l3, boolean bl2, JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        int n2;
        this.OdbcApi = jdbcOdbc;
        this.hDbc = l2;
        this.hStmt = l3;
        this.keepHSTMT = bl2;
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new JdbcOdbcBoundCol[this.numberOfCols];
        for (n2 = 0; n2 < this.numberOfCols; ++n2) {
            this.boundCols[n2] = new JdbcOdbcBoundCol();
        }
        this.ownerStatement = jdbcOdbcStatement;
        this.rowPosition = 0;
        this.lastForwardRecord = 0;
        this.lastRowPosition = 0;
        this.lastColumnData = 0;
        this.currentBlockCell = 0;
        this.blockCursor = false;
        this.rowSet = 1;
        if (this.getType() != 1003) {
            if (this.ownerStatement != null) {
                this.rowSet = this.ownerStatement.getBlockCursorSize();
            }
            this.setRowStatusPtr();
            this.setResultSetVisibilityIndicators();
            this.calculateRowCount();
            if (this.numberOfRows >= 0) {
                n2 = 0;
                n2 = this.setRowArraySize() ? 1 : 0;
                if (n2 == 0) {
                    this.rowSet = 1;
                }
                if (this.pA != null && this.pA[0] != 0L) {
                    JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                    this.pA[0] = 0L;
                    this.pA[1] = 0L;
                }
                this.setRowStatusPtr();
                if (this.rowSet > 1) {
                    this.blockCursor = true;
                    this.setCursorType();
                }
                for (int i2 = 0; i2 < this.numberOfCols; ++i2) {
                    this.boundCols[i2].initStagingArea(this.rowSet);
                }
            }
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }
}

