/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private InputStream socketInputStream = null;

    public int getLocalPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getPort();
    }

    public int getPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.opts().getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public int getTrafficClass() throws SocketException {
        int n2 = this.opts().getTrafficClass();
        if (n2 < 0) {
            n2 = this.trafficClass;
        }
        return n2;
    }

    public void close() throws IOException {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        return this.opts().getKeepAlive();
    }

    public boolean getOOBInline() throws SocketException {
        return this.opts().getOOBInline();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.opts().getTcpNoDelay();
    }

    public boolean isBound() {
        return this.sc.isBound();
    }

    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    public void sendUrgentData(int n2) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setReceiveBufferSize(int n2) throws SocketException {
        this.opts().setReceiveBufferSize(n2);
    }

    public void setSendBufferSize(int n2) throws SocketException {
        this.opts().setSendBufferSize(n2);
    }

    public void setSoTimeout(int n2) throws SocketException {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n2;
    }

    public void setTrafficClass(int n2) throws SocketException {
        this.opts().setTrafficClass(n2);
        this.trafficClass = n2;
    }

    public void setKeepAlive(boolean bl2) throws SocketException {
        this.opts().setKeepAlive(bl2);
    }

    public void setOOBInline(boolean bl2) throws SocketException {
        this.opts().setOOBInline(bl2);
    }

    public void setReuseAddress(boolean bl2) throws SocketException {
        this.opts().setReuseAddress(bl2);
    }

    public void setTcpNoDelay(boolean bl2) throws SocketException {
        this.opts().setTcpNoDelay(bl2);
    }

    public void setSoLinger(boolean bl2, int n2) throws SocketException {
        this.opts().setSoLinger(bl2, n2);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public InetAddress getInetAddress() {
        if (!this.sc.isConnected()) {
            return null;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.sc.isBound()) {
            return new InetSocketAddress(0).getAddress();
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getAddress();
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(SocketAddress socketAddress, int n2) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (n2 == 0) {
                    this.sc.connect(socketAddress);
                    return;
                }
                SelectionKey selectionKey = null;
                Selector selector = null;
                this.sc.configureBlocking(false);
                try {
                    block21: {
                        long l2;
                        if (this.sc.connect(socketAddress)) {
                            Object var13_7 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (this.sc.isOpen()) {
                                this.sc.configureBlocking(true);
                            }
                            if (selector == null) return;
                            Util.releaseTemporarySelector(selector);
                            return;
                        }
                        selector = Util.getTemporarySelector(this.sc);
                        selectionKey = this.sc.register(selector, 8);
                        long l3 = n2;
                        do {
                            if (!this.sc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            l2 = System.currentTimeMillis();
                            int n3 = selector.select(l3);
                            if (n3 > 0 && selectionKey.isConnectable() && this.sc.finishConnect()) break block21;
                            selector.selectedKeys().remove(selectionKey);
                        } while ((l3 -= System.currentTimeMillis() - l2) > 0L);
                        try {
                            this.sc.close();
                            throw new SocketTimeoutException();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    Object var13_8 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (selector == null) return;
                    Util.releaseTemporarySelector(selector);
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (selector == null) throw throwable;
                    Util.releaseTemporarySelector(selector);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Net.translateException(exception, true);
            }
            return;
        }
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.sc);
        }
        return this.opts;
    }

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) {
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        return new SocketAdaptor(socketChannelImpl);
    }

    private class SocketInputStream
    extends ChannelInputStream {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = SocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!SocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (SocketAdaptor.this.timeout == 0) {
                    return SocketAdaptor.this.sc.read(byteBuffer);
                }
                SelectionKey selectionKey = null;
                Selector selector = null;
                SocketAdaptor.this.sc.configureBlocking(false);
                try {
                    long l2;
                    int n2 = SocketAdaptor.this.sc.read(byteBuffer);
                    if (n2 != 0) {
                        int n3 = n2;
                        Object var13_8 = null;
                        if (selectionKey != null) {
                            selectionKey.cancel();
                        }
                        if (SocketAdaptor.this.sc.isOpen()) {
                            SocketAdaptor.this.sc.configureBlocking(true);
                        }
                        if (selector == null) return n3;
                        Util.releaseTemporarySelector(selector);
                        return n3;
                    }
                    selector = Util.getTemporarySelector(SocketAdaptor.this.sc);
                    selectionKey = SocketAdaptor.this.sc.register(selector, 1);
                    long l3 = SocketAdaptor.this.timeout;
                    do {
                        if (!SocketAdaptor.this.sc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l2 = System.currentTimeMillis();
                        int n4 = selector.select(l3);
                        if (n4 > 0 && selectionKey.isReadable() && (n2 = SocketAdaptor.this.sc.read(byteBuffer)) != 0) {
                            int n5 = n2;
                            Object var13_9 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (SocketAdaptor.this.sc.isOpen()) {
                                SocketAdaptor.this.sc.configureBlocking(true);
                            }
                            if (selector == null) return n5;
                            Util.releaseTemporarySelector(selector);
                            return n5;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l3 -= System.currentTimeMillis() - l2) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (SocketAdaptor.this.sc.isOpen()) {
                        SocketAdaptor.this.sc.configureBlocking(true);
                    }
                    if (selector == null) throw throwable;
                    Util.releaseTemporarySelector(selector);
                    throw throwable;
                }
            }
        }

        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }
    }
}

