/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.br;
import sun.security.krb5.internal.ccache.a3;
import sun.security.krb5.internal.n;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddresses
implements Cloneable {
    private static boolean DEBUG = br.ed;
    private n[] addresses = null;
    private volatile int hashCode = 0;

    public int hashCode() {
        if (this.hashCode == 0) {
            int n2 = 17;
            if (this.addresses != null) {
                int n3 = 0;
                while (n3 < this.addresses.length) {
                    n2 = 37 * n2 + this.addresses[n3].hashCode();
                    ++n3;
                }
            }
            this.hashCode = n2;
        }
        return this.hashCode;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new n[1];
        this.addresses[0] = new n();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            int n2 = 0;
            while (n2 < this.addresses.length) {
                derOutputStream.write(this.addresses[n2].c());
                ++n2;
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    private HostAddresses(int n2) {
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new n[this.addresses.length];
            int n2 = 0;
            while (n2 < this.addresses.length) {
                hostAddresses.addresses[n2] = (n)this.addresses[n2].clone();
                ++n2;
            }
        }
        return hostAddresses;
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            try {
                if (this.addresses[n2].a == 2) {
                    arrayList.add(this.addresses[n2].b());
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            ++n2;
        }
        Object[] objectArray = new InetAddress[arrayList.size()];
        return (InetAddress[])arrayList.toArray(objectArray);
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new n[inetAddressArray.length];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            this.addresses[n2] = new n(inetAddressArray[n2]);
            ++n2;
        }
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException("TBD: Bad name");
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        n[] nArray = new n[inetAddressArray.length];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            nArray[n2] = new n(inetAddressArray[n2]);
            ++n2;
        }
        this.addresses = nArray;
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        String string = null;
        InetAddress[] inetAddressArray = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            n[] nArray = new n[inetAddressArray.length];
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                nArray[n2] = new n(inetAddressArray[n2]);
                ++n2;
            }
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq local addresses for " + string + " are: ");
                int n3 = 0;
                while (n3 < inetAddressArray.length) {
                    System.out.println("\n\t" + inetAddressArray[n3]);
                    ++n3;
                }
            }
            return new HostAddresses(nArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.addresses.length) {
                if (!this.addresses[n2].a(hostAddresses.addresses[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void writeAddrs(a3 a32) throws IOException {
        a32.a(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            a32.b(this.addresses[n2].a);
            a32.a(this.addresses[n2].b.length);
            a32.write(this.addresses[n2].b, 0, this.addresses[n2].b.length);
            ++n2;
        }
    }

    public boolean inList(n n2) {
        if (this.addresses != null) {
            int n3 = 0;
            while (n3 < this.addresses.length) {
                if (this.addresses[n3].a(n2)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public HostAddresses(n[] nArray) throws IOException {
        if (nArray != null) {
            this.addresses = new n[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == null) {
                    throw new IOException("Cannot create a HostAddress");
                }
                this.addresses[n2] = (n)nArray[n2].clone();
                ++n2;
            }
        }
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector vector = new Vector();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new n(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new n[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }
}

