/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            if ((this.style & 0x200) != 0) {
                int n3 = OS.GetThemeSysSize(n2, 2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n3;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n3;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                int n4 = rectangle.height - 2 * n3;
                int n5 = Math.max(n3 / 2, n4 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n6 = rectangle.y + n3 + Math.max(0, n4 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n3;
                rECT.bottom = n6;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n5;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(n2, gC.handle, 9, nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n3;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
            } else {
                int n7 = OS.GetThemeSysSize(n2, 2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n7;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n7;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                int n8 = rectangle.width - 2 * n7;
                int n9 = Math.max(n7 / 2, n8 * this.thumb / (this.maximum - this.minimum));
                int n10 = rectangle.x + n7 + Math.max(0, n8 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n7;
                rECT.right = n10;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rECT.left + n9;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(n2, gC.handle, 8, nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n7;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(n2);
        }
    }

    char[] getClassId() {
        return SCROLLBAR;
    }

    int[] getPartId(int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.state[n2];
        switch (n2) {
            case 1: {
                n3 = 1;
                if ((this.style & 0x200) != 0) {
                    n4 = 1;
                    if ((n5 & 0x40) != 0) {
                        n4 = 2;
                    }
                    if ((n5 & 8) != 0) {
                        n4 = 3;
                    }
                    if ((n5 & 0x20) == 0) break;
                    n4 = 4;
                    break;
                }
                n4 = 9;
                if ((n5 & 0x40) != 0) {
                    n4 = 10;
                }
                if ((n5 & 8) != 0) {
                    n4 = 11;
                }
                if ((n5 & 0x20) == 0) break;
                n4 = 12;
                break;
            }
            case 2: {
                n3 = 1;
                if ((this.style & 0x200) != 0) {
                    n4 = 5;
                    if ((n5 & 0x40) != 0) {
                        n4 = 6;
                    }
                    if ((n5 & 8) != 0) {
                        n4 = 7;
                    }
                    if ((n5 & 0x20) == 0) break;
                    n4 = 8;
                    break;
                }
                n4 = 13;
                if ((n5 & 0x40) != 0) {
                    n4 = 14;
                }
                if ((n5 & 8) != 0) {
                    n4 = 15;
                }
                if ((n5 & 0x20) == 0) break;
                n4 = 16;
                break;
            }
            case 0: 
            case 5: {
                if ((this.style & 0x200) != 0) {
                    n3 = 3;
                    break;
                }
                n3 = 2;
                break;
            }
            case 3: {
                if ((this.style & 0x200) != 0) {
                    n3 = 7;
                    break;
                }
                n3 = 5;
                break;
            }
            case 4: {
                n3 = (this.style & 0x200) != 0 ? 6 : 4;
            }
        }
        if (n2 != 2 && n2 != 1) {
            n4 = 1;
            if ((n5 & 0x40) != 0) {
                n4 = 2;
            }
            if ((n5 & 8) != 0) {
                n4 = 3;
            }
            if ((n5 & 0x20) != 0) {
                n4 = 4;
            }
        }
        return new int[]{n3, n4};
    }

    Rectangle getBounds(int n2, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n3 = OS.OpenThemeData(0, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n4 = OS.GetThemeSysSize(n3, 2);
                int n5 = rectangle.height - 2 * n4;
                int n6 = Math.max(n4 / 2, n5 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n7 = rectangle.y + n4 + Math.max(0, n5 * this.selection / Math.max(1, this.maximum - this.minimum));
                switch (n2) {
                    case 2: {
                        return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n4, rectangle.width, n4);
                    }
                    case 1: {
                        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n4);
                    }
                    case 3: {
                        return new Rectangle(rectangle.x, rectangle.y + n4, rectangle.width, n7 - rectangle.y - n4);
                    }
                    case 5: {
                        return new Rectangle(rectangle.x, n7, rectangle.width, n6);
                    }
                    case 4: {
                        return new Rectangle(rectangle.x, n7 + n6, rectangle.width, rectangle.y + rectangle.height - n4 - n7 - n6);
                    }
                }
            }
            OS.CloseThemeData(n3);
        }
        return super.getBounds(n2, rectangle);
    }

    int getSelection(Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData(0, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n3 = OS.GetThemeSysSize(n2, 2);
                int n4 = rectangle.height - 2 * n3;
                int n5 = rectangle.y + n3 + Math.max(0, n4 * this.selection / Math.max(1, this.maximum - this.minimum));
                int n6 = ((n5 += point.y) - rectangle.y - n3) * (this.maximum - this.minimum) / n4;
                return Math.max(0, Math.min(n6, this.maximum - this.thumb));
            }
            OS.CloseThemeData(n2);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6) return -1;
        if (!OS.IsAppThemed()) {
            return -1;
        }
        int n2 = OS.OpenThemeData(0, this.getClassId());
        int n3 = 0;
        RECT rECT = new RECT();
        POINT pOINT = new POINT();
        pOINT.x = point.x;
        pOINT.y = point.y;
        short[] sArray = new short[1];
        try {
            block28: {
                block29: {
                    int[] nArray;
                    int n4;
                    block33: {
                        block27: {
                            int n5;
                            block32: {
                                block25: {
                                    block31: {
                                        block23: {
                                            block30: {
                                                block21: {
                                                    block19: {
                                                        int[] nArray2;
                                                        int n6;
                                                        block26: {
                                                            int n7;
                                                            block24: {
                                                                block22: {
                                                                    block20: {
                                                                        if ((this.style & 0x200) == 0) break block19;
                                                                        n6 = OS.GetThemeSysSize(n2, 2);
                                                                        rECT.left = rectangle.x;
                                                                        rECT.right = rECT.left + rectangle.width;
                                                                        rECT.top = rectangle.y;
                                                                        rECT.bottom = rECT.top + n6;
                                                                        nArray2 = this.getPartId(1);
                                                                        OS.HitTestThemeBackground(n2, n3, nArray2[0], nArray2[1], 0, rECT, 0, pOINT, sArray);
                                                                        if (sArray[0] == 0) break block20;
                                                                        break block21;
                                                                    }
                                                                    rECT.bottom = rectangle.y + rectangle.height;
                                                                    rECT.top = rECT.bottom - n6;
                                                                    nArray2 = this.getPartId(2);
                                                                    OS.HitTestThemeBackground(n2, n3, nArray2[0], nArray2[1], 0, rECT, 0, pOINT, sArray);
                                                                    if (sArray[0] == 0) break block22;
                                                                    break block23;
                                                                }
                                                                int n8 = rectangle.height - 2 * n6;
                                                                n7 = Math.max(n6 / 2, n8 * this.thumb / Math.max(1, this.maximum - this.minimum));
                                                                int n9 = rectangle.y + n6 + Math.max(0, n8 * this.selection / Math.max(1, this.maximum - this.minimum));
                                                                rECT.top = rectangle.y + n6;
                                                                rECT.bottom = n9;
                                                                nArray2 = this.getPartId(5);
                                                                OS.HitTestThemeBackground(n2, n3, nArray2[0], nArray2[1], 0, rECT, 0, pOINT, sArray);
                                                                if (sArray[0] == 0) break block24;
                                                                break block25;
                                                            }
                                                            rECT.top = rECT.bottom;
                                                            rECT.bottom = rECT.top + n7;
                                                            nArray2 = this.getPartId(3);
                                                            OS.HitTestThemeBackground(n2, n3, nArray2[0], nArray2[1], 0, rECT, 0, pOINT, sArray);
                                                            if (sArray[0] == 0) break block26;
                                                            break block27;
                                                        }
                                                        rECT.top = rECT.bottom;
                                                        rECT.bottom = rectangle.y + rectangle.height - n6;
                                                        nArray2 = this.getPartId(4);
                                                        OS.HitTestThemeBackground(n2, n3, nArray2[0], nArray2[1], 0, rECT, 0, pOINT, sArray);
                                                        if (sArray[0] == 0) break block28;
                                                        break block29;
                                                    }
                                                    n4 = OS.GetThemeSysSize(n2, 2);
                                                    rECT.top = rectangle.y;
                                                    rECT.bottom = rECT.top + rectangle.height;
                                                    rECT.left = rectangle.x;
                                                    rECT.right = rECT.left + n4;
                                                    nArray = this.getPartId(1);
                                                    OS.HitTestThemeBackground(n2, n3, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                                                    if (sArray[0] == 0) break block30;
                                                }
                                                Object var14_13 = null;
                                                OS.CloseThemeData(n2);
                                                return 1;
                                            }
                                            rECT.right = rectangle.x + rectangle.width;
                                            rECT.left = rECT.right - n4;
                                            nArray = this.getPartId(2);
                                            OS.HitTestThemeBackground(n2, n3, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                                            if (sArray[0] == 0) break block31;
                                        }
                                        Object var14_14 = null;
                                        OS.CloseThemeData(n2);
                                        return 2;
                                    }
                                    int n10 = rectangle.width - 2 * n4;
                                    n5 = Math.max(n4 / 2, n10 * this.thumb / (this.maximum - this.minimum));
                                    int n11 = rectangle.x + n4 + Math.max(0, n10 * this.selection / Math.max(1, this.maximum - this.minimum));
                                    rECT.left = rectangle.x + n4;
                                    rECT.right = n11;
                                    nArray = this.getPartId(3);
                                    OS.HitTestThemeBackground(n2, n3, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                                    if (sArray[0] == 0) break block32;
                                }
                                Object var14_15 = null;
                                OS.CloseThemeData(n2);
                                return 3;
                            }
                            rECT.left = rECT.right;
                            rECT.right = rECT.left + n5;
                            nArray = this.getPartId(5);
                            OS.HitTestThemeBackground(n2, n3, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                            if (sArray[0] == 0) break block33;
                        }
                        Object var14_16 = null;
                        OS.CloseThemeData(n2);
                        return 5;
                    }
                    rECT.left = rECT.right;
                    rECT.right = rectangle.x + rectangle.width - n4;
                    nArray = this.getPartId(4);
                    OS.HitTestThemeBackground(n2, n3, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                    if (sArray[0] == 0) break block28;
                }
                Object var14_17 = null;
                OS.CloseThemeData(n2);
                return 4;
            }
            Object var14_19 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            OS.CloseThemeData(n2);
            throw throwable;
        }
        OS.CloseThemeData(n2);
        return -1;
    }
}

