/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int INSET = 1;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = this.clientArea.x;
            rECT.right = this.clientArea.x + this.clientArea.width;
            rECT.top = this.clientArea.y;
            rECT.bottom = this.clientArea.y + this.clientArea.height;
            RECT rECT2 = new RECT();
            int[] nArray = this.getPartId(0);
            OS.GetThemeBackgroundExtent(n2, gC.handle, nArray[0], nArray[1], rECT, rECT2);
            OS.CloseThemeData(n2);
            if ((this.style & 4) != 0) {
                SIZE sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(n2, 0, nArray[0], nArray[1], null, 1, sIZE);
                rECT2.right = Math.max(rECT2.left, rECT2.right + sIZE.cx);
            } else {
                --rECT2.left;
                --rECT2.top;
                ++rECT2.right;
                ++rECT2.bottom;
            }
            return new Rectangle(rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            SIZE sIZE = null;
            int[] nArray = null;
            if ((this.style & 4) != 0) {
                sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(n2, gC.handle, nArray[0], nArray[1], rECT, 1, sIZE);
                rECT.right -= sIZE.cx;
                if (rECT.right < rECT.left) {
                    rECT.right = rECT.left;
                }
            }
            int[] nArray2 = this.getPartId(0);
            OS.DrawThemeBackground(n2, gC.handle, nArray2[0], nArray2[1], rECT, null);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect(n2, gC.handle, nArray2[0], nArray2[1], rECT, rECT2);
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
            if ((this.style & 4) != 0) {
                rECT.left = rECT.right;
                rECT.right = rECT.left + sIZE.cx;
                OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(n2);
        }
    }

    char[] getClassId() {
        return TOOLBAR;
    }

    int[] getPartId(int n2) {
        int n3 = this.state[n2];
        int n4 = 0;
        int n5 = 0;
        switch (n2) {
            case 0: {
                if ((this.style & 0x38) != 0) {
                    n4 = 1;
                } else if ((this.style & 4) != 0) {
                    n4 = 3;
                } else if ((this.style & 2) != 0) {
                    n4 = (this.parent.style & 0x200) != 0 ? 6 : 5;
                }
                if ((this.style & 2) != 0) break;
                if ((n3 & 0x40) != 0) {
                    n5 = (this.style & 0x30) != 0 && (n3 & 2) != 0 ? 6 : 2;
                }
                if ((this.style & 0x30) != 0 && (n3 & 2) != 0) {
                    n5 = 5;
                }
                if ((n3 & 8) != 0) {
                    n5 = 3;
                }
                if ((n3 & 0x20) == 0) break;
                n5 = 4;
                break;
            }
            case 1: {
                n4 = 4;
                if ((n3 & 0x40) != 0) {
                    n5 = 2;
                }
                if ((n3 & 8) != 0) {
                    n5 = 3;
                }
                if ((n3 & 0x20) == 0) break;
                n5 = 4;
            }
        }
        return new int[]{n4, n5};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int hit(Theme theme, Point point, Rectangle rectangle) {
        int n2;
        block6: {
            if (OS.COMCTL32_MAJOR < 6) return -1;
            if (!OS.IsAppThemed()) {
                return -1;
            }
            if (!rectangle.contains(point)) {
                return -1;
            }
            n2 = OS.OpenThemeData(0, this.getClassId());
            try {
                RECT rECT = new RECT();
                rECT.left = rectangle.x;
                rECT.right = rectangle.x + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rectangle.y + rectangle.height;
                POINT pOINT = new POINT();
                pOINT.x = point.x;
                pOINT.y = point.y;
                short[] sArray = new short[1];
                int[] nArray = this.getPartId(0);
                OS.HitTestThemeBackground(n2, 0, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                if (sArray[0] == 0) {
                    Object var11_9 = null;
                    OS.CloseThemeData(n2);
                    return -1;
                }
                int n3 = this.style;
                if ((n3 & 4) == 0) break block6;
                SIZE sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(n2, 0, nArray[0], nArray[1], rECT, 1, sIZE);
                rECT.left = Math.max(rECT.left, rECT.right - sIZE.cx);
                OS.HitTestThemeBackground(n2, 0, nArray[0], nArray[1], 0, rECT, 0, pOINT, sArray);
                if (sArray[0] == 0) break block6;
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                OS.CloseThemeData(n2);
                throw throwable;
            }
            OS.CloseThemeData(n2);
            return 1;
        }
        Object var11_12 = null;
        OS.CloseThemeData(n2);
        return 0;
    }
}

