/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthIcon;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

class SynthGraphics {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintInsets = new Insets(0, 0, 0, 0);
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private Insets viewSizingInsets = new Insets(0, 0, 0, 0);

    SynthGraphics() {
    }

    public int getMaximumCharHeight(JComponent jComponent) {
        FontMetrics fontMetrics = jComponent.getToolkit().getFontMetrics(jComponent.getFont());
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.drawLine(n2, n3, n4, n5);
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n2, int n3, int n4) {
        if (string != null) {
            JComponent jComponent = synthContext.getComponent();
            SynthStyle synthStyle = synthContext.getStyle();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(string, n2, n3 += fontMetrics.getAscent());
            if (n4 >= 0 && n4 < string.length()) {
                int n5 = n2 + fontMetrics.stringWidth(string.substring(0, n4));
                int n6 = n3;
                int n7 = fontMetrics.charWidth(string.charAt(n4));
                int n8 = 1;
                graphics.fillRect(n5, n6 + fontMetrics.getDescent() - 1, n7, n8);
            }
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Rectangle rectangle, int n2) {
        this.paintText(synthContext, graphics, string, rectangle.x, rectangle.y, n2);
    }

    public int computeStringWidth(SynthContext synthContext, Font font, FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Object object;
        if (icon == null && string == null) {
            return;
        }
        JComponent jComponent = synthContext.getComponent();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = SynthLookAndFeel.getPaintingInsets(synthContext, this.paintInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String string2 = this.layoutText(synthContext, fontMetrics, string, icon, n2, n3, n4, n5, this.paintViewR, this.paintIconR, this.paintTextR, n6);
        if (icon != null) {
            object = graphics.getColor();
            this.paintIconR.x += n8;
            this.paintIconR.y += n8;
            SynthIcon.paintIcon(icon, synthContext, graphics, this.paintIconR.x, this.paintIconR.y, this.paintIconR.width, this.paintIconR.height);
            graphics.setColor((Color)object);
        }
        if (string != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, this.paintTextR);
            } else {
                this.paintTextR.x += n8;
                this.paintTextR.y += n8;
                this.paintText(synthContext, graphics, string, this.paintTextR, n7);
            }
        }
    }

    public Dimension getMaximumSize(SynthContext synthContext, Font font, String string, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n2, n3, n4, n5, n6, n7);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(SynthContext synthContext, Font font, String string, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n2, n3, n4, n5, n6, n7);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(SynthContext synthContext, Font font, String string, Icon icon, int n2, int n3, int n4, int n5, int n6, int n7) {
        JComponent jComponent = synthContext.getComponent();
        Insets insets = jComponent.getInsets(this.viewSizingInsets);
        int n8 = insets.left + insets.right;
        int n9 = insets.top + insets.bottom;
        if (icon == null && (string == null || font == null)) {
            return new Dimension(n8, n9);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(SynthIcon.getIconWidth(icon, synthContext) + n8, SynthIcon.getIconHeight(icon, synthContext) + n9);
        }
        FontMetrics fontMetrics = jComponent.getToolkit().getFontMetrics(font);
        this.iconR.height = 0;
        this.iconR.width = 0;
        this.iconR.y = 0;
        this.iconR.x = 0;
        this.textR.height = 0;
        this.textR.width = 0;
        this.textR.y = 0;
        this.textR.x = 0;
        this.viewR.x = n8;
        this.viewR.y = n9;
        this.viewR.height = Short.MAX_VALUE;
        this.viewR.width = Short.MAX_VALUE;
        this.layoutText(synthContext, fontMetrics, string, icon, n2, n3, n4, n5, this.viewR, this.iconR, this.textR, n6);
        int n10 = Math.min(this.iconR.x, this.textR.x);
        int n11 = Math.max(this.iconR.x + this.iconR.width, this.textR.x + this.textR.width);
        int n12 = Math.min(this.iconR.y, this.textR.y);
        int n13 = Math.max(this.iconR.y + this.iconR.height, this.textR.y + this.textR.height);
        Dimension dimension = new Dimension(n11 - n10, n13 - n12);
        dimension.width += n8;
        dimension.height += n9;
        return dimension;
    }

    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        if (icon instanceof SynthIcon) {
            SynthIconWrapper synthIconWrapper = SynthIconWrapper.get((SynthIcon)icon, synthContext);
            String string2 = SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, synthIconWrapper, n3, n2, n5, n4, rectangle, rectangle2, rectangle3, n6);
            SynthIconWrapper.release(synthIconWrapper);
            return string2;
        }
        return SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, icon, n3, n2, n5, n4, rectangle, rectangle2, rectangle3, n6);
    }

    private static class SynthIconWrapper
    implements Icon {
        private static final List CACHE = new ArrayList(1);
        private SynthIcon synthIcon;
        private SynthContext context;

        public int getIconHeight() {
            return this.synthIcon.getIconHeight(this.context);
        }

        public int getIconWidth() {
            return this.synthIcon.getIconWidth(this.context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void release(SynthIconWrapper synthIconWrapper) {
            synthIconWrapper.reset(null, null);
            List list = CACHE;
            synchronized (list) {
                CACHE.add(synthIconWrapper);
            }
        }

        SynthIconWrapper(SynthIcon synthIcon, SynthContext synthContext) {
            this.reset(synthIcon, synthContext);
        }

        void reset(SynthIcon synthIcon, SynthContext synthContext) {
            this.synthIcon = synthIcon;
            this.context = synthContext;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SynthIconWrapper get(SynthIcon synthIcon, SynthContext synthContext) {
            List list = CACHE;
            synchronized (list) {
                int n2 = CACHE.size();
                if (n2 > 0) {
                    SynthIconWrapper synthIconWrapper = (SynthIconWrapper)CACHE.remove(n2 - 1);
                    synthIconWrapper.reset(synthIcon, synthContext);
                    return synthIconWrapper;
                }
            }
            return new SynthIconWrapper(synthIcon, synthContext);
        }
    }
}

