/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsDesktopManager;
import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WindowsInternalFrameUI
extends BasicInternalFrameUI {
    XPStyle xp = XPStyle.getXP();

    public void installDefaults() {
        super.installDefaults();
        if (this.xp != null) {
            this.frame.setBorder(new XPBorder());
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
    }

    public void uninstallDefaults() {
        this.frame.setBorder(null);
        super.uninstallDefaults();
    }

    protected LayoutManager createLayoutManager() {
        if (XPStyle.getXP() != null) {
            return new BasicInternalFrameUI.InternalFrameLayout(){

                public void layoutContainer(Container container) {
                    Dimension dimension;
                    Insets insets = WindowsInternalFrameUI.this.frame.getInsets();
                    int n2 = insets.left;
                    int n3 = 0;
                    int n4 = WindowsInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
                    int n5 = WindowsInternalFrameUI.this.frame.getHeight() - insets.bottom;
                    if (WindowsInternalFrameUI.this.getNorthPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getNorthPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getNorthPane().setBounds(0, 0, WindowsInternalFrameUI.this.frame.getWidth(), dimension.height);
                        n3 += dimension.height;
                        n5 -= dimension.height;
                    }
                    if (WindowsInternalFrameUI.this.getSouthPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getSouthPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getSouthPane().setBounds(n2, WindowsInternalFrameUI.this.frame.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                        n5 -= dimension.height;
                    }
                    if (WindowsInternalFrameUI.this.getWestPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getWestPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                        n4 -= dimension.width;
                        n2 += dimension.width;
                    }
                    if (WindowsInternalFrameUI.this.getEastPane() != null) {
                        dimension = WindowsInternalFrameUI.this.getEastPane().getPreferredSize();
                        WindowsInternalFrameUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                        n4 -= dimension.width;
                    }
                    if (WindowsInternalFrameUI.this.frame.getRootPane() != null) {
                        WindowsInternalFrameUI.this.frame.getRootPane().setBounds(n2, n3, n4, n5);
                    }
                }
            };
        }
        return super.createLayoutManager();
    }

    protected DesktopManager createDesktopManager() {
        return new WindowsDesktopManager();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(this.xp == null);
    }

    public WindowsInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new WindowsInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsInternalFrameUI((JInternalFrame)jComponent);
    }

    private class XPBorder
    extends AbstractBorder {
        private XPStyle.Skin leftSkin;
        private XPStyle.Skin rightSkin;
        private XPStyle.Skin bottomSkin;

        public boolean isBorderOpaque() {
            return true;
        }

        private XPBorder() {
            this.leftSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameleft");
            this.rightSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameright");
            this.bottomSkin = WindowsInternalFrameUI.this.xp.getSkin("window.framebottom");
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            boolean bl2 = ((JInternalFrame)component).isSelected();
            int n6 = WindowsInternalFrameUI.this.titlePane != null ? ((WindowsInternalFrameUI)WindowsInternalFrameUI.this).titlePane.getSize().height : 0;
            this.bottomSkin.paintSkin(graphics, 0, n5 - this.bottomSkin.getHeight(), n4, this.bottomSkin.getHeight(), bl2 ? 0 : 1);
            this.leftSkin.paintSkin(graphics, 0, n6 - 1, this.leftSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
            this.rightSkin.paintSkin(graphics, n4 - this.rightSkin.getWidth(), n6 - 1, this.rightSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 4;
            insets.left = this.leftSkin.getWidth();
            insets.right = this.rightSkin.getWidth();
            insets.bottom = this.bottomSkin.getHeight();
            return insets;
        }
    }
}

