/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    private Object pauseLock = new Object();
    private boolean paused = false;

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block27: {
            InputStream inputStream = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                int n2;
                                int n3;
                                byte[] byArray = new byte[2048];
                                int n4 = 0;
                                int n5 = 0;
                                int n6 = 0;
                                inputStream = this.getInputStream();
                                int n7 = inputStream.read(byArray, n4, 1);
                                if (n7 < 0) {
                                    if (inputStream != this.getInputStream()) {
                                        continue;
                                    }
                                    break block27;
                                }
                                if (byArray[n4++] != 48) continue;
                                n7 = inputStream.read(byArray, n4, 1);
                                if (n7 < 0) {
                                    break block27;
                                }
                                if (((n5 = byArray[n4++]) & 0x80) == 128) {
                                    int n8;
                                    n6 = n5 & 0x7F;
                                    boolean bl2 = false;
                                    for (n7 = 0; n7 < n6; n7 += n8) {
                                        n8 = inputStream.read(byArray, n4 + n7, n6 - n7);
                                        if (n8 >= 0) continue;
                                        bl2 = true;
                                        break;
                                    }
                                    if (bl2) {
                                        break block27;
                                    }
                                    n5 = 0;
                                    for (n3 = 0; n3 < n6; ++n3) {
                                        n5 = (n5 << 8) + (byArray[n4 + n3] & 0xFF);
                                    }
                                    n4 += n7;
                                }
                                if (n4 + (n2 = n5) > byArray.length) {
                                    byte[] byArray2 = new byte[n4 + n2];
                                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                                    byArray = byArray2;
                                }
                                while (n2 > 0 && (n7 = inputStream.read(byArray, n4, n2)) >= 0) {
                                    n4 += n7;
                                    n2 -= n7;
                                }
                                try {
                                    BerDecoder berDecoder = new BerDecoder(byArray, 0, n4);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n4);
                                    }
                                    berDecoder.parseSeq(null);
                                    int n9 = berDecoder.parseInt();
                                    berDecoder.reset();
                                    n3 = 0;
                                    if (n9 == 0) {
                                        this.parent.processUnsolicited(berDecoder);
                                        continue block12;
                                    }
                                    LdapRequest ldapRequest = this.findRequest(n9);
                                    if (ldapRequest == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        n3 = ldapRequest.addReplyBer(berDecoder) ? 1 : 0;
                                        if (n3 != 0) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (inputStream != this.getInputStream()) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.closureReason = iOException;
                    break block27;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }

    void setBound() {
        this.bound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    void setV3(boolean bl2) {
        this.v3 = bl2;
    }

    synchronized LdapRequest findRequest(int n2) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n2) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n2 = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n2);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void cleanup(Control[] controlArray, boolean bl2) {
        boolean bl3;
        block16: {
            bl3 = false;
            Connection connection = this;
            synchronized (connection) {
                block17: {
                    this.useable = false;
                    if (this.sock == null) break block16;
                    if (!bl2) {
                        this.abandonOutstandingReqs(controlArray);
                    }
                    if (this.bound) {
                        this.ldapUnbind(controlArray);
                    }
                    Object var6_5 = null;
                    try {
                        this.outStream.flush();
                        this.sock.close();
                        this.unpauseReader();
                    }
                    catch (IOException object) {
                        // empty catch block
                    }
                    if (!bl2) {
                        object = this.pendingRequests;
                        while (object != null) {
                            ((LdapRequest)object).cancel();
                            object = ((LdapRequest)object).next;
                        }
                    }
                    break block17;
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        try {
                            this.outStream.flush();
                            this.sock.close();
                            this.unpauseReader();
                        }
                        catch (IOException object) {
                            // empty catch block
                        }
                        if (!bl2) {
                            object = this.pendingRequests;
                            while (object != null) {
                                ((LdapRequest)object).cancel();
                                object = ((LdapRequest)object).next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                }
                this.sock = null;
                bl3 = bl2;
            }
        }
        if (bl3) {
            this.parent.processConnectionClosure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        while ((berDecoder = ldapRequest.getReplyBer()) == null) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
                    }
                }
                object = ldapRequest;
                synchronized (object) {
                    berDecoder = ldapRequest.getReplyBer();
                    if (berDecoder != null) {
                        break;
                    }
                    ldapRequest.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        return berDecoder;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n2) throws IOException {
        return this.writeRequest(berEncoder, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n2, boolean bl2) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n2, bl2);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            this.cleanup(null, true);
            this.closureReason = iOException;
            throw this.closureReason;
        }
        return ldapRequest;
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    private Object createInetSocketAddress(String string, int n2) throws NoSuchMethodException {
        try {
            Class clazz = Class.forName("java.net.InetSocketAddress");
            Constructor constructor = clazz.getConstructor(new Class[]{String.class, Integer.TYPE});
            return constructor.newInstance(new Object[]{string, new Integer(n2)});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchMethodException();
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchMethodException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchMethodException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchMethodException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n2 = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n2);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Socket createSocket(String string, int n2, String string2, int n3) throws Exception {
        Socket socket = null;
        if (string2 != null) {
            Class clazz = Obj.helper.loadClass(string2);
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = null;
            if (n3 > 0) {
                try {
                    method2 = clazz.getMethod("createSocket", new Class[0]);
                    Method method3 = Socket.class.getMethod("connect", new Class[]{Class.forName("java.net.SocketAddress"), Integer.TYPE});
                    Object object2 = this.createInetSocketAddress(string, n2);
                    socket = (Socket)method2.invoke(object, new Object[0]);
                    method3.invoke(socket, new Object[]{object2, new Integer(n3)});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                method2 = clazz.getMethod("createSocket", new Class[]{String.class, Integer.TYPE});
                socket = (Socket)method2.invoke(object, new Object[]{string, new Integer(n2)});
            }
        } else {
            if (n3 > 0) {
                try {
                    Constructor constructor = Socket.class.getConstructor(new Class[0]);
                    Method method = Socket.class.getMethod("connect", new Class[]{Class.forName("java.net.SocketAddress"), Integer.TYPE});
                    Object object = this.createInetSocketAddress(string, n2);
                    socket = (Socket)constructor.newInstance(new Object[0]);
                    method.invoke(socket, new Object[]{object, new Integer(n3)});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(string, n2);
            }
        }
        return socket;
    }

    Connection(LdapClient ldapClient, String string, int n2, String string2, int n3, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n2;
        this.parent = ldapClient;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n2 + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n2 + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n2, string2, n3);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n2);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n2);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }
}

