/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;

public class MixerClip
extends AbstractDataLine
implements Clip,
AutoClosingClip {
    private int id;
    private long waveformId;
    private int frameLength = -1;
    private long microsecondLength = -1L;
    int position = 0;
    int loopCount = 0;
    int currentLoop = 0;
    int loopStart;
    int loopEnd;
    private boolean resettingFramePosition = false;
    private boolean stopping = false;
    MixerClipSampleRateControl rateControl;
    MixerClipGainControl gainControl = new MixerClipGainControl();
    MixerClipMuteControl muteControl;
    MixerClipPanControl panControl;
    private boolean autoclosing = false;

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getFramePosition() {
        return this.id != 0 ? this.position + (int)this.nGetPosition(this.id) : this.position;
    }

    synchronized int getValidVoiceId() throws LineUnavailableException {
        int n2;
        float f2;
        if (this.id != 0) {
            return this.id;
        }
        float f3 = this.muteControl.getValue() ? 0.0f : Toolkit.dBToLinear(this.gainControl.getValue());
        int n3 = this.nSetup(this.waveformId, this.position, this.loopStart, this.loopEnd, f3, (f2 = this.panControl.getValue()) * -1.0f, n2 = (int)this.rateControl.getValue());
        if (n3 == 0) {
            throw new LineUnavailableException("Failed to allocate sample voice");
        }
        return n3;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackSampleEnd() {
        MixerClip mixerClip = this;
        synchronized (mixerClip) {
            this.id = 0;
            this.notifyAll();
        }
        if (!this.resettingFramePosition) {
            this.setActive(false);
            if (!this.stopping) {
                this.setEOM();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        try {
            boolean bl2;
            long l2 = System.currentTimeMillis() + this.getMicrosecondLength() / 1000L;
            boolean bl3 = bl2 = this.id != 0;
            while (this.id != 0 && System.currentTimeMillis() < l2) {
                MixerClip mixerClip = this;
                synchronized (mixerClip) {
                    this.wait(1000L);
                }
            }
            if (bl2 && this.id == 0) {
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void implClose() {
        this.nClose(this.id, this.waveformId);
        this.id = 0;
        this.waveformId = 0L;
        this.getEventDispatcher().autoClosingClipClosed(this);
    }

    void implStart() {
        int n2 = this.bufferSize / this.format.getFrameSize();
        if (this.position >= n2) {
            return;
        }
        try {
            this.id = this.getValidVoiceId();
            if (this.nStart(this.id)) {
                this.setActive(true);
                this.setStarted(true);
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implStop() {
        this.position = this.getFramePosition();
        this.loopCount = 0;
        this.currentLoop = 0;
        this.stopping = true;
        this.nStop(this.id);
        MixerClip mixerClip = this;
        synchronized (mixerClip) {
            if (this.id != 0) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopping = false;
        this.setStarted(false);
    }

    boolean callbackSampleLoop() {
        boolean bl2 = this.loopCount == -1 || this.currentLoop < this.loopCount;
        ++this.currentLoop;
        if (!bl2) {
            this.loopCount = 0;
            this.currentLoop = 0;
        }
        return bl2;
    }

    public synchronized boolean isAutoClosing() {
        return this.autoclosing;
    }

    private native float nGetLevel(int var1);

    private native long nGetPosition(int var1);

    public void loop(int n2) {
        if (n2 != 0) {
            this.stop();
        }
        this.loopCount = n2;
        this.start();
    }

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native void nStop(int var1);

    public synchronized void setFramePosition(int n2) {
        int n3 = this.bufferSize / this.format.getFrameSize();
        if (!this.isStartedRunning() && n2 == this.position) {
            return;
        }
        this.resettingFramePosition = true;
        boolean bl2 = this.isStartedRunning();
        if (this.id != 0) {
            this.implStop();
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n3) {
            n2 = n3;
        }
        this.position = n2;
        if (this.loopStart < this.position) {
            this.loopStart = this.position;
        }
        if (this.loopEnd < this.position) {
            this.loopStart = n3;
        }
        if (bl2) {
            this.implStart();
        }
        this.resettingFramePosition = false;
    }

    private native boolean nStart(int var1);

    protected native float nSetLinearGain(int var1, float var2);

    protected native float nSetPan(int var1, float var2);

    protected native int nSetSampleRate(int var1, int var2);

    public void setLoopPoints(int n2, int n3) {
        int n4 = this.bufferSize / this.format.getFrameSize();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n3 == -1) {
            n3 = n4;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("End position " + n3 + "  preceeds start position " + n2);
        }
        if (n2 < this.position) {
            n2 = this.position;
        }
        if (n3 < this.position) {
            n3 = n4;
        }
        this.loopStart = n2;
        this.loopEnd = n3;
    }

    private native long nOpen(int var1, int var2, float var3, byte[] var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose(int var1, long var2);

    public synchronized void setMicrosecondPosition(long l2) {
        int n2 = (int)((double)((float)l2 * this.getFormat().getFrameRate()) / 1000000.0);
        this.setFramePosition(n2);
    }

    private native int nSetup(long var1, int var3, int var4, int var5, float var6, float var7, int var8) throws LineUnavailableException, IllegalArgumentException;

    public synchronized void setAutoClosing(boolean bl2) {
        if (bl2 != this.autoclosing) {
            if (this.isOpen()) {
                if (bl2) {
                    this.getEventDispatcher().autoClosingClipOpened(this);
                } else {
                    this.getEventDispatcher().autoClosingClipClosed(this);
                }
            }
            this.autoclosing = bl2;
        }
    }

    void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        throw new IllegalArgumentException("Illegal call to open() in interface Clip");
    }

    void implOpen(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
        int n4;
        boolean bl2;
        this.rateControl.update(audioFormat.getFrameRate());
        int n5 = (int)(0.015f * audioFormat.getFrameRate()) * audioFormat.getFrameSize();
        if (n3 < n5) {
            bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) && audioFormat.getSampleSizeInBits() == 8;
            n4 = 0;
            if (bl2) {
                n4 = -128;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            for (int i2 = n3; i2 < n5; ++i2) {
                byArray2[i2] = n4;
            }
            byArray = byArray2;
            n3 = n5;
        }
        bl2 = false;
        n4 = 0;
        if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl2 = true;
        }
        if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
            n4 = 1;
        }
        if (bl2) {
            Toolkit.getUnsigned8(byArray, n2, n3);
        } else if (n4 != 0) {
            Toolkit.getByteSwapped(byArray, n2, n3);
        }
        int n6 = n3 / audioFormat.getFrameSize();
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        if (n6 > 0x100000) {
            throw new LineUnavailableException("Failed to allocate clip data: Requested buffer too large.");
        }
        this.waveformId = this.nOpen(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getSampleRate(), byArray, n2, n6);
        if (bl2) {
            Toolkit.getUnsigned8(byArray, n2, n3);
        } else if (n4 != 0) {
            Toolkit.getByteSwapped(byArray, n2, n3);
        }
        if (this.waveformId == 0L) {
            throw new LineUnavailableException("Failed to allocate clip data.");
        }
        this.format = audioFormat;
        this.bufferSize = n3;
        this.frameLength = this.bufferSize / audioFormat.getFrameSize();
        this.microsecondLength = (long)((double)this.frameLength / (double)audioFormat.getFrameRate() * 1000000.0);
        this.loopStart = 0;
        this.loopEnd = n6;
        this.position = 0;
        try {
            this.id = this.getValidVoiceId();
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.implClose();
            throw lineUnavailableException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen()) throw new IllegalStateException("Line is already open with " + this.getBufferSize() + " bytes of " + this.getFormat() + " data");
            this.mixer.open(this);
            try {
                this.implOpen(audioFormat, byArray, n2, n3);
                this.setOpen(true);
                if (!this.autoclosing) return;
                this.getEventDispatcher().autoClosingClipOpened(this);
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.mixer.close(this);
                throw lineUnavailableException;
            }
            return;
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        byte[] byArray;
        int n2 = (int)audioInputStream.getFrameLength();
        int n3 = n2 * audioInputStream.getFormat().getFrameSize();
        if (n2 != -1) {
            byArray = new byte[n3];
            int n4 = n3;
            int n5 = 0;
            while (n4 > 0) {
                int n6 = audioInputStream.read(byArray, n5, n4);
                if (n6 > 0) {
                    n5 += n6;
                    n4 -= n6;
                    continue;
                }
                if (n6 != 0) break;
                Thread.yield();
            }
            if (n5 != n3) {
                n3 = n5;
                n2 = n5 / audioInputStream.getFormat().getFrameSize();
            }
        } else {
            n3 = 0;
            int n7 = 0;
            int n8 = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray2 = new byte[n8];
            while (true) {
                if ((n7 = audioInputStream.read(byArray2, 0, byArray2.length)) == -1) {
                    if (n3 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n7);
                n3 += n7;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
            n2 = byArray.length / audioInputStream.getFormat().getFrameSize();
        }
        this.open(audioInputStream.getFormat(), byArray, 0, byArray.length);
    }

    MixerClip(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[4], audioFormat, n2);
        this.controls[0] = this.gainControl;
        this.muteControl = new MixerClipMuteControl();
        this.controls[1] = this.muteControl;
        this.panControl = new MixerClipPanControl();
        this.controls[2] = this.panControl;
        this.rateControl = new MixerClipSampleRateControl();
        this.controls[3] = this.rateControl;
    }

    private class MixerClipApplyReverbControl
    extends BooleanControl {
        public void setValue(boolean bl2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl2 == this.getValue() || MixerClip.this.id != 0) {
                // empty if block
            }
            super.setValue(bl2);
        }

        private MixerClipApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }
    }

    private class MixerClipGainControl
    extends FloatControl {
        private float linearGain;

        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            float f3 = Toolkit.dBToLinear(f2 = Math.max(f2, this.getMinimum()));
            if (f3 != this.linearGain && MixerClip.this.id != 0) {
                f3 = MixerClip.this.nSetLinearGain(MixerClip.this.id, f3);
            }
            this.linearGain = f3;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }

        private MixerClipGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Math.abs(Toolkit.linearToDB(5.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
            this.linearGain = 1.0f;
        }
    }

    private class MixerClipMuteControl
    extends BooleanControl {
        public void setValue(boolean bl2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl2 && !this.getValue() && MixerClip.this.id != 0) {
                MixerClip.this.nSetLinearGain(MixerClip.this.id, 0.0f);
            } else if (!bl2 && this.getValue() && MixerClip.this.id != 0) {
                float f2 = Toolkit.dBToLinear(MixerClip.this.gainControl.getValue());
                MixerClip.this.nSetLinearGain(MixerClip.this.id, f2);
            }
            super.setValue(bl2);
        }

        private MixerClipMuteControl() {
            super(BooleanControl.Type.MUTE, false, "Mute", "Not Mute");
        }
    }

    private class MixerClipPanControl
    extends FloatControl {
        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f2 = -1.0f * MixerClip.this.nSetPan(MixerClip.this.id, -1.0f * f2);
            }
            super.setValue(f2);
        }

        private MixerClipPanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }
    }

    private class MixerClipSampleRateControl
    extends FloatControl {
        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f2 = MixerClip.this.nSetSampleRate(MixerClip.this.id, (int)f2);
            }
            super.setValue(f2);
        }

        private void update(float f2) {
            super.setValue(f2);
        }

        private MixerClipSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerClip.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }
    }
}

