/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.text.CharacterIterator;

class CharArrayIterator
implements CharacterIterator {
    private char[] chars;
    private int pos;
    private int begin;

    public char current() {
        if (this.pos >= 0 && this.pos < this.chars.length) {
            return this.chars[this.pos];
        }
        return '\uffff';
    }

    public char first() {
        this.pos = 0;
        return this.current();
    }

    public char last() {
        this.pos = this.chars.length > 0 ? this.chars.length - 1 : 0;
        return this.current();
    }

    public char next() {
        if (this.pos < this.chars.length - 1) {
            ++this.pos;
            return this.chars[this.pos];
        }
        this.pos = this.chars.length;
        return '\uffff';
    }

    public char previous() {
        if (this.pos > 0) {
            --this.pos;
            return this.chars[this.pos];
        }
        this.pos = 0;
        return '\uffff';
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.begin + this.chars.length;
    }

    public int getIndex() {
        return this.begin + this.pos;
    }

    public char setIndex(int n2) {
        if ((n2 -= this.begin) < 0 || n2 > this.chars.length) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.pos = n2;
        return this.current();
    }

    CharArrayIterator(char[] cArray) {
        this.reset(cArray, 0);
    }

    void reset(char[] cArray) {
        this.reset(cArray, 0);
    }

    CharArrayIterator(char[] cArray, int n2) {
        this.reset(cArray, n2);
    }

    void reset(char[] cArray, int n2) {
        this.chars = cArray;
        this.begin = n2;
        this.pos = 0;
    }

    public Object clone() {
        CharArrayIterator charArrayIterator = new CharArrayIterator(this.chars, this.begin);
        charArrayIterator.pos = this.pos;
        return charArrayIterator;
    }
}

