/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2RTFDTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;
    protected DTM[] m_dtms = new DTM[256];
    int[] m_dtm_offsets = new int[256];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();

    public synchronized int getFirstFreeDTMID() {
        int n2 = this.m_dtms.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (null != this.m_dtms[i2]) continue;
            return i2;
        }
        return n2;
    }

    public synchronized DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            return this.getDTM(new DOMSource(documentFragment), true, null, false, false);
        }
        catch (Exception exception) {
            throw new DTMException(exception);
        }
    }

    public synchronized DTM getDTM(int n2) {
        try {
            return this.m_dtms[n2 >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 == -1) {
                return null;
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public synchronized int getDTMIdentity(DTM dTM) {
        if (dTM instanceof DTMDefaultBase) {
            DTMDefaultBase dTMDefaultBase = (DTMDefaultBase)dTM;
            if (dTMDefaultBase.getManager() == this) {
                return dTMDefaultBase.getDTMIDs().elementAt(0);
            }
            return -1;
        }
        int n2 = this.m_dtms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DTM dTM2 = this.m_dtms[i2];
            if (dTM2 != dTM || this.m_dtm_offsets[i2] != 0) continue;
            return i2 << 16;
        }
        return -1;
    }

    public synchronized void addDTM(DTM dTM, int n2) {
        this.addDTM(dTM, n2, 0);
    }

    public synchronized void addDTM(DTM dTM, int n2, int n3) {
        if (n2 >= 65536) {
            throw new DTMException(XSLMessages.createMessage("ER_NO_DTMIDS_AVAIL", null));
        }
        int n4 = this.m_dtms.length;
        if (n4 <= n2) {
            int n5 = Math.min(n2 + 256, 65536);
            DTM[] dTMArray = new DTM[n5];
            System.arraycopy(this.m_dtms, 0, dTMArray, 0, n4);
            this.m_dtms = dTMArray;
            int[] nArray = new int[n5];
            System.arraycopy(this.m_dtm_offsets, 0, nArray, 0, n4);
            this.m_dtm_offsets = nArray;
        }
        this.m_dtms[n2] = dTM;
        this.m_dtm_offsets[n2] = n3;
        dTM.documentRegistration();
    }

    public synchronized boolean release(DTM dTM, boolean bl2) {
        if (dTM instanceof SAX2DTM) {
            ((SAX2DTM)dTM).clearCoRoutine();
        }
        if (dTM instanceof DTMDefaultBase) {
            SuballocatedIntVector suballocatedIntVector = ((DTMDefaultBase)dTM).getDTMIDs();
            for (int i2 = suballocatedIntVector.size() - 1; i2 >= 0; --i2) {
                this.m_dtms[suballocatedIntVector.elementAt((int)i2) >>> 16] = null;
            }
        } else {
            int n2 = this.getDTMIdentity(dTM);
            if (n2 >= 0) {
                this.m_dtms[n2 >>> 16] = null;
            }
        }
        dTM.documentRelease();
        return true;
    }

    public synchronized DTMIterator createDTMIterator(int n2) {
        return null;
    }

    public synchronized int getDTMHandleFromNode(Node node) {
        int n2;
        Object object;
        if (null == node) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NODE_NON_NULL", null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int n3 = this.m_dtms.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            object = this.m_dtms[i2];
            if (null == object || !(object instanceof DOM2DTM) || (n4 = ((DOM2DTM)object).getHandleOfNode(node)) == -1) continue;
            return n4;
        }
        Object object2 = node;
        Object object3 = object = object2.getNodeType() == 2 ? ((Attr)object2).getOwnerElement() : object2.getParentNode();
        while (object != null) {
            object2 = object;
            object = object.getParentNode();
        }
        DOM2DTM dOM2DTM = (DOM2DTM)this.getDTM(new DOMSource((Node)object2), false, null, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            n2 = dOM2DTM.getHandleOfNode(((Attr)node).getOwnerElement());
            n2 = dOM2DTM.getAttributeNode(n2, node.getNamespaceURI(), node.getLocalName());
        } else {
            n2 = dOM2DTM.getHandleOfNode(node);
        }
        if (-1 == n2) {
            throw new RuntimeException(XSLMessages.createMessage("ER_COULD_NOT_RESOLVE_NODE", null));
        }
        return n2;
    }

    public synchronized DTMIterator createDTMIterator(Object object, int n2) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(int n2, DTMFilter dTMFilter, boolean bl2) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dTM) {
        return this.m_expandedNameTable;
    }

    public synchronized XMLReader getXMLReader(Source source) {
        try {
            boolean bl2;
            XMLReader xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            boolean bl3 = bl2 = xMLReader != null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new DTMException(sAXException.getMessage(), sAXException);
        }
    }

    public synchronized DTM getDTM(Source source, boolean bl2, DTMWSFilter dTMWSFilter, boolean bl3, boolean bl4) {
        boolean bl5;
        XMLStringFactory xMLStringFactory = this.m_xsf;
        int n2 = this.getFirstFreeDTMID();
        int n3 = n2 << 16;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dOM2DTM = new DOM2DTM((DTMManager)this, (DOMSource)source, n3, dTMWSFilter, xMLStringFactory, bl4);
            this.addDTM(dOM2DTM, n2, 0);
            return dOM2DTM;
        }
        boolean bl6 = null != source ? source instanceof SAXSource : true;
        boolean bl7 = bl5 = null != source ? source instanceof StreamSource : false;
        if (bl6 || bl5) {
            boolean bl8;
            Object object;
            XMLReader xMLReader;
            InputSource inputSource;
            if (null == source) {
                inputSource = null;
                xMLReader = null;
            } else {
                xMLReader = this.getXMLReader(source);
                inputSource = SAXSource.sourceToInputSource(source);
                object = inputSource.getSystemId();
                if (null != object) {
                    try {
                        object = SystemIDResolver.getAbsoluteURI((String)object);
                    }
                    catch (Exception exception) {
                        System.err.println("Can not absolutize URL: " + (String)object);
                    }
                    inputSource.setSystemId((String)object);
                }
            }
            object = source == null && bl2 && !bl3 && !bl4 ? new SAX2RTFDTM(this, source, n3, dTMWSFilter, xMLStringFactory, bl4) : new SAX2DTM(this, source, n3, dTMWSFilter, xMLStringFactory, bl4);
            this.addDTM((DTM)object, n2, 0);
            boolean bl9 = bl8 = null != xMLReader && xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (bl8) {
                bl3 = true;
            }
            if (m_incremental && bl3) {
                IncrementalSAXSource incrementalSAXSource = null;
                if (bl8) {
                    try {
                        incrementalSAXSource = (IncrementalSAXSource)Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces").newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        incrementalSAXSource = null;
                    }
                }
                if (incrementalSAXSource == null) {
                    if (null == xMLReader) {
                        incrementalSAXSource = new IncrementalSAXSource_Filter();
                    } else {
                        IncrementalSAXSource_Filter incrementalSAXSource_Filter = new IncrementalSAXSource_Filter();
                        incrementalSAXSource_Filter.setXMLReader(xMLReader);
                        incrementalSAXSource = incrementalSAXSource_Filter;
                    }
                }
                ((SAX2DTM)object).setIncrementalSAXSource(incrementalSAXSource);
                if (null == inputSource) {
                    return object;
                }
                if (null == xMLReader.getErrorHandler()) {
                    xMLReader.setErrorHandler((ErrorHandler)object);
                }
                xMLReader.setDTDHandler((DTDHandler)object);
                try {
                    incrementalSAXSource.startParse(inputSource);
                }
                catch (RuntimeException runtimeException) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    ((SAX2DTM)object).clearCoRoutine();
                    throw new WrappedRuntimeException(exception);
                }
            }
            if (null == xMLReader) {
                return object;
            }
            xMLReader.setContentHandler((ContentHandler)object);
            xMLReader.setDTDHandler((DTDHandler)object);
            if (null == xMLReader.getErrorHandler()) {
                xMLReader.setErrorHandler((ErrorHandler)object);
            }
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            try {
                xMLReader.parse(inputSource);
            }
            catch (RuntimeException runtimeException) {
                ((SAX2DTM)object).clearCoRoutine();
                throw runtimeException;
            }
            catch (Exception exception) {
                ((SAX2DTM)object).clearCoRoutine();
                throw new WrappedRuntimeException(exception);
            }
            return object;
        }
        throw new DTMException(XSLMessages.createMessage("ER_NOT_SUPPORTED", new Object[]{source}));
    }

    public synchronized DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return null;
    }
}

