/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.color.CMM;
import sun.awt.color.CMMImageLayout;
import sun.awt.color.ProfileDeferralMgr;
import sun.awt.color.pelArrayInfo;

public class ICC_Transform {
    long ID;
    public static final int Any = -1;
    public static final int In = 1;
    public static final int Out = 2;
    public static final int Gamut = 3;
    public static final int Simulation = 4;

    public int getNumInComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[0];
    }

    public int getNumOutComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[1];
    }

    long getID() {
        return this.ID;
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }

    public ICC_Transform() {
    }

    public void finalize() {
        CMM.checkStatus(CMM.cmmFreeTransform(this.ID));
    }

    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
        byte[] byArray3 = byArray2 != null ? byArray2 : new byte[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(byArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return byArray3;
    }

    public short[] colorConvert(short[] sArray, short[] sArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        short[] sArray3 = sArray2 != null ? sArray2 : new short[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return sArray3;
    }

    public ICC_Transform(ICC_Profile iCC_Profile, int n2, int n3) {
        if (iCC_Profile == null) {
            CMM.checkStatus(503);
        }
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n2, n3, this));
    }

    private boolean checkMinMaxScaling(ComponentColorModel componentColorModel) {
        float f2;
        float[] fArray;
        float[] fArray2;
        int n2;
        Object object;
        int n3 = componentColorModel.getNumComponents();
        int n4 = componentColorModel.getNumColorComponents();
        int[] nArray = componentColorModel.getComponentSize();
        boolean bl2 = componentColorModel.hasAlpha();
        switch (componentColorModel.getTransferType()) {
            case 0: {
                object = new byte[n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    object[n2] = 0;
                }
                if (bl2) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                for (n2 = 0; n2 < n4; ++n2) {
                    object[n2] = (byte)((1 << nArray[n2]) - 1);
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f2 = 256.0f;
                break;
            }
            case 1: {
                object = new short[n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    object[n2] = 0;
                }
                if (bl2) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                for (n2 = 0; n2 < n4; ++n2) {
                    object[n2] = (byte)((1 << nArray[n2]) - 1);
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f2 = 65536.0f;
                break;
            }
            default: {
                return false;
            }
        }
        object = componentColorModel.getColorSpace();
        for (n2 = 0; n2 < n4; ++n2) {
            float f3 = ((ColorSpace)object).getMinValue(n2);
            float f4 = ((ColorSpace)object).getMaxValue(n2);
            float f5 = (f4 - f3) / f2;
            if ((f3 -= fArray2[n2]) < 0.0f) {
                f3 = -f3;
            }
            if ((f4 -= fArray[n2]) < 0.0f) {
                f4 = -f4;
            }
            if (!(f3 > f5) && !(f4 > f5)) continue;
            return false;
        }
        return true;
    }

    public ICC_Transform(ICC_Transform[] iCC_TransformArray) {
        int n2 = iCC_TransformArray.length;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = iCC_TransformArray[i2].ID;
        }
        int n3 = CMM.cmmCombineTransforms(lArray, this);
        if (n3 != 0 || this.ID == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
    }

    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n2;
        int n3;
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(bufferedImage);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(bufferedImage2)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = colorModel.getNumColorComponents();
        int n7 = colorModel2.getNumColorComponents();
        int n8 = 8;
        float f2 = 255.0f;
        for (n3 = 0; n3 < n6; ++n3) {
            if (colorModel.getComponentSize(n3) <= 8) continue;
            n8 = 16;
            f2 = 65535.0f;
        }
        for (n3 = 0; n3 < n7; ++n3) {
            if (colorModel2.getComponentSize(n3) <= 8) continue;
            n8 = 16;
            f2 = 65535.0f;
        }
        float[] fArray = new float[n6];
        float[] fArray2 = new float[n6];
        ColorSpace colorSpace = colorModel.getColorSpace();
        for (int i2 = 0; i2 < n6; ++i2) {
            fArray[i2] = colorSpace.getMinValue(i2);
            fArray2[i2] = f2 / (colorSpace.getMaxValue(i2) - fArray[i2]);
        }
        colorSpace = colorModel2.getColorSpace();
        float[] fArray3 = new float[n7];
        float[] fArray4 = new float[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            fArray3[n2] = colorSpace.getMinValue(n2);
            fArray4[n2] = (colorSpace.getMaxValue(n2) - fArray3[n2]) / f2;
        }
        n2 = colorModel2.hasAlpha() ? 1 : 0;
        boolean bl2 = colorModel.hasAlpha() && n2 != 0;
        float[] fArray5 = n2 != 0 ? new float[n7 + 1] : new float[n7];
        if (n8 == 8) {
            byte[] byArray = new byte[n4 * n6];
            byte[] byArray2 = new byte[n4 * n7];
            float[] fArray6 = null;
            if (bl2) {
                fArray6 = new float[n4];
            }
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            for (int i3 = 0; i3 < n5; ++i3) {
                int n9;
                int n10;
                Object object = null;
                float[] fArray7 = null;
                int n11 = 0;
                for (n10 = 0; n10 < n4; ++n10) {
                    object = writableRaster.getDataElements(n10, i3, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    for (n9 = 0; n9 < n6; ++n9) {
                        byArray[n11++] = (byte)((fArray7[n9] - fArray[n9]) * fArray2[n9] + 0.5f);
                    }
                    if (!bl2) continue;
                    fArray6[n10] = fArray7[n6];
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n11 = 0;
                for (n10 = 0; n10 < n4; ++n10) {
                    for (n9 = 0; n9 < n7; ++n9) {
                        fArray5[n9] = (float)(byArray2[n11++] & 0xFF) * fArray4[n9] + fArray3[n9];
                    }
                    if (bl2) {
                        fArray5[n7] = fArray6[n10];
                    } else if (n2 != 0) {
                        fArray5[n7] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n10, i3, object);
                }
            }
        } else {
            short[] sArray = new short[n4 * n6];
            short[] sArray2 = new short[n4 * n7];
            float[] fArray8 = null;
            if (bl2) {
                fArray8 = new float[n4];
            }
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            for (int i4 = 0; i4 < n5; ++i4) {
                int n12;
                int n13;
                Object object = null;
                float[] fArray9 = null;
                int n14 = 0;
                for (n13 = 0; n13 < n4; ++n13) {
                    object = writableRaster.getDataElements(n13, i4, object);
                    fArray9 = colorModel.getNormalizedComponents(object, fArray9, 0);
                    for (n12 = 0; n12 < n6; ++n12) {
                        sArray[n14++] = (short)((fArray9[n12] - fArray[n12]) * fArray2[n12] + 0.5f);
                    }
                    if (!bl2) continue;
                    fArray8[n13] = fArray9[n6];
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n14 = 0;
                for (n13 = 0; n13 < n4; ++n13) {
                    for (n12 = 0; n12 < n7; ++n12) {
                        fArray5[n12] = (float)(sArray2[n14++] & 0xFFFF) * fArray4[n12] + fArray3[n12];
                    }
                    if (bl2) {
                        fArray5[n7] = fArray8[n13];
                    } else if (n2 != 0) {
                        fArray5[n7] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n13, i4, object);
                }
            }
        }
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(raster);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(writableRaster)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n4 = raster.getTransferType();
        int n5 = writableRaster.getTransferType();
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        int n8 = raster.getNumBands();
        int n9 = writableRaster.getNumBands();
        int n10 = 8;
        float f2 = 255.0f;
        for (n3 = 0; n3 < n8; ++n3) {
            if (sampleModel.getSampleSize(n3) <= 8) continue;
            n10 = 16;
            f2 = 65535.0f;
        }
        for (n3 = 0; n3 < n9; ++n3) {
            if (sampleModel2.getSampleSize(n3) <= 8) continue;
            n10 = 16;
            f2 = 65535.0f;
        }
        float[] fArray = new float[n8];
        float[] fArray2 = new float[n9];
        for (n2 = 0; n2 < n8; ++n2) {
            fArray[n2] = n4 == 2 ? f2 / 32767.0f : f2 / (float)((1 << sampleModel.getSampleSize(n2)) - 1);
        }
        for (n2 = 0; n2 < n9; ++n2) {
            fArray2[n2] = n5 == 2 ? 32767.0f / f2 : (float)((1 << sampleModel2.getSampleSize(n2)) - 1) / f2;
        }
        n2 = raster.getMinY();
        int n11 = writableRaster.getMinY();
        if (n10 == 8) {
            byte[] byArray = new byte[n6 * n8];
            byte[] byArray2 = new byte[n6 * n9];
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n12 = 0;
            while (n12 < n7) {
                int n13;
                int n14;
                int n15 = raster.getMinX();
                int n16 = 0;
                int n17 = 0;
                while (n17 < n6) {
                    for (n14 = 0; n14 < n8; ++n14) {
                        n13 = raster.getSample(n15, n2, n14);
                        byArray[n16++] = (byte)((float)n13 * fArray[n14] + 0.5f);
                    }
                    ++n17;
                    ++n15;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n18 = writableRaster.getMinX();
                n16 = 0;
                n17 = 0;
                while (n17 < n6) {
                    for (n14 = 0; n14 < n9; ++n14) {
                        n13 = (int)((float)(byArray2[n16++] & 0xFF) * fArray2[n14] + 0.5f);
                        writableRaster.setSample(n18, n11, n14, n13);
                    }
                    ++n17;
                    ++n18;
                }
                ++n12;
                ++n2;
                ++n11;
            }
        } else {
            short[] sArray = new short[n6 * n8];
            short[] sArray2 = new short[n6 * n9];
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n19 = 0;
            while (n19 < n7) {
                int n20;
                int n21;
                int n22 = raster.getMinX();
                int n23 = 0;
                int n24 = 0;
                while (n24 < n6) {
                    for (n21 = 0; n21 < n8; ++n21) {
                        n20 = raster.getSample(n22, n2, n21);
                        sArray[n23++] = (short)((float)n20 * fArray[n21] + 0.5f);
                    }
                    ++n24;
                    ++n22;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n25 = writableRaster.getMinX();
                n23 = 0;
                n24 = 0;
                while (n24 < n6) {
                    for (n21 = 0; n21 < n9; ++n21) {
                        n20 = (int)((float)(sArray2[n23++] & 0xFFFF) * fArray2[n21] + 0.5f);
                        writableRaster.setSample(n25, n11, n21, n20);
                    }
                    ++n24;
                    ++n25;
                }
                ++n19;
                ++n2;
                ++n11;
            }
        }
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n2;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n3 = raster.getTransferType();
        int n4 = writableRaster.getTransferType();
        boolean bl2 = n3 == 4 || n3 == 5;
        boolean bl3 = n4 == 4 || n4 == 5;
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getNumBands();
        int n8 = writableRaster.getNumBands();
        float[] fArray5 = new float[n7];
        float[] fArray6 = new float[n8];
        float[] fArray7 = new float[n7];
        float[] fArray8 = new float[n8];
        for (n2 = 0; n2 < n7; ++n2) {
            if (bl2) {
                fArray5[n2] = 65535.0f / (fArray2[n2] - fArray[n2]);
                fArray7[n2] = fArray[n2];
                continue;
            }
            fArray5[n2] = n3 == 2 ? 2.0000305f : 65535.0f / (float)((1 << sampleModel.getSampleSize(n2)) - 1);
            fArray7[n2] = 0.0f;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            if (bl3) {
                fArray6[n2] = (fArray4[n2] - fArray3[n2]) / 65535.0f;
                fArray8[n2] = fArray3[n2];
                continue;
            }
            fArray6[n2] = n4 == 2 ? 0.49999237f : (float)((1 << sampleModel2.getSampleSize(n2)) - 1) / 65535.0f;
            fArray8[n2] = 0.0f;
        }
        n2 = raster.getMinY();
        int n9 = writableRaster.getMinY();
        short[] sArray = new short[n5 * n7];
        short[] sArray2 = new short[n5 * n8];
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        int n10 = 0;
        while (n10 < n6) {
            float f2;
            int n11;
            int n12 = raster.getMinX();
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                for (n11 = 0; n11 < n7; ++n11) {
                    f2 = raster.getSampleFloat(n12, n2, n11);
                    sArray[n13++] = (short)((f2 - fArray7[n11]) * fArray5[n11] + 0.5f);
                }
                ++n14;
                ++n12;
            }
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
            int n15 = writableRaster.getMinX();
            n13 = 0;
            n14 = 0;
            while (n14 < n5) {
                for (n11 = 0; n11 < n8; ++n11) {
                    f2 = (float)(sArray2[n13++] & 0xFFFF) * fArray6[n11] + fArray8[n11];
                    writableRaster.setSample(n15, n9, n11, f2);
                }
                ++n14;
                ++n15;
            }
            ++n10;
            ++n2;
            ++n9;
        }
    }

    private CMMImageLayout getImageLayout(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return new CMMImageLayout(bufferedImage);
            }
            case 5: 
            case 6: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 10: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 8) {
                    return null;
                }
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 11: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 16) {
                    return null;
                }
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                return null;
            }
            if (colorModel.getTransferType() != 3) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n2 = directColorModel.getRedMask();
            int n3 = directColorModel.getGreenMask();
            int n4 = directColorModel.getBlueMask();
            int n5 = directColorModel.getAlphaMask();
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            int n11 = 3;
            if (n5 != 0) {
                n11 = 4;
            }
            int n12 = 0;
            int n13 = -16777216;
            while (n12 < 4) {
                if (n2 == n13) {
                    n9 = n12;
                    ++n10;
                } else if (n3 == n13) {
                    n8 = n12;
                    ++n10;
                } else if (n4 == n13) {
                    n7 = n12;
                    ++n10;
                } else if (n5 == n13) {
                    n6 = n12;
                    ++n10;
                }
                ++n12;
                n13 >>>= 8;
            }
            if (n10 != n11) {
                return null;
            }
            return new CMMImageLayout(bufferedImage, (SinglePixelPackedSampleModel)sampleModel, n9, n8, n7, n6);
        }
        if (colorModel instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel;
            int n14;
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof ComponentSampleModel)) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            int n15 = colorModel.getNumComponents();
            if (sampleModel.getNumBands() != n15) {
                return null;
            }
            int n16 = colorModel.getTransferType();
            if (n16 == 0) {
                for (n14 = 0; n14 < n15; ++n14) {
                    if (colorModel.getComponentSize(n14) == 8) continue;
                    return null;
                }
            } else if (n16 == 1) {
                for (n14 = 0; n14 < n15; ++n14) {
                    if (colorModel.getComponentSize(n14) == 16) continue;
                    return null;
                }
            } else {
                return null;
            }
            if ((componentColorModel = (ComponentColorModel)colorModel).getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                return new CMMImageLayout(bufferedImage, (ComponentSampleModel)sampleModel);
            }
            return null;
        }
        return null;
    }

    private CMMImageLayout getImageLayout(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = raster.getNumBands();
            int n3 = sampleModel.getTransferType();
            if (n3 == 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (sampleModel.getSampleSize(i2) == 8) continue;
                    return null;
                }
            } else if (n3 == 1) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (sampleModel.getSampleSize(i3) == 16) continue;
                    return null;
                }
            } else {
                return null;
            }
            return new CMMImageLayout(raster, (ComponentSampleModel)sampleModel);
        }
        return null;
    }
}

