/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.systemresource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class SystemResourceURLConnection
extends URLConnection {
    URL delegateUrl;
    URLConnection delegateConnection;

    public void connect() throws IOException {
        this.delegateConnection.connect();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegateConnection.getInputStream();
    }

    public Object getContent() throws IOException {
        return this.delegateConnection.getContent();
    }

    public String getContentType() {
        return this.delegateConnection.getContentType();
    }

    SystemResourceURLConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.delegateUrl = this.makeDelegateUrl(uRL);
        this.delegateConnection = this.delegateUrl.openConnection();
    }

    public Permission getPermission() throws IOException {
        return this.delegateConnection.getPermission();
    }

    public String getHeaderField(String string) {
        return this.delegateConnection.getHeaderField(string);
    }

    private URL makeDelegateUrl(URL uRL) throws MalformedURLException {
        boolean bl2 = false;
        String string = uRL.getFile();
        if (string.startsWith("/FILE")) {
            bl2 = true;
        }
        int n2 = bl2 ? 5 : 4;
        int n3 = string.lastIndexOf("/+/");
        if (n3 < 0) {
            throw new MalformedURLException("no /+/ found in URL");
        }
        string = bl2 ? "file:" + string.substring(n2, n3) + File.separatorChar + string.substring(n3 + 3, string.length()) : "jar:file:" + string.substring(n2, n3) + "!/" + string.substring(n3 + 3, string.length());
        return new URL(string);
    }
}

