/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public final class FormAttachment {
    public int numerator;
    public int denominator = 100;
    public int offset;
    public Control control;
    public int alignment;

    public FormAttachment() {
    }

    public FormAttachment(int n2) {
        this(n2, 100, 0);
    }

    public FormAttachment(int n2, int n3) {
        this(n2, 100, n3);
    }

    public FormAttachment(int n2, int n3, int n4) {
        if (n3 == 0) {
            SWT.error(7);
        }
        this.numerator = n2;
        this.denominator = n3;
        this.offset = n4;
    }

    public FormAttachment(Control control) {
        this(control, 0, -1);
    }

    public FormAttachment(Control control, int n2) {
        this(control, n2, -1);
    }

    public FormAttachment(Control control, int n2, int n3) {
        this.control = control;
        this.offset = n2;
        this.alignment = n3;
    }

    FormAttachment divide(int n2) {
        return new FormAttachment(this.numerator, this.denominator * n2, this.offset / n2);
    }

    int gcd(int n2, int n3) {
        int n4;
        if ((n2 = Math.abs(n2)) < (n3 = Math.abs(n3))) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        while (n3 != 0) {
            n4 = n2;
            n2 = n3;
            n3 = n4 % n3;
        }
        return n2;
    }

    FormAttachment minus(FormAttachment formAttachment) {
        FormAttachment formAttachment2 = new FormAttachment();
        formAttachment2.numerator = this.numerator * formAttachment.denominator - this.denominator * formAttachment.numerator;
        formAttachment2.denominator = this.denominator * formAttachment.denominator;
        int n2 = this.gcd(formAttachment2.denominator, formAttachment2.numerator);
        formAttachment2.numerator /= n2;
        formAttachment2.denominator /= n2;
        formAttachment2.offset = this.offset - formAttachment.offset;
        return formAttachment2;
    }

    FormAttachment minus(int n2) {
        return new FormAttachment(this.numerator, this.denominator, this.offset - n2);
    }

    FormAttachment plus(FormAttachment formAttachment) {
        FormAttachment formAttachment2 = new FormAttachment();
        formAttachment2.numerator = this.numerator * formAttachment.denominator + this.denominator * formAttachment.numerator;
        formAttachment2.denominator = this.denominator * formAttachment.denominator;
        int n2 = this.gcd(formAttachment2.denominator, formAttachment2.numerator);
        formAttachment2.numerator /= n2;
        formAttachment2.denominator /= n2;
        formAttachment2.offset = this.offset + formAttachment.offset;
        return formAttachment2;
    }

    FormAttachment plus(int n2) {
        return new FormAttachment(this.numerator, this.denominator, this.offset + n2);
    }

    int solveX(int n2) {
        if (this.denominator == 0) {
            SWT.error(7);
        }
        return this.numerator * n2 / this.denominator + this.offset;
    }

    int solveY(int n2) {
        if (this.numerator == 0) {
            SWT.error(7);
        }
        return (n2 - this.offset) * this.denominator / this.numerator;
    }

    public String toString() {
        String string = this.control != null ? this.control.toString() : String.valueOf(this.numerator) + "/" + this.denominator;
        return "{y = (" + string + (this.offset >= 0 ? ")x + " + this.offset : ")x - " + -this.offset) + "}";
    }
}

