/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.opengl.win32.PIXELFORMATDESCRIPTOR;
import org.eclipse.swt.internal.opengl.win32.WGL;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int context;
    int pixelFormat;

    public GLCanvas(Composite composite, int n2, GLData gLData) {
        super(composite, n2);
        if (gLData == null) {
            SWT.error(4);
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = new PIXELFORMATDESCRIPTOR();
        pIXELFORMATDESCRIPTOR.nSize = (short)40;
        pIXELFORMATDESCRIPTOR.nVersion = 1;
        pIXELFORMATDESCRIPTOR.dwFlags = 36;
        pIXELFORMATDESCRIPTOR.dwLayerMask = 0;
        pIXELFORMATDESCRIPTOR.iPixelType = 0;
        if (gLData.doubleBuffer) {
            pIXELFORMATDESCRIPTOR.dwFlags |= 1;
        }
        if (gLData.stereo) {
            pIXELFORMATDESCRIPTOR.dwFlags |= 2;
        }
        pIXELFORMATDESCRIPTOR.cRedBits = (byte)gLData.redSize;
        pIXELFORMATDESCRIPTOR.cGreenBits = (byte)gLData.greenSize;
        pIXELFORMATDESCRIPTOR.cBlueBits = (byte)gLData.blueSize;
        pIXELFORMATDESCRIPTOR.cAlphaBits = (byte)gLData.alphaSize;
        pIXELFORMATDESCRIPTOR.cDepthBits = (byte)gLData.depthSize;
        pIXELFORMATDESCRIPTOR.cStencilBits = (byte)gLData.stencilSize;
        pIXELFORMATDESCRIPTOR.cAccumRedBits = (byte)gLData.accumRedSize;
        pIXELFORMATDESCRIPTOR.cAccumGreenBits = (byte)gLData.accumGreenSize;
        pIXELFORMATDESCRIPTOR.cAccumBlueBits = (byte)gLData.accumBlueSize;
        pIXELFORMATDESCRIPTOR.cAccumAlphaBits = (byte)gLData.accumAlphaSize;
        pIXELFORMATDESCRIPTOR.cAccumBits = (byte)(pIXELFORMATDESCRIPTOR.cAccumRedBits + pIXELFORMATDESCRIPTOR.cAccumGreenBits + pIXELFORMATDESCRIPTOR.cAccumBlueBits + pIXELFORMATDESCRIPTOR.cAccumAlphaBits);
        int n3 = OS.GetDC(this.handle);
        this.pixelFormat = WGL.ChoosePixelFormat(n3, pIXELFORMATDESCRIPTOR);
        if (this.pixelFormat == 0 || !WGL.SetPixelFormat(n3, this.pixelFormat, pIXELFORMATDESCRIPTOR)) {
            OS.ReleaseDC(this.handle, n3);
            this.dispose();
            SWT.error(38);
        }
        this.context = WGL.wglCreateContext(n3);
        if (this.context == 0) {
            OS.ReleaseDC(this.handle, n3);
            SWT.error(2);
        }
        OS.ReleaseDC(this.handle, n3);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        WGL.wglDeleteContext(GLCanvas.this.context);
                    }
                }
            }
        };
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        GLData gLData = new GLData();
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = new PIXELFORMATDESCRIPTOR();
        pIXELFORMATDESCRIPTOR.nSize = (short)40;
        int n2 = OS.GetDC(this.handle);
        WGL.DescribePixelFormat(n2, this.pixelFormat, 40, pIXELFORMATDESCRIPTOR);
        OS.ReleaseDC(this.handle, n2);
        gLData.doubleBuffer = (pIXELFORMATDESCRIPTOR.dwFlags & 1) != 0;
        gLData.stereo = (pIXELFORMATDESCRIPTOR.dwFlags & 2) != 0;
        gLData.redSize = pIXELFORMATDESCRIPTOR.cRedBits;
        gLData.greenSize = pIXELFORMATDESCRIPTOR.cGreenBits;
        gLData.blueSize = pIXELFORMATDESCRIPTOR.cBlueBits;
        gLData.alphaSize = pIXELFORMATDESCRIPTOR.cAlphaBits;
        gLData.depthSize = pIXELFORMATDESCRIPTOR.cDepthBits;
        gLData.stencilSize = pIXELFORMATDESCRIPTOR.cStencilBits;
        gLData.accumRedSize = pIXELFORMATDESCRIPTOR.cAccumRedBits;
        gLData.accumGreenSize = pIXELFORMATDESCRIPTOR.cAccumGreenBits;
        gLData.accumBlueSize = pIXELFORMATDESCRIPTOR.cAccumBlueBits;
        gLData.accumAlphaSize = pIXELFORMATDESCRIPTOR.cAccumAlphaBits;
        return gLData;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return WGL.wglGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (WGL.wglGetCurrentContext() == this.context) {
            return;
        }
        int n2 = OS.GetDC(this.handle);
        WGL.wglMakeCurrent(n2, this.context);
        OS.ReleaseDC(this.handle, n2);
    }

    public void swapBuffers() {
        this.checkWidget();
        int n2 = OS.GetDC(this.handle);
        WGL.SwapBuffers(n2);
        OS.ReleaseDC(this.handle, n2);
    }
}

