/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.lwjgl.d;
import org.lwjgl.e;
import org.lwjgl.f;
import org.lwjgl.g;

public class LWJGLUtil {
    public static final int PLATFORM_LINUX = 1;
    public static final int PLATFORM_MACOSX = 2;
    public static final int PLATFORM_WINDOWS = 3;
    public static final String PLATFORM_LINUX_NAME = "linux";
    public static final String PLATFORM_MACOSX_NAME = "macosx";
    public static final String PLATFORM_WINDOWS_NAME = "windows";
    public static final boolean DEBUG = LWJGLUtil.getPrivilegedBoolean("org.lwjgl.util.Debug");
    static Class class$java$lang$String;

    public static int getPlatform() {
        String string = LWJGLUtil.getPrivilegedProperty("os.name");
        if (string.startsWith("Windows")) {
            return 3;
        }
        if (string.startsWith("Mac OS X")) {
            return 2;
        }
        throw new LinkageError("Unknown platform: " + string);
    }

    static void execPrivileged(String[] stringArray) throws Exception {
        try {
            Process process = (Process)AccessController.doPrivileged(new f(stringArray));
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            throw (Exception)privilegedActionException.getCause();
        }
    }

    private static String getPrivilegedProperty(String string) {
        return (String)AccessController.doPrivileged(new d(string));
    }

    public static String getPathFromClassLoader(String string, ClassLoader classLoader) {
        try {
            LWJGLUtil.log("getPathFromClassLoader: searching for: " + string);
            for (Class<?> clazz = classLoader.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Class<?> clazz2 = clazz;
                try {
                    return (String)AccessController.doPrivileged(new e(clazz2, string, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    LWJGLUtil.log("Failed to locate findLibrary method: " + privilegedActionException.getCause());
                    continue;
                }
            }
        }
        catch (Exception exception) {
            LWJGLUtil.log("Failure locating " + exception + " using classloader:" + exception);
        }
        return null;
    }

    private static boolean getPrivilegedBoolean(String string) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new g(string));
        return bl2;
    }

    public static void log(String string) {
        if (DEBUG) {
            System.err.println(string);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

