/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.t;
import org.lwjgl.opengl.y;
import org.lwjgl.opengl.z;

public final class GLContext {
    private static final ThreadLocal current_capabilities = new ThreadLocal();
    private static t fast_path_cache = new t(null);
    private static final ThreadLocal thread_cache_entries = new ThreadLocal();
    private static final Map capability_cache = new WeakHashMap();
    private static int gl_ref_count;
    private static boolean did_auto_load;

    public static ContextCapabilities getCapabilities() {
        t t2 = fast_path_cache;
        if (t2.a == Thread.currentThread()) {
            return t2.a;
        }
        return GLContext.getThreadLocalCapabilities();
    }

    private static ContextCapabilities getThreadLocalCapabilities() {
        return (ContextCapabilities)current_capabilities.get();
    }

    static void setCapabilities(ContextCapabilities contextCapabilities) {
        current_capabilities.set(contextCapabilities);
        t t2 = (t)thread_cache_entries.get();
        if (t2 == null) {
            t2 = new t(null);
            thread_cache_entries.set(t2);
        }
        t2.a = Thread.currentThread();
        t2.a = contextCapabilities;
        fast_path_cache = t2;
    }

    static long getPlatformSpecificFunctionAddress(String string, String[] stringArray, String[] stringArray2, String string2) {
        String string3 = (String)AccessController.doPrivileged(new y());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string3.startsWith(stringArray[i2])) continue;
            String string4 = string2.replaceFirst(string, stringArray2[i2]);
            long l2 = GLContext.getFunctionAddress(string4);
            return l2;
        }
        return 0L;
    }

    static native long getFunctionAddress(String var0);

    static Set getSupportedExtensions() {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = GL11.glGetString(7939);
        if (string2 == null) {
            throw new IllegalStateException("glGetString(GL_EXTENSIONS) returned null - is there a context current?");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            hashSet.add(string);
        }
        string = GL11.glGetString(7938);
        if (string == null) {
            throw new IllegalStateException("glGetString(GL_VERSION) returned null - possibly caused by missing current context.");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ". ");
        String string3 = stringTokenizer2.nextToken();
        String string4 = stringTokenizer2.nextToken();
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            LWJGLUtil.log("The major and/or minor OpenGL version is malformed: " + numberFormatException.getMessage());
        }
        if (n2 >= 2) {
            switch (n3) {
                case 1: {
                    hashSet.add("OpenGL21");
                }
                case 0: {
                    hashSet.add("OpenGL20");
                }
            }
            hashSet.add("OpenGL11");
            hashSet.add("OpenGL12");
            hashSet.add("OpenGL13");
            hashSet.add("OpenGL14");
            hashSet.add("OpenGL15");
        } else if (n2 == 1) {
            switch (n3) {
                case 5: {
                    hashSet.add("OpenGL15");
                }
                case 4: {
                    hashSet.add("OpenGL14");
                }
                case 3: {
                    hashSet.add("OpenGL13");
                }
                case 2: {
                    hashSet.add("OpenGL12");
                }
                case 1: {
                    hashSet.add("OpenGL11");
                }
            }
        }
        return hashSet;
    }

    static void initNativeStubs(Class clazz, Set set, String string) {
        GLContext.resetNativeStubs(clazz);
        if (set.contains(string)) {
            try {
                AccessController.doPrivileged(new z(clazz));
                return;
            }
            catch (Exception exception) {
                LWJGLUtil.log("Failed to initialize extension " + clazz + " - exception: " + exception);
                set.remove(string);
            }
        }
    }

    public static synchronized void useContext(Object object) throws LWJGLException {
        if (object == null) {
            ContextCapabilities.unloadAllStubs();
            GLContext.setCapabilities(null);
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            return;
        }
        if (gl_ref_count == 0) {
            GLContext.loadOpenGLLibrary();
            did_auto_load = true;
        }
        try {
            ContextCapabilities contextCapabilities = (ContextCapabilities)capability_cache.get(object);
            if (contextCapabilities != null) {
                GLContext.setCapabilities(contextCapabilities);
                return;
            }
            new ContextCapabilities();
            capability_cache.put(object, GLContext.getCapabilities());
        }
        catch (LWJGLException lWJGLException) {
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            throw lWJGLException;
        }
    }

    public static synchronized void loadOpenGLLibrary() throws LWJGLException {
        if (gl_ref_count == 0) {
            GLContext.nLoadOpenGLLibrary();
        }
        ++gl_ref_count;
    }

    private static native void nLoadOpenGLLibrary() throws LWJGLException;

    public static synchronized void unloadOpenGLLibrary() {
        if (--gl_ref_count == 0 && LWJGLUtil.getPlatform() != 1) {
            GLContext.nUnloadOpenGLLibrary();
        }
    }

    private static native void nUnloadOpenGLLibrary();

    static native void resetNativeStubs(Class var0);

    static {
        Sys.initialize();
    }
}

