/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CLabel
extends Canvas {
    private static final int GAP = 5;
    private static final int INDENT = 3;
    private static final String ELLIPSIS = "...";
    private int align = 16384;
    private int hIndent = 3;
    private int vIndent = 3;
    private String text;
    private Image image;
    private String appToolTipText;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
    private Color background;
    private static int DRAW_FLAGS = 15;

    public CLabel(Composite composite, int n2) {
        super(composite, CLabel.checkStyle(n2));
        if ((n2 & 0x1020000) == 0) {
            n2 |= 0x4000;
        }
        if ((n2 & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((n2 & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((n2 & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CLabel.this.onPaint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CLabel.this.onDispose(disposeEvent);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128) {
                    CLabel.this.onMnemonic(traverseEvent);
                }
            }
        });
        this.initAccessible();
    }

    private static int checkStyle(int n2) {
        if ((n2 & 0x800) != 0) {
            n2 |= 4;
        }
        int n3 = 100663340;
        n2 &= n3;
        return n2 |= 0x20080000;
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        Point point = this.getTotalSize(this.image, this.text);
        point.x = n2 == -1 ? (point.x += 2 * this.hIndent) : n2;
        point.y = n3 == -1 ? (point.y += 2 * this.vIndent) : n3;
        return point;
    }

    private void drawBevelRect(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        gC.setForeground(color2);
        gC.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        gC.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        gC.setForeground(color);
        gC.drawLine(n2, n3, n2 + n4 - 1, n3);
        gC.drawLine(n2, n3, n2, n3 + n5 - 1);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    public Image getImage() {
        return this.image;
    }

    private Point getTotalSize(Image image, String string) {
        Object object;
        Point point = new Point(0, 0);
        if (image != null) {
            object = image.getBounds();
            point.x += ((Rectangle)object).width;
            point.y += ((Rectangle)object).height;
        }
        object = new GC(this);
        if (string != null && string.length() > 0) {
            Point point2 = ((GC)object).textExtent(string, DRAW_FLAGS);
            point.x += point2.x;
            point.y = Math.max(point.y, point2.y);
            if (image != null) {
                point.x += 5;
            }
        } else {
            point.y = Math.max(point.y, ((GC)object).getFontMetrics().getHeight());
        }
        ((GC)object).dispose();
        return point;
    }

    public int getStyle() {
        int n2 = super.getStyle();
        switch (this.align) {
            case 131072: {
                n2 |= 0x20000;
                break;
            }
            case 0x1000000: {
                n2 |= 0x1000000;
                break;
            }
            case 16384: {
                n2 |= 0x4000;
            }
        }
        return n2;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = CLabel.this.getText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = CLabel.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c2 = CLabel.this._findMnemonic(CLabel.this.text);
                if (c2 != '\u0000') {
                    accessibleEvent.result = "Alt+" + c2;
                }
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = CLabel.this.getDisplay().map((Control)CLabel.this.getParent(), null, CLabel.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 41;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 64;
            }
        });
    }

    void onDispose(DisposeEvent disposeEvent) {
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    void onMnemonic(TraverseEvent traverseEvent) {
        char c2 = this._findMnemonic(this.text);
        if (c2 == '\u0000') {
            return;
        }
        if (Character.toLowerCase(traverseEvent.character) != c2) {
            return;
        }
        Composite composite = this.getParent();
        while (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] == this) break;
                ++n2;
            }
            if (++n2 < controlArray.length && controlArray[n2].setFocus()) {
                traverseEvent.doit = true;
                traverseEvent.detail = 0;
            }
            composite = composite.getParent();
        }
    }

    void onPaint(PaintEvent paintEvent) {
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray;
        GC gC;
        Point point;
        Image image;
        Rectangle rectangle;
        block37: {
            Object object;
            rectangle = this.getClientArea();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl2 = false;
            String string = this.text;
            image = this.image;
            int n6 = Math.max(0, rectangle.width - 2 * this.hIndent);
            point = this.getTotalSize(image, string);
            if (point.x > n6) {
                image = null;
                point = this.getTotalSize(image, string);
                if (point.x > n6) {
                    bl2 = true;
                }
            }
            gC = paintEvent.gc;
            String[] stringArray2 = stringArray = this.text == null ? null : this.splitString(this.text);
            if (bl2) {
                point.x = 0;
                n5 = 0;
                while (n5 < stringArray.length) {
                    object = gC.textExtent(stringArray[n5], DRAW_FLAGS);
                    if (((Point)object).x > n6) {
                        stringArray[n5] = this.shortenText(gC, stringArray[n5], n6);
                        point.x = Math.max(point.x, this.getTotalSize(null, (String)stringArray[n5]).x);
                    } else {
                        point.x = Math.max(point.x, ((Point)object).x);
                    }
                    ++n5;
                }
                if (this.appToolTipText == null) {
                    super.setToolTipText(this.text);
                }
            } else {
                super.setToolTipText(this.appToolTipText);
            }
            n5 = rectangle.x + this.hIndent;
            if (this.align == 0x1000000) {
                n5 = (rectangle.width - point.x) / 2;
            }
            if (this.align == 131072) {
                n5 = rectangle.width - this.hIndent - point.x;
            }
            try {
                if (this.backgroundImage != null) {
                    object = this.backgroundImage.getBounds();
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                    int n7 = 0;
                    while (n7 < rectangle.width) {
                        int n8 = 0;
                        while (n8 < rectangle.height) {
                            gC.drawImage(this.backgroundImage, n7, n8);
                            n8 += ((Rectangle)object).height;
                        }
                        n7 += ((Rectangle)object).width;
                    }
                } else if (this.gradientColors != null) {
                    object = gC.getBackground();
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gC.setBackground(this.gradientColors[0]);
                        }
                        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
                    } else {
                        Color color = gC.getForeground();
                        Object object2 = this.gradientColors[0];
                        if (object2 == null) {
                            object2 = object;
                        }
                        n4 = 0;
                        n3 = 0;
                        while (n3 < this.gradientPercents.length) {
                            gC.setForeground((Color)object2);
                            object2 = this.gradientColors[n3 + 1];
                            if (object2 == null) {
                                object2 = object;
                            }
                            gC.setBackground((Color)object2);
                            if (this.gradientVertical) {
                                n2 = this.gradientPercents[n3] * rectangle.height / 100 - n4;
                                gC.fillGradientRectangle(0, n4, rectangle.width, n2, true);
                                n4 += n2;
                            } else {
                                n2 = this.gradientPercents[n3] * rectangle.width / 100 - n4;
                                gC.fillGradientRectangle(n4, 0, n2, rectangle.height, false);
                                n4 += n2;
                            }
                            ++n3;
                        }
                        if (this.gradientVertical && n4 < rectangle.height) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(0, n4, rectangle.width, rectangle.height - n4);
                        }
                        if (!this.gradientVertical && n4 < rectangle.width) {
                            gC.setBackground(this.getBackground());
                            gC.fillRectangle(n4, 0, rectangle.width - n4, rectangle.height);
                        }
                        gC.setForeground(color);
                    }
                    gC.setBackground((Color)object);
                } else if (this.background != null || (this.getStyle() & 0x20000000) == 0) {
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                }
            }
            catch (SWTException sWTException) {
                if ((this.getStyle() & 0x20000000) != 0) break block37;
                gC.setBackground(this.getBackground());
                gC.fillRectangle(rectangle);
            }
        }
        int n9 = this.getStyle();
        if ((n9 & 4) != 0 || (n9 & 8) != 0) {
            this.paintBorder(gC, rectangle);
        }
        if (image != null) {
            Rectangle rectangle2 = image.getBounds();
            gC.drawImage(image, 0, 0, rectangle2.width, rectangle2.height, n5, (rectangle.height - rectangle2.height) / 2, rectangle2.width, rectangle2.height);
            n5 += rectangle2.width + 5;
            point.x -= rectangle2.width + 5;
        }
        if (stringArray != null) {
            int n10 = gC.getFontMetrics().getHeight();
            int n11 = stringArray.length * n10;
            n4 = Math.max(this.vIndent, rectangle.y + (rectangle.height - n11) / 2);
            gC.setForeground(this.getForeground());
            n3 = 0;
            while (n3 < stringArray.length) {
                n2 = n5;
                if (stringArray.length > 1) {
                    int n12;
                    if (this.align == 0x1000000) {
                        n12 = gC.textExtent((String)stringArray[n3], (int)CLabel.DRAW_FLAGS).x;
                        n2 = n5 + Math.max(0, (point.x - n12) / 2);
                    }
                    if (this.align == 131072) {
                        n12 = gC.textExtent((String)stringArray[n3], (int)CLabel.DRAW_FLAGS).x;
                        n2 = Math.max(n5, rectangle.x + rectangle.width - this.hIndent - n12);
                    }
                }
                gC.drawText(stringArray[n3], n2, n4, DRAW_FLAGS);
                n4 += n10;
                ++n3;
            }
        }
    }

    private void paintBorder(GC gC, Rectangle rectangle) {
        Display display = this.getDisplay();
        Color color = null;
        Color color2 = null;
        int n2 = this.getStyle();
        if ((n2 & 4) != 0) {
            color = display.getSystemColor(18);
            color2 = display.getSystemColor(20);
        }
        if ((n2 & 8) != 0) {
            color = display.getSystemColor(19);
            color2 = display.getSystemColor(18);
        }
        if (color != null && color2 != null) {
            gC.setLineWidth(1);
            this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color, color2);
        }
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if (n2 != 16384 && n2 != 131072 && n2 != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != n2) {
            this.align = n2;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && (color == null ? this.background == null : color.equals(this.background))) {
            return;
        }
        this.background = color;
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl2) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] < 0 || nArray[n3] > 100) {
                    SWT.error(5);
                }
                if (n3 > 0 && nArray[n3] < nArray[n3 - 1]) {
                    SWT.error(5);
                }
                ++n3;
            }
        }
        Color color = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                n2 = 0;
                int n4 = 0;
                while (n4 < this.gradientColors.length) {
                    int n5 = n2 = !(this.gradientColors[n4] == colorArray[n4] || this.gradientColors[n4] == null && colorArray[n4] == color || this.gradientColors[n4] == color && colorArray[n4] == null) ? 0 : 1;
                    if (n2 == 0) break;
                    ++n4;
                }
                if (n2 != 0) {
                    n4 = 0;
                    while (n4 < this.gradientPercents.length) {
                        int n6 = n2 = this.gradientPercents[n4] == nArray[n4] ? 1 : 0;
                        if (n2 == 0) break;
                        ++n4;
                    }
                }
                if (n2 != 0 && this.gradientVertical == bl2) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colorArray.length];
            n2 = 0;
            while (n2 < colorArray.length) {
                this.gradientColors[n2] = colorArray[n2] != null ? colorArray[n2] : color;
                ++n2;
            }
            this.gradientPercents = new int[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                this.gradientPercents[n2] = nArray[n2];
                ++n2;
            }
            this.gradientVertical = bl2;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.text)) {
            this.text = string;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    /*
     * Unable to fully structure code
     */
    protected String shortenText(GC var1_1, String var2_2, int var3_3) {
        if (var2_2 == null) {
            return null;
        }
        var4_4 = var1_1.textExtent((String)"...", (int)CLabel.DRAW_FLAGS).x;
        if (var3_3 <= var4_4) {
            return var2_2;
        }
        var5_5 = var2_2.length();
        var6_6 = var5_5 / 2;
        var8_8 = (var6_6 + (var7_7 = 0)) / 2 - 1;
        if (var8_8 > 0) ** GOTO lbl24
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var9_9 = var2_2.substring(0, var8_8);
            var10_10 = var2_2.substring(var5_5 - var8_8, var5_5);
            var11_11 = var1_1.textExtent((String)var9_9, (int)CLabel.DRAW_FLAGS).x;
            var12_12 = var1_1.textExtent((String)var10_10, (int)CLabel.DRAW_FLAGS).x;
            if (var11_11 + var4_4 + var12_12 > var3_3) {
                var6_6 = var8_8;
                var8_8 = (var6_6 + var7_7) / 2;
                continue;
            }
            if (var11_11 + var4_4 + var12_12 < var3_3) {
                var7_7 = var8_8;
                var8_8 = (var6_6 + var7_7) / 2;
                continue;
            }
            var7_7 = var6_6;
lbl24:
            // 4 sources

            ** while (var7_7 < var8_8 && var8_8 < var6_6)
        }
lbl25:
        // 1 sources

        if (var8_8 == 0) {
            return var2_2;
        }
        return String.valueOf(var2_2.substring(0, var8_8)) + "..." + var2_2.substring(var5_5 - var8_8, var5_5);
    }

    private String[] splitString(String string) {
        int n2;
        String[] stringArray = new String[1];
        int n3 = 0;
        do {
            if ((n2 = string.indexOf(10, n3)) == -1) {
                stringArray[stringArray.length - 1] = string.substring(n3);
                continue;
            }
            boolean bl2 = n2 > 0 && string.charAt(n2 - 1) == '\r';
            stringArray[stringArray.length - 1] = string.substring(n3, n2 - (bl2 ? 1 : 0));
            n3 = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        } while (n2 != -1);
        return stringArray;
    }
}

