/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.HDHITTESTINFO;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVODSTATECHANGE;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    int columnCount;
    int customCount;
    ImageList imageList;
    ImageList headerImageList;
    TableItem currentItem;
    TableColumn sortColumn;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawFocus;
    boolean ignoreDrawSelection;
    boolean ignoreDrawHot;
    boolean customDraw;
    boolean dragStarted;
    boolean explorerTheme;
    boolean firstColumnImage;
    boolean fixScrollWidth;
    boolean tipRequested;
    boolean wasSelected;
    boolean wasResized;
    boolean ignoreActivate;
    boolean ignoreSelect;
    boolean ignoreShrink;
    boolean ignoreResize;
    boolean ignoreColumnMove;
    boolean ignoreColumnResize;
    int headerToolTipHandle;
    int itemHeight;
    int lastIndexOf;
    int lastWidth;
    int sortDirection;
    int resizeCount;
    int selectionForeground;
    int hotIndex;
    static int HeaderProc;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int SORT_WIDTH = 10;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int VISTA_EXTRA = 2;
    static final int EXPLORER_EXTRA = 2;
    static final boolean EXPLORER_THEME = true;
    static final int TableProc;
    static final TCHAR TableClass;

    static {
        TableClass = new TCHAR(0, "SysListView32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TableClass, wNDCLASS);
        TableProc = wNDCLASS.lpfnWndProc;
    }

    public Table(Composite composite, int n2) {
        super(composite, Table.checkStyle(n2));
    }

    void _addListener(int n2, Listener listener) {
        super._addListener(n2, listener);
        switch (n2) {
            case 40: 
            case 41: 
            case 42: {
                this.setCustomDraw(true);
                this.setBackgroundTransparent(true);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style |= 0x20000000;
                }
                OS.SendMessage(this.handle, 4150, 16384, 0);
            }
        }
    }

    TableItem _getItem(int n2) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n2];
        }
        if (this.items[n2] != null) {
            return this.items[n2];
        }
        this.items[n2] = new TableItem(this, 0, -1, false);
        return this.items[n2];
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        return this.callWindowProc(n2, n3, n4, n5, false);
    }

    int callWindowProc(int n2, int n3, int n4, int n5, boolean bl2) {
        if (this.handle == 0) {
            return 0;
        }
        if (this.handle != n2) {
            return OS.CallWindowProc(HeaderProc, n2, n3, n4, n5);
        }
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        switch (n3) {
            case 256: {
                bl4 = true;
            }
            case 71: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl6 = bl5 = this.findImageControl() != null && this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (bl5) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                bl3 = true;
            }
            case 48: 
            case 275: {
                if (this.findImageControl() == null) break;
                n6 = OS.SendMessage(this.handle, 4135, 0, 0);
            }
        }
        boolean bl7 = this.wasSelected;
        if (bl3) {
            this.wasSelected = false;
        }
        if (bl4) {
            this.ignoreActivate = true;
        }
        int n7 = OS.CallWindowProc(TableProc, n2, n3, n4, n5);
        if (bl4) {
            this.ignoreActivate = false;
        }
        if (bl3) {
            if (this.wasSelected || bl2) {
                Event event = new Event();
                int n8 = OS.SendMessage(this.handle, 4108, -1, 1);
                if (n8 != -1) {
                    event.item = this._getItem(n8);
                }
                this.postEvent(13, event);
            }
            this.wasSelected = bl7;
        }
        switch (n3) {
            case 71: 
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (bl5) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                    int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
                    if (n9 != 0) {
                        OS.InvalidateRect(n9, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null || n6 == OS.SendMessage(this.handle, 4135, 0, 0)) break;
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return n7;
    }

    static int checkStyle(int n2) {
        return Table.checkBits(n2 |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    LRESULT CDDS_ITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        int n5;
        int n6 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            this.hotIndex = -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.RestoreDC(n6, -1);
            }
        }
        if (!this.ignoreCustomDraw && !this.ignoreDrawFocus && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n5 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0 && OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && this.handle == OS.GetFocus() && ((n4 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            RECT rECT = new RECT();
            rECT.left = 0;
            boolean bl2 = this.ignoreCustomDraw;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4110, nMLVCUSTOMDRAW.dwItemSpec, rECT);
            int n7 = OS.SendMessage(this.handle, 4127, 0, 0);
            int n8 = OS.SendMessage(n7, 4623, 0, 0);
            RECT rECT2 = new RECT();
            if (n8 == 0) {
                rECT2.left = 2;
                OS.SendMessage(this.handle, 4110, n8, rECT2);
            } else {
                rECT2.top = n8;
                rECT2.left = 1;
                OS.SendMessage(this.handle, 4152, nMLVCUSTOMDRAW.dwItemSpec, rECT2);
            }
            this.ignoreCustomDraw = bl2;
            rECT.left = rECT2.left;
            OS.DrawFocusRect(nMLVCUSTOMDRAW.hdc, rECT);
        }
        return null;
    }

    LRESULT CDDS_ITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        if (!this.ignoreCustomDraw && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0 && (nMLVCUSTOMDRAW.uItemState & 0x10) != 0) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            int n5 = this.hotIndex = (nMLVCUSTOMDRAW.uItemState & 0x40) != 0 ? nMLVCUSTOMDRAW.dwItemSpec : -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.SaveDC(nMLVCUSTOMDRAW.hdc);
                n4 = OS.CreateRectRgn(0, 0, 0, 0);
                OS.SelectClipRgn(nMLVCUSTOMDRAW.hdc, n4);
                OS.DeleteObject(n4);
            }
        }
        return new LRESULT(48);
    }

    LRESULT CDDS_POSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (--this.customCount == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0) {
            int n5 = 32;
            if (OS.IsWinCE) {
                RECT rECT = new RECT();
                boolean bl2 = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, n5, n5);
                OS.ValidateRect(this.handle, null);
                if (bl2) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                int n6 = OS.CreateRectRgn(0, 0, 0, 0);
                int n7 = OS.GetUpdateRgn(this.handle, n6, true);
                OS.SendMessage(this.handle, 4150, n5, n5);
                OS.ValidateRect(this.handle, null);
                if (n7 != 1) {
                    OS.InvalidateRgn(this.handle, n6, true);
                }
                OS.DeleteObject(n6);
            }
        }
        return null;
    }

    LRESULT CDDS_PREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        RECT rECT;
        int n5;
        int n6;
        if (this.ignoreCustomDraw) {
            return new LRESULT(48);
        }
        if (this.customCount++ == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && OS.SendMessage(this.handle, 4096, 0, 0) == -1 && ((n6 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) != 0) {
            n5 = 32;
            if (OS.IsWinCE) {
                rECT = new RECT();
                n4 = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, n5, 0);
                OS.ValidateRect(this.handle, null);
                if (n4 != 0) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                int n7 = OS.CreateRectRgn(0, 0, 0, 0);
                n4 = OS.GetUpdateRgn(this.handle, n7, true);
                OS.SendMessage(this.handle, 4150, n5, 0);
                OS.ValidateRect(this.handle, null);
                if (n4 != 1) {
                    OS.InvalidateRgn(this.handle, n7, true);
                }
                OS.DeleteObject(n7);
            }
        }
        if (OS.IsWindowVisible(this.handle)) {
            n6 = 1;
            if (this.explorerTheme && this.columnCount == 0) {
                n5 = nMLVCUSTOMDRAW.hdc;
                rECT = new RECT();
                OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(n5, rECT);
                } else {
                    this.fillBackground(n5, OS.GetSysColor(OS.COLOR_3DFACE), rECT);
                }
                n6 = 0;
            }
            if (n6 != 0) {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null) {
                    rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    this.fillImageBackground(nMLVCUSTOMDRAW.hdc, control, rECT);
                } else if (OS.SendMessage(this.handle, 4096, 0, 0) == -1 && OS.IsWindowEnabled(this.handle)) {
                    rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    if (control == null) {
                        control = this;
                    }
                    this.fillBackground(nMLVCUSTOMDRAW.hdc, control.getBackgroundPixel(), rECT);
                    if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && (n4 = this.indexOf(this.sortColumn)) != -1) {
                        this.parent.forceResize();
                        int n8 = this.getSortColumnPixel();
                        RECT rECT2 = new RECT();
                        RECT rECT3 = new RECT();
                        OS.GetClientRect(this.handle, rECT2);
                        int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
                        if (OS.SendMessage(n9, 4615, n4, rECT3) != 0) {
                            OS.MapWindowPoints(n9, this.handle, rECT3, 2);
                            rECT2.left = rECT3.left;
                            rECT2.right = rECT3.right;
                            if (OS.IntersectRect(rECT2, rECT2, rECT)) {
                                this.fillBackground(nMLVCUSTOMDRAW.hdc, n8, rECT2);
                            }
                        }
                    }
                }
            }
        }
        return new LRESULT(48);
    }

    LRESULT CDDS_SUBITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(0);
        }
        int n4 = nMLVCUSTOMDRAW.hdc;
        if (this.ignoreDrawForeground) {
            OS.RestoreDC(n4, -1);
        }
        if (OS.IsWindowVisible(this.handle)) {
            int n5;
            if (OS.SendMessage(this.handle, 4096, 0, 0) != -1 && (this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n5 = OS.SendMessage(this.handle, 4270, 0, 0)) == -1) {
                int n6 = this.indexOf(this.sortColumn);
                int n7 = 0;
                int n8 = 0;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n8 = OS.CreateRectRgn(0, 0, 0, 0);
                    n7 = OS.GetUpdateRgn(this.handle, n8, true);
                }
                OS.SendMessage(this.handle, 4236, n6, 0);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n7 != 1) {
                        OS.InvalidateRgn(this.handle, n8, true);
                    }
                    OS.DeleteObject(n8);
                }
            }
            if (this.hooks(42)) {
                TableItem tableItem = this._getItem(nMLVCUSTOMDRAW.dwItemSpec);
                this.sendPaintItemEvent(tableItem, nMLVCUSTOMDRAW);
            }
        }
        return null;
    }

    LRESULT CDDS_SUBITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2, int n3) {
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        int n8;
        TableItem tableItem;
        int n9 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw && this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
            OS.RestoreDC(n9, -1);
        }
        if ((tableItem = this._getItem(nMLVCUSTOMDRAW.dwItemSpec)) == null) {
            return null;
        }
        int n10 = n8 = tableItem.cellFont != null ? tableItem.cellFont[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n8 == -1) {
            n8 = tableItem.font;
        }
        if (n8 != -1) {
            OS.SelectObject(n9, n8);
        }
        if (this.ignoreCustomDraw || nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(n8 == -1 ? 0 : 2);
        }
        int n11 = 0;
        this.selectionForeground = -1;
        this.ignoreDrawBackground = false;
        this.ignoreDrawFocus = false;
        this.ignoreDrawSelection = false;
        this.ignoreDrawForeground = false;
        if (OS.IsWindowVisible(this.handle)) {
            if (this.hooks(41)) {
                this.sendMeasureItemEvent(tableItem, nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, nMLVCUSTOMDRAW.hdc);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
            }
            if (this.hooks(40)) {
                this.sendEraseItemEvent(tableItem, nMLVCUSTOMDRAW, n3);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
                n11 |= 0x10;
            }
            if (this.ignoreDrawForeground || this.hooks(42)) {
                n11 |= 0x10;
            }
        }
        int n12 = n7 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n7 == -1) {
            n7 = tableItem.foreground;
        }
        int n13 = n6 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n6 == -1) {
            n6 = tableItem.background;
        }
        if (this.selectionForeground != -1) {
            n7 = this.selectionForeground;
        }
        if (OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && !this.ignoreDrawSelection && (this.style & 0x10000) != 0 && ((n5 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x20) == 0) {
            object = new LVITEM();
            ((LVITEM)object).mask = 8;
            ((LVITEM)object).stateMask = 2;
            ((LVITEM)object).iItem = nMLVCUSTOMDRAW.dwItemSpec;
            n4 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, (LVITEM)object);
            if (n4 != 0 && (((LVITEM)object).state & 2) != 0) {
                int n14 = -1;
                if (nMLVCUSTOMDRAW.iSubItem == 0) {
                    if (OS.GetFocus() == this.handle) {
                        n14 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                    } else if ((this.style & 0x8000) == 0) {
                        n14 = OS.GetSysColor(OS.COLOR_3DFACE);
                    }
                } else if (OS.GetFocus() == this.handle) {
                    n7 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    n6 = n14 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else if ((this.style & 0x8000) == 0) {
                    n6 = n14 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (n14 != -1) {
                    RECT rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, nMLVCUSTOMDRAW.iSubItem != 0, true, false, n9);
                    this.fillBackground(n9, n14, rECT);
                }
            }
        }
        if (!this.ignoreDrawForeground) {
            int n15;
            n5 = 1;
            if (n8 == -1 && n7 == -1 && n6 == -1 && tableItem.cellForeground == null && tableItem.cellBackground == null && tableItem.cellFont == null && (n4 = OS.SendMessage(n15 = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 1) {
                n5 = 0;
            }
            if (n5 != 0) {
                if (n8 == -1) {
                    n8 = OS.SendMessage(this.handle, 49, 0, 0);
                }
                OS.SelectObject(n9, n8);
                if (OS.IsWindowEnabled(this.handle)) {
                    int n16 = nMLVCUSTOMDRAW.clrText = n7 == -1 ? this.getForegroundPixel() : n7;
                    if (n6 == -1) {
                        nMLVCUSTOMDRAW.clrTextBk = -1;
                        if (this.selectionForeground == -1) {
                            object = this.findBackgroundControl();
                            if (object == null) {
                                object = this;
                            }
                            if (((Control)object).backgroundImage == null && OS.SendMessage(this.handle, 4096, 0, 0) != -1) {
                                nMLVCUSTOMDRAW.clrTextBk = ((Control)object).getBackgroundPixel();
                            }
                        }
                    } else {
                        nMLVCUSTOMDRAW.clrTextBk = this.selectionForeground != -1 ? -1 : n6;
                    }
                    OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
                }
                n11 |= 2;
            }
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (n6 != -1 && (n5 = OS.SendMessage(this.handle, 4270, 0, 0)) != -1 && n5 == nMLVCUSTOMDRAW.iSubItem) {
                int n17 = 0;
                n4 = 0;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n4 = OS.CreateRectRgn(0, 0, 0, 0);
                    n17 = OS.GetUpdateRgn(this.handle, n4, true);
                }
                OS.SendMessage(this.handle, 4236, -1, 0);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n17 != 1) {
                        OS.InvalidateRgn(this.handle, n4, true);
                    }
                    OS.DeleteObject(n4);
                }
                n11 |= 0x10;
            }
        } else {
            nMLVCUSTOMDRAW.clrText = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            nMLVCUSTOMDRAW.clrTextBk = this.findImageControl() != null ? -1 : OS.GetSysColor(OS.COLOR_3DFACE);
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
            OS.MoveMemory(n3, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            n11 |= 2;
        }
        return new LRESULT(n11);
    }

    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
        if ((this.style & 0x10000000) != 0) {
            this.style |= 0x20000000;
        }
    }

    boolean checkData(TableItem tableItem, boolean bl2) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        return this.checkData(tableItem, this.indexOf(tableItem), bl2);
    }

    boolean checkData(TableItem tableItem, int n2, boolean bl2) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!tableItem.cached) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = n2;
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (bl2 && !this.setScrollWidth(tableItem, false)) {
                tableItem.redraw();
            }
        }
        return true;
    }

    boolean checkHandle(int n2) {
        if (n2 == this.handle) {
            return true;
        }
        return n2 == OS.SendMessage(this.handle, 4127, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n2) {
        TableItem tableItem;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            this.error(6);
        }
        if ((tableItem = this.items[n2]) != null) {
            if (tableItem != this.currentItem) {
                tableItem.clear();
            }
            if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 17;
                lVITEM.pszText = -1;
                lVITEM.iItem = n2;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                tableItem.cached = false;
            }
            if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, n2, n2);
            }
            this.setScrollWidth(tableItem, false);
        }
    }

    public void clear(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n4 - 1) {
            this.clearAll();
        } else {
            LVITEM lVITEM = null;
            boolean bl2 = false;
            int n5 = n2;
            while (n5 <= n3) {
                TableItem tableItem = this.items[n5];
                if (tableItem != null) {
                    if (tableItem != this.currentItem) {
                        bl2 = true;
                        tableItem.clear();
                    }
                    if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                        if (lVITEM == null) {
                            lVITEM = new LVITEM();
                            lVITEM.mask = 17;
                            lVITEM.pszText = -1;
                        }
                        lVITEM.iItem = n5;
                        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                        tableItem.cached = false;
                    }
                }
                ++n5;
            }
            if (bl2) {
                if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, n2, n3);
                }
                TableItem tableItem = n2 == n3 ? this.items[n2] : null;
                this.setScrollWidth(tableItem, false);
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 0 || nArray[n3] >= n2) {
                this.error(6);
            }
            ++n3;
        }
        LVITEM lVITEM = null;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            TableItem tableItem = this.items[n5];
            if (tableItem != null) {
                if (tableItem != this.currentItem) {
                    bl2 = true;
                    tableItem.clear();
                }
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1;
                    }
                    lVITEM.iItem = n4;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                    tableItem.cached = false;
                }
                if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, n5, n5);
                }
            }
            ++n4;
        }
        if (bl2) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        LVITEM lVITEM = null;
        boolean bl2 = false;
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            TableItem tableItem = this.items[n3];
            if (tableItem != null) {
                if (tableItem != this.currentItem) {
                    bl2 = true;
                    tableItem.clear();
                }
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1;
                    }
                    lVITEM.iItem = n3;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                    tableItem.cached = false;
                }
            }
            ++n3;
        }
        if (bl2) {
            if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0, n2 - 1);
            }
            this.setScrollWidth(null, false);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        int n7 = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rECT = new RECT();
        OS.GetWindowRect(n7, rECT);
        int n8 = rECT.bottom - rECT.top;
        int n9 = 0;
        if (n2 != -1) {
            n9 |= n2 & 0xFFFF;
        } else {
            n6 = 0;
            n5 = OS.SendMessage(n7, 4608, 0, 0);
            n4 = 0;
            while (n4 < n5) {
                n6 += OS.SendMessage(this.handle, 4125, n4, 0);
                ++n4;
            }
            n9 |= n6 & 0xFFFF;
        }
        n6 = OS.SendMessage(this.handle, 4160, -1, n9 | 0xFFFF0000);
        n5 = n6 & 0xFFFF;
        n4 = OS.SendMessage(this.handle, 4160, 0, 0);
        int n10 = OS.SendMessage(this.handle, 4160, 1, 0);
        int n11 = (n10 >> 16) - (n4 >> 16);
        n8 += OS.SendMessage(this.handle, 4100, 0, 0) * n11;
        if (n5 == 0) {
            n5 = 64;
        }
        if (n8 == 0) {
            n8 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n8 = n3;
        }
        int n12 = this.getBorderWidth();
        n5 += n12 * 2;
        n8 += n12 * 2;
        if ((this.style & 0x200) != 0) {
            n5 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n8 += OS.GetSystemMetrics(3);
        }
        return new Point(n5, n8);
    }

    void createHandle() {
        int n2;
        int n3;
        int n4;
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            this.explorerTheme = true;
            OS.SetWindowTheme(this.handle, Display.EXPLORER, null);
        }
        if (HeaderProc == 0) {
            n4 = OS.SendMessage(this.handle, 4127, 0, 0);
            HeaderProc = OS.GetWindowLong(n4, -4);
        }
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            n4 = OS.SendMessage(this.handle, 4160, 0, 0);
            int n5 = OS.SendMessage(this.handle, 4160, 1, 0);
            n2 = n3 = (n5 >> 16) - (n4 >> 16);
            this.setCheckboxImageList(n3, n2, false);
            OS.SendMessage(this.handle, 4107, 61440, 0);
        }
        n4 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n4, 0);
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 6;
        n3 = OS.GetProcessHeap();
        lVCOLUMN.pszText = n2 = OS.HeapAlloc(n3, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0, lVCOLUMN);
        OS.HeapFree(n3, 0, n2);
        int n6 = 16384;
        if ((this.style & 0x10000) != 0) {
            n6 |= 0x20;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            n6 |= 0x10000;
        }
        OS.SendMessage(this.handle, 4150, n6, n6);
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        if ((this.style & 0x4000000) != 0) {
            int n7 = OS.SendMessage(this.handle, 4127, 0, 0);
            int n8 = OS.GetWindowLong(n7, -20);
            OS.SetWindowLong(n7, -20, n8 | 0x400000);
        }
    }

    void createHeaderToolTips() {
        if (OS.IsWinCE) {
            return;
        }
        if (this.headerToolTipHandle != 0) {
            return;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0) {
            this.error(2);
        }
        OS.SendMessage(this.headerToolTipHandle, 1048, 0, Short.MAX_VALUE);
    }

    void createItem(TableColumn tableColumn, int n2) {
        Object object;
        int n3;
        if (n2 < 0 || n2 > this.columnCount) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 4270, 0, 0)) >= n2) {
            OS.SendMessage(this.handle, 4236, n3 + 1, 0);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n5 = 0;
        while (n5 < n4) {
            object = this.items[n5];
            if (object != null) {
                int[] nArray;
                Object[] objectArray;
                Object[] objectArray2;
                String[] stringArray = ((TableItem)object).strings;
                if (stringArray != null) {
                    objectArray2 = new String[this.columnCount + 1];
                    System.arraycopy(stringArray, 0, objectArray2, 0, n2);
                    System.arraycopy(stringArray, n2, objectArray2, n2 + 1, this.columnCount - n2);
                    ((TableItem)object).strings = objectArray2;
                }
                if ((objectArray2 = ((TableItem)object).images) != null) {
                    objectArray = new Image[this.columnCount + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                    System.arraycopy(objectArray2, n2, objectArray, n2 + 1, this.columnCount - n2);
                    ((TableItem)object).images = objectArray;
                }
                if (n2 == 0 && this.columnCount != 0) {
                    if (stringArray == null) {
                        ((TableItem)object).strings = new String[this.columnCount + 1];
                        ((TableItem)object).strings[1] = ((TableItem)object).text;
                    }
                    ((TableItem)object).text = "";
                    if (objectArray2 == null) {
                        ((TableItem)object).images = new Image[this.columnCount + 1];
                        ((TableItem)object).images[1] = ((TableItem)object).image;
                    }
                    ((TableItem)object).image = null;
                }
                if (((TableItem)object).cellBackground != null) {
                    objectArray = ((TableItem)object).cellBackground;
                    nArray = new int[this.columnCount + 1];
                    System.arraycopy(objectArray, 0, nArray, 0, n2);
                    System.arraycopy(objectArray, n2, nArray, n2 + 1, this.columnCount - n2);
                    nArray[n2] = -1;
                    ((TableItem)object).cellBackground = nArray;
                }
                if (((TableItem)object).cellForeground != null) {
                    objectArray = ((TableItem)object).cellForeground;
                    nArray = new int[this.columnCount + 1];
                    System.arraycopy(objectArray, 0, nArray, 0, n2);
                    System.arraycopy(objectArray, n2, nArray, n2 + 1, this.columnCount - n2);
                    nArray[n2] = -1;
                    ((TableItem)object).cellForeground = nArray;
                }
                if (((TableItem)object).cellFont != null) {
                    objectArray = ((TableItem)object).cellFont;
                    nArray = new int[this.columnCount + 1];
                    System.arraycopy(objectArray, 0, nArray, 0, n2);
                    System.arraycopy(objectArray, n2, nArray, n2 + 1, this.columnCount - n2);
                    nArray[n2] = -1;
                    ((TableItem)object).cellFont = nArray;
                }
            }
            ++n5;
        }
        System.arraycopy(this.columns, n2, this.columns, n2 + 1, this.columnCount++ - n2);
        this.columns[n2] = tableColumn;
        this.ignoreColumnResize = true;
        if (n2 == 0) {
            if (this.columnCount > 1) {
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lVCOLUMN);
                int n6 = lVCOLUMN.cx;
                int n7 = 1024;
                int n8 = OS.GetProcessHeap();
                int n9 = n7 * TCHAR.sizeof;
                int n10 = OS.HeapAlloc(n8, 8, n9);
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = n10;
                lVCOLUMN.cchTextMax = n7;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1, lVCOLUMN);
                lVCOLUMN.fmt = 2048;
                lVCOLUMN.cx = n6;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.cchTextMax = 0;
                lVCOLUMN.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                lVCOLUMN.mask = 1;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n10 != 0) {
                    OS.HeapFree(n8, 0, n10);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0, 0);
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                int n11 = 0;
                while (n11 < n4) {
                    lVITEM.iItem = n11++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        } else {
            n5 = 0;
            if ((tableColumn.style & 0x1000000) == 0x1000000) {
                n5 = 2;
            }
            if ((tableColumn.style & 0x20000) == 131072) {
                n5 = 1;
            }
            object = new LVCOLUMN();
            ((LVCOLUMN)object).mask = 3;
            ((LVCOLUMN)object).fmt = n5;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, n2, (LVCOLUMN)object);
        }
        this.ignoreColumnResize = false;
        if (this.headerToolTipHandle != 0) {
            RECT rECT = new RECT();
            int n12 = OS.SendMessage(this.handle, 4127, 0, 0);
            if (OS.SendMessage(n12, 4615, n2, rECT) != 0) {
                TOOLINFO tOOLINFO = new TOOLINFO();
                tOOLINFO.cbSize = TOOLINFO.sizeof;
                tOOLINFO.uFlags = 16;
                tOOLINFO.hwnd = n12;
                tableColumn.id = this.display.nextToolTipId++;
                tOOLINFO.uId = tableColumn.id;
                tOOLINFO.left = rECT.left;
                tOOLINFO.top = rECT.top;
                tOOLINFO.right = rECT.right;
                tOOLINFO.bottom = rECT.bottom;
                tOOLINFO.lpszText = -1;
                OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
    }

    void createItem(TableItem tableItem, int n2) {
        int n3;
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 > n4) {
            this.error(6);
        }
        if (n4 == this.items.length) {
            boolean bl2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            n3 = bl2 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n3];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 3;
        lVITEM.iItem = n2;
        lVITEM.pszText = -1;
        lVITEM.iImage = -1;
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        n3 = OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0, lVITEM);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n3 == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, n4 - n2);
        this.items[n2] = tableItem;
        this.setDeferResize(false);
        if (n4 == 0) {
            this.setScrollWidth(tableItem, false);
        }
    }

    void createWidget() {
        super.createWidget();
        this.hotIndex = -1;
        this.itemHeight = -1;
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        super.deregister();
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (n2 != 0) {
            this.display.removeControl(n2);
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, nArray[n2], lVITEM);
                this.ignoreSelect = false;
            }
            ++n2;
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 == 0 && n3 == n4 - 1) {
            this.deselectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 2;
            int n5 = n2 = Math.max(0, n2);
            while (n5 <= n3) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, n5, lVITEM);
                this.ignoreSelect = false;
                ++n5;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object[] objectArray;
        int n2;
        int n3 = 0;
        while (n3 < this.columnCount) {
            if (this.columns[n3] == tableColumn) break;
            ++n3;
        }
        int n4 = OS.SendMessage(this.handle, 4270, 0, 0);
        if (n4 == n3) {
            OS.SendMessage(this.handle, 4236, -1, 0);
        } else if (n4 > n3) {
            OS.SendMessage(this.handle, 4236, n4 - 1, 0);
        }
        int n5 = 0;
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
        while (n5 < this.columnCount) {
            if (nArray[n5] == n3) break;
            ++n5;
        }
        this.ignoreColumnResize = true;
        boolean bl2 = false;
        if (n3 == 0) {
            int n6;
            int n7;
            bl2 = true;
            if (this.columnCount > 1) {
                n3 = 1;
                n7 = 1024;
                n2 = OS.GetProcessHeap();
                n6 = n7 * TCHAR.sizeof;
                int n8 = OS.HeapAlloc(n2, 8, n6);
                objectArray = new LVCOLUMN();
                objectArray.mask = 23;
                objectArray.pszText = n8;
                objectArray.cchTextMax = n7;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, (LVCOLUMN)objectArray);
                objectArray.fmt &= 0xFFFFFFFC;
                objectArray.fmt |= 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, (LVCOLUMN)objectArray);
                if (n8 != 0) {
                    OS.HeapFree(n2, 0, n8);
                }
            } else {
                n7 = OS.GetProcessHeap();
                n2 = OS.HeapAlloc(n7, 8, TCHAR.sizeof);
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = n2;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n2 != 0) {
                    OS.HeapFree(n7, 0, n2);
                }
                if (OS.COMCTL32_MAJOR >= 6) {
                    HDITEM hDITEM = new HDITEM();
                    hDITEM.mask = 4;
                    hDITEM.fmt = 0;
                    int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
                    OS.SendMessage(n9, OS.HDM_SETITEM, n3, hDITEM);
                }
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                n2 = OS.SendMessage(this.handle, 4100, 0, 0);
                n6 = 0;
                while (n6 < n2) {
                    lVITEM.iItem = n6++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        }
        if (this.columnCount > 1 && OS.SendMessage(this.handle, 4124, n3, 0) == 0) {
            this.error(15);
        }
        if (bl2) {
            n3 = 0;
        }
        System.arraycopy(this.columns, n3 + 1, this.columns, n3, --this.columnCount - n3);
        this.columns[this.columnCount] = null;
        int n10 = OS.SendMessage(this.handle, 4100, 0, 0);
        n2 = 0;
        while (n2 < n10) {
            TableItem tableItem = this.items[n2];
            if (tableItem != null) {
                if (this.columnCount == 0) {
                    tableItem.strings = null;
                    tableItem.images = null;
                    tableItem.cellBackground = null;
                    tableItem.cellForeground = null;
                    tableItem.cellFont = null;
                } else {
                    if (tableItem.strings != null) {
                        String[] stringArray = tableItem.strings;
                        if (n3 == 0) {
                            tableItem.text = stringArray[1] != null ? stringArray[1] : "";
                        }
                        objectArray = new String[this.columnCount];
                        System.arraycopy(stringArray, 0, objectArray, 0, n3);
                        System.arraycopy(stringArray, n3 + 1, objectArray, n3, this.columnCount - n3);
                        tableItem.strings = objectArray;
                    } else if (n3 == 0) {
                        tableItem.text = "";
                    }
                    if (tableItem.images != null) {
                        Image[] imageArray = tableItem.images;
                        if (n3 == 0) {
                            tableItem.image = imageArray[1];
                        }
                        objectArray = new Image[this.columnCount];
                        System.arraycopy(imageArray, 0, objectArray, 0, n3);
                        System.arraycopy(imageArray, n3 + 1, objectArray, n3, this.columnCount - n3);
                        tableItem.images = objectArray;
                    } else if (n3 == 0) {
                        tableItem.image = null;
                    }
                    if (tableItem.cellBackground != null) {
                        int[] nArray2 = tableItem.cellBackground;
                        objectArray = new int[this.columnCount];
                        System.arraycopy(nArray2, 0, objectArray, 0, n3);
                        System.arraycopy(nArray2, n3 + 1, objectArray, n3, this.columnCount - n3);
                        tableItem.cellBackground = (int[])objectArray;
                    }
                    if (tableItem.cellForeground != null) {
                        int[] nArray3 = tableItem.cellForeground;
                        objectArray = new int[this.columnCount];
                        System.arraycopy(nArray3, 0, objectArray, 0, n3);
                        System.arraycopy(nArray3, n3 + 1, objectArray, n3, this.columnCount - n3);
                        tableItem.cellForeground = (int[])objectArray;
                    }
                    if (tableItem.cellFont != null) {
                        int[] nArray4 = tableItem.cellFont;
                        objectArray = new int[this.columnCount];
                        System.arraycopy(nArray4, 0, objectArray, 0, n3);
                        System.arraycopy(nArray4, n3 + 1, objectArray, n3, this.columnCount - n3);
                        tableItem.cellFont = (int[])objectArray;
                    }
                }
            }
            ++n2;
        }
        if (this.columnCount == 0) {
            this.setScrollWidth(null, true);
        }
        this.updateMoveable();
        this.ignoreColumnResize = false;
        if (this.columnCount != 0) {
            n2 = 0;
            int n11 = nArray[n5];
            int[] nArray5 = new int[this.columnCount];
            int n12 = 0;
            while (n12 < nArray.length) {
                if (nArray[n12] != n11) {
                    int n13 = nArray[n12] <= n11 ? nArray[n12] : nArray[n12] - 1;
                    nArray5[n2++] = n13;
                }
                ++n12;
            }
            OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
            n12 = 0;
            while (n12 < nArray5.length) {
                if (nArray[n12] != nArray5[n12]) break;
                ++n12;
            }
            if (n12 != nArray5.length) {
                OS.SendMessage(this.handle, 4154, nArray5.length, nArray5);
                OS.InvalidateRect(this.handle, null, true);
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount - n5];
            int n14 = n5;
            while (n14 < nArray5.length) {
                tableColumnArray[n14 - n5] = this.columns[nArray5[n14]];
                tableColumnArray[n14 - n5].updateToolTip(nArray5[n14]);
                ++n14;
            }
            n14 = 0;
            while (n14 < tableColumnArray.length) {
                if (!tableColumnArray[n14].isDisposed()) {
                    tableColumnArray[n14].sendEvent(10);
                }
                ++n14;
            }
        }
        if (this.headerToolTipHandle != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = tableColumn.id;
            tOOLINFO.hwnd = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            if (this.items[n3] == tableItem) break;
            ++n3;
        }
        if (n3 == n2) {
            return;
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n4 = OS.SendMessage(this.handle, 4104, n3, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n4 == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n3 + 1, this.items, n3, --n2 - n3);
        this.items[n2] = null;
        if (n2 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    void fixCheckboxImageList(boolean bl2) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4098, 1, 0);
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n2, nArray, nArray2);
        int n3 = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n3 == 0) {
            return;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.ImageList_GetIconSize(n3, nArray3, nArray4);
        if (nArray[0] == nArray3[0] && nArray2[0] == nArray4[0]) {
            return;
        }
        this.setCheckboxImageList(nArray[0], nArray2[0], bl2);
    }

    void fixCheckboxImageListColor(boolean bl2) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n2, nArray, nArray2);
        this.setCheckboxImageList(nArray[0], nArray2[0], bl2);
    }

    void fixItemHeight(boolean bl2) {
        int n2;
        if (this.itemHeight != -1) {
            return;
        }
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n3 & 1) == 0) {
            return;
        }
        n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0x4000) != 0) {
            return;
        }
        int n4 = this.getTopIndex();
        if (bl2 && n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if ((n2 = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
            return;
        }
        int n5 = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rECT = new RECT();
        OS.GetWindowRect(n5, rECT);
        int n6 = rECT.bottom - rECT.top - 1;
        int n7 = OS.ImageList_Create(1, n6, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1, n7);
        this.fixCheckboxImageList(false);
        OS.SendMessage(this.handle, 4099, 1, 0);
        if (this.headerImageList != null) {
            int n8 = this.headerImageList.getHandle();
            OS.SendMessage(n5, 4616, 0, n8);
        }
        OS.ImageList_Destroy(n7);
        if (bl2 && n4 != 0) {
            this.setTopIndex(n4);
            this.setRedraw(true);
        }
    }

    public TableColumn getColumn(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n2];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    int getFocusIndex() {
        return OS.SendMessage(this.handle, 4108, -1, 1);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (n2 == 0) {
            return 0;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(n2, rECT);
        return rECT.bottom - rECT.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        return (n2 & 0x4000) == 0;
    }

    public TableItem getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            this.error(6);
        }
        return this._getItem(n2);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        if (lVHITTESTINFO.iItem != -1) {
            int n2;
            int n3;
            if (lVHITTESTINFO.iItem == 0 && ((n3 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0 && (n2 = OS.SendMessage(this.handle, 4127, 0, 0)) != 0) {
                RECT rECT = new RECT();
                OS.GetWindowRect(n2, rECT);
                POINT pOINT = new POINT();
                pOINT.x = lVHITTESTINFO.x;
                pOINT.y = lVHITTESTINFO.y;
                OS.MapWindowPoints(this.handle, 0, pOINT, 1);
                if (OS.PtInRect(rECT, pOINT)) {
                    return null;
                }
            }
            return this._getItem(lVHITTESTINFO.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4100, 0, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4160, 0, 0);
        int n3 = OS.SendMessage(this.handle, 4160, 1, 0);
        return (n3 >> 16) - (n2 >> 16);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        TableItem[] tableItemArray = new TableItem[n2];
        if ((this.style & 0x10000000) != 0) {
            int n3 = 0;
            while (n3 < n2) {
                tableItemArray[n3] = this._getItem(n3);
                ++n3;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, n2);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4151, 0, 0);
        return (n2 & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n2 = -1;
        int n3 = 0;
        int n4 = OS.SendMessage(this.handle, 4146, 0, 0);
        TableItem[] tableItemArray = new TableItem[n4];
        while ((n2 = OS.SendMessage(this.handle, 4108, n2, 2)) != -1) {
            tableItemArray[n3++] = this._getItem(n2);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4146, 0, 0);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4108, -1, 1);
        int n3 = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n2 == n3) {
            return n3;
        }
        int n4 = -1;
        while ((n4 = OS.SendMessage(this.handle, 4108, n4, 2)) != -1) {
            if (n4 != n2) continue;
            return n4;
        }
        return n3;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n2 = -1;
        int n3 = 0;
        int n4 = OS.SendMessage(this.handle, 4146, 0, 0);
        int[] nArray = new int[n4];
        while ((n2 = OS.SendMessage(this.handle, 4108, n2, 2)) != -1) {
            nArray[n3++] = n2;
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int n2 = OS.IsWindowEnabled(this.handle) ? this.getBackgroundPixel() : OS.GetSysColor(OS.COLOR_3DFACE);
        int n3 = n2 & 0xFF;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = (n2 & 0xFF0000) >> 16;
        if (n3 > 240 && n4 > 240 && n5 > 240) {
            n3 -= 8;
            n4 -= 8;
            n5 -= 8;
        } else {
            n3 = Math.min(255, n3 / 10 + n3);
            n4 = Math.min(255, n4 / 10 + n4);
            n5 = Math.min(255, n5 / 10 + n5);
        }
        return n3 & 0xFF | (n4 & 0xFF) << 8 | (n5 & 0xFF) << 16;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, OS.SendMessage(this.handle, 4135, 0, 0));
    }

    boolean hasChildren() {
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.GetWindow(this.handle, 5);
        while (n3 != 0) {
            if (n3 != n2) {
                return true;
            }
            n3 = OS.GetWindow(n3, 2);
        }
        return false;
    }

    int imageIndex(Image image, int n2) {
        if (image == null) {
            return -2;
        }
        if (n2 == 0) {
            this.firstColumnImage = true;
        } else {
            this.setSubImagesVisible(true);
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n3 = this.imageList.indexOf(image);
            if (n3 == -1) {
                n3 = this.imageList.add(image);
            }
            int n4 = this.imageList.getHandle();
            int n5 = this.getTopIndex();
            if (n5 != 0) {
                this.setRedraw(false);
                this.setTopIndex(0);
            }
            OS.SendMessage(this.handle, 4099, 1, n4);
            if (this.headerImageList != null) {
                int n6 = OS.SendMessage(this.handle, 4127, 0, 0);
                int n7 = this.headerImageList.getHandle();
                OS.SendMessage(n6, 4616, 0, n7);
            }
            this.fixCheckboxImageList(false);
            if (this.itemHeight != -1) {
                this.setItemHeight(false);
            }
            if (n5 != 0) {
                this.setTopIndex(n5);
                this.setRedraw(true);
            }
            return n3;
        }
        int n8 = this.imageList.indexOf(image);
        if (n8 != -1) {
            return n8;
        }
        return this.imageList.add(image);
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle rectangle = image.getBounds();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.headerImageList.indexOf(image);
            if (n2 == -1) {
                n2 = this.headerImageList.add(image);
            }
            int n3 = this.headerImageList.getHandle();
            int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SendMessage(n4, 4616, 0, n3);
            return n2;
        }
        int n5 = this.headerImageList.indexOf(image);
        if (n5 != -1) {
            return n5;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2] == tableColumn) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (1 <= this.lastIndexOf && this.lastIndexOf < n2 - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < n2 / 2) {
            int n3 = 0;
            while (n3 < n2) {
                if (this.items[n3] == tableItem) {
                    this.lastIndexOf = n3;
                    return this.lastIndexOf;
                }
                ++n3;
            }
        } else {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                if (this.items[n4] == tableItem) {
                    this.lastIndexOf = n4;
                    return this.lastIndexOf;
                }
                --n4;
            }
        }
        return -1;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = n2;
        int n3 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        return n3 != 0 && (lVITEM.state & 2) != 0;
    }

    void register() {
        super.register();
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (n2 != 0) {
            this.display.addControl(n2, this);
        }
    }

    void releaseChildren(boolean bl2) {
        int n2;
        if (this.items != null) {
            TableItem tableItem;
            int n3;
            n2 = OS.SendMessage(this.handle, 4100, 0, 0);
            if (OS.IsWin95 && this.columnCount > 1) {
                this.resizeCount = 1;
                OS.SendMessage(this.handle, 11, 0, 0);
                n3 = n2 - 1;
                while (n3 >= 0) {
                    tableItem = this.items[n3];
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    this.ignoreShrink = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4104, n3, 0);
                    this.ignoreShrink = false;
                    this.ignoreSelect = false;
                    --n3;
                }
            } else {
                n3 = 0;
                while (n3 < n2) {
                    tableItem = this.items[n3];
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    ++n3;
                }
            }
            this.items = null;
        }
        if (this.columns != null) {
            n2 = 0;
            while (n2 < this.columnCount) {
                TableColumn tableColumn = this.columns[n2];
                if (!tableColumn.isDisposed()) {
                    tableColumn.release(false);
                }
                ++n2;
            }
            this.columns = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseWidget() {
        int n2;
        super.releaseWidget();
        this.customDraw = false;
        this.currentItem = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1, 0);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            n2 = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SendMessage(n2, 4616, 0, 0);
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        n2 = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, 0);
        if (n2 != 0) {
            OS.ImageList_Destroy(n2);
        }
        if (this.headerToolTipHandle != 0) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        this.setDeferResize(true);
        int n5 = -1;
        int n6 = 0;
        while (n6 < nArray2.length) {
            int n7 = nArray2[n6];
            if (n7 != n5) {
                TableItem tableItem = this.items[n7];
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n8 = OS.SendMessage(this.handle, 4104, n7, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n8 == 0) {
                    this.error(15);
                }
                System.arraycopy(this.items, n7 + 1, this.items, n7, --n4 - n7);
                this.items[n4] = null;
                n5 = n7;
            }
            ++n6;
        }
        if (n4 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n2) {
        TableItem tableItem;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            this.error(6);
        }
        if ((tableItem = this.items[n2]) != null && !tableItem.isDisposed()) {
            tableItem.release(false);
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n4 = OS.SendMessage(this.handle, 4104, n2, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n4 == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n3 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        if (n2 == 0 && n3 == n4 - 1) {
            this.removeAll();
        } else {
            this.setDeferResize(true);
            int n5 = n2;
            while (n5 <= n3) {
                TableItem tableItem = this.items[n5];
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n6 = OS.SendMessage(this.handle, 4104, n2, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n6 == 0) break;
                ++n5;
            }
            System.arraycopy(this.items, n5, this.items, n2, n4 - n5);
            int n7 = n4 - (n5 - n2);
            while (n7 < n4) {
                this.items[n7] = null;
                ++n7;
            }
            if (n5 <= n3) {
                this.error(15);
            }
            this.setDeferResize(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            TableItem tableItem = this.items[n3];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            ++n3;
        }
        this.setDeferResize(true);
        if (OS.IsWin95 && this.columnCount > 1) {
            int n4 = n3 = this.drawCount == 0 && OS.IsWindowVisible(this.handle) ? 1 : 0;
            if (n3 != 0) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            int n5 = n2 - 1;
            while (n5 >= 0) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n6 = OS.SendMessage(this.handle, 4104, n5, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n6 == 0) break;
                --n5;
            }
            if (n3 != 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
            }
            if (n5 != -1) {
                this.error(15);
            }
        } else {
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            n3 = OS.SendMessage(this.handle, 4105, 0, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (n3 == 0) {
                this.error(15);
            }
        }
        this.setTableEmpty();
        this.setDeferResize(false);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (nArray[n3] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, nArray[n3], lVITEM);
                this.ignoreSelect = false;
            }
            --n3;
        }
    }

    public void select(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        if (n2 == 0 && n3 == n4 - 1) {
            this.selectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 2;
            lVITEM.stateMask = 2;
            int n5 = n2;
            while (n5 <= n3) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, n5, lVITEM);
                this.ignoreSelect = false;
                ++n5;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    void sendEraseItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW, int n2) {
        RECT rECT;
        int n3;
        boolean bl2;
        int n4;
        int n5;
        int n6;
        int n7 = nMLVCUSTOMDRAW.hdc;
        int n8 = n6 = tableItem.cellFont != null ? tableItem.cellFont[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n6 == -1) {
            n6 = tableItem.font;
        }
        int n9 = n5 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n5 == -1) {
            n5 = tableItem.foreground;
        }
        int n10 = -1;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == nMLVCUSTOMDRAW.iSubItem) {
            n10 = this.getSortColumnPixel();
        }
        int n11 = n10 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n10 == -1) {
            n10 = tableItem.background;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = nMLVCUSTOMDRAW.dwItemSpec;
        int n12 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        boolean bl3 = n12 != 0 && (lVITEM.state & 2) != 0;
        GCData gCData = new GCData();
        gCData.device = this.display;
        int n13 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            boolean bl7 = bl6 = this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl3 && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle) {
                    bl4 = true;
                    gCData.foreground = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = n13 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl4 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(n7);
                    gCData.background = n13 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme) {
                    gCData.foreground = n5 != -1 ? n5 : this.getForegroundPixel();
                }
            } else {
                boolean bl8 = bl5 = n10 != -1;
                if (n10 == -1) {
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    n10 = control.getBackgroundPixel();
                }
                gCData.foreground = n5 != -1 ? n5 : OS.GetTextColor(n7);
                gCData.background = n10 != -1 ? n10 : OS.GetBkColor(n7);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
            if (bl3) {
                n13 = gCData.background;
            }
        }
        gCData.hFont = n6;
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        int n14 = OS.SaveDC(n7);
        GC gC = GC.win32_new(n7, gCData);
        RECT rECT2 = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, n7);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = nMLVCUSTOMDRAW.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n4 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            event.detail |= 4;
        }
        if (bl6) {
            event.detail |= 0x20;
        }
        if (bl4) {
            event.detail |= 2;
        }
        if (bl5) {
            event.detail |= 8;
        }
        event.x = rECT2.left;
        event.y = rECT2.top;
        event.width = rECT2.right - rECT2.left;
        event.height = rECT2.bottom - rECT2.top;
        gC.setClipping(event.x, event.y, event.width, event.height);
        this.sendEvent(40, event);
        event.gc = null;
        n4 = gCData.foreground;
        gC.dispose();
        OS.RestoreDC(n7, n14);
        if (this.isDisposed() || tableItem.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.ignoreDrawForeground = (event.detail & 0x10) == 0;
            this.ignoreDrawBackground = (event.detail & 8) == 0;
            this.ignoreDrawSelection = (event.detail & 2) == 0;
            this.ignoreDrawFocus = (event.detail & 4) == 0;
            this.ignoreDrawHot = (event.detail & 0x20) == 0;
        } else {
            this.ignoreDrawHot = true;
            this.ignoreDrawFocus = true;
            this.ignoreDrawSelection = true;
            this.ignoreDrawBackground = true;
            this.ignoreDrawForeground = true;
        }
        if (bl4) {
            if (this.ignoreDrawSelection) {
                this.ignoreDrawHot = true;
                if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
                    this.selectionForeground = n4;
                }
                nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
                OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            }
        } else if (this.ignoreDrawSelection) {
            nMLVCUSTOMDRAW.uItemState |= 1;
            OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.ignoreDrawFocus) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(n2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        boolean bl9 = bl2 = nMLVCUSTOMDRAW.iSubItem == OS.SendMessage(n3 = OS.SendMessage(this.handle, 4127, 0, 0), 4623, 0, 0);
        if (this.ignoreDrawForeground && this.ignoreDrawHot && !this.ignoreDrawBackground && bl5) {
            rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, true, false, n7);
            this.fillBackground(n7, n10, rECT);
        }
        if (!this.ignoreDrawHot || !this.ignoreDrawSelection && n13 != -1) {
            if (this.explorerTheme) {
                int n15;
                int n16;
                boolean bl10 = bl6;
                RECT rECT3 = new RECT();
                OS.SetRect(rECT3, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                RECT rECT4 = new RECT();
                OS.SetRect(rECT4, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                if ((this.style & 0x10000) != 0) {
                    n16 = OS.SendMessage(n3, 4608, 0, 0);
                    n15 = OS.SendMessage(n3, 4623, n16 - 1, 0);
                    RECT rECT5 = new RECT();
                    OS.SendMessage(n3, 4615, n15, rECT5);
                    OS.MapWindowPoints(n3, this.handle, rECT5, 2);
                    rECT4.left = 0;
                    rECT4.right = rECT5.right;
                    rECT3.left = rECT2.left;
                    rECT3.right += 2;
                } else {
                    rECT4.right += 2;
                    rECT3.right += 2;
                }
                n16 = OS.OpenThemeData(this.handle, Display.LISTVIEW);
                int n17 = n15 = bl3 ? 3 : 2;
                if (OS.GetFocus() != this.handle && bl3 && !bl10) {
                    n15 = 5;
                }
                OS.DrawThemeBackground(n16, n7, 1, n15, rECT4, rECT3);
                OS.CloseThemeData(n16);
            } else {
                boolean bl11 = (this.style & 0x10000) != 0 || !bl2;
                RECT rECT6 = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, bl11, false, n7);
                this.fillBackground(n7, n13, rECT6);
            }
        }
        if (this.ignoreDrawForeground) {
            rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, false, n7);
            OS.SaveDC(n7);
            OS.SelectClipRgn(n7, 0);
            OS.ExcludeClipRect(n7, rECT.left, rECT.top, rECT.right, rECT.bottom);
        }
    }

    Event sendMeasureItemEvent(TableItem tableItem, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = tableItem.cellFont != null ? tableItem.cellFont[n3] : -1;
        if (n5 == -1) {
            n5 = tableItem.font;
        }
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.hFont = n5;
        int n7 = OS.SaveDC(n4);
        GC gC = GC.win32_new(n4, gCData);
        RECT rECT = tableItem.getBounds(n2, n3, true, true, false, false, n4);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n3;
        event.x = rECT.left;
        event.y = rECT.top;
        event.width = rECT.right - rECT.left;
        event.height = rECT.bottom - rECT.top;
        this.sendEvent(41, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(n4, n7);
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            int n8;
            if (this.columnCount == 0 && event.x + event.width > (n8 = OS.SendMessage(this.handle, 4125, 0, 0))) {
                OS.SendMessage(this.handle, 4126, 0, event.x + event.width);
            }
            if (event.height > this.getItemHeight()) {
                this.setItemHeight(event.height);
            }
        }
        return event;
    }

    LRESULT sendMouseDownEvent(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        boolean bl2;
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n6 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n6 >> 16);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(n2, n3, this.handle, n4, n5, n6)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        OS.SetFocus(this.handle);
        if (((this.style & 4) != 0 || this.hooks(3) || this.hooks(4)) && lVHITTESTINFO.iItem == -1) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        boolean bl3 = false;
        int n8 = OS.SendMessage(this.handle, 4146, 0, 0);
        if (n8 == 1 && lVHITTESTINFO.iItem != -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 8;
            lVITEM.stateMask = 2;
            lVITEM.iItem = lVHITTESTINFO.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
            if ((lVITEM.state & 2) != 0) {
                bl3 = true;
            }
        }
        boolean bl4 = bl2 = (this.state & 0x8000) != 0 && this.hooks(29);
        if (!bl2) {
            n7 = 6;
            boolean bl5 = bl2 = lVHITTESTINFO.iItem == -1 || (lVHITTESTINFO.flags & n7) == 0;
        }
        if (!bl2) {
            display.runDragDrop = false;
        }
        n7 = this.callWindowProc(this.handle, n4, n5, n6, bl3);
        if (!bl2) {
            display.runDragDrop = true;
        }
        if (this.dragStarted || !bl2) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean bl6;
            int n9 = 6;
            boolean bl7 = bl6 = (lVHITTESTINFO.flags & n9) != 0;
            if (!bl6 && (this.style & 2) != 0) {
                boolean bl8 = bl6 = (lVHITTESTINFO.flags & 8) == 0;
            }
            if (bl6) {
                this.sendMouseEvent(4, n3, this.handle, n4, n5, n6);
            }
        }
        this.dragStarted = false;
        return new LRESULT(n7);
    }

    void sendPaintItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW) {
        int n2;
        Object object;
        int n3;
        int n4;
        int n5 = nMLVCUSTOMDRAW.hdc;
        GCData gCData = new GCData();
        gCData.device = this.display;
        int n6 = n4 = tableItem.cellFont != null ? tableItem.cellFont[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n4 == -1) {
            n4 = tableItem.font;
        }
        gCData.hFont = n4;
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = nMLVCUSTOMDRAW.dwItemSpec;
        int n7 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        boolean bl2 = n7 != 0 && (lVITEM.state & 2) != 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            boolean bl6 = bl5 = this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl2 && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle) {
                    bl3 = true;
                    gCData.foreground = this.selectionForeground != -1 ? this.selectionForeground : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl3 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(n5);
                    gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme && this.selectionForeground == -1) {
                    int n8 = n3 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                    if (n3 == -1) {
                        n3 = tableItem.foreground;
                    }
                    gCData.foreground = n3 != -1 ? n3 : this.getForegroundPixel();
                }
            } else {
                int n9;
                int n10 = n3 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n3 == -1) {
                    n3 = tableItem.foreground;
                }
                int n11 = n9 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n9 == -1) {
                    n9 = tableItem.background;
                }
                boolean bl7 = bl4 = n9 != -1;
                if (n9 == -1) {
                    object = this.findBackgroundControl();
                    if (object == null) {
                        object = this;
                    }
                    n9 = ((Control)object).getBackgroundPixel();
                }
                gCData.foreground = n3 != -1 ? n3 : OS.GetTextColor(n5);
                gCData.background = n9 != -1 ? n9 : OS.GetBkColor(n5);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
        }
        gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
        n3 = OS.SaveDC(n5);
        GC gC = GC.win32_new(n5, gCData);
        object = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, false, false, n5);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = nMLVCUSTOMDRAW.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1, 1) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n2 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
            event.detail |= 4;
        }
        if (bl5) {
            event.detail |= 0x20;
        }
        if (bl3) {
            event.detail |= 2;
        }
        if (bl4) {
            event.detail |= 8;
        }
        event.x = ((RECT)object).left;
        event.y = ((RECT)object).top;
        event.width = ((RECT)object).right - ((RECT)object).left;
        event.height = ((RECT)object).bottom - ((RECT)object).top;
        RECT rECT = tableItem.getBounds(nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, n5);
        int n12 = rECT.right - rECT.left;
        int n13 = rECT.bottom - rECT.top;
        gC.setClipping(rECT.left, rECT.top, n12, n13);
        this.sendEvent(42, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(n5, n3);
    }

    void setBackgroundImage(int n2) {
        super.setBackgroundImage(n2);
        if (!this.customDraw) {
            this.setBackgroundTransparent(n2 != 0);
        }
    }

    void setBackgroundPixel(int n2) {
        if (!this.customDraw) {
            int n3;
            if (this.findImageControl() != null) {
                return;
            }
            if (n2 == -1) {
                n2 = this.defaultBackground();
            }
            if ((n3 = OS.SendMessage(this.handle, 4096, 0, 0)) != n2) {
                OS.SendMessage(this.handle, 4097, 0, n2);
                OS.SendMessage(this.handle, 4134, 0, n2);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
            }
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setBackgroundTransparent(boolean bl2) {
        int n2 = OS.SendMessage(this.handle, 4096, 0, 0);
        if (bl2) {
            if (n2 != -1) {
                OS.SendMessage(this.handle, 4097, 0, -1);
                OS.SendMessage(this.handle, 4134, 0, -1);
                OS.InvalidateRect(this.handle, null, true);
                if (!this.explorerTheme && (this.style & 0x10000) != 0) {
                    int n3 = 32;
                    OS.SendMessage(this.handle, 4150, n3, 0);
                }
                if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed()) {
                    OS.SendMessage(this.handle, 4236, -1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        } else if (n2 == -1) {
            int n4;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setBackgroundPixel(control.getBackgroundPixel());
            }
            if (!(this.explorerTheme || (this.style & 0x10000) == 0 || this.hooks(40) || this.hooks(42))) {
                n4 = 32;
                OS.SendMessage(this.handle, 4150, n4, n4);
            }
            if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n4 = this.indexOf(this.sortColumn)) != -1) {
                OS.SendMessage(this.handle, 4236, n4, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    void setBounds(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this.setDeferResize(true);
        super.setBounds(n2, n3, n4, n5, n6, false);
        this.setDeferResize(false);
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        int n3 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, this.columnCount, nArray2);
        boolean bl2 = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n4 = 0;
        while (n4 < nArray.length) {
            n2 = nArray[n4];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (n2 != nArray2[n4]) {
                bl2 = true;
            }
            ++n4;
        }
        if (bl2) {
            RECT[] rECTArray = new RECT[this.columnCount];
            n2 = 0;
            while (n2 < this.columnCount) {
                rECTArray[n2] = new RECT();
                OS.SendMessage(n3, 4615, n2, rECTArray[n2]);
                ++n2;
            }
            OS.SendMessage(this.handle, 4154, nArray.length, nArray);
            OS.InvalidateRect(this.handle, null, true);
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            RECT rECT = new RECT();
            int n5 = 0;
            while (n5 < this.columnCount) {
                TableColumn tableColumn = tableColumnArray[n5];
                if (!tableColumn.isDisposed()) {
                    OS.SendMessage(n3, 4615, n5, rECT);
                    if (rECT.left != rECTArray[n5].left) {
                        tableColumn.updateToolTip(n5);
                        tableColumn.sendEvent(10);
                    }
                }
                ++n5;
            }
        }
    }

    void setCustomDraw(boolean bl2) {
        if (this.customDraw == bl2) {
            return;
        }
        if (!this.customDraw && bl2 && this.currentItem != null) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.customDraw = bl2;
    }

    void setDeferResize(boolean bl2) {
        if (bl2) {
            if (this.resizeCount++ == 0) {
                this.wasResized = false;
                if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && this.drawCount++ == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            }
        } else if (--this.resizeCount == 0) {
            if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && --this.drawCount == 0) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                if (OS.IsWinCE) {
                    int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
                    if (n2 != 0) {
                        OS.InvalidateRect(n2, null, true);
                    }
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int n3 = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n3);
                }
            }
            if (this.wasResized) {
                this.wasResized = false;
                this.setResizeChildren(false);
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
                this.setResizeChildren(true);
            }
        }
    }

    void setCheckboxImageList(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n10 = 4;
        int n11 = 0;
        if (OS.IsWinCE) {
            n11 |= 0;
        } else {
            n9 = OS.GetDC(this.handle);
            n8 = OS.GetDeviceCaps(n9, 12);
            n7 = OS.GetDeviceCaps(n9, 14);
            OS.ReleaseDC(this.handle, n9);
            n6 = n8 * n7;
            switch (n6) {
                case 4: {
                    n11 |= 4;
                    break;
                }
                case 8: {
                    n11 |= 8;
                    break;
                }
                case 16: {
                    n11 |= 0x10;
                    break;
                }
                case 24: {
                    n11 |= 0x18;
                    break;
                }
                case 32: {
                    n11 |= 0x20;
                    break;
                }
                default: {
                    n11 |= 0;
                }
            }
        }
        if ((this.style & 0x4000000) != 0) {
            n11 |= 0x2000;
        }
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            n11 |= 1;
        }
        n9 = OS.ImageList_Create(n2, n3, n11, n10, n10);
        n8 = OS.GetDC(this.handle);
        n7 = OS.CreateCompatibleDC(n8);
        n6 = OS.CreateCompatibleBitmap(n8, n2 * n10, n3);
        int n12 = OS.SelectObject(n7, n6);
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, n2 * n10, n3);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            n5 = control.getBackgroundPixel();
        } else {
            n5 = 0x20000FF;
            if ((n5 & 0xFFFFFF) == OS.GetSysColor(OS.COLOR_WINDOW)) {
                n5 = 0x200FF00;
            }
        }
        int n13 = OS.CreateSolidBrush(n5);
        OS.FillRect(n7, rECT, n13);
        OS.DeleteObject(n13);
        int n14 = OS.SelectObject(n8, this.defaultFont());
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n8, tEXTMETRIC);
        OS.SelectObject(n8, n14);
        int n15 = Math.min(tEXTMETRIC.tmHeight, n2);
        int n16 = Math.min(tEXTMETRIC.tmHeight, n3);
        int n17 = (n2 - n15) / 2;
        int n18 = (n3 - n16) / 2 + 1;
        OS.SetRect(rECT, n17, n18, n17 + n15, n18 + n16);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n4 = this.display.hButtonTheme();
            OS.DrawThemeBackground(n4, n7, 3, 1, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 5, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 1, rECT, null);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawThemeBackground(n4, n7, 3, 9, rECT, null);
        } else {
            OS.DrawFrameControl(n7, rECT, 4, 16384);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17408);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 16640);
            rECT.left += n2;
            rECT.right += n2;
            OS.DrawFrameControl(n7, rECT, 4, 17664);
        }
        OS.SelectObject(n7, n12);
        OS.DeleteDC(n7);
        OS.ReleaseDC(this.handle, n8);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            OS.ImageList_Add(n9, n6, 0);
        } else {
            OS.ImageList_AddMasked(n9, n6, n5);
        }
        OS.DeleteObject(n6);
        n4 = this.getTopIndex();
        if (bl2 && n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        int n19 = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, n9);
        if (n19 != 0) {
            OS.ImageList_Destroy(n19);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            int n20 = OS.SendMessage(this.handle, 4098, 1, 0);
            OS.SendMessage(this.handle, 4099, 1, n20);
        }
        if (bl2 && n4 != 0) {
            this.setTopIndex(n4);
            this.setRedraw(true);
        }
    }

    void setFocusIndex(int n2) {
        if (n2 < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 1;
        lVITEM.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n2, lVITEM);
        this.ignoreSelect = false;
        OS.SendMessage(this.handle, 4163, 0, n2);
    }

    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        int n3 = this.getTopIndex();
        if (n3 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight != -1) {
            n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 | 0x400);
        }
        super.setFont(font);
        if (this.itemHeight != -1) {
            n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 & 0xFFFFFBFF);
        }
        this.setScrollWidth(null, true);
        if (n3 != 0) {
            this.setTopIndex(n3);
            this.setRedraw(true);
        }
        n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        OS.InvalidateRect(n2, null, true);
    }

    void setForegroundPixel(int n2) {
        if (n2 == -1) {
            n2 = -16777216;
        }
        OS.SendMessage(this.handle, 4132, 0, n2);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setHeaderVisible(boolean bl2) {
        int n2;
        this.checkWidget();
        int n3 = OS.GetWindowLong(this.handle, -16);
        n3 &= 0xFFFFBFFF;
        if (!bl2) {
            n3 |= 0x4000;
        }
        int n4 = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, n3);
        int n5 = this.getTopIndex();
        if (n5 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (bl2 && ((n2 = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
            this.fixItemHeight(false);
        }
        this.setTopIndex(n4);
        if (n5 != 0) {
            this.setRedraw(true);
        }
        this.updateHeaderToolTips();
    }

    public void setItemCount(int n2) {
        boolean bl2;
        this.checkWidget();
        n2 = Math.max(0, n2);
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n2 == n3) {
            return;
        }
        this.setDeferResize(true);
        boolean bl3 = bl2 = (this.style & 0x10000000) != 0;
        if (!bl2) {
            this.setRedraw(false);
        }
        int n4 = n2;
        while (n4 < n3) {
            TableItem tableItem = this.items[n4];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            if (!bl2) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n5 = OS.SendMessage(this.handle, 4104, n2, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n5 == 0) break;
            }
            ++n4;
        }
        if (n4 < n3) {
            this.error(15);
        }
        int n6 = Math.max(4, (n2 + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n6];
        System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n2, n3));
        this.items = tableItemArray;
        if (bl2) {
            int n7 = 3;
            OS.SendMessage(this.handle, 4143, n2, n7);
            if (n2 == 0 && n3 != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            int n8 = n3;
            while (n8 < n2) {
                this.items[n8] = new TableItem(this, 0, n8, true);
                ++n8;
            }
        }
        if (!bl2) {
            this.setRedraw(true);
        }
        if (n3 == 0) {
            this.setScrollWidth(null, false);
        }
        this.setDeferResize(false);
    }

    void setItemHeight(boolean bl2) {
        int n2 = this.getTopIndex();
        if (bl2 && n2 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight == -1) {
            int n3 = OS.SendMessage(this.handle, 49, 0, 0);
            OS.SendMessage(this.handle, 48, n3, 0);
        } else {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n4 = rECT.right - rECT.left;
            int n5 = rECT.bottom - rECT.top;
            int n6 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n6 | 0x400);
            int n7 = 30;
            this.ignoreResize = true;
            this.SetWindowPos(this.handle, 0, 0, 0, n4, n5 + 1, n7);
            this.SetWindowPos(this.handle, 0, 0, 0, n4, n5, n7);
            this.ignoreResize = false;
            OS.SetWindowLong(this.handle, -16, n6);
        }
        if (bl2 && n2 != 0) {
            this.setTopIndex(n2);
            this.setRedraw(true);
        }
    }

    void setItemHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            this.error(5);
        }
        this.itemHeight = n2;
        this.setItemHeight(true);
        this.setScrollWidth(null, true);
    }

    public void setLinesVisible(boolean bl2) {
        int n2;
        this.checkWidget();
        int n3 = bl2 ? 1 : 0;
        OS.SendMessage(this.handle, 4150, 1, n3);
        if (bl2 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            this.fixItemHeight(true);
        }
    }

    public void setRedraw(boolean bl2) {
        int n2;
        this.checkWidget();
        if (this.drawCount == 0 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl2) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                this.setDeferResize(true);
                OS.SendMessage(this.handle, 11, 1, 0);
                n2 = OS.SendMessage(this.handle, 4127, 0, 0);
                if (n2 != 0) {
                    OS.SendMessage(n2, 11, 1, 0);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, false);
                    if (n2 != 0) {
                        OS.InvalidateRect(n2, null, false);
                    }
                } else {
                    int n3 = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n3);
                }
                this.setDeferResize(false);
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
            n2 = OS.SendMessage(this.handle, 4127, 0, 0);
            if (n2 != 0) {
                OS.SendMessage(n2, 11, 0, 0);
            }
        }
    }

    boolean setScrollWidth(TableItem tableItem, boolean bl2) {
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!(bl2 || this.drawCount == 0 && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        if (this.columnCount == 0) {
            int n2;
            int n3;
            int n4;
            Object object;
            Object object2;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = OS.SendMessage(this.handle, 4100, 0, 0);
            while (n7 < n8) {
                object2 = null;
                int n9 = -1;
                if (tableItem != null) {
                    object2 = tableItem.text;
                    n6 = Math.max(n6, tableItem.imageIndent);
                    if (tableItem.cellFont != null) {
                        n9 = tableItem.cellFont[0];
                    }
                    if (n9 == -1) {
                        n9 = tableItem.font;
                    }
                } else if (this.items[n7] != null) {
                    object = this.items[n7];
                    object2 = ((TableItem)object).text;
                    n6 = Math.max(n6, ((TableItem)object).imageIndent);
                    if (((TableItem)object).cellFont != null) {
                        n9 = ((TableItem)object).cellFont[0];
                    }
                    if (n9 == -1) {
                        n9 = ((TableItem)object).font;
                    }
                }
                if (object2 != null && ((String)object2).length() != 0) {
                    if (n9 != -1) {
                        int n10 = OS.GetDC(this.handle);
                        int n11 = OS.SelectObject(n10, n9);
                        n4 = 3104;
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), (String)object2, false);
                        RECT rECT = new RECT();
                        OS.DrawText(n10, tCHAR, tCHAR.length(), rECT, n4);
                        OS.SelectObject(n10, n11);
                        OS.ReleaseDC(this.handle, n10);
                        n5 = Math.max(n5, rECT.right - rECT.left);
                    } else {
                        object = new TCHAR(this.getCodePage(), (String)object2, true);
                        n5 = Math.max(n5, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, (TCHAR)object));
                    }
                }
                if (tableItem != null) break;
                ++n7;
            }
            if (n5 == 0) {
                object2 = new TCHAR(this.getCodePage(), " ", true);
                n5 = Math.max(n5, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, (TCHAR)object2));
            }
            if ((n3 = OS.SendMessage(this.handle, 4098, 2, 0)) != 0) {
                int[] nArray = new int[1];
                object = new int[1];
                OS.ImageList_GetIconSize(n3, nArray, (int[])object);
                n5 += nArray[0] + 4;
            }
            if ((n2 = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
                object = new int[1];
                int[] nArray = new int[1];
                OS.ImageList_GetIconSize(n2, (int[])object, nArray);
                n5 += (n6 + 1) * object[0];
            } else {
                ++n5;
            }
            n5 += 8;
            int n12 = OS.SendMessage(this.handle, 4125, 0, 0);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n5 += 2;
            }
            if (n5 > n12) {
                boolean bl3;
                boolean bl4 = bl3 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (bl3) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                OS.SendMessage(this.handle, 4126, 0, n5);
                if (bl3) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    if (OS.IsWinCE) {
                        n4 = OS.SendMessage(this.handle, 4127, 0, 0);
                        if (n4 != 0) {
                            OS.InvalidateRect(n4, null, true);
                        }
                        OS.InvalidateRect(this.handle, null, true);
                    } else {
                        n4 = 1157;
                        OS.RedrawWindow(this.handle, null, 0, n4);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray);
        int n3 = nArray[0];
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = tableItemArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = -1;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            int n5 = this.indexOf(tableItemArray[n4]);
            if (n5 != -1) {
                n3 = n5;
                this.select(n3);
            }
            --n4;
        }
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        this.select(n2);
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        this.select(n2, n3);
        this.setFocusIndex(n2);
        this.showSelection();
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int n2) {
        this.checkWidget();
        if ((n2 & 0x480) == 0 && n2 != 0) {
            return;
        }
        this.sortDirection = n2;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(n2);
        }
    }

    void setSubImagesVisible(boolean bl2) {
        int n2 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n2 & 2) != 0 == bl2) {
            return;
        }
        int n3 = bl2 ? 2 : 0;
        OS.SendMessage(this.handle, 4150, 2, n3);
    }

    void setTableEmpty() {
        if (this.imageList != null) {
            int n2 = OS.ImageList_Create(1, 1, 0, 0, 0);
            OS.SendMessage(this.handle, 4099, 1, n2);
            OS.SendMessage(this.handle, 4099, 1, 0);
            if (this.headerImageList != null) {
                int n3 = this.headerImageList.getHandle();
                int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
                OS.SendMessage(n4, 4616, 0, n3);
            }
            OS.ImageList_Destroy(n2);
            this.display.releaseImageList(this.imageList);
            this.imageList = null;
            if (this.itemHeight != -1) {
                this.setItemHeight(false);
            }
        }
        if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setCustomDraw(false);
                this.setBackgroundTransparent(false);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style &= 0xDFFFFFFF;
                }
            }
        }
        this.items = new TableItem[4];
        if (this.columnCount == 0) {
            OS.SendMessage(this.handle, 4126, 0, 0);
            this.setScrollWidth(null, false);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4135, 0, 0);
        if (n2 == n3) {
            return;
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, n2, 1);
            if (n2 != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n2, 1);
            }
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        this.ignoreCustomDraw = true;
        OS.SendMessage(this.handle, 4110, 0, rECT);
        this.ignoreCustomDraw = false;
        int n4 = (n2 - n3) * (rECT.bottom - rECT.top);
        OS.SendMessage(this.handle, 4116, 0, n4);
    }

    public void showColumn(TableColumn tableColumn) {
        int n2;
        int n3;
        Object object;
        int n4;
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n5 = this.indexOf(tableColumn);
        if (n5 < 0 || n5 >= this.columnCount) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        if (n5 == 0) {
            rECT.top = 1;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1, rECT);
            this.ignoreCustomDraw = false;
            rECT.right = rECT.left;
            n4 = OS.SendMessage(this.handle, 4125, 0, 0);
            rECT.left = rECT.right - n4;
        } else {
            rECT.top = n5;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1, rECT);
            this.ignoreCustomDraw = false;
        }
        n4 = 0;
        int n6 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n6 & 1) != 0) {
            object = new SCROLLINFO();
            ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
            ((SCROLLINFO)object).fMask = 4;
            OS.GetScrollInfo(this.handle, 0, (SCROLLINFO)object);
            n4 = ((SCROLLINFO)object).nPos;
        }
        object = new RECT();
        OS.GetClientRect(this.handle, (RECT)object);
        if (rECT.left < ((RECT)object).left) {
            n3 = rECT.left - ((RECT)object).left;
            OS.SendMessage(this.handle, 4116, n3, 0);
        } else {
            n3 = Math.min(((RECT)object).right - ((RECT)object).left, rECT.right - rECT.left);
            if (rECT.left + n3 > ((RECT)object).right) {
                n2 = rECT.left + n3 - ((RECT)object).right;
                OS.SendMessage(this.handle, 4116, n2, 0);
            }
        }
        if ((n6 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n2 = sCROLLINFO.nPos;
            if (n2 < n4) {
                ((RECT)object).right = n4 - n2 + 1;
                OS.InvalidateRect(this.handle, (RECT)object, true);
            }
        }
    }

    void showItem(int n2) {
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, n2, 1);
            if (n2 != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n2, 1);
            }
        } else {
            OS.SendMessage(this.handle, 4115, n2, 0);
        }
    }

    public void showItem(TableItem tableItem) {
        int n2;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.indexOf(tableItem)) != -1) {
            this.showItem(n2);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n2 != -1) {
            this.showItem(n2);
        }
    }

    void sort() {
        this.checkWidget();
    }

    void subclass() {
        super.subclass();
        if (HeaderProc != 0) {
            int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SetWindowLong(n2, -4, this.display.windowProc);
        }
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        int n2 = OS.SendMessage(this.handle, 4174, 0, 0);
        if (n2 == nMTTDISPINFO.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == nMTTDISPINFO.hwndFrom) {
            int n3 = 0;
            while (n3 < this.columnCount) {
                TableColumn tableColumn = this.columns[n3];
                if (tableColumn.id == nMTTDISPINFO.idFrom) {
                    return tableColumn.toolTipText;
                }
                ++n3;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    void unsubclass() {
        super.unsubclass();
        if (HeaderProc != 0) {
            int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
            OS.SetWindowLong(n2, -4, HeaderProc);
        }
    }

    void update(boolean bl2) {
        boolean bl3;
        int n2 = 0;
        int n3 = 0;
        int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
        boolean bl4 = bl3 = !this.hasChildren() && !this.hooks(9) && !this.filters(9);
        if (bl3) {
            n3 = OS.SetWindowLong(this.handle, -4, TableProc);
            n2 = OS.SetWindowLong(n4, -4, HeaderProc);
        }
        super.update(bl2);
        if (bl3) {
            OS.SetWindowLong(this.handle, -4, n3);
            OS.SetWindowLong(n4, -4, n2);
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rECT = new RECT();
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.uFlags = 16;
        tOOLINFO.hwnd = n2;
        tOOLINFO.lpszText = -1;
        int n3 = 0;
        while (n3 < this.columnCount) {
            TableColumn tableColumn = this.columns[n3];
            if (OS.SendMessage(n2, 4615, n3, rECT) != 0) {
                ++this.display.nextToolTipId;
                tOOLINFO.uId = tableColumn.id = tableColumn.id;
                tOOLINFO.left = rECT.left;
                tOOLINFO.top = rECT.top;
                tOOLINFO.right = rECT.right;
                tOOLINFO.bottom = rECT.bottom;
                OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
            ++n3;
        }
    }

    void updateImages() {
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && OS.COMCTL32_MAJOR < 6) {
            switch (this.sortDirection) {
                case 128: 
                case 1024: {
                    this.sortColumn.setImage(this.display.getSortImage(this.sortDirection), true, true);
                }
            }
        }
    }

    void updateMoveable() {
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].moveable) break;
            ++n2;
        }
        int n3 = n2 < this.columnCount ? 16 : 0;
        OS.SendMessage(this.handle, 4150, 16, n3);
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x40;
        if ((this.style & 0x8000) == 0) {
            n2 |= 8;
        }
        if ((this.style & 4) != 0) {
            n2 |= 4;
        }
        n2 |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            n2 |= 0x1000;
        }
        return n2;
    }

    TCHAR windowClass() {
        return TableClass;
    }

    int windowProc() {
        return TableProc;
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 != this.handle) {
            switch (n3) {
                case 533: {
                    int n6;
                    if (OS.COMCTL32_MAJOR >= 6 || n5 == 0 || n5 == (n6 = OS.SendMessage(this.handle, 4127, 0, 0))) break;
                    OS.InvalidateRect(n6, null, true);
                    break;
                }
                case 675: {
                    if (OS.COMCTL32_MAJOR >= 6) {
                        this.updateHeaderToolTips();
                    }
                    this.updateHeaderToolTips();
                    break;
                }
                case 78: {
                    NMHDR nMHDR = new NMHDR();
                    OS.MoveMemory(nMHDR, n5, NMHDR.sizeof);
                    switch (nMHDR.code) {
                        case -530: 
                        case -522: 
                        case -521: 
                        case -520: {
                            return OS.SendMessage(this.handle, n3, n4, n5);
                        }
                    }
                    break;
                }
                case 32: {
                    short s2;
                    if (n4 != n2 || (s2 = (short)(n5 & 0xFFFF)) != 1) break;
                    HDHITTESTINFO hDHITTESTINFO = new HDHITTESTINFO();
                    int n7 = OS.GetMessagePos();
                    POINT pOINT = new POINT();
                    pOINT.x = (short)(n7 & 0xFFFF);
                    pOINT.y = (short)(n7 >> 16);
                    OS.ScreenToClient(n2, pOINT);
                    hDHITTESTINFO.x = pOINT.x;
                    hDHITTESTINFO.y = pOINT.y;
                    int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
                    int n9 = OS.SendMessage(n8, 4614, 0, hDHITTESTINFO);
                    if (n9 < 0 || n9 >= this.columnCount || this.columns[n9].resizable || (hDHITTESTINFO.flags & 0xC) == 0) break;
                    OS.SetCursor(OS.LoadCursor(0, 32512));
                    return 1;
                }
            }
            return this.callWindowProc(n2, n3, n4, n5);
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                int n4;
                if ((this.style & 0x20) != 0 && (n4 = OS.SendMessage(this.handle, 4108, -1, 1)) != -1) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = this._getItem(n4)).getChecked(), true);
                    if (!OS.IsWinCE) {
                        OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
                    }
                }
                n4 = this.callWindowProc(this.handle, 256, n2, n3);
                return new LRESULT(n4);
            }
            case 13: {
                int n5 = OS.SendMessage(this.handle, 4108, -1, 1);
                if (n5 != -1) {
                    Event event = new Event();
                    event.item = this._getItem(n5);
                    this.postEvent(14, event);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_CONTEXTMENU(int n2, int n3) {
        if (!this.display.runDragDrop) {
            return LRESULT.ZERO;
        }
        return super.WM_CONTEXTMENU(n2, n3);
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if (OS.COMCTL32_MAJOR < 6 && (this.style & 0x20000000) != 0 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x10000) == 0) {
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETOBJECT(int n2, int n3) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n2, n3);
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                if (OS.GetKeyState(17) >= 0) break;
                int n4 = 0;
                while (n4 < this.columnCount) {
                    if (!this.columns[n4].getResizable()) break;
                    ++n4;
                }
                if (n4 == this.columnCount && !this.hooks(41)) break;
                TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                int n5 = 0;
                while (n5 < tableColumnArray.length) {
                    TableColumn tableColumn = tableColumnArray[n5];
                    if (!tableColumn.isDisposed() && tableColumn.getResizable()) {
                        tableColumn.pack();
                    }
                    ++n5;
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                int n6;
                boolean bl2;
                int n7 = 0;
                int n8 = 0;
                int n9 = OS.SendMessage(this.handle, 4127, 0, 0);
                boolean bl3 = bl2 = !this.hasChildren() && !this.hooks(9) && !this.filters(9);
                if (bl2) {
                    n8 = OS.SetWindowLong(this.handle, -4, TableProc);
                    n7 = OS.SetWindowLong(n9, -4, HeaderProc);
                }
                LRESULT lRESULT2 = lRESULT = (n6 = this.callWindowProc(this.handle, 256, n2, n3)) == 0 ? LRESULT.ZERO : new LRESULT(n6);
                if (bl2) {
                    OS.SetWindowLong(this.handle, -4, n8);
                    OS.SetWindowLong(n9, -4, n7);
                }
            }
            case 38: 
            case 40: {
                OS.SendMessage(this.handle, 295, 3, 0);
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n3 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n3 >> 16);
        int n4 = OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, this.handle, 513, n2, n3);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, n2, n3)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        if (lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 515, n2, n3);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 0x20) != 0 && n4 != -1 && lVHITTESTINFO.flags == 8) {
            TableItem tableItem;
            tableItem.setChecked(!(tableItem = this._getItem(n4)).getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = this.sendMouseDownEvent(3, 1, 513, n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0) {
            LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
            lVHITTESTINFO.x = (short)(n3 & 0xFFFF);
            lVHITTESTINFO.y = (short)(n3 >> 16);
            int n4 = OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
            if (n4 != -1 && lVHITTESTINFO.flags == 8) {
                TableItem tableItem;
                tableItem.setChecked(!(tableItem = this._getItem(n4)).getChecked(), true);
                if (!OS.IsWinCE) {
                    OS.NotifyWinEvent(32773, this.handle, -4, n4 + 1);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEHOVER(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_MOUSEHOVER(n2, n3);
        int n5 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n5 & (n4 = 200)) != 0) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PAINT(int n2, int n3) {
        int n4;
        if (!this.ignoreShrink) {
            n4 = OS.SendMessage(this.handle, 4100, 0, 0);
            if (this.items.length > 4 && this.items.length - n4 > 3) {
                int n5 = Math.max(4, (n4 + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n5];
                System.arraycopy(this.items, 0, tableItemArray, 0, n4);
                this.items = tableItemArray;
            }
        }
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        if (OS.COMCTL32_MAJOR < 6 && ((this.style & 0x20000000) != 0 || this.findImageControl() != null) && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 0x10000) == 0) {
            GC gC = null;
            int n6 = 0;
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            boolean bl2 = this.hooks(9);
            if (bl2) {
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                gC = GC.win32_new(this, gCData);
                n6 = gC.handle;
            } else {
                n6 = OS.BeginPaint(this.handle, pAINTSTRUCT);
            }
            int n7 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n8 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n7 != 0 && n8 != 0) {
                Object object;
                int n9 = OS.CreateCompatibleDC(n6);
                POINT pOINT = new POINT();
                POINT pOINT2 = new POINT();
                OS.SetWindowOrgEx(n9, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT);
                OS.SetBrushOrgEx(n9, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT2);
                int n10 = OS.CreateCompatibleBitmap(n6, n7, n8);
                int n11 = OS.SelectObject(n9, n10);
                if (OS.SendMessage(this.handle, 4096, 0, 0) != -1) {
                    object = new RECT();
                    OS.SetRect((RECT)object, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                    this.drawBackground(n9, (RECT)object);
                }
                this.callWindowProc(this.handle, 15, n9, 0);
                OS.SetWindowOrgEx(n9, pOINT.x, pOINT.y, null);
                OS.SetBrushOrgEx(n9, pOINT2.x, pOINT2.y, null);
                OS.BitBlt(n6, pAINTSTRUCT.left, pAINTSTRUCT.top, n7, n8, n9, 0, 0, 0xCC0020);
                OS.SelectObject(n9, n11);
                OS.DeleteObject(n10);
                OS.DeleteObject(n9);
                if (bl2) {
                    object = new Event();
                    ((Event)object).gc = gC;
                    ((Event)object).x = pAINTSTRUCT.left;
                    ((Event)object).y = pAINTSTRUCT.top;
                    ((Event)object).width = pAINTSTRUCT.right - pAINTSTRUCT.left;
                    ((Event)object).height = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                    this.sendEvent(9, (Event)object);
                    ((Event)object).gc = null;
                }
            }
            if (bl2) {
                gC.dispose();
            } else {
                OS.EndPaint(this.handle, pAINTSTRUCT);
            }
            return LRESULT.ZERO;
        }
        return super.WM_PAINT(n2, n3);
    }

    LRESULT WM_RBUTTONDBLCLK(int n2, int n3) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n3 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n3 >> 16);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, this.handle, 516, n2, n3);
        if (this.sendMouseEvent(8, 3, this.handle, 518, n2, n3) && lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 518, n2, n3);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_RBUTTONDOWN(int n2, int n3) {
        return this.sendMouseDownEvent(3, 3, 516, n2, n3);
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        if ((n4 = OS.SendMessage(this.handle, 4100, 0, 0)) == 0) {
            return lRESULT;
        }
        int n5 = OS.SendMessage(this.handle, 4108, -1, 1);
        if (n5 == -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 1;
            lVITEM.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0, lVITEM);
            this.ignoreSelect = false;
        }
        return lRESULT;
    }

    LRESULT WM_SETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
        OS.SendMessage(n4, 48, 0, n3);
        if (this.headerToolTipHandle != 0) {
            OS.SendMessage(this.headerToolTipHandle, 48, n2, n3);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            return null;
        }
        if (this.hooks(40) || this.hooks(42)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.resizeCount != 0) {
            this.wasResized = true;
            return null;
        }
        return super.WM_SIZE(n2, n3);
    }

    LRESULT WM_SYSCOLORCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.findBackgroundControl() == null) {
            this.setBackgroundPixel(this.defaultBackground());
        } else if ((this.style & 0x20) != 0) {
            this.fixCheckboxImageListColor(true);
        }
        return lRESULT;
    }

    LRESULT WM_HSCROLL(int n2, int n3) {
        boolean bl2;
        int n4 = 0;
        int n5 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n5 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n4 = sCROLLINFO.nPos;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = OS.SendMessage(this.handle, 4127, 0, 0);
        boolean bl3 = bl2 = !this.hasChildren() && !this.hooks(9) && !this.filters(9);
        if (bl2) {
            n7 = OS.SetWindowLong(this.handle, -4, TableProc);
            n6 = OS.SetWindowLong(n8, -4, HeaderProc);
        }
        LRESULT lRESULT = super.WM_HSCROLL(n2, n3);
        if (bl2) {
            OS.SetWindowLong(this.handle, -4, n7);
            OS.SetWindowLong(n8, -4, n6);
        }
        if ((n5 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            int n9 = sCROLLINFO.nPos;
            if (n9 < n4) {
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                rECT.right = n4 - n9 + 1;
                OS.InvalidateRect(this.handle, rECT, true);
            }
        }
        return lRESULT;
    }

    LRESULT WM_VSCROLL(int n2, int n3) {
        int n4;
        boolean bl2;
        int n5 = 0;
        int n6 = 0;
        int n7 = OS.SendMessage(this.handle, 4127, 0, 0);
        boolean bl3 = bl2 = !this.hasChildren() && !this.hooks(9) && !this.filters(9);
        if (bl2) {
            n6 = OS.SetWindowLong(this.handle, -4, TableProc);
            n5 = OS.SetWindowLong(n7, -4, HeaderProc);
        }
        LRESULT lRESULT = super.WM_VSCROLL(n2, n3);
        if (bl2) {
            OS.SetWindowLong(this.handle, -4, n6);
            OS.SetWindowLong(n7, -4, n5);
        }
        if (((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
            int n8 = n2 & 0xFFFF;
            switch (n8) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 0: 
                case 1: {
                    RECT rECT = new RECT();
                    OS.GetWindowRect(n7, rECT);
                    int n9 = rECT.bottom - rECT.top;
                    RECT rECT2 = new RECT();
                    OS.GetClientRect(this.handle, rECT2);
                    rECT2.top += n9;
                    int n10 = OS.SendMessage(this.handle, 4160, 0, 0);
                    int n11 = OS.SendMessage(this.handle, 4160, 1, 0);
                    int n12 = (n11 >> 16) - (n10 >> 16);
                    if (n8 == 1) {
                        rECT2.top = rECT2.bottom - n12 - 1;
                    } else {
                        rECT2.bottom = rECT2.top + n12 + 1;
                    }
                    OS.InvalidateRect(this.handle, rECT2, true);
                    break;
                }
                case 2: 
                case 3: {
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        }
        return lRESULT;
    }

    LRESULT wmMeasureChild(int n2, int n3) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n3, MEASUREITEMSTRUCT.sizeof);
        if (this.itemHeight == -1) {
            int n4 = OS.SendMessage(this.handle, 4160, 0, 0);
            int n5 = OS.SendMessage(this.handle, 4160, 1, 0);
            mEASUREITEMSTRUCT.itemHeight = (n5 >> 16) - (n4 >> 16);
        } else {
            mEASUREITEMSTRUCT.itemHeight = this.itemHeight;
        }
        OS.MoveMemory(n3, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        return null;
    }

    LRESULT wmNotify(NMHDR nMHDR, int n2, int n3) {
        Object object;
        int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (nMHDR.hwndFrom == n4) {
            block0 : switch (nMHDR.code) {
                case -326: 
                case -325: 
                case -306: 
                case -305: {
                    if (this.columnCount == 0) {
                        return LRESULT.ONE;
                    }
                    object = new NMHEADER();
                    OS.MoveMemory((NMHEADER)object, n3, NMHEADER.sizeof);
                    TableColumn tableColumn = this.columns[((NMHEADER)object).iItem];
                    if (tableColumn != null && !tableColumn.getResizable()) {
                        return LRESULT.ONE;
                    }
                    this.ignoreColumnMove = true;
                    switch (nMHDR.code) {
                        case -325: 
                        case -305: {
                            boolean bl2;
                            boolean bl3 = bl2 = ((NMHEADER)object).iItem == 0 && !this.firstColumnImage;
                            if (tableColumn == null || !bl2 && !this.hooks(41)) break block0;
                            tableColumn.pack();
                            return LRESULT.ONE;
                        }
                    }
                    break;
                }
                case -16: {
                    if (!this.ignoreColumnMove) {
                        int n5 = 0;
                        while (n5 < this.columnCount) {
                            TableColumn tableColumn = this.columns[n5];
                            tableColumn.updateToolTip(n5);
                            ++n5;
                        }
                    }
                    this.ignoreColumnMove = false;
                    break;
                }
                case -310: {
                    TableColumn tableColumn;
                    if (this.ignoreColumnMove) {
                        return LRESULT.ONE;
                    }
                    int n6 = OS.SendMessage(this.handle, 4151, 0, 0);
                    if ((n6 & 0x10) == 0) break;
                    if (this.columnCount == 0) {
                        return LRESULT.ONE;
                    }
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                    if (nMHEADER.iItem == -1 || (tableColumn = this.columns[nMHEADER.iItem]) == null || tableColumn.getMoveable()) break;
                    this.ignoreColumnMove = true;
                    return LRESULT.ONE;
                }
                case -311: {
                    int n7 = OS.SendMessage(this.handle, 4151, 0, 0);
                    if ((n7 & 0x10) == 0) break;
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                    if (nMHEADER.iItem == -1 || nMHEADER.pitem == 0) break;
                    HDITEM hDITEM = new HDITEM();
                    OS.MoveMemory(hDITEM, nMHEADER.pitem, HDITEM.sizeof);
                    if ((hDITEM.mask & 0x80) == 0 || hDITEM.iOrder == -1 || this.columnCount == 0) break;
                    int[] nArray = new int[this.columnCount];
                    OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
                    int n8 = 0;
                    while (n8 < nArray.length) {
                        if (nArray[n8] == nMHEADER.iItem) break;
                        ++n8;
                    }
                    if (n8 == nArray.length) {
                        n8 = 0;
                    }
                    if (n8 == hDITEM.iOrder) break;
                    int n9 = Math.min(n8, hDITEM.iOrder);
                    int n10 = Math.max(n8, hDITEM.iOrder);
                    this.ignoreColumnMove = false;
                    int n11 = n9;
                    while (n11 <= n10) {
                        TableColumn tableColumn = this.columns[nArray[n11]];
                        if (!tableColumn.isDisposed()) {
                            tableColumn.postEvent(10);
                        }
                        ++n11;
                    }
                    break;
                }
                case -321: 
                case -301: {
                    TableColumn tableColumn;
                    Object object2;
                    int n12;
                    int n13 = OS.SendMessage(this.handle, 4125, 0, 0);
                    if (this.lastWidth == 0 && n13 > 0 && ((n12 = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
                        object2 = new RECT();
                        OS.GetClientRect(this.handle, (RECT)object2);
                        ((RECT)object2).right = ((RECT)object2).left + n13;
                        OS.InvalidateRect(this.handle, (RECT)object2, true);
                    }
                    this.lastWidth = n13;
                    if (this.ignoreColumnResize) break;
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n3, NMHEADER.sizeof);
                    if (nMHEADER.pitem == 0) break;
                    object2 = new HDITEM();
                    OS.MoveMemory((HDITEM)object2, nMHEADER.pitem, HDITEM.sizeof);
                    if ((((HDITEM)object2).mask & 1) == 0 || (tableColumn = this.columns[nMHEADER.iItem]) == null) break;
                    tableColumn.updateToolTip(nMHEADER.iItem);
                    tableColumn.sendEvent(11);
                    if (this.isDisposed()) {
                        return LRESULT.ZERO;
                    }
                    TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                    System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                    int[] nArray = new int[this.columnCount];
                    OS.SendMessage(this.handle, 4155, this.columnCount, nArray);
                    boolean bl4 = false;
                    int n14 = 0;
                    while (n14 < this.columnCount) {
                        TableColumn tableColumn2 = tableColumnArray[nArray[n14]];
                        if (bl4 && !tableColumn2.isDisposed()) {
                            tableColumn2.updateToolTip(nArray[n14]);
                            tableColumn2.sendEvent(10);
                        }
                        if (tableColumn2 == tableColumn) {
                            bl4 = true;
                        }
                        ++n14;
                    }
                    break;
                }
                case -323: 
                case -303: {
                    object = new NMHEADER();
                    OS.MoveMemory((NMHEADER)object, n3, NMHEADER.sizeof);
                    TableColumn tableColumn = this.columns[((NMHEADER)object).iItem];
                    if (tableColumn == null) break;
                    tableColumn.postEvent(14);
                }
            }
        }
        if ((object = super.wmNotify(nMHDR, n2, n3)) != null) {
            return object;
        }
        switch (nMHDR.code) {
            case -530: 
            case -520: {
                this.tipRequested = true;
                int n15 = this.callWindowProc(this.handle, 78, n2, n3);
                this.tipRequested = false;
                return new LRESULT(n15);
            }
        }
        return object;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -179: 
            case -152: {
                if ((this.style & 0x10000000) == 0) break;
                return new LRESULT(-1);
            }
            case -115: {
                boolean bl2;
                if ((this.style & 0x10000000) == 0 || this.ignoreSelect) break;
                NMLVODSTATECHANGE nMLVODSTATECHANGE = new NMLVODSTATECHANGE();
                OS.MoveMemory(nMLVODSTATECHANGE, n3, NMLVODSTATECHANGE.sizeof);
                boolean bl3 = (nMLVODSTATECHANGE.uOldState & 2) != 0;
                boolean bl4 = bl2 = (nMLVODSTATECHANGE.uNewState & 2) != 0;
                if (bl3 == bl2) break;
                this.wasSelected = true;
                break;
            }
            case -177: 
            case -150: {
                Object[] objectArray;
                Object object;
                Object object2;
                NMLVDISPINFO nMLVDISPINFO = new NMLVDISPINFO();
                OS.MoveMemory(nMLVDISPINFO, n3, NMLVDISPINFO.sizeof);
                if ((this.style & 0x10000000) != 0 && this.ignoreShrink) {
                    OS.SendMessage(this.handle, 4117, nMLVDISPINFO.iItem, nMLVDISPINFO.iItem);
                    break;
                }
                TableItem tableItem = this._getItem(nMLVDISPINFO.iItem);
                if (tableItem == null) break;
                if (!tableItem.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        this.lastIndexOf = nMLVDISPINFO.iItem;
                        if (!this.checkData(tableItem, this.lastIndexOf, false)) break;
                        Object object3 = object2 = this.fixScrollWidth ? null : tableItem;
                        if (this.setScrollWidth((TableItem)object2, true)) {
                            OS.InvalidateRect(this.handle, null, true);
                        }
                    }
                    tableItem.cached = true;
                }
                if ((nMLVDISPINFO.mask & 1) != 0) {
                    object2 = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object2 = tableItem.text;
                    } else {
                        object = tableItem.strings;
                        if (object != null) {
                            object2 = object[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object2 != null) {
                        int n4 = Math.min(((String)object2).length(), nMLVDISPINFO.cchTextMax - 1);
                        if (!this.tipRequested && nMLVDISPINFO.iSubItem == 0 && n4 == 0) {
                            object2 = " ";
                            n4 = 1;
                        }
                        if ((objectArray = (Object[])this.display.tableBuffer) == null || nMLVDISPINFO.cchTextMax > objectArray.length) {
                            this.display.tableBuffer = new char[nMLVDISPINFO.cchTextMax];
                            objectArray = this.display.tableBuffer;
                        }
                        ((String)object2).getChars(0, n4, (char[])objectArray, 0);
                        objectArray[n4++] = (Image)false;
                        if (OS.IsUnicode) {
                            OS.MoveMemory(nMLVDISPINFO.pszText, (char[])objectArray, n4 * 2);
                        } else {
                            OS.WideCharToMultiByte(this.getCodePage(), 0, (char[])objectArray, n4, nMLVDISPINFO.pszText, nMLVDISPINFO.cchTextMax, null, null);
                            OS.MoveMemory(nMLVDISPINFO.pszText + nMLVDISPINFO.cchTextMax - 1, new byte[1], 1);
                        }
                    }
                }
                boolean bl5 = false;
                if ((nMLVDISPINFO.mask & 2) != 0) {
                    object = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object = tableItem.image;
                    } else {
                        objectArray = tableItem.images;
                        if (objectArray != null) {
                            object = objectArray[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object != null) {
                        nMLVDISPINFO.iImage = this.imageIndex((Image)object, nMLVDISPINFO.iSubItem);
                        bl5 = true;
                    }
                }
                if ((nMLVDISPINFO.mask & 8) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    int n5 = 1;
                    if (tableItem.checked) {
                        ++n5;
                    }
                    if (tableItem.grayed) {
                        n5 += 2;
                    }
                    nMLVDISPINFO.state = n5 << 12;
                    nMLVDISPINFO.stateMask = 61440;
                    bl5 = true;
                }
                if ((nMLVDISPINFO.mask & 0x10) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    nMLVDISPINFO.iIndent = tableItem.imageIndent;
                    bl5 = true;
                }
                if (!bl5) break;
                OS.MoveMemory(n3, nMLVDISPINFO, NMLVDISPINFO.sizeof);
                break;
            }
            case -12: {
                int n6 = OS.SendMessage(this.handle, 4127, 0, 0);
                if (nMHDR.hwndFrom == n6 || !this.customDraw && this.findImageControl() == null && OS.IsWindowEnabled(this.handle) && (!this.explorerTheme || this.columnCount != 0)) break;
                NMLVCUSTOMDRAW nMLVCUSTOMDRAW = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nMLVCUSTOMDRAW, n3, NMLVCUSTOMDRAW.sizeof);
                switch (nMLVCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 196609: {
                        return this.CDDS_SUBITEMPREPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 196610: {
                        return this.CDDS_SUBITEMPOSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(nMLVCUSTOMDRAW, n2, n3);
                    }
                }
                break;
            }
            case -156: {
                if ((this.style & 4) != 0) {
                    return LRESULT.ONE;
                }
                if (!this.hooks(3) && !this.hooks(4)) break;
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                this.dragStarted = true;
                if (nMHDR.code != -109) break;
                int n7 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                pOINT.x = (short)(n7 & 0xFFFF);
                pOINT.y = (short)(n7 >> 16);
                OS.ScreenToClient(this.handle, pOINT);
                this.sendDragEvent(1, pOINT.x, pOINT.y);
                break;
            }
            case -108: {
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                TableColumn tableColumn = this.columns[nMLISTVIEW.iSubItem];
                if (tableColumn == null) break;
                tableColumn.postEvent(13);
                break;
            }
            case -114: {
                if (this.ignoreActivate) break;
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(nMLISTVIEW.iItem);
                this.postEvent(14, event);
                break;
            }
            case -101: {
                int n8;
                int n9;
                if (!this.ignoreSelect) {
                    NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                    OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                    if ((nMLISTVIEW.uChanged & 8) != 0) {
                        if (nMLISTVIEW.iItem == -1) {
                            this.wasSelected = true;
                        } else {
                            int n10;
                            n9 = (nMLISTVIEW.uOldState & 2) != 0 ? 1 : 0;
                            int n11 = n10 = (nMLISTVIEW.uNewState & 2) != 0 ? 1 : 0;
                            if (n9 != n10) {
                                this.wasSelected = true;
                            }
                        }
                    }
                }
                if (!this.hooks(40) && !this.hooks(42) || (n9 = OS.SendMessage(n8 = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 0) break;
                this.forceResize();
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n3, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                RECT rECT2 = new RECT();
                rECT2.left = 0;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, 4110, nMLISTVIEW.iItem, rECT2);
                this.ignoreCustomDraw = false;
                RECT rECT3 = new RECT();
                int n12 = OS.SendMessage(n8, 4623, n9 - 1, 0);
                OS.SendMessage(n8, 4615, n12, rECT3);
                OS.MapWindowPoints(n8, this.handle, rECT3, 2);
                rECT.left = rECT3.right;
                rECT.top = rECT2.top;
                rECT.bottom = rECT2.bottom;
                OS.InvalidateRect(this.handle, rECT, true);
                break;
            }
            case -16: {
                boolean bl6;
                if (!OS.IsPPC) break;
                boolean bl7 = bl6 = this.menu != null && !this.menu.isDisposed();
                if (bl6 || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean bl8;
                if (!OS.IsPPC) break;
                boolean bl9 = bl8 = this.menu != null && !this.menu.isDisposed();
                if (!bl8 && !this.hooks(35)) break;
                NMRGINFO nMRGINFO = new NMRGINFO();
                OS.MoveMemory(nMRGINFO, n3, NMRGINFO.sizeof);
                this.showMenu(nMRGINFO.x, nMRGINFO.y);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }
}

