/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.b;
import org.objectweb.asm.f;
import org.objectweb.asm.tree.MethodNode;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n2, int n3) {
        this.b = byArray;
        this.items = new int[this.readUnsignedShort(n2 + 8)];
        int n4 = this.items.length;
        this.strings = new String[n4];
        int n5 = 0;
        int n6 = n2 + 10;
        for (int i2 = 1; i2 < n4; ++i2) {
            int n7;
            block7: {
                int n8;
                this.items[i2] = n6 + 1;
                switch (byArray[n6]) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n8 = 5;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n7 = 9;
                        ++i2;
                        break block7;
                    }
                    case 1: {
                        n7 = 3 + this.readUnsignedShort(n6 + 1);
                        if (n7 > n5) {
                            n5 = n7;
                        }
                        break block7;
                    }
                    default: {
                        n8 = 3;
                    }
                }
                n7 = n8;
            }
            n6 += n7;
        }
        this.maxStringLength = n5;
        this.header = n6;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        int n2 = this.items[this.readUnsignedShort(this.header + 4)];
        if (n2 == 0) {
            return null;
        }
        return this.readUTF8(n2, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int n2 = this.header + 6;
        int n3 = this.readUnsignedShort(n2);
        String[] stringArray = new String[n3];
        if (n3 > 0) {
            char[] cArray = new char[this.maxStringLength];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = this.readClass(n2 += 2, cArray);
            }
        }
        return stringArray;
    }

    void copyPool(ClassWriter classWriter) {
        int n2;
        char[] cArray = new char[this.maxStringLength];
        int n3 = this.items.length;
        b[] bArray = new b[n3];
        for (n2 = 1; n2 < n3; ++n2) {
            b b2;
            block12: {
                String string;
                String string2;
                String string3;
                byte by2;
                b b3;
                block11: {
                    block13: {
                        int n4 = this.items[n2];
                        byte by3 = this.b[n4 - 1];
                        b2 = new b(n2);
                        switch (by3) {
                            case 9: 
                            case 10: 
                            case 11: {
                                int n5 = this.items[this.readUnsignedShort(n4 + 2)];
                                b3 = b2;
                                by2 = by3;
                                string3 = this.readClass(n4, cArray);
                                string2 = this.readUTF8(n5, cArray);
                                string = this.readUTF8(n5 + 2, cArray);
                                break block11;
                            }
                            case 3: {
                                b2.a(this.readInt(n4));
                                break block12;
                            }
                            case 4: {
                                b2.a(Float.intBitsToFloat(this.readInt(n4)));
                                break block12;
                            }
                            case 12: {
                                b3 = b2;
                                by2 = by3;
                                string3 = this.readUTF8(n4, cArray);
                                string2 = this.readUTF8(n4 + 2, cArray);
                                break block13;
                            }
                            case 5: {
                                b2.a(this.readLong(n4));
                                ++n2;
                                break block12;
                            }
                            case 6: {
                                b2.a(Double.longBitsToDouble(this.readLong(n4)));
                                ++n2;
                                break block12;
                            }
                            case 1: {
                                String string4 = this.strings[n2];
                                if (string4 == null) {
                                    n4 = this.items[n2];
                                    string4 = this.strings[n2] = this.readUTF(n4 + 2, this.readUnsignedShort(n4), cArray);
                                }
                                b3 = b2;
                                by2 = by3;
                                string3 = string4;
                                break;
                            }
                            default: {
                                b3 = b2;
                                by2 = by3;
                                string3 = this.readUTF8(n4, cArray);
                            }
                        }
                        string2 = null;
                    }
                    string = null;
                }
                b3.a(by2, string3, string2, string);
            }
            int n6 = b2.d % bArray.length;
            b2.a = bArray[n6];
            bArray[n6] = b2;
        }
        n2 = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, n2, this.header - n2);
        classWriter.items = bArray;
        classWriter.threshold = (int)(0.75 * (double)n3);
        classWriter.index = n3;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream));
    }

    public ClassReader(String string) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        byte[] byArray = new byte[inputStream.available()];
        int n2 = 0;
        while (true) {
            byte[] byArray2;
            int n3;
            if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) == -1) {
                if (n2 < byArray.length) {
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    byArray = byArray2;
                }
                return byArray;
            }
            if ((n2 += n3) != byArray.length) continue;
            byArray2 = new byte[byArray.length + 1000];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
    }

    public void accept(ClassVisitor classVisitor, int n2) {
        this.accept(classVisitor, new Attribute[0], n2);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, int n2) {
        int n3;
        String string;
        Attribute attribute;
        int n4;
        String string2;
        int n5;
        int n6;
        byte[] byArray = this.b;
        char[] cArray = new char[this.maxStringLength];
        int n7 = 0;
        int n8 = 0;
        Attribute attribute2 = null;
        int n9 = this.header;
        int n10 = this.readUnsignedShort(n9);
        String string3 = this.readClass(n9 + 2, cArray);
        int n11 = this.items[this.readUnsignedShort(n9 + 4)];
        String string4 = n11 == 0 ? null : this.readUTF8(n11, cArray);
        String[] stringArray = new String[this.readUnsignedShort(n9 + 6)];
        int n12 = 0;
        n9 += 8;
        for (n6 = 0; n6 < stringArray.length; ++n6) {
            stringArray[n6] = this.readClass(n9, cArray);
            n9 += 2;
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 8) != 0;
        n11 = n9;
        n6 = this.readUnsignedShort(n11);
        n11 += 2;
        while (n6 > 0) {
            n5 = this.readUnsignedShort(n11 + 6);
            n11 += 8;
            while (n5 > 0) {
                n11 += 6 + this.readInt(n11 + 2);
                --n5;
            }
            --n6;
        }
        n6 = this.readUnsignedShort(n11);
        n11 += 2;
        while (n6 > 0) {
            n5 = this.readUnsignedShort(n11 + 6);
            n11 += 8;
            while (n5 > 0) {
                n11 += 6 + this.readInt(n11 + 2);
                --n5;
            }
            --n6;
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        n6 = this.readUnsignedShort(n11);
        n11 += 2;
        while (n6 > 0) {
            string2 = this.readUTF8(n11, cArray);
            if (string2.equals("SourceFile")) {
                string6 = this.readUTF8(n11 + 6, cArray);
            } else if (string2.equals("InnerClasses")) {
                n12 = n11 + 6;
            } else if (string2.equals("EnclosingMethod")) {
                string8 = this.readClass(n11 + 6, cArray);
                n4 = this.readUnsignedShort(n11 + 8);
                if (n4 != 0) {
                    string9 = this.readUTF8(this.items[n4], cArray);
                    string10 = this.readUTF8(this.items[n4] + 2, cArray);
                }
            } else if (string2.equals("Signature")) {
                string5 = this.readUTF8(n11 + 6, cArray);
            } else if (string2.equals("RuntimeVisibleAnnotations")) {
                n7 = n11 + 6;
            } else if (string2.equals("Deprecated")) {
                n10 |= 0x20000;
            } else if (string2.equals("Synthetic")) {
                n10 |= 0x1000;
            } else if (string2.equals("SourceDebugExtension")) {
                n4 = this.readInt(n11 + 2);
                string7 = this.readUTF(n11 + 6, n4, new char[n4]);
            } else if (string2.equals("RuntimeInvisibleAnnotations")) {
                n8 = n11 + 6;
            } else {
                attribute = this.readAttribute(attributeArray, string2, n11 + 6, this.readInt(n11 + 2), cArray, -1, null);
                if (attribute != null) {
                    attribute.next = attribute2;
                    attribute2 = attribute;
                }
            }
            n11 += 6 + this.readInt(n11 + 2);
            --n6;
        }
        classVisitor.visit(this.readInt(4), n10, string3, string5, string4, stringArray);
        if (!(bl3 || string6 == null && string7 == null)) {
            classVisitor.visitSource(string6, string7);
        }
        if (string8 != null) {
            classVisitor.visitOuterClass(string8, string9, string10);
        }
        for (n6 = 1; n6 >= 0; --n6) {
            n11 = n6 == 0 ? n8 : n7;
            if (n11 == 0) continue;
            n5 = this.readUnsignedShort(n11);
            n11 += 2;
            while (n5 > 0) {
                n11 = this.readAnnotationValues(n11 + 2, cArray, true, classVisitor.visitAnnotation(this.readUTF8(n11, cArray), n6 != 0));
                --n5;
            }
        }
        while (attribute2 != null) {
            attribute = attribute2.next;
            attribute2.next = null;
            classVisitor.visitAttribute(attribute2);
            attribute2 = attribute;
        }
        if (n12 != 0) {
            n6 = this.readUnsignedShort(n12);
            n12 += 2;
            while (n6 > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(n12) == 0 ? null : this.readClass(n12, cArray), this.readUnsignedShort(n12 + 2) == 0 ? null : this.readClass(n12 + 2, cArray), this.readUnsignedShort(n12 + 4) == 0 ? null : this.readUTF8(n12 + 4, cArray), this.readUnsignedShort(n12 + 6));
                n12 += 8;
                --n6;
            }
        }
        n6 = this.readUnsignedShort(n9);
        n9 += 2;
        while (n6 > 0) {
            n10 = this.readUnsignedShort(n9);
            string3 = this.readUTF8(n9 + 2, cArray);
            string = this.readUTF8(n9 + 4, cArray);
            n4 = 0;
            string5 = null;
            n7 = 0;
            n8 = 0;
            attribute2 = null;
            n5 = this.readUnsignedShort(n9 + 6);
            n9 += 8;
            while (n5 > 0) {
                string2 = this.readUTF8(n9, cArray);
                if (string2.equals("ConstantValue")) {
                    n4 = this.readUnsignedShort(n9 + 6);
                } else if (string2.equals("Signature")) {
                    string5 = this.readUTF8(n9 + 6, cArray);
                } else if (string2.equals("Deprecated")) {
                    n10 |= 0x20000;
                } else if (string2.equals("Synthetic")) {
                    n10 |= 0x1000;
                } else if (string2.equals("RuntimeVisibleAnnotations")) {
                    n7 = n9 + 6;
                } else if (string2.equals("RuntimeInvisibleAnnotations")) {
                    n8 = n9 + 6;
                } else {
                    attribute = this.readAttribute(attributeArray, string2, n9 + 6, this.readInt(n9 + 2), cArray, -1, null);
                    if (attribute != null) {
                        attribute.next = attribute2;
                        attribute2 = attribute;
                    }
                }
                n9 += 6 + this.readInt(n9 + 2);
                --n5;
            }
            FieldVisitor fieldVisitor = classVisitor.visitField(n10, string3, string, string5, n4 == 0 ? null : this.readConst(n4, cArray));
            if (fieldVisitor != null) {
                for (n5 = 1; n5 >= 0; --n5) {
                    n11 = n5 == 0 ? n8 : n7;
                    if (n11 == 0) continue;
                    n3 = this.readUnsignedShort(n11);
                    n11 += 2;
                    while (n3 > 0) {
                        n11 = this.readAnnotationValues(n11 + 2, cArray, true, fieldVisitor.visitAnnotation(this.readUTF8(n11, cArray), n5 != 0));
                        --n3;
                    }
                }
                while (attribute2 != null) {
                    attribute = attribute2.next;
                    attribute2.next = null;
                    fieldVisitor.visitAttribute(attribute2);
                    attribute2 = attribute;
                }
                fieldVisitor.visitEnd();
            }
            --n6;
        }
        n6 = this.readUnsignedShort(n9);
        n9 += 2;
        while (n6 > 0) {
            block224: {
                MethodVisitor methodVisitor;
                block225: {
                    Object object;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    block222: {
                        Object object2;
                        int n19;
                        int n20;
                        int n21;
                        block223: {
                            String[] stringArray2;
                            n4 = n9 + 6;
                            n10 = this.readUnsignedShort(n9);
                            string3 = this.readUTF8(n9 + 2, cArray);
                            string = this.readUTF8(n9 + 4, cArray);
                            string5 = null;
                            n7 = 0;
                            n8 = 0;
                            n21 = 0;
                            n20 = 0;
                            n19 = 0;
                            attribute2 = null;
                            n11 = 0;
                            n12 = 0;
                            n5 = this.readUnsignedShort(n9 + 6);
                            n9 += 8;
                            while (n5 > 0) {
                                string2 = this.readUTF8(n9, cArray);
                                int n22 = this.readInt(n9 + 2);
                                n9 += 6;
                                if (string2.equals("Code")) {
                                    if (!bl2) {
                                        n11 = n9;
                                    }
                                } else if (string2.equals("Exceptions")) {
                                    n12 = n9;
                                } else if (string2.equals("Signature")) {
                                    string5 = this.readUTF8(n9, cArray);
                                } else if (string2.equals("Deprecated")) {
                                    n10 |= 0x20000;
                                } else if (string2.equals("RuntimeVisibleAnnotations")) {
                                    n7 = n9;
                                } else if (string2.equals("AnnotationDefault")) {
                                    n21 = n9;
                                } else if (string2.equals("Synthetic")) {
                                    n10 |= 0x1000;
                                } else if (string2.equals("RuntimeInvisibleAnnotations")) {
                                    n8 = n9;
                                } else if (string2.equals("RuntimeVisibleParameterAnnotations")) {
                                    n20 = n9;
                                } else if (string2.equals("RuntimeInvisibleParameterAnnotations")) {
                                    n19 = n9;
                                } else {
                                    attribute = this.readAttribute(attributeArray, string2, n9, n22, cArray, -1, null);
                                    if (attribute != null) {
                                        attribute.next = attribute2;
                                        attribute2 = attribute;
                                    }
                                }
                                n9 += n22;
                                --n5;
                            }
                            if (n12 == 0) {
                                stringArray2 = null;
                            } else {
                                stringArray2 = new String[this.readUnsignedShort(n12)];
                                n12 += 2;
                                for (n5 = 0; n5 < stringArray2.length; ++n5) {
                                    stringArray2[n5] = this.readClass(n12, cArray);
                                    n12 += 2;
                                }
                            }
                            methodVisitor = classVisitor.visitMethod(n10, string3, string, string5, stringArray2);
                            if (methodVisitor == null) break block222;
                            if (!(methodVisitor instanceof f)) break block223;
                            object2 = (f)methodVisitor;
                            if (((f)object2).a.cr != this || string5 != ((f)object2).a) break block223;
                            n18 = 0;
                            if (stringArray2 == null) {
                                n18 = ((f)object2).c == 0 ? 1 : 0;
                            } else if (stringArray2.length == ((f)object2).c) {
                                n18 = 1;
                                for (n5 = stringArray2.length - 1; n5 >= 0; --n5) {
                                    if (((f)object2).a[n5] == this.readUnsignedShort(n12 -= 2)) continue;
                                    n18 = 0;
                                    break;
                                }
                            }
                            if (n18 == 0) break block223;
                            ((f)object2).a = n4;
                            ((f)object2).b = n9 - n4;
                            break block224;
                        }
                        if (n21 != 0) {
                            object2 = methodVisitor.visitAnnotationDefault();
                            this.readAnnotationValue(n21, cArray, null, (AnnotationVisitor)object2);
                            if (object2 != null) {
                                object2.visitEnd();
                            }
                        }
                        for (n5 = 1; n5 >= 0; --n5) {
                            n12 = n5 == 0 ? n8 : n7;
                            if (n12 == 0) continue;
                            n3 = this.readUnsignedShort(n12);
                            n12 += 2;
                            while (n3 > 0) {
                                n12 = this.readAnnotationValues(n12 + 2, cArray, true, methodVisitor.visitAnnotation(this.readUTF8(n12, cArray), n5 != 0));
                                --n3;
                            }
                        }
                        if (n20 != 0) {
                            this.readParameterAnnotations(n20, cArray, true, methodVisitor);
                        }
                        if (n19 != 0) {
                            this.readParameterAnnotations(n19, cArray, false, methodVisitor);
                        }
                        while (attribute2 != null) {
                            attribute = attribute2.next;
                            attribute2.next = null;
                            methodVisitor.visitAttribute(attribute2);
                            attribute2 = attribute;
                        }
                    }
                    if (methodVisitor == null || n11 == 0) break block225;
                    int n23 = this.readUnsignedShort(n11);
                    n18 = this.readUnsignedShort(n11 + 2);
                    int n24 = this.readInt(n11 + 4);
                    int n25 = n11 += 8;
                    int n26 = n11 + n24;
                    methodVisitor.visitCode();
                    if (methodVisitor instanceof MethodNode) {
                        ((MethodNode)methodVisitor).codeLength = n24;
                    }
                    Label[] labelArray = new Label[n24 + 1];
                    block58: while (n11 < n26) {
                        n17 = byArray[n11] & 0xFF;
                        switch (ClassWriter.TYPE[n17]) {
                            case 0: 
                            case 4: {
                                ++n11;
                                continue block58;
                            }
                            case 8: {
                                n16 = n11 - n25 + this.readShort(n11 + 1);
                                if (labelArray[n16] == null) {
                                    labelArray[n16] = new Label();
                                }
                                n11 += 3;
                                continue block58;
                            }
                            case 9: {
                                n16 = n11 - n25 + this.readInt(n11 + 1);
                                if (labelArray[n16] == null) {
                                    labelArray[n16] = new Label();
                                }
                                n11 += 5;
                                continue block58;
                            }
                            case 16: {
                                n17 = byArray[n11 + 1] & 0xFF;
                                if (n17 == 132) {
                                    n11 += 6;
                                    continue block58;
                                }
                                n11 += 4;
                                continue block58;
                            }
                            case 13: {
                                n12 = n11 - n25;
                                n11 = n11 + 4 - (n12 & 3);
                                n16 = n12 + this.readInt(n11);
                                if (labelArray[n16] == null) {
                                    labelArray[n16] = new Label();
                                }
                                n5 = this.readInt(n11 + 8) - this.readInt(n11 + 4) + 1;
                                n11 += 12;
                                while (n5 > 0) {
                                    n16 = n12 + this.readInt(n11);
                                    n11 += 4;
                                    if (labelArray[n16] == null) {
                                        labelArray[n16] = new Label();
                                    }
                                    --n5;
                                }
                                continue block58;
                            }
                            case 14: {
                                n12 = n11 - n25;
                                n11 = n11 + 4 - (n12 & 3);
                                n16 = n12 + this.readInt(n11);
                                if (labelArray[n16] == null) {
                                    labelArray[n16] = new Label();
                                }
                                n5 = this.readInt(n11 + 4);
                                n11 += 8;
                                while (n5 > 0) {
                                    n16 = n12 + this.readInt(n11 + 4);
                                    n11 += 8;
                                    if (labelArray[n16] == null) {
                                        labelArray[n16] = new Label();
                                    }
                                    --n5;
                                }
                                continue block58;
                            }
                            case 1: 
                            case 3: 
                            case 10: {
                                n11 += 2;
                                continue block58;
                            }
                            case 2: 
                            case 5: 
                            case 6: 
                            case 11: 
                            case 12: {
                                n11 += 3;
                                continue block58;
                            }
                            case 7: {
                                n11 += 5;
                                continue block58;
                            }
                        }
                        n11 += 4;
                    }
                    n5 = this.readUnsignedShort(n11);
                    n11 += 2;
                    while (n5 > 0) {
                        String string11;
                        Label label;
                        Label label2;
                        Label label3;
                        MethodVisitor methodVisitor2;
                        Label label4;
                        Label label5;
                        n16 = this.readUnsignedShort(n11);
                        Label label6 = labelArray[n16];
                        if (label6 == null) {
                            labelArray[n16] = label6 = new Label();
                        }
                        if ((label5 = labelArray[n16 = this.readUnsignedShort(n11 + 2)]) == null) {
                            labelArray[n16] = label5 = new Label();
                        }
                        if ((label4 = labelArray[n16 = this.readUnsignedShort(n11 + 4)]) == null) {
                            labelArray[n16] = label4 = new Label();
                        }
                        if ((n15 = this.readUnsignedShort(n11 + 6)) == 0) {
                            methodVisitor2 = methodVisitor;
                            label3 = label6;
                            label2 = label5;
                            label = label4;
                            string11 = null;
                        } else {
                            methodVisitor2 = methodVisitor;
                            label3 = label6;
                            label2 = label5;
                            label = label4;
                            string11 = this.readUTF8(this.items[n15], cArray);
                        }
                        methodVisitor2.visitTryCatchBlock(label3, label2, label, string11);
                        n11 += 8;
                        --n5;
                    }
                    n17 = 0;
                    int n27 = 0;
                    int n28 = 0;
                    n15 = 0;
                    int n29 = 0;
                    int n30 = 0;
                    int n31 = 0;
                    int n32 = 0;
                    int n33 = 0;
                    Object[] objectArray = null;
                    Object[] objectArray2 = null;
                    boolean bl5 = true;
                    attribute2 = null;
                    n5 = this.readUnsignedShort(n11);
                    n11 += 2;
                    while (n5 > 0) {
                        string2 = this.readUTF8(n11, cArray);
                        if (string2.equals("LocalVariableTable")) {
                            if (!bl3) {
                                n17 = n11 + 6;
                                n12 = n11 + 8;
                                for (n3 = this.readUnsignedShort(n11 + 6); n3 > 0; --n3) {
                                    n16 = this.readUnsignedShort(n12);
                                    if (labelArray[n16] == null) {
                                        labelArray[n16] = new Label(true);
                                    }
                                    if (labelArray[n16 += this.readUnsignedShort(n12 + 2)] == null) {
                                        labelArray[n16] = new Label(true);
                                    }
                                    n12 += 10;
                                }
                            }
                        } else if (string2.equals("LocalVariableTypeTable")) {
                            n27 = n11 + 6;
                        } else if (string2.equals("LineNumberTable")) {
                            if (!bl3) {
                                n12 = n11 + 8;
                                for (n3 = this.readUnsignedShort(n11 + 6); n3 > 0; --n3) {
                                    n16 = this.readUnsignedShort(n12);
                                    if (labelArray[n16] == null) {
                                        labelArray[n16] = new Label(true);
                                    }
                                    labelArray[n16].line = this.readUnsignedShort(n12 + 2);
                                    n12 += 4;
                                }
                            }
                        } else if (string2.equals("StackMapTable")) {
                            if ((n2 & 4) == 0) {
                                n28 = n11 + 8;
                                n15 = this.readUnsignedShort(n11 + 6);
                            }
                        } else if (string2.equals("StackMap")) {
                            if ((n2 & 4) == 0) {
                                n28 = n11 + 8;
                                n15 = this.readUnsignedShort(n11 + 6);
                                bl5 = false;
                            }
                        } else {
                            for (n3 = 0; n3 < attributeArray.length; ++n3) {
                                if (!attributeArray[n3].type.equals(string2) || (attribute = attributeArray[n3].read(this, n11 + 6, this.readInt(n11 + 2), cArray, n25 - 8, labelArray)) == null) continue;
                                attribute.next = attribute2;
                                attribute2 = attribute;
                            }
                        }
                        n11 += 6 + this.readInt(n11 + 2);
                        --n5;
                    }
                    if (n28 != 0) {
                        objectArray = new Object[n18];
                        objectArray2 = new Object[n23];
                        if (bl4) {
                            int n34 = 0;
                            if ((n10 & 8) == 0) {
                                Object object3;
                                int n35;
                                Object[] objectArray3;
                                if (string3.equals("<init>")) {
                                    objectArray3 = objectArray;
                                    n35 = 0;
                                    ++n34;
                                    object3 = Opcodes.UNINITIALIZED_THIS;
                                } else {
                                    objectArray3 = objectArray;
                                    n35 = 0;
                                    ++n34;
                                    object3 = this.readClass(this.header + 2, cArray);
                                }
                                objectArray3[n35] = object3;
                            }
                            n5 = 1;
                            block66: while (true) {
                                n3 = n5;
                                switch (string.charAt(n5++)) {
                                    case 'B': 
                                    case 'C': 
                                    case 'I': 
                                    case 'S': 
                                    case 'Z': {
                                        objectArray[n34++] = Opcodes.INTEGER;
                                        continue block66;
                                    }
                                    case 'F': {
                                        objectArray[n34++] = Opcodes.FLOAT;
                                        continue block66;
                                    }
                                    case 'J': {
                                        objectArray[n34++] = Opcodes.LONG;
                                        continue block66;
                                    }
                                    case 'D': {
                                        objectArray[n34++] = Opcodes.DOUBLE;
                                        continue block66;
                                    }
                                    case '[': {
                                        while (string.charAt(n5) == '[') {
                                            ++n5;
                                        }
                                        if (string.charAt(n5) == 'L') {
                                            while (string.charAt(++n5) != ';') {
                                            }
                                        }
                                        objectArray[n34++] = string.substring(n3, ++n5);
                                        continue block66;
                                    }
                                    case 'L': {
                                        while (string.charAt(n5) != ';') {
                                            ++n5;
                                        }
                                        objectArray[n34++] = string.substring(n3 + 1, n5++);
                                        continue block66;
                                    }
                                }
                                break;
                            }
                            n31 = n34;
                        }
                        n30 = -1;
                    }
                    n11 = n25;
                    block70: while (n11 < n26) {
                        int n36;
                        n12 = n11 - n25;
                        Label label = labelArray[n12];
                        if (label != null) {
                            methodVisitor.visitLabel(label);
                            if (!bl3 && label.line > 0) {
                                methodVisitor.visitLineNumber(label.line, label);
                            }
                        }
                        while (objectArray != null && (n30 == n12 || n30 == -1)) {
                            block228: {
                                int n37;
                                int n38;
                                MethodVisitor methodVisitor3;
                                block227: {
                                    block226: {
                                        if (bl5 && !bl4) break block226;
                                        methodVisitor3 = methodVisitor;
                                        n38 = -1;
                                        n37 = n31;
                                        break block227;
                                    }
                                    if (n30 == -1) break block228;
                                    methodVisitor3 = methodVisitor;
                                    n38 = n29;
                                    n37 = n32;
                                }
                                methodVisitor3.visitFrame(n38, n37, objectArray, n33, objectArray2);
                            }
                            if (n15 > 0) {
                                if (bl5) {
                                    n36 = byArray[n28++] & 0xFF;
                                } else {
                                    n36 = 255;
                                    n30 = -1;
                                }
                                n32 = 0;
                                if (n36 < 64) {
                                    n14 = n36;
                                    n29 = 3;
                                    n33 = 0;
                                } else if (n36 < 128) {
                                    n14 = n36 - 64;
                                    n28 = this.readFrameType(objectArray2, 0, n28, cArray, labelArray);
                                    n29 = 4;
                                    n33 = 1;
                                } else {
                                    n14 = this.readUnsignedShort(n28);
                                    n28 += 2;
                                    if (n36 == 247) {
                                        n28 = this.readFrameType(objectArray2, 0, n28, cArray, labelArray);
                                        n29 = 4;
                                        n33 = 1;
                                    } else if (n36 >= 248 && n36 < 251) {
                                        n29 = 2;
                                        n32 = 251 - n36;
                                        n31 -= n32;
                                        n33 = 0;
                                    } else if (n36 == 251) {
                                        n29 = 3;
                                        n33 = 0;
                                    } else if (n36 < 255) {
                                        n5 = bl4 ? n31 : 0;
                                        for (n3 = n36 - 251; n3 > 0; --n3) {
                                            n28 = this.readFrameType(objectArray, n5++, n28, cArray, labelArray);
                                        }
                                        n29 = 1;
                                        n32 = n36 - 251;
                                        n31 += n32;
                                        n33 = 0;
                                    } else {
                                        n29 = 0;
                                        n32 = n31 = this.readUnsignedShort(n28);
                                        n28 += 2;
                                        n5 = 0;
                                        for (n13 = n31; n13 > 0; --n13) {
                                            n28 = this.readFrameType(objectArray, n5++, n28, cArray, labelArray);
                                        }
                                        n13 = n33 = this.readUnsignedShort(n28);
                                        n28 += 2;
                                        if (objectArray2.length < n13) {
                                            System.out.println("KEmulator parses class error!!, " + this.getClassName() + "." + string3 + string + " stack overflow!!, check proguard");
                                        } else {
                                            n5 = 0;
                                            while (n13 > 0) {
                                                n28 = this.readFrameType(objectArray2, n5++, n28, cArray, labelArray);
                                                --n13;
                                            }
                                        }
                                    }
                                }
                                if (labelArray[n30 += n14 + 1] == null) {
                                    labelArray[n30] = new Label();
                                }
                                --n15;
                                continue;
                            }
                            objectArray = null;
                        }
                        n36 = byArray[n11] & 0xFF;
                        switch (ClassWriter.TYPE[n36]) {
                            case 0: {
                                methodVisitor.visitInsn(n36);
                                ++n11;
                                continue block70;
                            }
                            case 4: {
                                int n39;
                                MethodVisitor methodVisitor4;
                                if (n36 > 54) {
                                    n36 -= 59;
                                    methodVisitor4 = methodVisitor;
                                    n39 = 54;
                                } else {
                                    n36 -= 26;
                                    methodVisitor4 = methodVisitor;
                                    n39 = 21;
                                }
                                methodVisitor4.visitVarInsn(n39 + (n36 >> 2), n36 & 3);
                                ++n11;
                                continue block70;
                            }
                            case 8: {
                                methodVisitor.visitJumpInsn(n36, labelArray[n12 + this.readShort(n11 + 1)]);
                                n11 += 3;
                                continue block70;
                            }
                            case 9: {
                                methodVisitor.visitJumpInsn(n36 - 33, labelArray[n12 + this.readInt(n11 + 1)]);
                                n11 += 5;
                                continue block70;
                            }
                            case 16: {
                                n36 = byArray[n11 + 1] & 0xFF;
                                if (n36 == 132) {
                                    methodVisitor.visitIincInsn(this.readUnsignedShort(n11 + 2), this.readShort(n11 + 4));
                                    n11 += 6;
                                    continue block70;
                                }
                                methodVisitor.visitVarInsn(n36, this.readUnsignedShort(n11 + 2));
                                break;
                            }
                            case 13: {
                                n11 = n11 + 4 - (n12 & 3);
                                n16 = n12 + this.readInt(n11);
                                n14 = this.readInt(n11 + 4);
                                n13 = this.readInt(n11 + 8);
                                n11 += 12;
                                Label[] labelArray2 = new Label[n13 - n14 + 1];
                                for (n5 = 0; n5 < labelArray2.length; ++n5) {
                                    labelArray2[n5] = labelArray[n12 + this.readInt(n11)];
                                    n11 += 4;
                                }
                                methodVisitor.visitTableSwitchInsn(n14, n13, labelArray[n16], labelArray2);
                                continue block70;
                            }
                            case 14: {
                                n11 = n11 + 4 - (n12 & 3);
                                n16 = n12 + this.readInt(n11);
                                n5 = this.readInt(n11 + 4);
                                n11 += 8;
                                object = new int[n5];
                                Label[] labelArray3 = new Label[n5];
                                for (n5 = 0; n5 < ((int[])object).length; ++n5) {
                                    object[n5] = this.readInt(n11);
                                    labelArray3[n5] = labelArray[n12 + this.readInt(n11 + 4)];
                                    n11 += 8;
                                }
                                methodVisitor.visitLookupSwitchInsn(labelArray[n16], (int[])object, labelArray3);
                                continue block70;
                            }
                            case 3: {
                                methodVisitor.visitVarInsn(n36, byArray[n11 + 1] & 0xFF);
                                n11 += 2;
                                continue block70;
                            }
                            case 1: {
                                methodVisitor.visitIntInsn(n36, byArray[n11 + 1]);
                                n11 += 2;
                                continue block70;
                            }
                            case 2: {
                                methodVisitor.visitIntInsn(n36, this.readShort(n11 + 1));
                                n11 += 3;
                                continue block70;
                            }
                            case 10: {
                                methodVisitor.visitLdcInsn(this.readConst(byArray[n11 + 1] & 0xFF, cArray));
                                n11 += 2;
                                continue block70;
                            }
                            case 11: {
                                methodVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n11 + 1), cArray));
                                n11 += 3;
                                continue block70;
                            }
                            case 6: 
                            case 7: {
                                int n40 = this.items[this.readUnsignedShort(n11 + 1)];
                                String string12 = this.readClass(n40, cArray);
                                n40 = this.items[this.readUnsignedShort(n40 + 2)];
                                String string13 = this.readUTF8(n40, cArray);
                                String string14 = this.readUTF8(n40 + 2, cArray);
                                if (n36 < 182) {
                                    methodVisitor.visitFieldInsn(n36, string12, string13, string14);
                                } else {
                                    methodVisitor.visitMethodInsn(n36, string12, string13, string14);
                                }
                                if (n36 == 185) {
                                    n11 += 5;
                                    continue block70;
                                }
                                n11 += 3;
                                continue block70;
                            }
                            case 5: {
                                methodVisitor.visitTypeInsn(n36, this.readClass(n11 + 1, cArray));
                                n11 += 3;
                                continue block70;
                            }
                            case 12: {
                                methodVisitor.visitIincInsn(byArray[n11 + 1] & 0xFF, byArray[n11 + 2]);
                                n11 += 3;
                                continue block70;
                            }
                            default: {
                                methodVisitor.visitMultiANewArrayInsn(this.readClass(n11 + 1, cArray), byArray[n11 + 3] & 0xFF);
                            }
                        }
                        n11 += 4;
                    }
                    Label label = labelArray[n26 - n25];
                    if (label != null) {
                        methodVisitor.visitLabel(label);
                    }
                    if (!bl3 && n17 != 0) {
                        int[] nArray = null;
                        if (n27 != 0) {
                            n3 = this.readUnsignedShort(n27) * 3;
                            n12 = n27 + 2;
                            nArray = new int[n3];
                            while (n3 > 0) {
                                nArray[--n3] = n12 + 6;
                                nArray[--n3] = this.readUnsignedShort(n12 + 8);
                                nArray[--n3] = this.readUnsignedShort(n12);
                                n12 += 10;
                            }
                        }
                        n12 = n17 + 2;
                        for (n3 = this.readUnsignedShort(n17); n3 > 0; --n3) {
                            n14 = this.readUnsignedShort(n12);
                            n13 = this.readUnsignedShort(n12 + 2);
                            int n41 = this.readUnsignedShort(n12 + 8);
                            object = null;
                            if (nArray != null) {
                                for (int i2 = 0; i2 < nArray.length; i2 += 3) {
                                    if (nArray[i2] != n14 || nArray[i2 + 1] != n41) continue;
                                    object = this.readUTF8(nArray[i2 + 2], cArray);
                                    break;
                                }
                            }
                            methodVisitor.visitLocalVariable(this.readUTF8(n12 + 4, cArray), this.readUTF8(n12 + 6, cArray), (String)object, labelArray[n14], labelArray[n14 + n13], n41);
                            n12 += 10;
                        }
                    }
                    while (attribute2 != null) {
                        attribute = attribute2.next;
                        attribute2.next = null;
                        methodVisitor.visitAttribute(attribute2);
                        attribute2 = attribute;
                    }
                    methodVisitor.visitMaxs(n23, n18);
                }
                if (methodVisitor != null) {
                    methodVisitor.visitEnd();
                }
            }
            --n6;
        }
        classVisitor.visitEnd();
    }

    private void readParameterAnnotations(int n2, char[] cArray, boolean bl2, MethodVisitor methodVisitor) {
        int n3 = this.b[n2++] & 0xFF;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.readUnsignedShort(n2);
            n2 += 2;
            while (n4 > 0) {
                n2 = this.readAnnotationValues(n2 + 2, cArray, true, methodVisitor.visitParameterAnnotation(i2, this.readUTF8(n2, cArray), bl2));
                --n4;
            }
        }
    }

    private int readAnnotationValues(int n2, char[] cArray, boolean bl2, AnnotationVisitor annotationVisitor) {
        int n3 = this.readUnsignedShort(n2);
        n2 += 2;
        if (bl2) {
            while (n3 > 0) {
                n2 = this.readAnnotationValue(n2 + 2, cArray, this.readUTF8(n2, cArray), annotationVisitor);
                --n3;
            }
        } else {
            while (n3 > 0) {
                n2 = this.readAnnotationValue(n2, cArray, null, annotationVisitor);
                --n3;
            }
        }
        if (annotationVisitor != null) {
            annotationVisitor.visitEnd();
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readAnnotationValue(int n2, char[] cArray, String string, AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            switch (this.b[n2] & 0xFF) {
                case 101: {
                    return n2 + 5;
                }
                case 64: {
                    return this.readAnnotationValues(n2 + 3, cArray, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(n2 + 1, cArray, false, null);
                }
            }
            return n2 + 3;
        }
        switch (this.b[n2++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                annotationVisitor.visit(string, this.readConst(this.readUnsignedShort(n2), cArray));
                n2 += 2;
                return n2;
            }
            case 66: {
                annotationVisitor.visit(string, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(n2)])));
                n2 += 2;
                return n2;
            }
            case 90: {
                annotationVisitor.visit(string, this.readInt(this.items[this.readUnsignedShort(n2)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                n2 += 2;
                return n2;
            }
            case 83: {
                annotationVisitor.visit(string, new Short((short)this.readInt(this.items[this.readUnsignedShort(n2)])));
                n2 += 2;
                return n2;
            }
            case 67: {
                annotationVisitor.visit(string, new Character((char)this.readInt(this.items[this.readUnsignedShort(n2)])));
                n2 += 2;
                return n2;
            }
            case 115: {
                annotationVisitor.visit(string, this.readUTF8(n2, cArray));
                n2 += 2;
                return n2;
            }
            case 101: {
                annotationVisitor.visitEnum(string, this.readUTF8(n2, cArray), this.readUTF8(n2 + 2, cArray));
                n2 += 4;
                return n2;
            }
            case 99: {
                annotationVisitor.visit(string, Type.getType(this.readUTF8(n2, cArray)));
                n2 += 2;
                return n2;
            }
            case 64: {
                ClassReader classReader = this;
                int n3 = n2 + 2;
                char[] cArray2 = cArray;
                boolean bl2 = true;
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitAnnotation(string, this.readUTF8(n2, cArray));
                return classReader.readAnnotationValues(n3, cArray2, bl2, annotationVisitor2);
            }
            case 91: {
                int n4 = this.readUnsignedShort(n2);
                n2 += 2;
                if (n4 == 0) {
                    return this.readAnnotationValues(n2 - 2, cArray, false, annotationVisitor.visitArray(string));
                }
                switch (this.b[n2++] & 0xFF) {
                    case 66: {
                        byte[] byArray = new byte[n4];
                        for (int i2 = 0; i2 < n4; ++i2) {
                            byArray[i2] = (byte)this.readInt(this.items[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, byArray);
                        --n2;
                        return n2;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            blArray[i3] = this.readInt(this.items[this.readUnsignedShort(n2)]) != 0;
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, blArray);
                        --n2;
                        return n2;
                    }
                    case 83: {
                        short[] sArray = new short[n4];
                        for (int i4 = 0; i4 < n4; ++i4) {
                            sArray[i4] = (short)this.readInt(this.items[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, sArray);
                        --n2;
                        return n2;
                    }
                    case 67: {
                        char[] cArray3 = new char[n4];
                        for (int i5 = 0; i5 < n4; ++i5) {
                            cArray3[i5] = (char)this.readInt(this.items[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, cArray3);
                        --n2;
                        return n2;
                    }
                    case 73: {
                        int[] nArray = new int[n4];
                        for (int i6 = 0; i6 < n4; ++i6) {
                            nArray[i6] = this.readInt(this.items[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, nArray);
                        --n2;
                        return n2;
                    }
                    case 74: {
                        long[] lArray = new long[n4];
                        for (int i7 = 0; i7 < n4; ++i7) {
                            lArray[i7] = this.readLong(this.items[this.readUnsignedShort(n2)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, lArray);
                        --n2;
                        return n2;
                    }
                    case 70: {
                        float[] fArray = new float[n4];
                        for (int i8 = 0; i8 < n4; ++i8) {
                            fArray[i8] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(n2)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, fArray);
                        --n2;
                        return n2;
                    }
                    case 68: {
                        double[] dArray = new double[n4];
                        for (int i9 = 0; i9 < n4; ++i9) {
                            dArray[i9] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(n2)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, dArray);
                        --n2;
                        return n2;
                    }
                }
                ClassReader classReader = this;
                int n3 = n2 - 3;
                char[] cArray2 = cArray;
                boolean bl2 = false;
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string);
                return classReader.readAnnotationValues(n3, cArray2, bl2, annotationVisitor2);
            }
        }
        return n2;
    }

    private int readFrameType(Object[] objectArray, int n2, int n3, char[] cArray, Label[] labelArray) {
        block11: {
            Object object;
            int n4 = this.b[n3++] & 0xFF;
            switch (n4) {
                case 0: {
                    objectArray[n2] = Opcodes.TOP;
                    break block11;
                }
                case 1: {
                    objectArray[n2] = Opcodes.INTEGER;
                    break block11;
                }
                case 2: {
                    objectArray[n2] = Opcodes.FLOAT;
                    break block11;
                }
                case 3: {
                    objectArray[n2] = Opcodes.DOUBLE;
                    break block11;
                }
                case 4: {
                    objectArray[n2] = Opcodes.LONG;
                    break block11;
                }
                case 5: {
                    objectArray[n2] = Opcodes.NULL;
                    break block11;
                }
                case 6: {
                    objectArray[n2] = Opcodes.UNINITIALIZED_THIS;
                    break block11;
                }
                case 7: {
                    Object[] objectArray2 = objectArray;
                    int n5 = n2;
                    object = this.readClass(n3, cArray);
                    break;
                }
                default: {
                    int n6 = this.readUnsignedShort(n3);
                    if (labelArray[n6] == null) {
                        labelArray[n6] = new Label();
                    }
                    Object[] objectArray2 = objectArray;
                    int n5 = n2;
                    object = labelArray[n6];
                }
            }
            objectArray2[n5] = object;
            n3 += 2;
        }
        return n3;
    }

    private Attribute readAttribute(Attribute[] attributeArray, String string, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (!attributeArray[i2].type.equals(string)) continue;
            return attributeArray[i2].read(this, n2, n3, cArray, n4, labelArray);
        }
        return new Attribute(string).read(this, n2, n3, null, -1, null);
    }

    public int getItem(int n2) {
        return this.items[n2];
    }

    public int readByte(int n2) {
        return this.b[n2] & 0xFF;
    }

    public int readUnsignedShort(int n2) {
        byte[] byArray = this.b;
        return (this.b[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    public short readShort(int n2) {
        byte[] byArray = this.b;
        return (short)((this.b[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public int readInt(int n2) {
        byte[] byArray = this.b;
        return (this.b[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public long readLong(int n2) {
        long l2 = this.readInt(n2);
        long l3 = (long)this.readInt(n2 + 4) & 0xFFFFFFFFL;
        return l2 << 32 | l3;
    }

    public String readUTF8(int n2, char[] cArray) {
        int n3 = this.readUnsignedShort(n2);
        String string = this.strings[n3];
        if (string != null) {
            return string;
        }
        n2 = this.items[n3];
        this.strings[n3] = this.readUTF(n2 + 2, this.readUnsignedShort(n2), cArray);
        return this.strings[n3];
    }

    private String readUTF(int n2, int n3, char[] cArray) {
        int n4 = n2 + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        block4: while (n2 < n4) {
            byte by2;
            int n6 = byArray[n2++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n6;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by2 = byArray[n2++];
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | by2 & 0x3F);
                    continue block4;
                }
            }
            by2 = byArray[n2++];
            byte by3 = byArray[n2++];
            cArray[n5++] = (char)((n6 & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
        }
        return new String(cArray, 0, n5);
    }

    public String readClass(int n2, char[] cArray) {
        return this.readUTF8(this.items[this.readUnsignedShort(n2)], cArray);
    }

    public Object readConst(int n2, char[] cArray) {
        int n3 = this.items[n2];
        switch (this.b[n3 - 1]) {
            case 3: {
                return new Integer(this.readInt(n3));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n3)));
            }
            case 5: {
                return new Long(this.readLong(n3));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n3)));
            }
            case 7: {
                String string = this.readUTF8(n3, cArray);
                if (string.charAt(0) == '[') {
                    return Type.getType(string);
                }
                return Type.getObjectType(string);
            }
        }
        return this.readUTF8(n3, cArray);
    }
}

