/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

public class TreeNode {
    private TreeNode parent;
    private TreeNode[] children = new TreeNode[0];
    private Object m_userData;

    public TreeNode() {
    }

    public TreeNode(Object userObject) {
        this.m_userData = userObject;
    }

    public void add(TreeNode child, int index) {
        if (index < 0 || index == this.children.length) {
            TreeNode[] newChildren = new TreeNode[this.children.length + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            newChildren[this.children.length] = child;
            this.children = newChildren;
        } else {
            if (index > this.children.length) {
                throw new IllegalArgumentException("Cannot add child to index " + index + ".  There are only " + this.children.length + " children.");
            }
            TreeNode[] newChildren = new TreeNode[this.children.length + 1];
            if (index > 0) {
                System.arraycopy(this.children, 0, newChildren, 0, index);
            }
            newChildren[index] = child;
            System.arraycopy(this.children, index, newChildren, index + 1, this.children.length - index);
            this.children = newChildren;
        }
        child.parent = this;
    }

    public void add(TreeNode child) {
        this.add(child, -1);
    }

    public TreeNode remove(int index) {
        if (index < 0 || index >= this.children.length) {
            throw new IllegalArgumentException("Cannot remove element with index " + index + " when there are " + this.children.length + " elements.");
        }
        TreeNode node = this.children[index];
        node.parent = null;
        TreeNode[] newChildren = new TreeNode[this.children.length - 1];
        if (index > 0) {
            System.arraycopy(this.children, 0, newChildren, 0, index);
        }
        if (index != this.children.length - 1) {
            System.arraycopy(this.children, index + 1, newChildren, index, this.children.length - index - 1);
        }
        this.children = newChildren;
        return node;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            int position = this.index();
            this.parent.remove(position);
            this.parent = null;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TreeNode[] children() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.length != 0;
    }

    public int index() {
        if (this.parent != null) {
            int i = 0;
            while (true) {
                TreeNode node;
                if (this == (node = this.parent.children[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int depth() {
        int depth = this.recurseDepth(this.parent, 0);
        return depth;
    }

    private int recurseDepth(TreeNode node, int depth) {
        if (node == null) {
            return depth;
        }
        return this.recurseDepth(node.parent, depth + 1);
    }

    public void setUserObject(Object userObject) {
        this.m_userData = userObject;
    }

    public Object getUserObject() {
        return this.m_userData;
    }
}

