/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.util;

import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.j4me.logging.Log;

public class ConnectorHelper
extends Thread {
    private final String url;
    private final int mode;
    private final int timeout;
    private StreamConnection connection;
    private Exception exception;

    private ConnectorHelper(String url, int mode, int timeout) {
        super("ConnectorHelper");
        this.url = url;
        this.mode = mode;
        this.timeout = timeout;
    }

    public synchronized void run() {
        try {
            this.connection = (StreamConnection)Connector.open((String)this.url, (int)this.mode, (boolean)true);
        }
        catch (IOException e) {
            Log.warn("Problem opening connection to " + this.url, e);
            this.exception = e;
        }
        catch (SecurityException e) {
            Log.error("Not allowed to open connection", e);
            this.exception = e;
        }
        catch (Exception e) {
            Log.error("Unknown connection exception", e);
            this.exception = e;
        }
        this.notifyAll();
    }

    public synchronized StreamConnection blockUntilConnected() throws IOException, SecurityException {
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.exception != null) {
            if (this.exception instanceof ConnectionNotFoundException) {
                throw (ConnectionNotFoundException)this.exception;
            }
            if (this.exception instanceof SecurityException) {
                throw (SecurityException)this.exception;
            }
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)this.exception;
            }
            throw (RuntimeException)this.exception;
        }
        return this.connection;
    }

    public static Connection open(String url, int mode, int timeout) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        ConnectorHelper thread = new ConnectorHelper(url, mode, timeout);
        thread.start();
        StreamConnection connection = thread.blockUntilConnected();
        if (connection == null) {
            thread.interrupt();
            throw new ConnectionNotFoundException("Connection attempt timed out to " + url);
        }
        return connection;
    }
}

