/*
 * Decompiled with CFR 0.152.
 */
package com.webwag.htmlBrowser;

import com.webwag.engine.BufferFile;
import com.webwag.engine.BufferFileListener;
import com.webwag.engine.Language;
import com.webwag.engine.Widget;
import com.webwag.engine.WidgetCanvas;
import com.webwag.htmlBrowser.HtmlBrowserListener;
import com.webwag.htmlBrowser.HtmlLink;
import com.webwag.htmlBrowser.HtmlRender;
import com.webwag.utils.UtilMidp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.mobidgets.Menu;
import net.mobidgets.MenuItem;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HtmlBrowser
implements BufferFileListener {
    public static final int NB_PIXEL_TO_ACTIVATE_ACTION_KEY = 30;
    public static final int TITLE_LEFT = 0;
    public static final int TITLE_CENTER = 1;
    public static final int TITLE_RIGHT = 2;
    public static final int RENDERER_TYPE_HTML = 0;
    public static final int RENDERER_TYPE_RSS = 1;
    public static final int PROXY_IMAGE_QUALITY = 50;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_KEY_1 = 16;
    public static final int ARROW_KEY_3 = 32;
    public static final int CMD_FULL = 0;
    public static final int CMD_WITHOUT_PARAM_REFRESH = 1;
    public static final int CMD_WITHOUT_PARAM_REFRESH_CLOSE = 2;
    public static final int CMD_WITHOUT_CLOSE = 3;
    public static Image imageWait = null;
    public static Image imageArrows = null;
    public static Image imageTopLift = null;
    public static Image imageCheckbox = null;
    public static Image imageRadio = null;
    public static Image imageListArrow = null;
    public static Image imageHudBgLeft = null;
    public static Image imageHudBgCenter = null;
    public static Image imageUnreadBg = null;
    public static Font fontTitle = Font.getFont((int)64, (int)1, (int)8);
    public static boolean keyNumUsed = true;
    public static boolean displayScrollBar = false;
    public static boolean isParsing = false;
    public static boolean isPainting = false;
    public boolean stopRender = false;
    public boolean updateRender = false;
    public boolean computeAll = false;
    public String currentRoot = "";
    public String currentUrl = "";
    public Menu menuHTML = null;
    public Menu subMenuHTML = null;
    public int titleFontColor = 0;
    public int titleBgColor = 2522319;
    public int titleBgGradient = 2522319;
    public int bgColor = 0xFFFFFF;
    public int bgGradient = 0xFFFFFF;
    public WidgetCanvas currentCanvas = null;
    public HtmlRender htmlRender = null;
    public Widget widgetInitialized = null;
    public Image imageArrowsBg = null;
    public int typeRenderer = 0;
    public boolean icoResized = false;
    private static Vector b = new Vector(1);
    private HtmlBrowserListener a;
    private MenuItem a;
    private MenuItem b;
    public Vector listMenuItem = new Vector(1);
    public Hashtable listUrls = new Hashtable();
    public boolean isFullScreen = false;
    public boolean a;
    public int a;
    public int b;
    public Vector a;
    public Hashtable a;
    public boolean b = true;
    public int c = 0;
    public SmoothScrolling a = null;
    public Image ico = null;
    public String title = null;
    public int titleAlign = 0;
    public String rightInfo = null;
    public boolean enabledSkin = false;
    public String focusRect = null;
    public boolean displayHeader = true;
    public boolean displayTitle = true;
    public boolean resizedImage = false;
    public boolean firstPage = false;
    public int defaultMenu = 0;
    public Image imgTitle = null;
    public int unreadBgColor = 2522319;
    public int unreadFontColor = 0xFFFFFF;
    public boolean rssDescription = false;
    private int d = 0;
    public int currentDescriptionIndex = 0;
    private int e = 0;
    public int nbRSSTopics = 0;
    public boolean navLeftRight = false;
    private static HtmlLink a = new HtmlLink(12, null, "prev");
    private static HtmlLink b = new HtmlLink(12, null, "next");
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private int i = 0;

    public HtmlBrowser(WidgetCanvas widgetCanvas) {
        this.currentCanvas = widgetCanvas;
        if (b.isEmpty()) {
            String[] stringArray = new String[]{"A", "B", "BASE", "BASEFONT", "BODY", "BR", "COL", "COLGROUP", "DIV", "FONT", "FORM", "HR", "HTML", "I", "IMG", "OL", "P", "STRONG", "TABLE", "TD", "TR", "TITLE", "U", "UL", "LI", "H1", "H2", "H3", "H4", "H5", "H6", "INPUT", "SELECT", "OPTION"};
            for (int i = 0; i < stringArray.length; ++i) {
                b.addElement(stringArray[i]);
            }
            stringArray = null;
        }
        if (imageWait == null) {
            imageWait = UtilMidp.loadImage("/wait.png");
        }
        if (imageArrows == null) {
            imageArrows = UtilMidp.loadImage("/htmlDigits.png");
        }
        if (imageTopLift == null) {
            imageTopLift = UtilMidp.loadImage("/topLift.png");
        }
        if (imageCheckbox == null) {
            imageCheckbox = UtilMidp.loadImage("/checkbox.png");
        }
        if (imageRadio == null) {
            imageRadio = UtilMidp.loadImage("/radio.png");
        }
        if (imageListArrow == null) {
            imageListArrow = UtilMidp.loadImage("/arrowList.png");
        }
        if (imageHudBgLeft == null) {
            imageHudBgLeft = UtilMidp.loadImage(WidgetCanvas.resPath + "/htmlHudBgLeft.png");
        }
        if (imageHudBgCenter == null) {
            imageHudBgCenter = UtilMidp.loadImage(WidgetCanvas.resPath + "/htmlHudBgCenter.png");
        }
        if (imageUnreadBg == null) {
            imageUnreadBg = UtilMidp.loadImage(WidgetCanvas.resPath + "/unreadBg.png");
        }
        this.menuHTML = new Menu(this.currentCanvas, WidgetCanvas.GLOBAL_FONT_SIZE);
        this.menuHTML.colorSelector = WidgetCanvas.menuColorSelector;
        this.menuHTML.colorBg = WidgetCanvas.menuColorBg;
    }

    private byte[] a(String string) {
        byte[] byArray = null;
        if (string.indexOf("<html") == -1 && string.indexOf("<HTML") == -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<HTML>");
            if (string.indexOf("<body") == -1 && string.indexOf("<BODY") == -1) {
                stringBuffer.append("<BODY>");
            }
            if (string.indexOf("<title") == -1 && string.indexOf("<TITLE") == -1) {
                stringBuffer.append("<TITLE>" + this.title + "</TITLE>");
            }
            stringBuffer.append(string);
            if (string.indexOf("</body>") == -1 && string.indexOf("</BODY>") == -1) {
                stringBuffer.append("</BODY>");
            }
            if (string.indexOf("</html>") == -1 && string.indexOf("</HTML>") == -1) {
                stringBuffer.append("</HTML>");
            }
            byArray = stringBuffer.toString().getBytes();
            stringBuffer = null;
        } else {
            byArray = string.getBytes();
        }
        return byArray;
    }

    public void init(Widget widget, String string) {
        this.init(widget, 0, 0, this.currentCanvas.getWidth(), WidgetCanvas.canvasHeight, string);
    }

    public void init(Widget widget, InputStreamReader inputStreamReader) {
        this.init(widget, 0, 0, this.currentCanvas.getWidth(), WidgetCanvas.canvasHeight, inputStreamReader);
    }

    public void init(Widget widget, int n, int n2, int n3, int n4, String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.a(string));
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        this.init(widget, n, n2, n3, n4, inputStreamReader);
    }

    public void init(Widget widget, int n, int n2, int n3, int n4, InputStreamReader inputStreamReader) {
        this.a.onLoad();
        this.widgetInitialized = widget;
        n = n < 0 ? 0 : n;
        n3 = n3 < 0 ? this.currentCanvas.getWidth() : n3;
        n2 = n2 < 0 ? 0 : n2;
        n4 = n4 < 0 ? WidgetCanvas.canvasHeight : n4;
        this.isFullScreen = n <= 0 && n2 <= 0 && n3 >= WidgetCanvas.canvasWidth && n4 >= WidgetCanvas.canvasHeight;
        this.htmlRender = new HtmlRender(this, n, n2, n3, n4);
        if (this.enabledSkin && !UtilMidp.isRIM() && this.titleBgColor != 2522319) {
            this.htmlRender.a = UtilMidp.changeImageColor(imageHudBgLeft, this.titleBgColor);
            this.htmlRender.b = UtilMidp.changeImageColor(imageHudBgCenter, this.titleBgColor);
        }
        this.displayHTMLContent(widget, inputStreamReader, -1);
        this.firstPage = true;
    }

    public void setViewPort() {
        if (this.isFullScreen) {
            this.setViewPort(0, WidgetCanvas.headerHeight, WidgetCanvas.canvasWidth, WidgetCanvas.canvasHeight - WidgetCanvas.headerHeight);
        } else {
            this.setViewPort(this.htmlRender.a, this.htmlRender.b, this.htmlRender.c, this.htmlRender.d);
        }
        this.htmlRender.restoreAllTextLines();
        this.htmlRender.firstPaint();
    }

    public void setViewPort(int n, int n2, int n3, int n4) {
        n = n < 0 ? 0 : n;
        n3 = n3 < 0 ? WidgetCanvas.canvasWidth : n3;
        n2 = n2 < 0 ? WidgetCanvas.headerHeight : n2;
        n4 = n4 < 0 ? WidgetCanvas.canvasHeight - WidgetCanvas.headerHeight : n4;
        boolean bl = this.isFullScreen = n <= 0 && n2 <= WidgetCanvas.headerHeight && n3 >= WidgetCanvas.canvasWidth && n4 >= WidgetCanvas.canvasHeight - WidgetCanvas.headerHeight;
        if (this.htmlRender != null) {
            this.htmlRender.restoreAllTextLines();
            this.htmlRender.firstPaint();
            this.htmlRender.updateViewPort(n, n2, n3, n4);
        }
    }

    public void close() {
        if (this.htmlRender == null) {
            return;
        }
        this.stopRender = isPainting;
        this.b();
        this.htmlRender.close();
        this.htmlRender = null;
        this.removeCommands();
        this.currentRoot = "";
        this.currentUrl = "";
        this.widgetInitialized = null;
        this.ico = null;
        this.imgTitle = null;
        this.title = null;
        this.titleAlign = 0;
        this.titleFontColor = 0;
        this.titleBgColor = 2522319;
        this.titleBgGradient = 2522319;
        this.bgColor = 0xFFFFFF;
        this.bgGradient = 0xFFFFFF;
        this.rightInfo = null;
        this.enabledSkin = false;
        this.focusRect = null;
        this.displayHeader = true;
        this.displayTitle = true;
        this.resizedImage = false;
        this.firstPage = false;
        this.defaultMenu = 0;
        this.a = 0;
        this.b = 0;
        this.b = true;
        isParsing = false;
        this.unreadBgColor = 2522319;
        this.unreadFontColor = 0xFFFFFF;
        this.d = 0;
        this.currentDescriptionIndex = 0;
        this.e = 0;
        this.nbRSSTopics = 0;
        this.a.removeAllElements();
        this.a.clear();
        this.imageArrowsBg = null;
        this.a.onClose();
        if (this.currentCanvas.mode != 3) {
            this.a = null;
        }
    }

    public void setHtmlListener(HtmlBrowserListener htmlBrowserListener) {
        this.a = htmlBrowserListener;
    }

    public void resetRss() {
        this.setIndexNavigation(0, this.d);
        this.rssDescription = false;
        if (this.htmlRender != null) {
            this.htmlRender.h = 0;
        }
    }

    public void setIndexLinkRender(int n) {
        if (this.htmlRender != null) {
            this.htmlRender.firstPaint();
            this.htmlRender.restoreLinkIndex = n;
        }
    }

    public void setRSSInfo(int n, int n2) {
        this.e = n;
        this.nbRSSTopics = n2;
    }

    public void setIndexNavigation(int n, int n2) {
        this.currentDescriptionIndex = n;
        this.d = n2;
    }

    public void addCommandOK(String string, int n, String string2) {
        this.currentCanvas.removeCommand(this.a);
        this.a = new MenuItem(string, 4, n, WidgetCanvas.GLOBAL_FONT_SIZE);
        this.listUrls.put(this.a, string2);
        this.currentCanvas.addCommand(this.a);
    }

    public void addCommandBack(String string, int n, String string2) {
        this.currentCanvas.removeCommand(this.b);
        this.b = new MenuItem(string, 2, n, WidgetCanvas.GLOBAL_FONT_SIZE);
        this.listUrls.put(this.b, string2);
        this.currentCanvas.addCommand(this.b);
    }

    public void addCommandItem(String string, int n, String string2) {
        MenuItem menuItem = new MenuItem(string, 8, n, WidgetCanvas.GLOBAL_FONT_SIZE);
        this.listMenuItem.addElement(menuItem);
        this.listUrls.put(menuItem, string2);
        if (!UtilMidp.isRIM() && this.subMenuHTML != null) {
            this.subMenuHTML.addCommand(menuItem);
        } else {
            this.currentCanvas.addCommand(menuItem);
        }
    }

    public void addCommands() {
        if (!this.currentCanvas.isDialogBoxDisplayed() && this.widgetInitialized.isSendable) {
            this.currentCanvas.addCommand(WidgetCanvas.cmdSendWidgetView);
        }
        this.currentCanvas.addCommand(WidgetCanvas.cmdCloseView);
        this.listUrls.put(WidgetCanvas.cmdCloseView, "exit");
        if (this.defaultMenu == 0 || this.defaultMenu == 3) {
            if (this.widgetInitialized.ws.functionExists("onRefresh")) {
                this.currentCanvas.addCommand(WidgetCanvas.cmdRefreshView);
            }
            if (this.currentCanvas.hasConfig(this.widgetInitialized.findByName("prefs"))) {
                this.currentCanvas.addCommand(WidgetCanvas.cmdSettingView);
            }
            this.currentCanvas.addCommand(WidgetCanvas.cmdAboutView);
        }
        if (this.defaultMenu == 2 || this.defaultMenu == 3) {
            this.currentCanvas.removeCommand(WidgetCanvas.cmdCloseView);
        }
    }

    public void removeCommands() {
        this.currentCanvas.removeCommand(this.a);
        this.currentCanvas.removeCommand(this.b);
        this.currentCanvas.removeCommand(WidgetCanvas.cmdCloseView);
        this.currentCanvas.removeCommand(WidgetCanvas.cmdAboutView);
        this.currentCanvas.removeCommand(WidgetCanvas.cmdRefreshView);
        this.currentCanvas.removeCommand(WidgetCanvas.cmdSettingView);
        this.currentCanvas.removeCommand(WidgetCanvas.cmdSendWidgetView);
        Enumeration enumeration = this.listMenuItem.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)((Object)enumeration.nextElement());
            if (!UtilMidp.isRIM()) {
                if (menuItem.subMenu != null) {
                    menuItem.subMenu.close();
                    menuItem.subMenu = null;
                }
                this.menuHTML.removeCommand(menuItem);
            }
            this.currentCanvas.removeCommand(menuItem);
        }
        this.listMenuItem.removeAllElements();
        this.listUrls.clear();
        this.a = null;
        this.b = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().indexOf("-") != -1) {
            return;
        }
        if (!this.rssDescription) {
            if (command == WidgetCanvas.cmdCloseView) {
                if (this.firstPage || this.defaultMenu != 2 && this.defaultMenu != 3) {
                    this.close();
                } else {
                    this.htmlRender.currentLinkIndex = -1;
                    this.htmlRender.h = 0;
                    this.firstPage = true;
                    this.a.onReturnToFirstPage();
                }
                return;
            }
            if (command == this.a && "exit".equals(this.listUrls.get(command)) || command == this.b && "exit".equals(this.listUrls.get(command))) {
                this.close();
                return;
            }
        }
        HtmlLink htmlLink = new HtmlLink(12, command.getLabel(), this.listUrls.get(command).toString());
        this.linkSelected(htmlLink);
    }

    public void linkSelected(HtmlLink htmlLink) {
        if (this.a != null) {
            this.currentUrl = htmlLink.getUrl();
            this.a.onLinkSelected(htmlLink);
        }
    }

    public void buttonSubmit(HtmlLink htmlLink, boolean bl) {
        if (this.a != null) {
            this.currentUrl = htmlLink.getUrl();
            this.a.onSubmit(htmlLink, bl);
        }
    }

    public void repaint(boolean bl) {
        this.updateRender = true;
        if (isPainting) {
            if (bl && !this.computeAll) {
                this.computeAll = true;
            }
            return;
        }
        if (bl) {
            this.htmlRender.firstPaint();
        }
        this.updateRender = false;
        this.currentCanvas.repaint();
    }

    public void displayHTMLContent(Widget widget, String string, int n) {
        if (widget != this.widgetInitialized) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.a(string));
        this.displayHTMLContent(widget, new InputStreamReader(byteArrayInputStream), n);
    }

    public void displayHTMLContent(Widget widget, InputStreamReader inputStreamReader, int n) {
        if (widget != this.widgetInitialized) {
            return;
        }
        if (isParsing) {
            return;
        }
        if (this.htmlRender == null) {
            return;
        }
        isParsing = true;
        this.b = true;
        this.a = 0;
        this.htmlRender.currentLinkIndex = n;
        this.htmlRender.h = 0;
        this.htmlRender.E = 0;
        this.htmlRender.F = 0;
        this.a.clear();
        this.stopRender = isPainting;
        this.removeCommands();
        this.addCommands();
        this.a.removeAllElements();
        this.a(inputStreamReader);
        isParsing = false;
        this.a();
        this.repaint(true);
        this.currentCanvas.serviceRepaints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(InputStreamReader inputStreamReader) {
        try {
            if (inputStreamReader == null) {
                return;
            }
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#relaxed", true);
            kXmlParser.setInput(inputStreamReader);
            int n = kXmlParser.next();
            String string = null;
            boolean bl = false;
            HtmlLink htmlLink = null;
            int n2 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string2 = null;
            String string3 = null;
            int n3 = -1;
            Vector vector = null;
            Vector<Integer> vector2 = new Vector<Integer>(1);
            int n4 = -1;
            Vector vector3 = null;
            int n5 = -1;
            int n6 = 0;
            this.htmlRender.a.removeAllElements();
            while (n != 1) {
                switch (n) {
                    case 2: {
                        String string4 = kXmlParser.getName().toUpperCase();
                        string = null;
                        bl = false;
                        if (b.contains(string4)) {
                            Object object;
                            String string5;
                            Object object2;
                            string = string4;
                            boolean bl5 = false;
                            String string6 = null;
                            boolean bl6 = false;
                            String string7 = null;
                            if (string4.equals("A")) {
                                if (bl2) {
                                    bl3 = true;
                                } else {
                                    htmlLink = new HtmlLink(10);
                                    n2 = this.a;
                                    bl = true;
                                    htmlLink.b = this.a.size();
                                    this.htmlRender.a.addElement(htmlLink);
                                }
                            } else if (string4.equals("FORM")) {
                                vector = new Vector(1);
                                n4 = this.a;
                            } else if (string4.equals("INPUT")) {
                                object2 = kXmlParser.getAttributeValue(null, "type");
                                if (object2 != null) {
                                    if (n4 != -1) {
                                        bl5 = true;
                                    }
                                    if (((String)object2).equals("checkbox")) {
                                        string6 = kXmlParser.getAttributeValue(null, "checked");
                                        string6 = "checked".equals(string6) ? "checked" : "";
                                        this.a(14);
                                    } else if (((String)object2).equals("radio")) {
                                        string6 = kXmlParser.getAttributeValue(null, "checked");
                                        String string8 = string6 = "checked".equals(string6) ? "checked" : "";
                                        if ("checked".equals(string6)) {
                                            string5 = this.getSelectedValueByName(kXmlParser.getAttributeValue(null, "name"));
                                            if (string5 != null && !string5.equals("null")) {
                                                this.htmlRender.uncheckValue(string5);
                                                if (vector != null) {
                                                    vector.removeElement(vector.lastElement());
                                                }
                                            }
                                        } else {
                                            string5 = this.getSelectedValueByName(kXmlParser.getAttributeValue(null, "name"));
                                            if (string5 != null && !"null".equals(string5)) {
                                                bl5 = false;
                                                string6 = null;
                                            } else {
                                                string6 = "checked";
                                            }
                                        }
                                        this.a(15);
                                    } else if (((String)object2).equals("text") || ((String)object2).equals("password")) {
                                        this.a(((String)object2).equals("password") ? 18 : 16);
                                    } else if (((String)object2).equals("phoneNumber")) {
                                        this.a(20);
                                    } else if (((String)object2).equals("submit")) {
                                        bl5 = false;
                                        string7 = kXmlParser.getAttributeValue(null, "disabled");
                                        if (string7 == null || !"disabled".equals(string7)) {
                                            string7 = null;
                                            this.a(17);
                                        }
                                        if (n4 != -1) {
                                            vector2.addElement(new Integer(this.a));
                                        }
                                    }
                                }
                            } else if (string4.equals("SELECT")) {
                                vector3 = new Vector(1);
                                n5 = this.a;
                                this.a(19);
                            } else if (string4.equals("OPTION") && n5 != -1) {
                                bl6 = true;
                            }
                            object2 = new Hashtable();
                            string5 = null;
                            String string9 = null;
                            for (int i = 0; i < kXmlParser.getAttributeCount(); ++i) {
                                string5 = kXmlParser.getAttributeName(i).toUpperCase();
                                string9 = kXmlParser.getAttributeValue(i);
                                if (string4.equals("DIV")) {
                                    if ("ID".equals(string5) && "command".equals(string9)) {
                                        bl2 = true;
                                    } else if ("LABEL".equals(string5)) {
                                        bl4 = true;
                                        object = null;
                                        if (!UtilMidp.isRIM()) {
                                            object = new MenuItem(string9, 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE);
                                            this.subMenuHTML = new Menu(this.currentCanvas, WidgetCanvas.GLOBAL_FONT_SIZE);
                                            this.subMenuHTML.colorSelector = WidgetCanvas.menuColorSelector;
                                            this.subMenuHTML.colorBg = WidgetCanvas.menuColorBg;
                                            ((MenuItem)((Object)object)).setSubMenu(this.subMenuHTML);
                                        } else {
                                            object = new MenuItem("--- " + string9 + " ---", 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE);
                                        }
                                        this.listMenuItem.addElement(object);
                                        this.currentCanvas.addCommand((MenuItem)((Object)object));
                                    }
                                } else if (string5.equals("HREF")) {
                                    if (htmlLink != null) {
                                        if (!string9.startsWith("http://") && string9.startsWith("/")) {
                                            string9 = this.currentRoot + string9;
                                        }
                                        htmlLink.setUrl(string9);
                                    }
                                } else if (string5.equals("TYPE")) {
                                    if (htmlLink != null && (string9.equals("PlateformRequest") || string9.equals("PlatformRequest"))) {
                                        htmlLink.setType(13);
                                    }
                                } else if (string5.equals("BACKGROUND") || string5.equals("SRC")) {
                                    if (string9.startsWith("http")) {
                                        if (string9.indexOf("/services/image/image.php?url=") == -1) {
                                            string9 = WidgetCanvas.proxyImage + string9;
                                        }
                                        if (string9.indexOf("quality=") == -1) {
                                            string9 = string9 + "&quality=50";
                                        }
                                        if (this.rssDescription && n6 == 0) {
                                            string9 = string9 + "&effects=white_border,grey_halo";
                                            ((Hashtable)object2).put("ALIGN", "CENTER");
                                        }
                                    } else if (string9.startsWith("/")) {
                                        string9 = !this.currentRoot.equals("") ? WidgetCanvas.proxyImage + this.currentRoot + string9 : string9.substring(1);
                                    }
                                    if (this.resizedImage && string9.indexOf("/services/image/image.php?url=") != -1 && string9.indexOf("&maxWidth=") == -1) {
                                        string9 = string9 + "&maxWidth=" + this.htmlRender.c;
                                    }
                                    if (this.a.get(string9 = UtilMidp.encodeName(string9)) == null) {
                                        this.a.put(string9, imageWait);
                                    }
                                    ++n6;
                                }
                                if (string7 != null) {
                                    ((Hashtable)object2).put(string5, "hidden");
                                    continue;
                                }
                                ((Hashtable)object2).put(string5, string9);
                            }
                            if (bl3) {
                                Object v = ((Hashtable)object2).get("HREF");
                                object = ((Hashtable)object2).get("TYPE");
                                Object v2 = ((Hashtable)object2).get("PRIORITY");
                                string2 = v != null ? (String)v : "";
                                string3 = object != null ? (String)object : null;
                                n3 = v2 != null ? Integer.parseInt((String)v2) : 1;
                            }
                            this.htmlRender.addTag(100 + b.indexOf(string), string, (Hashtable)object2, null);
                            if (bl5) {
                                vector.addElement(this.a.elementAt(this.a));
                            }
                            if (string6 != null) {
                                this.htmlRender.addCheckedValue(this.a, string6);
                            }
                            if (bl6) {
                                vector3.addElement(this.a.elementAt(this.a));
                            }
                            ++this.a;
                            break;
                        }
                        if (!"SCRIPT".equals(string4) && !"STYLE".equals(string4)) break;
                        string = string4;
                        break;
                    }
                    case 4: {
                        String string4 = kXmlParser.getText().trim();
                        if (string4.startsWith("ERR: Attr.value missing f. selected")) {
                            string4 = string4.substring(35);
                        } else if (string4.startsWith("ERR: attr value delimiter missing!")) {
                            string4 = string4.substring(34);
                        } else if (string4.startsWith("ERR:")) {
                            string4 = "";
                        }
                        if ("SCRIPT".equals(string) || "STYLE".equals(string)) {
                            string4 = "";
                        }
                        if (string4.equals("")) break;
                        string4 = UtilMidp.replaceAll(string4, "\n", " ");
                        string4 = UtilMidp.replaceAll(string4, "&nbsp;", " ");
                        string4 = UtilMidp.decodeUnicode(string4);
                        if ("TITLE".equals(string)) {
                            this.title = string4;
                        }
                        if (string == null) {
                            this.htmlRender.addTag(199, "", null, string4);
                            ++this.a;
                            break;
                        }
                        if (htmlLink != null) {
                            htmlLink.setText(string4);
                        }
                        if (bl3) {
                            if ("OK".equals(string3)) {
                                this.addCommandOK(Language.getScriptLabel(string4), n3, string2);
                            } else if ("BACK".equals(string3)) {
                                this.addCommandBack(Language.getScriptLabel(string4), n3, string2);
                            } else if ("ITEM".equals(string3)) {
                                this.addCommandItem(Language.getScriptLabel(string4), n3, string2);
                            }
                        }
                        this.htmlRender.addText(this.a - 1, string4);
                        break;
                    }
                    case 3: {
                        String string4 = kXmlParser.getName().toUpperCase();
                        if (string4.equals("DIV")) {
                            if (bl4) {
                                bl4 = false;
                                this.subMenuHTML = null;
                                if (UtilMidp.isRIM()) {
                                    MenuItem menuItem = new MenuItem("--------------", 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE);
                                    this.listMenuItem.addElement(menuItem);
                                    this.currentCanvas.addCommand(menuItem);
                                }
                            } else {
                                bl2 = false;
                                bl3 = false;
                                string2 = null;
                                string3 = null;
                                n3 = -1;
                            }
                        } else if (string4.equals("A") && htmlLink != null) {
                            if (htmlLink.a == null && bl) {
                                this.htmlRender.a.removeElement(htmlLink);
                                for (int i = n2; i < this.a.size(); ++i) {
                                    this.a.removeElementAt(i);
                                }
                                this.a = n2;
                            }
                            htmlLink = null;
                        }
                        string = null;
                        if (!b.contains(string4)) break;
                        this.htmlRender.addTag(200 + b.indexOf(string4), "/" + string4, new Hashtable(), null);
                        ++this.a;
                        if (!vector2.isEmpty()) {
                            if (!string4.equals("FORM")) break;
                            Enumeration enumeration = vector2.elements();
                            while (enumeration.hasMoreElements()) {
                                this.htmlRender.addInputListForTagSubmit((Integer)enumeration.nextElement(), vector, n4);
                            }
                            n4 = -1;
                            vector = null;
                            vector2.removeAllElements();
                            break;
                        }
                        if (!string4.equals("SELECT")) break;
                        this.htmlRender.addOptionListForTagSelect(n5, vector3, vector);
                    }
                }
                n = kXmlParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            System.err.println("XmlPullParserException in HtmlBrowser.parseHTML\nCause : " + xmlPullParserException.getMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            UtilMidp.handleOutOfMemoryError();
        }
        catch (Exception exception) {
            UtilMidp.debugOutError("Exception in HtmlBrowser.parseHTML\nCause : " + exception.getMessage());
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                UtilMidp.handleOutOfMemoryError();
            }
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                System.err.println("IOException in HtmlBrowser.parseHTML\nCause : " + iOException.getMessage());
            }
            inputStreamReader = null;
        }
    }

    public void initUrl(String string) {
        int n = string.indexOf("/", string.startsWith("http://") ? "http://".length() : 0);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.currentRoot = string;
    }

    private void a(int n) {
        HtmlLink htmlLink = new HtmlLink(n);
        htmlLink.b = this.a.size();
        this.htmlRender.a.addElement(htmlLink);
    }

    public int getHudHeight() {
        if (!this.displayTitle) {
            return 0;
        }
        if (this.enabledSkin) {
            return imageHudBgLeft.getHeight();
        }
        return fontTitle.getHeight() > 16 ? fontTitle.getHeight() : 16;
    }

    public int getWidthRightInfo() {
        if (this.rightInfo == null) {
            return 0;
        }
        return UtilMidp.substringWidth(this.rightInfo, 0, this.rightInfo.length(), fontTitle) + 8;
    }

    private void a() {
        String string = null;
        Image image = null;
        this.b = 0;
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            BufferFile bufferFile;
            string = (String)enumeration.nextElement();
            image = (Image)this.a.get(string);
            if (image != imageWait || !(bufferFile = BufferFile.loadImage(string, false)).addFileListener(this)) continue;
            ++this.b;
        }
    }

    public void fileLoaded(BufferFile bufferFile) {
        Image image = bufferFile.getImage();
        bufferFile.unload();
        if (image == null) {
            image = WidgetCanvas.imgUnavailable;
        }
        if (this.a.get(bufferFile.name) == imageWait) {
            this.a.put(bufferFile.name, image);
        }
        if (bufferFile.removeFileListener(this)) {
            --this.b;
        }
        this.repaint(true);
    }

    public void keyPressed(int n, int n2) {
        if (this.htmlRender == null) {
            return;
        }
        if (this.htmlRender.a) {
            return;
        }
        if (this.typeRenderer == 1) {
            if (n == 49) {
                this.linkSelected(a);
                return;
            }
            if (n == 51) {
                this.linkSelected(b);
                return;
            }
            if (n2 == 8) {
                if (!keyNumUsed && n == 53) {
                    return;
                }
                if (!this.rssDescription && this.htmlRender.currentLinkIndex >= 0) {
                    if (this.htmlRender.currentLinkIndex < this.nbRSSTopics) {
                        this.rssDescription = true;
                        this.currentDescriptionIndex = this.htmlRender.currentLinkIndex;
                    }
                    this.htmlRender.nextLink(n2);
                    return;
                }
            }
            if (n2 == -2004318077) {
                if (this.rssDescription) {
                    HtmlLink htmlLink = new HtmlLink(12, null, "Back");
                    this.linkSelected(htmlLink);
                } else {
                    this.close();
                }
                return;
            }
        }
        if (n == 48) {
            this.currentCanvas.showView("prefs");
            return;
        }
        if (n2 == 1 || n2 == 6 || n2 == 2 || n2 == 5) {
            int n3;
            if (!keyNumUsed && (n2 == 2 && n == 52 || n2 == 5 && n == 54)) {
                return;
            }
            int n4 = this.htmlRender.h;
            this.b();
            if (n == 50) {
                for (n3 = 0; n3 < 4; ++n3) {
                    this.htmlRender.nextLink(1);
                }
            } else if (n == 56) {
                for (n3 = 0; n3 < 4; ++n3) {
                    this.htmlRender.nextLink(6);
                }
            } else {
                this.htmlRender.nextLink(n2);
            }
            if (n4 != this.htmlRender.h) {
                n3 = this.htmlRender.h - n4;
                this.htmlRender.h = n4;
                this.a = new SmoothScrolling(this, n3);
                return;
            }
        } else if (n2 == 8) {
            this.htmlRender.nextLink(n2);
        } else if (n == 42) {
            this.currentCanvas.refresh();
        } else if (n == 35 || n2 == -2004318076 || n2 == -2004318077) {
            if (this.currentCanvas.isDialogBoxDisplayed()) {
                this.currentCanvas.closeDialogBox();
            } else {
                this.close();
            }
            return;
        }
        this.repaint(false);
    }

    public void paint(Graphics graphics) {
        if (this.htmlRender == null || isParsing) {
            return;
        }
        isPainting = true;
        graphics.setClip(this.htmlRender.a - 2, this.htmlRender.b, this.htmlRender.a + this.htmlRender.c + 2, this.htmlRender.d);
        this.htmlRender.render(graphics);
        this.a(graphics);
        this.b(graphics);
        graphics.setClip(0, 0, WidgetCanvas.canvasWidth, WidgetCanvas.canvasHeight);
        this.stopRender = false;
        if (this.updateRender) {
            this.updateRender = false;
            if (this.computeAll) {
                this.computeAll = false;
                this.htmlRender.firstPaint();
            }
            this.currentCanvas.repaint();
        }
        isPainting = false;
    }

    private void a(Graphics graphics) {
        if (this.stopRender || this.htmlRender != null && this.htmlRender.i <= 0 || !this.b || this.htmlRender.i <= this.htmlRender.d) {
            return;
        }
        if (!displayScrollBar) {
            return;
        }
        int n = this.htmlRender.a + this.htmlRender.c + 2 - imageTopLift.getWidth() - 1;
        int n2 = this.htmlRender.d - (this.displayHeader ? this.htmlRender.g : 0);
        int n3 = n2 * n2 / this.htmlRender.i;
        int n4 = (this.displayHeader ? this.htmlRender.g : 0) + imageTopLift.getHeight() + this.htmlRender.b + -this.htmlRender.h * n2 / this.htmlRender.i;
        int n5 = n4 + n3;
        graphics.drawImage(imageTopLift, n, n4 - imageTopLift.getHeight(), 20);
        graphics.drawRegion(imageTopLift, 0, 0, imageTopLift.getWidth(), imageTopLift.getHeight(), 3, n, n5, 20);
        graphics.setColor(0xA6A6A6);
        graphics.fillRect(n, n4, imageTopLift.getWidth(), n3);
    }

    private void b(Graphics graphics) {
        if (this.stopRender || !this.navLeftRight) {
            return;
        }
        this.c = 0;
        if (this.typeRenderer == 1) {
            if (this.rssDescription) {
                if (this.currentDescriptionIndex > 0) {
                    this.c |= 0x10;
                }
                if (this.currentDescriptionIndex < this.nbRSSTopics - 1) {
                    this.c |= 0x20;
                }
            } else {
                if (this.d > 0) {
                    this.c |= 0x10;
                }
                if (this.d < this.e - 1) {
                    this.c |= 0x20;
                }
            }
            if (this.c == 0) {
                return;
            }
            if (this.imageArrowsBg == null) {
                this.imageArrowsBg = !UtilMidp.isRIM() ? UtilMidp.getBlendRect(26, 19, this.menuHTML.colorBg, this.menuHTML.opacity, true) : UtilMidp.getBlendRect(26, 19, 0x3B3B3B, 229, true);
            }
            int n = WidgetCanvas.canvasWidth - 26 >> 1;
            int n2 = WidgetCanvas.canvasHeight - 17;
            UtilMidp.drawRegion(graphics, this.imageArrowsBg, 0, 0, 26, 17, n, n2, 20);
            UtilMidp.drawRegion(graphics, imageArrows, (this.c & 0x10) != 0 ? 0 : 14, 0, 7, 9, n + 4, n2 += 4, 20);
            UtilMidp.drawRegion(graphics, imageArrows, (this.c & 0x20) != 0 ? 7 : 21, 0, 7, 9, n + 15, n2, 20);
        }
    }

    public void pointerPressed(int n, int n2) {
        this.f = 0;
        this.g = n;
        this.h = n2;
        this.i = n2;
    }

    public void pointerDragged(int n, int n2) {
        this.htmlRender.h -= this.i - n2;
        this.i = n2;
        if (n != this.g || this.h != n2) {
            ++this.f;
        }
        this.a = true;
        this.htmlRender.checkLimitScroll();
        this.repaint(false);
    }

    public void pointerReleased(int n, int n2) {
        block2: {
            block1: {
                int n3;
                block3: {
                    this.a = false;
                    if (this.f <= 3) break block1;
                    if (this.typeRenderer != 1) break block2;
                    n3 = n - this.g;
                    if (n3 >= -30) break block3;
                    this.keyPressed(49, 0);
                    break block2;
                }
                if (n3 <= 30) break block2;
                this.keyPressed(51, 0);
                break block2;
            }
            int n4 = this.htmlRender.a.size();
            for (int i = 0; i < n4; ++i) {
                HtmlLink htmlLink = (HtmlLink)this.htmlRender.a.elementAt(i);
                if (n < htmlLink.c || n > htmlLink.f || n2 < htmlLink.d + this.htmlRender.h || n2 > htmlLink.e + this.htmlRender.h) continue;
                this.htmlRender.currentLinkIndex = i;
                this.keyPressed(0, 8);
                break;
            }
        }
        this.repaint(false);
    }

    public String getValueById(String string) {
        return this.htmlRender.getInputValueById(string);
    }

    public String getValueByName(String string) {
        return this.htmlRender.getInputValueByName(string);
    }

    public String getSelectedValueByName(String string) {
        return this.htmlRender.getSelectedValueByName(string);
    }

    public String isCheckedByName(String string) {
        return this.htmlRender.isChecked(string, "NAME");
    }

    public String isCheckedById(String string) {
        return this.htmlRender.isChecked(string, "ID");
    }

    public String getSelectedLinkPos() {
        return "" + this.htmlRender.currentLinkIndex;
    }

    public String getSelectedLinkHRef() {
        if (this.htmlRender.currentLinkIndex == -1) {
            return null;
        }
        HtmlLink htmlLink = (HtmlLink)this.htmlRender.a.elementAt(this.htmlRender.currentLinkIndex);
        return htmlLink.getUrl();
    }

    public Vector getListInput(String string) {
        return this.htmlRender.getListInputTagByRef(string.toUpperCase());
    }

    private void b() {
        if (this.a != null && this.a.isAlive()) {
            this.a.stop();
            this.a = null;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class SmoothScrolling
    extends Thread {
        public int a;
        public boolean a;
        private final HtmlBrowser a;

        public SmoothScrolling(HtmlBrowser htmlBrowser, int n) {
            this.a = htmlBrowser;
            this.a = 0;
            this.a = false;
            this.a = n;
            displayScrollBar = true;
            this.start();
        }

        public void stop() {
            this.a.htmlRender.h -= this.a;
            this.a = 0;
            this.a = true;
        }

        public void run() {
            while (this.a != 0) {
                int n = this.a >> 3;
                if (n == 0) {
                    n = this.a < 0 ? -1 : 1;
                }
                this.a -= n;
                this.a.htmlRender.h += n;
                this.a.htmlRender.checkLimitScroll();
                if (this.a.htmlRender.topReached || this.a.htmlRender.bottomReached) {
                    this.stop();
                    this.a = false;
                }
                this.a.repaint(false);
                try {
                    SmoothScrolling.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    SmoothScrolling.yield();
                }
                if (this.a.widgetInitialized != null) continue;
                return;
            }
            displayScrollBar = this.a;
            this.a.repaint(false);
        }
    }
}

