/*
 * Decompiled with CFR 0.152.
 */
public class Record
implements Runnable {
    static final int EVENTO_PULSAR_CUERDA = 0;
    static final int EVENTO_PULSAR_TRASTE = 1;
    static final int EVENTO_DESPLAZAR_TRASTE = 2;
    static boolean ALGUN_RECORD_ACTUALIZADO = false;
    private Guitarra guitarra;
    private String titulo;
    private int dim;
    private int longitud;
    private int longitudAnterior;
    private int indice;
    private int[] espaciado;
    private int[] evento;
    private int[] dato;
    private boolean grabando;
    private boolean reproduciendo;
    private long tiempo;

    public Record(int dim, Guitarra guitarra) {
        this.guitarra = guitarra;
        this.dim = dim;
        this.titulo = "";
        this.longitud = 0;
        this.espaciado = new int[dim];
        this.evento = new int[dim];
        this.dato = new int[dim];
        this.grabando = false;
        this.reproduciendo = false;
    }

    public void init(String data) {
        int iPos2;
        int idato = -1;
        int iPos = 0;
        int indice = 0;
        while ((iPos2 = data.indexOf("|", iPos)) > -1) {
            switch (idato) {
                case -1: {
                    this.titulo = data.substring(iPos, iPos2);
                    break;
                }
                case 0: {
                    this.espaciado[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 1: {
                    this.evento[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 2: {
                    this.dato[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    ++indice;
                }
            }
            if (++idato > 2) {
                idato = 0;
            }
            iPos = iPos2 + 1;
        }
        this.longitud = indice;
        indice = 0;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public String getDescripcion() {
        return String.valueOf(new String(this.titulo.length() > 0 ? this.titulo : Idioma.texto_sin_titulo[this.guitarra.getIdioma()])) + new String(this.longitud > 0 ? " (" + String.valueOf(this.getNotas()) + " " + Idioma.texto_notas[this.guitarra.getIdioma()] + ")" : " (" + Idioma.texto_vacio[this.guitarra.getIdioma()] + ")");
    }

    public int getLongitud() {
        return this.longitud;
    }

    public int getNotas() {
        int notas = 0;
        int i = 0;
        while (i < this.longitud) {
            if (this.evento[i] == 0) {
                ++notas;
            }
            ++i;
        }
        return notas;
    }

    public boolean reproduciendo() {
        return this.reproduciendo;
    }

    public boolean grabando() {
        return this.grabando;
    }

    public boolean enPausa() {
        return !this.reproduciendo && !this.grabando;
    }

    public void grabar() {
        this.longitudAnterior = this.longitud;
        this.longitud = 0;
        this.indice = 0;
        this.grabando = true;
        this.reproduciendo = false;
        this.tiempo = System.currentTimeMillis();
    }

    public void reproducir() {
        this.indice = 0;
        this.reproduciendo = true;
        this.grabando = false;
        new Thread(this).start();
    }

    public void parar() {
        if (this.grabando) {
            if (this.longitud > 0) {
                this.guitarra.crearListaTracks();
                ALGUN_RECORD_ACTUALIZADO = true;
            } else {
                this.longitud = this.longitudAnterior;
            }
        }
        this.reproduciendo = false;
        this.grabando = false;
    }

    public void borrar() {
        this.titulo = "";
        this.longitud = 0;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public void restaurar(int melodia) {
        switch (melodia) {
            case 0: {
                this.init("vutaikt@4T\u2122|843|1|0|0|1|20|0|1|41|0|1|63|0|1|84|0|1|103|0|2|1|772|0|2|310|0|3|310|0|4|300|0|5|509|1|0|0|1|21|0|1|43|0|1|63|0|1|83|0|1|101|0|2|1|422|0|1|298|0|2|302|0|3|289|0|4|430|1|0|0|1|23|0|1|45|0|1|65|0|1|84|0|1|103|0|2|1|466|0|1|305|0|2|306|0|3|309|0|4|376|1|3|0|1|25|0|1|45|0|1|63|0|1|83|0|1|103|0|2|1|443|0|0|303|0|1|302|0|2|312|0|3|356|1|4|0|1|23|0|1|41|0|1|61|0|1|81|0|1|104|0|2|1|465|0|0|306|0|1|305|0|2|329|0|3|432|1|0|0|1|20|0|1|41|0|1|63|0|1|84|0|1|103|0|2|1|416|0|2|318|0|3|291|0|4|333|0|5|381|1|1|0|1|23|0|1|43|0|1|61|0|1|81|0|1|101|0|2|1|460|0|0|315|0|1|303|0|2|323|0|3|441|1|0|0|1|21|0|1|43|0|1|63|0|1|83|0|1|101|0|2|1|415|0|1|299|0|2|316|0|3|301|0|4|459|1|0|0|1|20|0|1|41|0|1|63|0|1|84|0|1|103|0|2|1|486|0|2|28|0|3|26|0|4|32|0|5|614|1|0|0|1|21|0|1|43|0|1|63|0|1|83|0|1|101|0|2|1|412|0|2|1|0|1|52|0|3|49|0|4|43|0|5|463|1|0|0|1|23|0|1|45|0|1|65|2|1|84|0|1|103|0|2|1|429|0|1|32|0|2|21|0|3|34|0|4|48|0|5|333|1|3|0|1|25|0|1|45|0|1|63|0|1|83|0|1|103|0|2|1|335|0|0|8|0|1|47|0|2|17|0|3|35|0|4|42|0|5|313|1|4|0|1|23|0|1|41|0|1|61|0|1|81|0|1|104|0|2|1|353|0|0|4|0|1|26|0|2|31|0|3|44|0|4|51|0|5|567|1|0|0|1|20|0|1|41|0|1|63|0|1|84|0|1|103|0|2|1|462|0|2|47|0|3|60|0|4|61|0|5|469|1|1|0|1|23|0|1|43|0|1|61|0|1|81|0|1|101|0|2|1|507|0|0|39|0|1|48|0|2|46|0|3|52|0|4|16|0|5|610|1|0|0|1|21|1|1|43|0|1|63|0|1|83|0|1|101|0|2|1|504|0|1|17|0|2|47|0|3|40|0|4|52|0|5|");
                break;
            }
            default: {
                this.borrar();
            }
        }
    }

    public void grabarEvento(int evento, int dato) {
        if (this.indice < this.dim) {
            this.espaciado[this.indice] = (int)(System.currentTimeMillis() - this.tiempo);
            this.evento[this.indice] = evento;
            this.dato[this.indice] = dato;
            ++this.indice;
            this.longitud = this.indice;
        } else {
            this.parar();
        }
        this.tiempo = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.longitud > 0) {
            sb.append(this.titulo).append("|");
            int i = 0;
            while (i < this.longitud) {
                sb.append(this.espaciado[i]).append("|");
                sb.append(this.evento[i]).append("|");
                sb.append(this.dato[i]).append("|");
                ++i;
            }
        } else {
            sb.append(this.titulo);
        }
        return sb.toString();
    }

    public void run() {
        this.tiempo = System.currentTimeMillis();
        while (this.indice < this.longitud && this.reproduciendo) {
            while (System.currentTimeMillis() - this.tiempo < (long)this.espaciado[this.indice] && this.reproduciendo) {
            }
            if (this.reproduciendo) {
                this.tiempo = System.currentTimeMillis();
                switch (this.evento[this.indice]) {
                    case 0: {
                        this.guitarra.getCuerdas().activarCuerda(this.dato[this.indice]);
                        break;
                    }
                    case 1: {
                        int cuerda = this.dato[this.indice] / 20;
                        int traste = this.dato[this.indice] % 20;
                        this.guitarra.getCuerdas().setTraste(cuerda, traste - 1);
                        break;
                    }
                    case 2: {
                        this.guitarra.getCuerdas().setTraste(this.dato[this.indice]);
                        break;
                    }
                }
            }
            ++this.indice;
        }
        this.parar();
        this.guitarra.getCuerdas().repintarBarra();
    }
}

