/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.List;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class MenuBar
extends Container
implements ActionListener {
    private Command selectCommand;
    private Command defaultCommand;
    private Command backCommand;
    private Command clearCommand;
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private Command menuCommand;
    private Vector commands = new Vector();
    private Button[] soft;
    private Command[] softCommand;
    private Button left;
    private Button right;
    private Button main;
    private ListCellRenderer menuCellRenderer;
    private Transition transitionIn;
    private Transition transitionOut;
    private Component commandList;
    private Style menuStyle;
    private Command selectMenuItem;
    private Command cancelMenuItem;
    private Form parent;
    private int softkeyCount;
    private boolean thirdSoftButton;

    protected void initMenuBar(Form form) {
        this.parent = form;
        this.selectMenuItem = this.createMenuSelectCommand();
        this.cancelMenuItem = this.createMenuCancelCommand();
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        this.setUIID("SoftButton");
        this.menuCommand = new Command(UIManager.getInstance().localize("menu", "Menu"), lookAndFeel.getMenuIcons()[2]);
        if (lookAndFeel.getDefaultMenuTransitionIn() != null || lookAndFeel.getDefaultMenuTransitionOut() != null) {
            this.transitionIn = lookAndFeel.getDefaultMenuTransitionIn();
            this.transitionOut = lookAndFeel.getDefaultMenuTransitionOut();
        } else {
            this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
            this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
        }
        this.menuCellRenderer = lookAndFeel.getMenuRenderer();
        this.softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
        this.thirdSoftButton = Display.getInstance().isThirdSoftButton();
        int n = this.getCommandBehavior();
        if (this.softkeyCount > 1 && n < 4) {
            Button button;
            if (this.thirdSoftButton) {
                this.setLayout(new GridLayout(1, 3));
                this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[1];
                this.right = this.soft[2];
                if (form.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.main);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.main);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    button = this.soft[1];
                    this.soft[1] = this.soft[2];
                    this.soft[2] = button;
                }
            } else {
                this.setLayout(new GridLayout(1, 2));
                this.soft = new Button[]{this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[0];
                this.right = this.soft[1];
                if (form.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    button = this.soft[0];
                    this.soft[0] = this.soft[1];
                    this.soft[1] = button;
                }
            }
            for (int i = 0; i < this.soft.length; ++i) {
                this.soft[i].setEndsWith3Points(false);
            }
        } else if (this.thirdSoftButton) {
            this.setLayout(new GridLayout(1, 3));
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
            this.main = this.soft[0];
            this.left = this.soft[1];
            this.right = this.soft[2];
            this.addComponent(this.left);
            this.addComponent(this.main);
            this.addComponent(this.right);
            if (this.isReverseSoftButtons()) {
                Button button = this.soft[1];
                this.soft[1] = this.soft[2];
                this.soft[2] = button;
            }
        } else {
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter")};
        }
        this.softCommand = new Command[this.soft.length];
    }

    private int getCommandBehavior() {
        int n = Display.getInstance().getCommandBehavior();
        if (Display.getInstance().getImplementation().getSoftkeyCount() == 0) {
            if (n != 4 && n != 5 && n != 6) {
                return 5;
            }
            return n;
        }
        if (n == 1) {
            if (Display.getInstance().isTouchScreenDevice()) {
                return 3;
            }
            return 2;
        }
        return n;
    }

    public void setDefaultCommand(Command command) {
        this.defaultCommand = command;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command command) {
        this.clearCommand = command;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    public void setBackCommand(Command command) {
        this.backCommand = command;
        int n = this.getCommandBehavior();
        if (n == 5 && !(this.parent instanceof Dialog)) {
            Component component;
            Container container = this.parent.getTitleArea();
            ((BorderLayout)container.getLayout()).setCenterBehavior(2);
            Button button = null;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                component = container.getComponentAt(i);
                if (!(component instanceof Button)) continue;
                button = (Button)component;
                break;
            }
            if (command == null) {
                if (button != null) {
                    container.removeComponent(button);
                    BorderLayout borderLayout = new BorderLayout();
                    container.setLayout(borderLayout);
                    component = container.getComponentAt(0);
                    container.removeComponent(component);
                    container.addComponent("Center", component);
                }
            } else {
                if (button == null) {
                    button = new Button(command);
                    button.setUIID("BackCommand");
                    container.addComponent("West", (Component)button);
                } else {
                    button.setCommand(command);
                }
                this.removeCommand(command);
            }
        }
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    public Command getSelectCommand() {
        return this.selectCommand;
    }

    public void setSelectCommand(Command command) {
        this.selectCommand = command;
    }

    private void updateCommands() {
        int n = this.getCommandBehavior();
        if (n == 10) {
            Display.getInstance().getImplementation().setNativeCommands(this.commands);
            return;
        }
        if (n >= 4) {
            return;
        }
        if (this.soft.length > 1) {
            this.soft[0].setText("");
            this.soft[1].setText("");
            this.soft[0].setIcon(null);
            this.soft[1].setIcon(null);
            int n2 = this.getCommandCount();
            if (this.soft.length > 2) {
                this.soft[2].setText("");
                if (n2 > 2) {
                    this.softCommand[2] = n2 > 3 ? this.menuCommand : this.getCommand(this.getCommandCount() - 3);
                    this.soft[2].setText(this.softCommand[2].getCommandName());
                    this.soft[2].setIcon(this.softCommand[2].getIcon());
                } else {
                    this.softCommand[2] = null;
                }
            }
            if (n2 > 0) {
                this.softCommand[0] = this.getCommand(this.getCommandCount() - 1);
                this.soft[0].setText(this.softCommand[0].getCommandName());
                this.soft[0].setIcon(this.softCommand[0].getIcon());
                if (n2 > 1) {
                    this.softCommand[1] = this.soft.length == 2 && n2 > 2 ? this.menuCommand : this.getCommand(this.getCommandCount() - 2);
                    this.soft[1].setText(this.softCommand[1].getCommandName());
                    this.soft[1].setIcon(this.softCommand[1].getIcon());
                } else {
                    this.softCommand[1] = null;
                }
            } else {
                this.softCommand[0] = null;
                this.softCommand[1] = null;
            }
            if (n2 == 1 && this.parent.isVisible()) {
                this.parent.revalidate();
            }
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.isConsumed()) {
            return;
        }
        Object object = actionEvent.getSource();
        if (this.commandList == null) {
            Button button = (Button)object;
            for (int i = 0; i < this.soft.length; ++i) {
                if (button != this.soft[i]) continue;
                if (this.softCommand[i] == this.menuCommand) {
                    this.showMenu();
                    return;
                }
                if (this.softCommand[i] != null) {
                    ActionEvent actionEvent2 = new ActionEvent(this.softCommand[i]);
                    this.softCommand[i].actionPerformed(actionEvent2);
                    if (!actionEvent2.isConsumed()) {
                        this.parent.actionCommandImpl(this.softCommand[i]);
                    }
                }
                return;
            }
        } else {
            Command command;
            Container container;
            if (object instanceof Button) {
                for (int i = 0; i < this.soft.length; ++i) {
                    if (object != this.soft[i]) continue;
                    for (container = this.commandList.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof Dialog)) continue;
                        ((Dialog)container).actionCommand(this.softCommand[i]);
                        return;
                    }
                }
            }
            if (!(command = this.getComponentSelectedCommand(this.commandList)).isEnabled()) {
                return;
            }
            for (container = this.commandList.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Dialog)) continue;
                ((Dialog)container).actionCommand(command);
                return;
            }
        }
    }

    protected Button createSoftButton(String string) {
        Button button = new Button();
        button.setUIID(string);
        button.addActionListener(this);
        button.setFocusable(false);
        button.setTactileTouch(true);
        this.updateSoftButtonStyle(button);
        return button;
    }

    private void updateSoftButtonStyle(Button button) {
        if (this.softkeyCount < 2) {
            button.getStyle().setMargin(0, 0, 0, 0);
            button.getStyle().setPadding(0, 0, 0, 0);
        }
    }

    public void setUnselectedStyle(Style style) {
        style.setMargin(0, 0, true);
        style.setMargin(2, 0, true);
        super.setUnselectedStyle(style);
        if (this.soft != null) {
            for (int i = 0; i < this.soft.length; ++i) {
                this.updateSoftButtonStyle(this.soft[i]);
            }
        }
    }

    protected Dimension calcPreferredSize() {
        if (this.soft.length > 1) {
            Dimension dimension = super.calcPreferredSize();
            if (!(this.soft[0].getText() != null && !this.soft[0].getText().equals("") || this.soft[1].getText() != null && !this.soft[1].getText().equals("") || this.soft[0].getIcon() != null || this.soft[1].getIcon() != null || this.soft.length >= 3 && (this.soft[2].getText() != null && !this.soft[2].getText().equals("") || this.soft[2].getIcon() != null))) {
                dimension.setHeight(0);
            }
            return dimension;
        }
        return super.calcPreferredSize();
    }

    public void setTransitions(Transition transition, Transition transition2) {
        this.transitionIn = transition;
        this.transitionOut = transition2;
    }

    public void showMenu() {
        Object object;
        Command command;
        Dialog dialog = new Dialog("Menu", "");
        dialog.setDisposeWhenPointerOutOfBounds(true);
        dialog.setMenu(true);
        dialog.setTransitionInAnimator(this.transitionIn);
        dialog.setTransitionOutAnimator(this.transitionOut);
        dialog.setLayout(new BoxLayout(2));
        dialog.setScrollable(false);
        dialog.getMenuBar().commandList = this.createCommandComponent(this.commands);
        if (this.menuCellRenderer != null && dialog.getMenuBar().commandList instanceof List) {
            ((List)dialog.getMenuBar().commandList).setListCellRenderer(this.menuCellRenderer);
        }
        dialog.getContentPane().getStyle().setMargin(0, 0, 0, 0);
        dialog.addComponent(dialog.getMenuBar().commandList);
        if (this.thirdSoftButton) {
            dialog.addCommand(this.selectMenuItem);
            dialog.addCommand(this.cancelMenuItem);
        } else {
            dialog.addCommand(this.cancelMenuItem);
            if (this.soft.length > 1) {
                dialog.addCommand(this.selectMenuItem);
            }
        }
        dialog.setClearCommand(this.cancelMenuItem);
        dialog.setBackCommand(this.cancelMenuItem);
        if (dialog.getMenuBar().commandList instanceof List) {
            ((List)dialog.getMenuBar().commandList).addActionListener(dialog.getMenuBar());
        }
        if ((command = this.showMenuDialog(dialog)) != this.cancelMenuItem) {
            object = null;
            if (command == this.selectMenuItem) {
                object = this.getComponentSelectedCommand(dialog.getMenuBar().commandList);
                if (object != null) {
                    ActionEvent actionEvent = new ActionEvent(object);
                    ((Command)object).actionPerformed(actionEvent);
                }
            } else {
                object = command;
                if (!UIManager.getInstance().getLookAndFeel().isTouchMenus() && (object = command) != null) {
                    ActionEvent actionEvent = new ActionEvent(object);
                    ((Command)object).actionPerformed(actionEvent);
                }
            }
            if (object != null) {
                this.parent.actionCommandImpl((Command)object);
            }
        }
        if (dialog.getMenuBar().commandList instanceof List) {
            ((List)dialog.getMenuBar().commandList).removeActionListener(dialog.getMenuBar());
        }
        if ((object = Display.getInstance().getCurrentUpcoming()) == this.parent) {
            dialog.disposeImpl();
        } else {
            this.parent.tint = object instanceof Dialog;
        }
    }

    Button[] getSoftButtons() {
        return this.soft;
    }

    public void addCommand(Command command) {
        int n;
        if (this.commands.contains(command)) {
            return;
        }
        if (this.soft.length > 2 && this.parent.getDefaultCommand() != null && command == this.parent.getDefaultCommand()) {
            this.commands.addElement(command);
        } else {
            this.commands.insertElementAt(command, 0);
        }
        if (!(this.parent instanceof Dialog || (n = this.getCommandBehavior()) != 4 && n != 5 && n != 6)) {
            if (n == 5 && command == this.parent.getBackCommand()) {
                return;
            }
            if (this.parent.getBackCommand() != command) {
                this.setLayout(new BoxLayout(2));
                this.addComponent(this.createTouchCommandButton(command));
            } else {
                this.commands.removeElement(command);
            }
            return;
        }
        this.updateCommands();
    }

    public Command getCommand(int n) {
        return (Command)this.commands.elementAt(n);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    protected void addCommand(Command command, int n) {
        int n2;
        if (this.getCommandCount() == 0 && this.parent != null) {
            this.installMenuBar();
        }
        if (this.commands.contains(command)) {
            return;
        }
        this.commands.insertElementAt(command, n);
        if (!(this.parent instanceof Dialog || (n2 = this.getCommandBehavior()) != 4 && n2 != 5 && n2 != 6)) {
            if (n2 == 5 && command == this.parent.getBackCommand()) {
                return;
            }
            if (this.parent.getBackCommand() != command) {
                this.setLayout(new BoxLayout(2));
                this.addComponent(n, (Component)this.createTouchCommandButton(command));
            } else {
                this.commands.removeElement(command);
            }
            return;
        }
        this.updateCommands();
    }

    protected void installMenuBar() {
        if (this.getParent() == null) {
            int n = Display.getInstance().getCommandBehavior();
            if (n == 6) {
                this.parent.getTitleArea().addComponent("East", (Component)this);
                return;
            }
            if (this.softkeyCount > 1 || n == 4 || n == 5) {
                this.parent.addComponentToForm("South", this);
            }
        }
    }

    protected void unInstallMenuBar() {
        this.parent.removeComponentFromForm(this);
    }

    protected void removeAllCommands() {
        this.commands.removeAllElements();
        int n = this.getCommandBehavior();
        if (n == 4 || n == 5 || n == 6) {
            this.removeAll();
            return;
        }
        this.updateCommands();
    }

    protected void removeCommand(Command command) {
        int n = this.getCommandBehavior();
        if (n == 4 || n == 5 || n == 6) {
            int n2 = this.commands.indexOf(command);
            if (n2 > -1) {
                this.commands.removeElementAt(n2);
                this.removeComponent(this.getComponentAt(n2));
                if (this.getCommandCount() > 0) {
                    this.setLayout(new GridLayout(1, this.getCommandCount()));
                }
            }
            return;
        }
        this.commands.removeElement(command);
        this.updateCommands();
    }

    void addSelectCommand(String string) {
        if (this.thirdSoftButton) {
            if (this.selectCommand == null) {
                this.selectCommand = this.createSelectCommand();
            }
            this.selectCommand.setCommandName(string);
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (this.thirdSoftButton) {
            this.removeCommand(this.selectCommand);
        }
    }

    protected Command createSelectCommand() {
        return new Command(UIManager.getInstance().localize("select", "Select"));
    }

    protected Command createMenuSelectCommand() {
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("select", "Select"), lookAndFeel.getMenuIcons()[0]);
    }

    protected Command createMenuCancelCommand() {
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("cancel", "Cancel"), lookAndFeel.getMenuIcons()[1]);
    }

    public void setMenuCellRenderer(ListCellRenderer listCellRenderer) {
        this.menuCellRenderer = listCellRenderer;
    }

    public Style getMenuStyle() {
        return this.menuStyle;
    }

    static boolean isLSK(int n) {
        return n == leftSK;
    }

    static boolean isRSK(int n) {
        return n == rightSK || n == rightSK2;
    }

    public boolean handlesKeycode(int n) {
        int n2 = Display.getInstance().getGameAction(n);
        return n == leftSK || n == rightSK || n == rightSK2 || n == backSK || n == clearSK && this.clearCommand != null || n == backspaceSK && this.clearCommand != null || this.thirdSoftButton && n2 == 8;
    }

    public void keyPressed(int n) {
        int n2 = this.getCommandBehavior();
        if (n2 >= 4) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (n == leftSK) {
                if (this.left != null) {
                    this.left.pressed();
                }
            } else if (n == rightSK || n == rightSK2) {
                if (this.right != null) {
                    this.right.pressed();
                }
            } else if (Display.getInstance().getGameAction(n) == 8) {
                this.main.pressed();
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getCommandBehavior();
        if (n2 >= 4 && n != backSK && n != clearSK && n != backspaceSK) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (this.softkeyCount < 2 && n == leftSK) {
                if (this.commandList != null) {
                    for (Container container = this.commandList.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof Dialog) || !((Dialog)container).isMenu()) continue;
                        return;
                    }
                }
                this.showMenu();
                return;
            }
            if (n == leftSK) {
                if (this.left != null) {
                    this.left.released();
                }
                return;
            }
            if (n == rightSK || n == rightSK2) {
                if (this.right != null) {
                    this.right.released();
                }
                return;
            }
            if (Display.getInstance().getGameAction(n) == 8) {
                this.main.released();
                return;
            }
        }
        Command command = null;
        if (n == backSK) {
            command = this.parent.getBackCommand();
        } else if (n == clearSK || n == backspaceSK) {
            command = this.getClearCommand();
        }
        if (command != null) {
            ActionEvent actionEvent = new ActionEvent(command, n);
            command.actionPerformed(actionEvent);
            if (!actionEvent.isConsumed()) {
                this.parent.actionCommandImpl(command);
            }
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        if (this.menuStyle.isModified()) {
            this.menuStyle.merge(UIManager.getInstance().getComponentStyle("Menu"));
        } else {
            this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        }
        if (this.menuCellRenderer != null) {
            List list = new List();
            list.setListCellRenderer(this.menuCellRenderer);
            list.refreshTheme();
        }
        for (int i = 0; i < this.soft.length; ++i) {
            this.updateSoftButtonStyle(this.soft[i]);
        }
        this.revalidate();
    }

    protected Command showMenuDialog(Dialog dialog) {
        int n;
        int n2;
        boolean bl = UIManager.getInstance().isThemeConstant("menuPrefSizeBool", false);
        int n3 = 0;
        if (bl) {
            Container container = dialog.getDialogComponent();
            n2 = this.parent.getWidth() - (container.getPreferredW() + dialog.getStyle().getPadding(1) + dialog.getStyle().getPadding(3));
            n2 = Math.max(0, n2);
            n = this.parent.getSoftButtonCount() > 1 ? this.parent.getHeight() - this.parent.getSoftButton(0).getParent().getPreferredH() - container.getPreferredH() : this.parent.getHeight() - container.getPreferredH();
            n = Math.max(0, n);
        } else {
            float f = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuWidthPercent", "75")) / 100.0f;
            float f2 = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuHeightPercent", "50")) / 100.0f;
            n = (int)((float)this.parent.getHeight() * f2);
            n2 = (int)((float)this.parent.getWidth() * f);
        }
        if (this.isReverseSoftButtons()) {
            n3 = n2;
            n2 = 0;
        }
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus() && UIManager.getInstance().isThemeConstant("PackTouchMenuBool", true)) {
            return dialog.showPacked("South", true);
        }
        return dialog.show(n, 0, n2, n3, true);
    }

    protected boolean isReverseSoftButtons() {
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        if (this.isRTL()) {
            return !lookAndFeel.isReverseSoftButtons();
        }
        return lookAndFeel.isReverseSoftButtons();
    }

    protected int calculateTouchCommandGridColumns(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponentAt(i);
            Style style = component.getUnselectedStyle();
            n2 = Math.max(n2, component.getPreferredW() + style.getMargin(false, 1) + style.getMargin(false, 3));
        }
        return Math.max(2, Display.getInstance().getDisplayWidth() / n2);
    }

    protected Button createTouchCommandButton(Command command) {
        Button button = new Button(command);
        if (button.getIcon() == null) {
            // empty if block
        }
        button.getUnselectedStyle().setBgColor(0xF1F1F1);
        button.getUnselectedStyle().setFgColor(0x444444);
        button.getSelectedStyle().setBgColor(0x444444);
        button.getSelectedStyle().setFgColor(0xF1F1F1);
        button.setTactileTouch(true);
        button.setTextPosition(2);
        button.setUIID("TouchCommand");
        return button;
    }

    protected Component createCommandComponent(Vector vector) {
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            // empty if block
        }
        return this.createCommandList(vector);
    }

    protected Vector getCommands() {
        return this.commands;
    }

    protected List createCommandList(Vector vector) {
        List list = new List(vector);
        list.setUIID("CommandList");
        Component component = (Component)((Object)list.getRenderer());
        component.setUIID("Command");
        component = list.getRenderer().getListFocusComponent(list);
        component.setUIID("CommandFocus");
        list.setPreferredW(Display.getInstance().getDisplayWidth());
        list.setFixedSelection(1);
        if (UIManager.getInstance().isThemeConstant("menuPrefSizeBool", false)) {
            list.setListSizeCalculationSampleCount(50);
        }
        return list;
    }

    Command getComponentSelectedCommand(Component component) {
        if (component instanceof List) {
            List list = (List)component;
            return (Command)list.getSelectedItem();
        }
        if ((component = component.getComponentForm().getFocused()) instanceof Button) {
            return ((Button)component).getCommand();
        }
        return null;
    }

    protected Command getSelectMenuItem() {
        return this.selectMenuItem;
    }

    protected Command getCancelMenuItem() {
        return this.cancelMenuItem;
    }

    static {
        if (Display.getInstance() == null || Display.getInstance().getImplementation() == null) {
            leftSK = -6;
            rightSK = -7;
            rightSK2 = -7;
            backSK = -11;
            clearSK = -8;
            backspaceSK = -8;
        }
    }
}

