/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.painter;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;

public class BackgroundPainter
implements Painter {
    private Component parent;

    public BackgroundPainter(Component component) {
        this.parent = component;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        Style style = this.parent.getStyle();
        int n = rectangle.getX();
        int n2 = rectangle.getY();
        int n3 = rectangle.getSize().getWidth();
        int n4 = rectangle.getSize().getHeight();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Image image = style.getBgImage();
        if (image == null) {
            graphics.setColor(style.getBgColor());
            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
        } else {
            if (style.getBackgroundType() == 1) {
                if (image.getWidth() != n3 || image.getHeight() != n4) {
                    image = image.scaled(n3, n4);
                    style.setBgImage(image, true);
                }
            } else {
                int n5 = image.getWidth();
                int n6 = image.getHeight();
                for (int i = 0; i < n3; i += n5) {
                    for (int j = 0; j < n4; j += n6) {
                        graphics.drawImage(style.getBgImage(), n + i, n2 + j);
                    }
                }
                return;
            }
            graphics.drawImage(style.getBgImage(), n, n2);
        }
    }
}

