/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import core.ListModel;
import core.VideoCanvas;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import framework.XMLNode;
import framework.XMLParser;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class PhotoManager
implements ActionListener,
NetworkListener,
CommandListener {
    VideoControl mVideoControl;
    Player mPlayer;
    byte[] _recentCapture = null;
    Vector _chkList;
    Hashtable _listTable;
    Form frmShare;
    Form _frmAlbumList;
    Form _frmChoose;
    Button btnShareMyPeople;
    Button btnShareMyGroups;
    Button btnTakePhoto;
    Command cmdBack;
    Command cmdOpen;
    Command cmdDoShare;
    String _sharingType;
    String _shareItemID;
    XMLParser _xmlParser;
    Common _common;
    ListModel _listModel;
    int _operation = -1;
    static int SHOW_ALBUMS = 1;
    static int UPLOAD_PHOTO = 2;
    static int SHOW_MY_PEOPLE_LIST = 3;
    static int SHOW_MY_LABEL_LIST = 4;
    static int SHARE_PHOTO = 5;
    static int SHOW_PHOTOS = 6;

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == SHOW_ALBUMS) {
            this._listModel.buildList(string, "aid", "name", "size", false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            this._frmAlbumList = new Form();
            this._frmAlbumList.setTitle("My Photo Albums");
            this._frmAlbumList.setScrollable(false);
            this._frmAlbumList.setLayout(new BorderLayout());
            this._frmAlbumList.addComponent("North", (Component)this._listModel.getList());
            this.cmdOpen = new Command("Open");
            this._frmAlbumList.addCommand(this.cmdOpen);
            this._frmAlbumList.addCommand(this.cmdBack);
            this._frmAlbumList.addCommandListener(this);
            this._common.showForm(this._frmAlbumList);
        } else if (this._operation == UPLOAD_PHOTO) {
            if (string == null) {
                this._common.showDialog("Unable to upload the photo, try again", 0);
            } else {
                this._xmlParser = XMLParser.parse(string);
                String string2 = this._xmlParser.getTagValue("pid");
                String string3 = this._xmlParser.getTagValue("thumb");
                Form form = new Form();
                form.setTitle("Share Photo");
                form.setLayout(new BoxLayout(2));
                this._common._shareItemID = string2;
                Image image = Network.getImage(Common._baseURL + string3);
                if (image != null) {
                    Label label = new Label(image);
                    label.setAlignment(4);
                    form.addComponent(label);
                }
                form.addCommand(new Command("Share This"));
                form.addCommand(new Command("Add Another Photo"));
                form.addCommand(this.cmdBack);
                form.addCommandListener(this);
                this._common.showForm(form);
            }
        } else if (this._operation == SHOW_MY_LABEL_LIST) {
            if (string == null || string.indexOf("<err>") != -1) {
                this._common.showDialog("Unable to fetch contacts, try again", 0);
                return;
            }
            this._xmlParser = XMLParser.parse(string);
            String string4 = null;
            String string5 = null;
            this._chkList = new Vector();
            this._common.debug(this._xmlParser._nodes.size() + " nodes available");
            this._frmChoose = new Form();
            this._frmChoose.setTitle("Choose Labels");
            this._frmChoose.setScrollable(true);
            this._frmChoose.setLayout(new BoxLayout(2));
            for (int i = 0; i < this._xmlParser._nodes.size(); ++i) {
                XMLNode xMLNode = (XMLNode)this._xmlParser._nodes.elementAt(i);
                if (xMLNode.getTag().trim().equals("gid")) {
                    string4 = xMLNode.getValue();
                } else if (xMLNode.getTag().trim().equals("name")) {
                    string5 = xMLNode.getValue();
                }
                if (string4 == null || string5 == null) continue;
                CheckBox checkBox = new CheckBox(string5);
                checkBox.setName(string4);
                checkBox.setSelected(true);
                this._frmChoose.addComponent(checkBox);
                this._chkList.addElement(checkBox);
                string4 = null;
                string5 = null;
            }
            this.cmdDoShare = new Command("Share");
            this._frmChoose.addCommand(this.cmdDoShare);
            this._frmChoose.addCommand(this.cmdBack);
            this._frmChoose.addCommandListener(this);
            this._common.showForm(this._frmChoose);
        } else if (this._operation == SHOW_MY_PEOPLE_LIST) {
            if (string == null || string.indexOf("<err>") != -1) {
                this._common.showDialog("Unable to fetch contacts, try again", 0);
                return;
            }
            this._xmlParser = XMLParser.parse(string);
            String string6 = null;
            String string7 = null;
            this._chkList = new Vector();
            this._common.debug(this._xmlParser._nodes.size() + " nodes available");
            this._frmChoose = new Form();
            this._frmChoose.setTitle("Choose People");
            this._frmChoose.setScrollable(true);
            this._frmChoose.setLayout(new BoxLayout(2));
            for (int i = 0; i < this._xmlParser._nodes.size(); ++i) {
                XMLNode xMLNode = (XMLNode)this._xmlParser._nodes.elementAt(i);
                if (xMLNode.getTag().trim().equals("uid")) {
                    string6 = xMLNode.getValue();
                } else if (xMLNode.getTag().trim().equals("name")) {
                    string7 = xMLNode.getValue();
                }
                if (string6 == null || string7 == null) continue;
                CheckBox checkBox = new CheckBox(string7);
                checkBox.setName(string6);
                checkBox.setSelected(true);
                this._frmChoose.addComponent(checkBox);
                this._chkList.addElement(checkBox);
                string6 = null;
                string7 = null;
            }
            this.cmdDoShare = new Command("Share");
            this._frmChoose.addCommand(this.cmdDoShare);
            this._frmChoose.addCommand(this.cmdBack);
            this._frmChoose.addCommandListener(this);
            this._common.showForm(this._frmChoose);
        } else if (this._operation == SHARE_PHOTO) {
            if (string == null || string.indexOf("<msg>ok") == -1) {
                this._common.showDialog("Unable to share currently, try again later", 0);
            } else {
                this._common.showDialog("Shared", 0);
            }
        } else if (this._operation == SHOW_PHOTOS) {
            if (string == null) {
                this._common.showDialog("Unable to show details, try again", 0);
                return;
            }
            string = string.trim();
            this._xmlParser = XMLParser.parse(string);
            String string8 = null;
            String string9 = null;
            if (this._listTable != null) {
                this._listTable.clear();
            } else {
                this._listTable = new Hashtable();
            }
            Form form = new Form("Photos");
            form.setLayout(new FlowLayout());
            for (int i = 0; i < this._xmlParser._nodes.size(); ++i) {
                XMLNode xMLNode = (XMLNode)this._xmlParser._nodes.elementAt(i);
                if (xMLNode.getTag().equals("pid")) {
                    string8 = xMLNode.getValue();
                }
                if (xMLNode.getTag().equals("thumb")) {
                    string9 = xMLNode.getValue();
                }
                if (string8 == null || string9 == null) continue;
                try {
                    String string10 = null;
                    string10 = string9.indexOf("http:") != -1 ? string9 : Common._baseURL + string9;
                    Image image = Network.getImage(string10);
                    if (image != null) {
                        image = image.scaled(48, 48);
                        Button button = new Button(image);
                        button.addActionListener(this);
                        button.setName("viewphoto");
                        form.addComponent(button);
                        this._listTable.put(new Integer(button.hashCode()), string9 + " " + string8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string8 = null;
                string9 = null;
            }
            form.addCommand(new Command("Add Photo"));
            this._common.showForm(form);
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    public PhotoManager(Common common) {
        this._common = common;
        this._listModel = new ListModel(common);
        this.cmdBack = new Command("Back");
    }

    public void showPhotoSharingForm() {
        if (this.frmShare == null) {
            this.frmShare = new Form();
            this.frmShare.setTitle("Share with...");
            this.frmShare.setLayout(new BoxLayout(2));
            this.btnShareMyPeople = new Button("My People");
            this.btnShareMyPeople.addActionListener(this);
            this.frmShare.addComponent(this.btnShareMyPeople);
            this.btnShareMyGroups = new Button("My Labels");
            this.btnShareMyGroups.addActionListener(this);
            this.frmShare.addComponent(this.btnShareMyGroups);
            this.frmShare.addCommand(new Command(""));
            this.frmShare.addCommand(this.cmdBack);
            this.frmShare.addCommandListener(this);
        }
        this._common.backStack.push(this.frmShare);
        this._common.showForm(this.frmShare);
    }

    public void showMyPhotoAlbums() {
        this._common.setCurrentWindow(Common.MYPHOTOS);
        this._operation = SHOW_ALBUMS;
        this._common.showProgress();
        this._listModel.fetchList("m_albums.php", "aid", "name", "size", false, this);
    }

    public void commandAction(javax.microedition.lcdui.Command command, Displayable displayable) {
        if (command.getLabel().equals("Capture")) {
            try {
                this._recentCapture = this.mVideoControl.getSnapshot(null);
                this.mPlayer.close();
                Form form = new Form();
                form.setTitle("Upload Photo");
                form.setLayout(new BoxLayout(2));
                form.addComponent(new Label("Upload the photo to Tubri to save"));
                form.addCommand(new Command("Upload"));
                form.addCommand(new Command("Cancel"));
                form.addCommandListener(this);
                this._common.showForm(form);
            }
            catch (Exception exception) {
                this._common.showDialog("Error in taking the photo, try again", 0);
            }
        } else if (command.getLabel().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }

    public void uploadRecentPhoto() {
        this._operation = UPLOAD_PHOTO;
        this._common.showProgress();
        Network.post2(Common._baseURL + "m_uploadphoto.php", this._recentCapture, true, (NetworkListener)this);
    }

    public void showPhoto(Button button) {
        String string = (String)this._listTable.get(new Integer(button.hashCode()));
        if (string == null) {
            this._common.showDialog("Unable to show this photo, try again", 0);
        } else {
            String string2 = null;
            string2 = string.indexOf("http:") != -1 ? string : Common._baseURL + string;
            int n = string2.indexOf(" ");
            if (n == -1) {
                this._common.showDialog("Unable to show this photo, try again", 0);
                return;
            }
            this._shareItemID = string2.substring(n, string2.length()).trim();
            string2 = string2.substring(0, n);
            this._common.debug("KEPT ITEMID FOR SHARING AS:" + this._shareItemID);
            Image image = Network.getImage(string2);
            if (image == null) {
                this._common.showDialog("Unable to show this photo, try again", 0);
            } else {
                Form form = new Form();
                form.setTitle("");
                form.setLayout(new BoxLayout(2));
                Label label = new Label(image);
                label.setAlignment(4);
                form.addComponent(label);
                form.addCommandListener(this);
                form.addCommand(new Command("Share This"));
                form.addCommand(this.cmdBack);
                this._common.showForm(form);
                this._common.backStack.push(form);
            }
        }
    }

    private void showMyPeopleList() {
        this._common._sharingType = "mypeople";
        this._operation = SHOW_MY_PEOPLE_LIST;
        this._common.showProgress();
        Network.get2(Common._baseURL + "m_people.php", true, this);
    }

    private void showMyLabelList() {
        this._common._sharingType = "mylabel";
        this._operation = SHOW_MY_LABEL_LIST;
        this._common.showProgress();
        Network.get2(Common._baseURL + "m_groups.php", true, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Share This")) {
            this.showPhotoSharingForm();
        } else if (actionEvent.getSource() == this.btnShareMyPeople) {
            this.showMyPeopleList();
        } else if (actionEvent.getSource() == this.btnShareMyGroups) {
            this.showMyLabelList();
        } else if (actionEvent.getCommand() != null && (actionEvent.getCommand().getCommandName().equals("Add Photo") || actionEvent.getCommand().getCommandName().equals("Cancel") || actionEvent.getCommand().getCommandName().equals("Add Another Photo"))) {
            this.showCaptureForm();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Upload")) {
            this.uploadRecentPhoto();
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            this.showPhoto(button);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdDoShare) {
            this.sharePhoto();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdOpen) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                return;
            }
            this.showPhotoAlbum(string);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }

    private void showCaptureForm() {
        try {
            if (System.getProperty("supports.video.capture").equals("false")) {
                this._common.showDialog("Sorry, your phone is not allowing Tubri to use camera!", 0);
                return;
            }
            this.mPlayer = Manager.createPlayer((String)"capture://video");
            this.mPlayer.realize();
            this.mVideoControl = (VideoControl)this.mPlayer.getControl("VideoControl");
            VideoCanvas videoCanvas = new VideoCanvas(this.mVideoControl);
            videoCanvas.addCommand(new javax.microedition.lcdui.Command("Capture", 4, 1));
            videoCanvas.addCommand(new javax.microedition.lcdui.Command("Back", 2, 2));
            videoCanvas.setCommandListener(this);
            this.mPlayer.start();
        }
        catch (Exception exception) {
            this._common.showDialog("Problem in using camera, try again", 0);
        }
    }

    private void sharePhoto() {
        String string;
        String string2 = null;
        this._common.debug("Okay, sharing...");
        for (int i = 0; i < this._chkList.size(); ++i) {
            CheckBox checkBox = (CheckBox)this._chkList.elementAt(i);
            if (!checkBox.isSelected()) continue;
            int n = checkBox.getText().hashCode();
            String string3 = (String)this._listTable.get(String.valueOf(n));
            if (string3 == null) {
                this._common.showDialog("Unable to share currently, try again later", 4000);
                return;
            }
            string2 = string2 == null ? string3 : string2 + "-" + string3;
        }
        this._common.debug("idlist is:" + string2);
        if (string2 != null) {
            string = "";
            this._common.debug("sharing type:" + this._sharingType);
            if (this._sharingType.equals("mygroups")) {
                string = "gids=";
            } else if (this._sharingType.equals("mypeople")) {
                string = "uidList=";
            }
        } else {
            this._common.showDialog("Unable to share currently, try again later", 0);
            return;
        }
        string = string + string2;
        this._operation = SHARE_PHOTO;
        this._common.showProgress();
        Network.get2(Common._baseURL + "m_sharemanager.php?itemtype=1&itemid=" + this._shareItemID + "&" + this._sharingType + "=1&" + string, true, this);
    }

    public void showPhotoAlbum(String string) {
        this._operation = SHOW_PHOTOS;
        this._common.showProgress();
        Network.get2(Common._baseURL + "m_viewalbum.php?aid=" + string, true, this);
    }
}

