/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.Painter;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.VirtualKeyboardInterface;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VirtualKeyboard
extends Dialog
implements VirtualKeyboardInterface {
    private static final String MARKER_COMMIT_ON_DISPOSE = "$VKB_COM$";
    private static final String MARKER_TINT_COLOR = "$VKB_TINT$";
    private static final String MARKER_VKB = "$VKB$";
    private static Transition transitionIn = CommonTransitions.createSlide(1, true, 500);
    private static Transition transitionOut = CommonTransitions.createSlide(1, false, 500);
    public static final String[][] DEFAULT_QWERTY = new String[][]{{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p"}, {"a", "s", "d", "f", "g", "h", "j", "k", "l"}, {"$Shift$", "z", "x", "c", "v", "b", "n", "m", "$Delete$"}, {"$Mode$", "$T9$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}, {"*", "0", "#"}, {"$Mode$", "$Space$", "$Delete$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS_SYMBOLS = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"}, {"-", "/", ":", ";", "(", ")", "$", "&", "@"}, {".", ",", "?", "!", "'", "\"", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_SYMBOLS = new String[][]{{"[", "]", "{", "}", "#", "%", "^", "*", "+", "="}, {"_", "\\", "|", "~", "<", ">", "\u00a3", "\u00a5"}, {":-0", ";-)", ":-)", ":-(", ":P", ":D", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String QWERTY_MODE = "ABC";
    public static final String NUMBERS_MODE = "123";
    public static final String NUMBERS_SYMBOLS_MODE = ".,123";
    public static final String SYMBOLS_MODE = ".,?";
    private static Hashtable modesMap = new Hashtable();
    private static String[] defaultInputModeOrder = new String[]{"ABC", ".,123", "123", ".,?"};
    private String currentMode = defaultInputModeOrder[0];
    private String[] inputModeOrder = defaultInputModeOrder;
    private TextField inputField;
    private Container buttons = new Container(new BoxLayout(2));
    private TextPainter txtPainter = new TextPainter();
    private boolean upperCase = false;
    private Button currentButton;
    public static final int INSERT_CHAR = 1;
    public static final int DELETE_CHAR = 2;
    public static final int CHANGE_MODE = 3;
    public static final int SHIFT = 4;
    public static final int OK = 5;
    public static final int SPACE = 6;
    public static final int T9 = 7;
    private Hashtable specialButtons = new Hashtable();
    private TextArea field;
    private boolean finishedT9Edit = true;
    private String originalText;
    private boolean useSoftKeys = false;
    private static boolean showTooltips = true;
    private boolean okPressed;
    private static Class vkbClass;
    private VirtualKeyboard vkb;
    public static final String NAME = "LWUIT_VirtualKeyboard";
    private boolean isShowing = false;
    private static Hashtable defaultInputModes;

    public VirtualKeyboard() {
        this.setLayout(new BorderLayout());
        this.setDialogUIID("VKB");
        this.setAutoDispose(false);
        this.setDisposeWhenPointerOutOfBounds(true);
        this.setTransitionInAnimator(transitionIn);
        this.setTransitionOutAnimator(transitionOut);
        if (showTooltips) {
            this.setGlassPane(this.txtPainter);
        }
    }

    public void setTextField(TextArea textArea) {
        this.field = textArea;
        this.removeAll();
        this.okPressed = false;
        if (textArea instanceof TextField) {
            this.useSoftKeys = ((TextField)textArea).isUseSoftkeys();
            ((TextField)textArea).setUseSoftkeys(false);
        }
        this.originalText = textArea.getText();
        this.inputField = new InputField(textArea);
        this.inputField.setText(this.originalText);
        this.inputField.setCursorPosition(textArea.getCursorPosition());
        this.inputField.setConstraint(textArea.getConstraint());
        this.inputField.setInputModeOrder(new String[]{QWERTY_MODE});
        this.inputField.setMaxSize(textArea.getMaxSize());
        this.initModes();
        this.initSpecialButtons();
        this.addComponent("North", (Component)this.inputField);
        this.buttons.getStyle().setPadding(0, 0, 0, 0);
        this.addComponent("Center", (Component)this.buttons);
        this.initInputButtons(this.upperCase);
        this.inputField.setUseSoftkeys(false);
        this.applyRTL(false);
    }

    public void show() {
        super.showPacked("South", true);
    }

    protected void autoAdjust(int n, int n2) {
        if (this.finishedT9Edit) {
            this.setTransitionOutAnimator(CommonTransitions.createEmpty());
            this.dispose();
        }
    }

    protected void initModes() {
        this.addInputMode(QWERTY_MODE, DEFAULT_QWERTY);
        this.addInputMode(NUMBERS_SYMBOLS_MODE, DEFAULT_NUMBERS_SYMBOLS);
        this.addInputMode(SYMBOLS_MODE, DEFAULT_SYMBOLS);
        this.addInputMode(NUMBERS_MODE, DEFAULT_NUMBERS);
        if (defaultInputModes != null) {
            Enumeration enumeration = defaultInputModes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addInputMode(string, (String[][])defaultInputModes.get(string));
            }
        }
    }

    protected void setCurrentMode(String string) {
        this.currentMode = string;
    }

    protected String getCurrentMode() {
        return this.currentMode;
    }

    private void initInputButtons(boolean bl) {
        int n;
        this.buttons.removeAll();
        int n2 = 0;
        String[][] stringArray = (String[][])modesMap.get(this.currentMode);
        for (n = 1; n < stringArray.length; ++n) {
            if (stringArray[n].length <= stringArray[n2].length) continue;
            n2 = n;
        }
        n = stringArray[n2].length;
        if (n == 0) {
            return;
        }
        Button button = this.createButton(new Command("dummy"), 0);
        int n3 = button.getUnselectedStyle().getMargin(button.isRTL(), 1) + button.getUnselectedStyle().getMargin(button.isRTL(), 3);
        Container container = null;
        int n4 = Display.getInstance().getDisplayWidth() - this.getDialogStyle().getPadding(false, 1) - this.getDialogStyle().getPadding(false, 3) - this.getDialogStyle().getMargin(false, 1) - this.getDialogStyle().getMargin(false, 3);
        int n5 = n4 - n * n3;
        int n6 = n5 / n;
        for (int i = 0; i < stringArray.length; ++i) {
            Button button2;
            int n7;
            int n8 = n4;
            container = new Container(new BoxLayout(1));
            container.getUnselectedStyle().setMargin(0, 0, 0, 0);
            Vector<Button> vector = new Vector<Button>();
            for (n7 = 0; n7 < stringArray[i].length; ++n7) {
                String string = stringArray[i][n7];
                Button button3 = null;
                if (string.startsWith("$") && string.endsWith("$") && string.length() > 1) {
                    button2 = (Button)this.specialButtons.get(string.substring(1, string.length() - 1));
                    Command command = null;
                    int n9 = 0;
                    if (button2 != null) {
                        command = button2.getCommand();
                        int n10 = (Integer)button2.getClientProperty("space");
                        if (n10 != -1) {
                            n9 = n5 * n10 / 100;
                        }
                    }
                    button3 = this.createButton(command, n9, "VKBSpecialButton");
                    if (n9 != 0) {
                        n8 -= button3.getPreferredW() + n3;
                    } else {
                        vector.addElement(button3);
                    }
                } else {
                    if (bl) {
                        string = string.toUpperCase();
                    }
                    button3 = this.createInputButton(string, n6);
                    n8 -= button3.getPreferredW() + n3;
                }
                if (this.currentButton != null) {
                    if (this.currentButton.getCommand() != null && button3.getCommand() != null && this.currentButton.getCommand().getId() == button3.getCommand().getId()) {
                        this.currentButton = button3;
                    }
                    if (this.currentButton.getText().equals(button3.getText())) {
                        this.currentButton = button3;
                    }
                }
                container.addComponent(button3);
            }
            n7 = Math.max(n8, 0);
            if (vector.size() > 0) {
                int n11 = n7 / vector.size();
                for (int j = 0; j < vector.size(); ++j) {
                    button2 = (Button)vector.elementAt(j);
                    button2.setPreferredW(n11);
                }
            } else {
                container.getUnselectedStyle().setPadding(1, 0);
                container.getUnselectedStyle().setPadding(3, 0);
                container.getUnselectedStyle().setMargin(1, n7 / 2);
                container.getUnselectedStyle().setMargin(3, n7 / 2);
            }
            this.buttons.addComponent(container);
        }
        this.applyRTL(false);
    }

    private Button createInputButton(String string, int n) {
        Button button = this.createButton(new Command(string, 1), n);
        button.putClientProperty("glasspane", "true");
        return button;
    }

    private Button createButton(Command command, int n) {
        return this.createButton(command, n, "VKBButton");
    }

    private Button createButton(Command command, int n, String string) {
        Button button;
        if (command != null) {
            button = new Button(command);
        } else {
            button = new Button();
            button.setVisible(false);
        }
        final Button button2 = button;
        button2.setUIID(string);
        button2.setEndsWith3Points(false);
        button2.setAlignment(4);
        n = Math.max(n, button2.getPreferredW());
        button2.setPreferredW(n);
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VirtualKeyboard.this.currentButton = button2;
            }
        });
        return button2;
    }

    public static void addDefaultInputMode(String string, String[][] stringArray) {
        if (defaultInputModes == null) {
            defaultInputModes = new Hashtable();
        }
        defaultInputModes.put(string, stringArray);
    }

    public void addInputMode(String string, String[][] stringArray) {
        modesMap.put(string, stringArray);
    }

    public void addSpecialButton(String string, Command command) {
        this.addSpecialButton(string, command, -1);
    }

    public void addSpecialButton(String string, Command command, int n) {
        Button button = new Button(command);
        button.putClientProperty("space", new Integer(n));
        this.specialButtons.put(string, button);
    }

    private String getNextMode(String string) {
        for (int i = 0; i < this.inputModeOrder.length - 1; ++i) {
            String string2 = this.inputModeOrder[i];
            if (!string2.equals(string)) continue;
            return this.inputModeOrder[i + 1];
        }
        return this.inputModeOrder[0];
    }

    public void pointerPressed(int n, int n2) {
        super.pointerPressed(n, n2);
        Component component = this.getComponentAt(n, n2);
        if (showTooltips && component != null && component instanceof Button && component.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)component);
        }
    }

    public void pointerDragged(int n, int n2) {
        super.pointerDragged(n, n2);
        Component component = this.getComponentAt(n, n2);
        if (showTooltips && component != null && component instanceof Button && component.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)component);
        }
    }

    public void pointerReleased(int n, int n2) {
        if (showTooltips) {
            this.txtPainter.clear();
        }
        super.pointerReleased(n, n2);
    }

    protected void initSpecialButtons() {
        this.addSpecialButton("Shift", new Command("SH", 4), 15);
        this.addSpecialButton("Delete", new Command("Del", 2), 15);
        this.addSpecialButton("T9", new Command("T9", 7), 15);
        this.addSpecialButton("Mode", new Command(this.getNextMode(this.currentMode), 3));
        this.addSpecialButton("Space", new Command("Space", 6), 50);
        this.addSpecialButton("OK", new Command("Ok", 5));
    }

    public String[] getInputModeOrder() {
        return this.inputModeOrder;
    }

    public void setInputModeOrder(String[] stringArray) {
        this.inputModeOrder = stringArray;
        this.setCurrentMode(stringArray[0]);
    }

    public static String[] getDefaultInputModeOrder() {
        return defaultInputModeOrder;
    }

    public static void setDefaultInputModeOrder(String[] stringArray) {
        defaultInputModeOrder = stringArray;
    }

    private void updateText(String string) {
        this.field.setText(string);
        if (this.field instanceof TextField) {
            ((TextField)this.field).setCursorPosition(string.length());
        }
        if (this.okPressed) {
            this.field.fireActionEvent();
        }
    }

    protected void actionCommand(Command command) {
        super.actionCommand(command);
        switch (command.getId()) {
            case 5: {
                this.okPressed = true;
                this.updateText(this.inputField.getText());
                this.dispose();
                break;
            }
            case 1: {
                Button button = this.currentButton;
                String string = button.getText();
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(string);
                    this.inputField.setCursorPosition(string.length());
                    break;
                }
                this.inputField.insertChars(string);
                break;
            }
            case 6: {
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(" ");
                    break;
                }
                this.inputField.insertChars(" ");
                break;
            }
            case 2: {
                this.inputField.deleteChar();
                break;
            }
            case 3: {
                this.currentMode = this.getNextMode(this.currentMode);
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                        String string = VirtualKeyboard.this.getNextMode(VirtualKeyboard.this.currentMode);
                        VirtualKeyboard.this.currentButton.setText(string);
                        VirtualKeyboard.this.currentButton.getCommand().setCommandName(string);
                        VirtualKeyboard.this.setTransitionOutAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.setTransitionInAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.revalidate();
                        VirtualKeyboard.this.show();
                    }
                });
                return;
            }
            case 4: {
                if (this.currentMode.equals(QWERTY_MODE)) {
                    this.upperCase = !this.upperCase;
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                            VirtualKeyboard.this.revalidate();
                        }
                    });
                }
                return;
            }
            case 7: {
                this.finishedT9Edit = false;
                if (this.field != null) {
                    Display.getInstance().editString(this.field, this.field.getMaxSize(), this.field.getConstraint(), this.field.getText());
                } else {
                    Display.getInstance().editString(this.inputField, this.inputField.getMaxSize(), this.inputField.getConstraint(), this.inputField.getText());
                }
                this.dispose();
                this.finishedT9Edit = true;
            }
        }
    }

    public void dispose() {
        if (this.field != null) {
            if (!this.okPressed && !VirtualKeyboard.isCommitOnDispose(this.field) && this.finishedT9Edit) {
                this.field.setText(this.originalText);
            }
            if (this.field instanceof TextField) {
                ((TextField)this.field).setUseSoftkeys(this.useSoftKeys);
            }
            this.setTransitionInAnimator(transitionIn);
            this.field = null;
        }
        this.currentMode = this.inputModeOrder[0];
        super.dispose();
    }

    protected void onShow() {
        super.onShow();
        this.setTransitionOutAnimator(transitionOut);
    }

    protected TextField getInputField() {
        return this.inputField;
    }

    public static void setCommitOnDispose(TextField textField, boolean bl) {
        textField.putClientProperty(MARKER_COMMIT_ON_DISPOSE, new Boolean(bl));
    }

    public static void bindVirtualKeyboard(TextArea textArea, VirtualKeyboard virtualKeyboard) {
        textArea.putClientProperty(MARKER_VKB, virtualKeyboard);
    }

    public static VirtualKeyboard getVirtualKeyboard(TextArea textArea) {
        return (VirtualKeyboard)textArea.getClientProperty(MARKER_VKB);
    }

    public static boolean isCommitOnDispose(TextArea textArea) {
        Boolean bl = (Boolean)textArea.getClientProperty(MARKER_COMMIT_ON_DISPOSE);
        return bl != null && bl != false;
    }

    public static void setVKBTint(TextField textField, int n) {
        textField.putClientProperty(MARKER_TINT_COLOR, new Integer(n));
    }

    public static int getVKBTint(TextArea textArea) {
        Integer n = (Integer)textArea.getClientProperty(MARKER_TINT_COLOR);
        if (n != null) {
            return n;
        }
        return UIManager.getInstance().getLookAndFeel().getDefaultFormTintColor();
    }

    public static boolean isShowTooltips() {
        return showTooltips;
    }

    public static void setShowTooltips(boolean bl) {
        showTooltips = bl;
    }

    public static Transition getTransitionIn() {
        return transitionIn;
    }

    public static void setTransitionIn(Transition transition) {
        transitionIn = transition;
    }

    public static Transition getTransitionOut() {
        return transitionOut;
    }

    public static void setTransitionOut(Transition transition) {
        transitionOut = transition;
    }

    public void showKeyboard(boolean bl) {
        TextArea textArea;
        this.isShowing = bl;
        Form form = Display.getInstance().getCurrent();
        if (bl && (textArea = (TextArea)form.getFocused()) != null) {
            if (this.vkb != null && this.vkb.contains(textArea)) {
                return;
            }
            this.vkb = VirtualKeyboard.getVirtualKeyboard(textArea);
            if (this.vkb == null) {
                this.vkb = this.createVirtualKeyboard();
            }
            this.vkb.setTextField(textArea);
            int n = form.getTintColor();
            form.setTintColor(VirtualKeyboard.getVKBTint(textArea));
            boolean bl2 = Display.getInstance().isThirdSoftButton();
            Display.getInstance().setThirdSoftButton(false);
            boolean bl3 = textArea.isQwertyInput();
            if (textArea instanceof TextField) {
                ((TextField)textArea).setQwertyInput(true);
            }
            this.vkb.showDialog();
            if (textArea instanceof TextField) {
                ((TextField)textArea).setQwertyInput(bl3);
            }
            Display.getInstance().setThirdSoftButton(bl2);
            form.setTintColor(n);
        }
    }

    public static void setDefaultVirtualKeyboardClass(Class clazz) {
        vkbClass = clazz;
    }

    private VirtualKeyboard createVirtualKeyboard() {
        try {
            if (vkbClass != null) {
                return (VirtualKeyboard)vkbClass.newInstance();
            }
            return new VirtualKeyboard();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new VirtualKeyboard();
        }
    }

    public String getVirtualKeyboardName() {
        return NAME;
    }

    public boolean isVirtualKeyboardShowing() {
        return this.isShowing;
    }

    static {
        defaultInputModes = null;
    }

    class TextPainter
    implements Painter {
        private Label label = new Label();
        private boolean paint = true;

        public TextPainter() {
            this.label.setUIID("VKBtooltip");
        }

        public void showButtonOnGlasspane(Button button) {
            if (this.label.getText().equals(button.getText())) {
                return;
            }
            this.paint = true;
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getWidth() + 4, this.label.getHeight() + 4);
            this.label.setText(button.getText());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setX(button.getAbsoluteX() + (button.getWidth() - this.label.getWidth()) / 2);
            this.label.setY(button.getAbsoluteY() - this.label.getPreferredH() * 4 / 3);
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getPreferredW() + 4, this.label.getPreferredH() + 4);
        }

        public void paint(Graphics graphics, Rectangle rectangle) {
            if (this.paint) {
                this.label.paintComponent(graphics);
            }
        }

        private void clear() {
            this.paint = false;
            VirtualKeyboard.this.repaint();
        }
    }

    static class InputField
    extends TextField {
        private TextArea field;

        InputField(TextArea textArea) {
            this.field = textArea;
        }

        public boolean hasFocus() {
            return true;
        }

        public String getUIID() {
            return "VKBTextInput";
        }

        public void deleteChar() {
            super.deleteChar();
            this.field.setText(this.getText());
            if (this.field instanceof TextField) {
                ((TextField)this.field).setCursorPosition(this.getCursorPosition());
            }
        }

        public void setCursorPosition(int n) {
            super.setCursorPosition(n);
            if (this.field != null && this.field.getText().length() > n && this.field instanceof TextField) {
                ((TextField)this.field).setCursorPosition(n);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.field != null) {
                this.field.setText(string);
            }
        }

        public boolean validChar(String string) {
            if (this.field instanceof TextField) {
                return ((TextField)this.field).validChar(string);
            }
            return true;
        }
    }
}

