/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class GridLayout
extends Layout {
    private boolean fillLastRow;
    private int rows;
    private int columns;
    private boolean autoFit;

    public GridLayout(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("rows and columns must be greater then zero");
        }
    }

    private void autoSizeCols(Container container, int n) {
        if (this.isAutoFit()) {
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponentAt(i);
                n3 = Math.max(component.getPreferredW(), n3);
            }
            if (n < n3) {
                n = Display.getInstance().getDisplayWidth();
            }
            this.columns = n3 <= 0 ? 1 : Math.max(n / n3, 1);
        }
    }

    public void layoutContainer(Container container) {
        int n = container.getLayoutWidth() - container.getSideGap() - container.getStyle().getPadding(false, 3) - container.getStyle().getPadding(false, 1);
        int n2 = container.getLayoutHeight() - container.getBottomGap() - container.getStyle().getPadding(false, 2) - container.getStyle().getPadding(false, 0);
        int n3 = container.getComponentCount();
        this.autoSizeCols(container, n);
        int n4 = container.getStyle().getPadding(container.isRTL(), 1);
        int n5 = container.getStyle().getPadding(false, 0);
        boolean bl = container.isRTL();
        if (bl) {
            n4 += container.getSideGap();
        }
        int n6 = this.columns;
        int n7 = n / this.columns;
        int n8 = n3 > this.rows * this.columns ? n2 / (n3 / this.columns + (n3 % this.columns == 0 ? 0 : 1)) : n2 / this.rows;
        int n9 = 0;
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponentAt(i);
            Style style = component.getStyle();
            int n10 = style.getMargin(container.isRTL(), 1);
            int n11 = style.getMargin(false, 0);
            component.setWidth(n7 - n10 - style.getMargin(container.isRTL(), 3));
            component.setHeight(n8 - n11 - style.getMargin(false, 2));
            if (bl) {
                component.setX(n4 + (n6 - 1 - i % n6) * n7 + n10);
            } else {
                component.setX(n4 + i % n6 * n7 + n10);
            }
            component.setY(n5 + n9 * n8 + n11);
            if ((i + 1) % this.columns != 0 || !this.fillLastRow || ++n9 != this.rows - 1) continue;
            n6 = n3 % this.columns;
            if (n6 == 0) {
                n6 = this.columns;
            }
            n7 = n / n6;
        }
    }

    public Dimension getPreferredSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponentAt(i);
            n = Math.max(n, component.getPreferredW() + component.getStyle().getMargin(false, 1) + component.getStyle().getMargin(false, 3));
            n2 = Math.max(n2, component.getPreferredH() + component.getStyle().getMargin(false, 0) + component.getStyle().getMargin(false, 2));
        }
        this.autoSizeCols(container, container.getWidth());
        if (this.columns > 1) {
            n *= this.columns;
        }
        if (this.rows > 1) {
            n2 = n3 > this.rows * this.columns ? (n2 *= n3 / this.columns + (n3 % this.columns == 0 ? 0 : 1)) : (n2 *= this.rows);
        }
        return new Dimension(n + container.getStyle().getPadding(false, 1) + container.getStyle().getPadding(false, 3), n2 + container.getStyle().getPadding(false, 0) + container.getStyle().getPadding(false, 2));
    }

    public String toString() {
        return "GridLayout";
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean equals(Object object) {
        return super.equals(object) && ((GridLayout)object).getRows() == this.getRows() && ((GridLayout)object).getColumns() == this.getColumns() && ((GridLayout)object).autoFit == this.autoFit;
    }

    public boolean isFillLastRow() {
        return this.fillLastRow;
    }

    public void setFillLastRow(boolean bl) {
        this.fillLastRow = bl;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean bl) {
        this.autoFit = bl;
    }
}

