/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;
import java.util.Vector;

public class GenericListCellRenderer
implements ListCellRenderer,
CellRenderer {
    private Button lastClickedComponent;
    private Vector pendingAnimations;
    public static final String ENABLED = "$$ENABLED$$";
    public static final String SELECT_ALL_FLAG = "$$SELECTALL$$";
    private Label focusComponent = new Label();
    private Component selected;
    private Component unselected;
    private Component[] selectedEntries;
    private Component[] unselectedEntries;
    private Component selectedEven;
    private Component unselectedEven;
    private Component[] selectedEntriesEven;
    private Component[] unselectedEntriesEven;
    private Monitor mon = new Monitor();
    private Component parentList;
    private boolean selectionListener = true;
    private boolean firstCharacterRTL;
    private boolean fisheye;

    public GenericListCellRenderer(Component component, Component component2) {
        if (component == component2) {
            throw new IllegalArgumentException("Must use distinct instances for renderer!");
        }
        this.selected = component;
        this.unselected = component2;
        this.focusComponent.setUIID(component.getUIID() + "Focus");
        this.focusComponent.setFocus(true);
        this.selectedEntries = this.initRenderer(component);
        this.unselectedEntries = this.initRenderer(component2);
        this.firstCharacterRTL = UIManager.getInstance().isThemeConstant("firstCharRTLBool", false);
        this.addSelectedEntriesListener(this.selectedEntries);
    }

    private void addSelectedEntriesListener(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Button)) continue;
            ((Button)componentArray[i]).addActionListener(this.mon);
        }
    }

    private Component[] initRenderer(Component component) {
        component.setCellRenderer(true);
        if (component instanceof Container) {
            Vector vector = new Vector();
            this.findComponentsOfInterest(component, vector);
            return this.vectorToComponentArray(vector);
        }
        return new Component[]{component};
    }

    public Button extractLastClickedComponent() {
        Button button = this.lastClickedComponent;
        this.lastClickedComponent = null;
        return button;
    }

    public GenericListCellRenderer(Component component, Component component2, Component component3, Component component4) {
        this(component, component2);
        this.selectedEven = component3;
        this.unselectedEven = component4;
        this.selectedEntriesEven = this.initRenderer(component3);
        this.unselectedEntriesEven = this.initRenderer(component4);
        this.addSelectedEntriesListener(this.selectedEntriesEven);
    }

    private Component[] vectorToComponentArray(Vector vector) {
        Component[] componentArray = new Component[vector.size()];
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i] = (Component)vector.elementAt(i);
        }
        return componentArray;
    }

    private void findComponentsOfInterest(Component component, Vector vector) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.findComponentsOfInterest(container.getComponentAt(i), vector);
            }
            return;
        }
        if ((component instanceof Label || component instanceof TextArea) && component.getName() != null) {
            vector.addElement(component);
            return;
        }
    }

    public Component getCellRendererComponent(Component component, Object object, Object object2, int n, boolean bl) {
        if (!this.fisheye && !Display.getInstance().shouldRenderSelection()) {
            bl = false;
        }
        if (bl && (this.fisheye || component.hasFocus())) {
            Component component2 = this.selected;
            Component[] componentArray = this.selectedEntries;
            if (this.selectedEven != null && n % 2 == 0) {
                component2 = this.selectedEven;
                componentArray = this.selectedEntriesEven;
                if (component instanceof List) {
                    ((List)component).setMutableRendererBackgrounds(true);
                }
            }
            if (object2 instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)object2;
                Boolean bl2 = (Boolean)hashtable.get(ENABLED);
                if (bl2 != null) {
                    component2.setEnabled(bl2);
                }
                for (int i = 0; i < componentArray.length; ++i) {
                    String string;
                    String string2 = componentArray[i].getName();
                    if (string2.equals("$number")) {
                        string = "" + (n + 1);
                    } else {
                        string = hashtable.get("#" + string2);
                        if (string == null) {
                            string = hashtable.get(string2);
                        }
                    }
                    this.setComponentValueWithTickering(componentArray[i], string, component);
                    componentArray[i].setFocus(componentArray[i].isFocusable());
                }
            } else {
                this.setComponentValueWithTickering(componentArray[0], object2, component);
                componentArray[0].setFocus(componentArray[0].isFocusable());
            }
            return component2;
        }
        Component component3 = this.unselected;
        Component[] componentArray = this.unselectedEntries;
        if (this.unselectedEven != null && n % 2 == 0) {
            component3 = this.unselectedEven;
            componentArray = this.unselectedEntriesEven;
            if (component instanceof List) {
                ((List)component).setMutableRendererBackgrounds(true);
            }
        }
        if (object2 instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object2;
            Boolean bl3 = (Boolean)hashtable.get(ENABLED);
            if (bl3 != null) {
                component3.setEnabled(bl3);
            }
            for (int i = 0; i < componentArray.length; ++i) {
                String string = componentArray[i].getName();
                if (string.equals("$number")) {
                    this.setComponentValue(componentArray[i], "" + (n + 1));
                    continue;
                }
                this.setComponentValue(componentArray[i], hashtable.get(string));
            }
        } else {
            this.setComponentValue(componentArray[0], object2);
        }
        return component3;
    }

    public Component getListCellRendererComponent(List list, Object object, int n, boolean bl) {
        return this.getCellRendererComponent(list, list.getModel(), object, n, bl);
    }

    private boolean isSelectedValue(Object object) {
        return object != null && "true".equalsIgnoreCase(object.toString());
    }

    private void setComponentValueWithTickering(Component component, Object object, Component component2) {
        this.setComponentValue(component, object);
        if (component instanceof Label) {
            Label label;
            if (this.selectionListener) {
                if (component2 instanceof List) {
                    ((List)component2).addActionListener(this.mon);
                }
                this.parentList = component2;
            }
            if ((label = (Label)component).shouldTickerStart() && Display.getInstance().shouldRenderSelection()) {
                if (!label.isTickerRunning()) {
                    Form form;
                    this.parentList = component2;
                    if (this.parentList != null && (form = this.parentList.getComponentForm()) != null) {
                        form.registerAnimated(this.mon);
                        label.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
                    }
                }
            } else {
                if (label.isTickerRunning()) {
                    label.stopTicker();
                }
                label.setTextPosition(0);
            }
        }
    }

    protected void setComponentValue(Component component, Object object) {
        if (component.getName().toLowerCase().endsWith("fixed")) {
            return;
        }
        if (component instanceof Label) {
            String string;
            if (object instanceof Image) {
                Image image = (Image)object;
                if (image.isAnimation()) {
                    if (this.pendingAnimations == null) {
                        this.pendingAnimations = new Vector();
                    }
                    if (!this.pendingAnimations.contains(image)) {
                        Form form;
                        this.pendingAnimations.addElement(image);
                        if (this.parentList != null && (form = this.parentList.getComponentForm()) != null) {
                            form.registerAnimated(this.mon);
                        }
                    }
                }
                ((Label)component).setIcon(image);
                ((Label)component).setText("");
                return;
            }
            ((Label)component).setIcon(null);
            if (component instanceof CheckBox) {
                ((CheckBox)component).setSelected(this.isSelectedValue(object));
                return;
            }
            if (component instanceof RadioButton) {
                ((RadioButton)component).setSelected(this.isSelectedValue(object));
                return;
            }
            Label label = (Label)component;
            if (object == null) {
                label.setText("");
            } else if (object instanceof Label) {
                label.setText(((Label)object).getText());
                label.setIcon(((Label)object).getIcon());
            } else {
                label.setText(object.toString());
            }
            if (this.firstCharacterRTL && (string = label.getText()).length() > 0) {
                label.setRTL(Display.getInstance().isRTL(string.charAt(0)));
            }
            return;
        }
        if (component instanceof TextArea) {
            if (object == null) {
                ((TextArea)component).setText("");
            } else {
                ((TextArea)component).setText(object.toString());
            }
        }
    }

    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    public Component getFocusComponent(Component component) {
        return this.focusComponent;
    }

    public boolean isSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(boolean bl) {
        if (this.parentList != null && this.parentList instanceof List) {
            ((List)this.parentList).addActionListener(this.mon);
        }
        this.selectionListener = bl;
    }

    public Component getSelected() {
        return this.selected;
    }

    public Component getUnselected() {
        return this.unselected;
    }

    public Component getSelectedEven() {
        return this.selectedEven;
    }

    public Component getUnselectedEven() {
        return this.unselectedEven;
    }

    public boolean isFisheye() {
        return this.fisheye;
    }

    public void setFisheye(boolean bl) {
        this.fisheye = bl;
    }

    class Monitor
    implements ActionListener,
    Animation {
        private boolean selectAllChecked;
        private int selectAllOffset;

        Monitor() {
        }

        public boolean animate() {
            if (GenericListCellRenderer.this.parentList != null) {
                Form form;
                Object object;
                int n;
                boolean bl = false;
                if (GenericListCellRenderer.this.pendingAnimations != null) {
                    int n2 = GenericListCellRenderer.this.pendingAnimations.size();
                    for (n = 0; n < n2; ++n) {
                        object = (Image)GenericListCellRenderer.this.pendingAnimations.elementAt(n);
                        bl = bl || ((Image)object).animate();
                    }
                    GenericListCellRenderer.this.pendingAnimations.removeAllElements();
                }
                if ((form = GenericListCellRenderer.this.parentList.getComponentForm()) != null) {
                    if (GenericListCellRenderer.this.parentList.hasFocus() && Display.getInstance().shouldRenderSelection()) {
                        for (n = 0; n < GenericListCellRenderer.this.selectedEntries.length; ++n) {
                            if (!(GenericListCellRenderer.this.selectedEntries[n] instanceof Label) || !((Label)(object = (Label)GenericListCellRenderer.this.selectedEntries[n])).isTickerRunning()) continue;
                            bl = true;
                            ((Label)object).animate();
                        }
                    } else {
                        for (n = 0; n < GenericListCellRenderer.this.selectedEntries.length; ++n) {
                            if (!(GenericListCellRenderer.this.selectedEntries[n] instanceof Label) || !((Label)(object = (Label)GenericListCellRenderer.this.selectedEntries[n])).isTickerRunning()) continue;
                            ((Label)object).stopTicker();
                            bl = true;
                        }
                    }
                    if (bl) {
                        GenericListCellRenderer.this.parentList.repaint();
                    } else {
                        form.deregisterAnimated(this);
                    }
                    return false;
                }
                if (bl) {
                    GenericListCellRenderer.this.parentList.repaint();
                }
            }
            return false;
        }

        public void paint(Graphics graphics) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getComponent() instanceof Button) {
                GenericListCellRenderer.this.lastClickedComponent = (Button)actionEvent.getComponent();
                return;
            }
            if (GenericListCellRenderer.this.parentList instanceof List) {
                GenericListCellRenderer.this.parentList.setHandlesInput(true);
                Object object = ((List)GenericListCellRenderer.this.parentList).getSelectedItem();
                if (object instanceof Hashtable) {
                    Hashtable hashtable = (Hashtable)object;
                    Command command = (Command)hashtable.get("$navigation");
                    if (command != null) {
                        GenericListCellRenderer.this.parentList.getComponentForm().dispatchCommand(command, new ActionEvent(GenericListCellRenderer.this.parentList));
                        return;
                    }
                    for (int i = 0; i < GenericListCellRenderer.this.selectedEntries.length; ++i) {
                        boolean bl;
                        if (!(GenericListCellRenderer.this.selectedEntries[i] instanceof CheckBox) && !(GenericListCellRenderer.this.selectedEntries[i] instanceof RadioButton)) continue;
                        boolean bl2 = bl = !GenericListCellRenderer.this.isSelectedValue(hashtable.get(GenericListCellRenderer.this.selectedEntries[i].getName()));
                        if (hashtable.get(GenericListCellRenderer.SELECT_ALL_FLAG) != null) {
                            this.selectAllChecked = bl;
                            this.selectAllOffset = ((List)GenericListCellRenderer.this.parentList).getSelectedIndex();
                            int n = ((List)GenericListCellRenderer.this.parentList).getModel().getSize();
                            String string = "" + bl;
                            for (int j = 0; j < n; ++j) {
                                Object object2 = ((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(j);
                                if (!(object2 instanceof Hashtable)) continue;
                                ((Hashtable)object2).put(GenericListCellRenderer.this.selectedEntries[i].getName(), string);
                            }
                        } else {
                            if (this.selectAllChecked) {
                                this.selectAllChecked = false;
                                Hashtable hashtable2 = (Hashtable)((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(this.selectAllOffset);
                                hashtable2.put(GenericListCellRenderer.this.selectedEntries[i].getName(), "false");
                            }
                            hashtable.put(GenericListCellRenderer.this.selectedEntries[i].getName(), "" + bl);
                        }
                        return;
                    }
                }
            }
        }
    }
}

