/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.table.DefaultTableModel;
import com.sun.lwuit.table.TableLayout;
import com.sun.lwuit.table.TableModel;

public class Table
extends Container {
    public static final int INNER_BORDERS_NONE = 0;
    public static final int INNER_BORDERS_ROWS = 1;
    public static final int INNER_BORDERS_COLS = 2;
    public static final int INNER_BORDERS_ALL = 3;
    private TableModel model;
    private Listener listener = new Listener();
    private boolean drawBorder = true;
    private boolean collapseBorder = true;
    private boolean drawEmptyCellsBorder = true;
    private int horizontalBorderSpacing = 0;
    private int verticalBorderSpacing = 0;
    private boolean includeHeader = true;
    private int innerBorder = 3;
    private int titleAlignment = 4;
    private int cellAlignment = 1;
    private boolean potentiallyDirtyModel;
    static /* synthetic */ Class array$$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public Table() {
        this(new DefaultTableModel(new String[]{"Col1", "Col2"}, new String[][]{{"1", "2"}, {"3", "4"}}));
    }

    public Table(TableModel tableModel) {
        this.model = tableModel;
        this.updateModel();
        this.setUIID("Table");
    }

    public Table(TableModel tableModel, boolean bl) {
        this.setUIID("Table");
        this.includeHeader = bl;
        this.model = tableModel;
        this.updateModel();
    }

    public int getSelectedRow() {
        Component component;
        Form form = this.getComponentForm();
        if (form != null && (component = form.getFocused()) != null) {
            return this.getCellRow(component);
        }
        return -1;
    }

    public int getSelectedColumn() {
        Component component;
        Form form = this.getComponentForm();
        if (form != null && (component = form.getFocused()) != null) {
            return this.getCellColumn(component);
        }
        return -1;
    }

    private void updateModel() {
        Object object;
        int n;
        Component component;
        int n2 = -1;
        int n3 = -1;
        Form form = this.getComponentForm();
        if (form != null && (component = form.getFocused()) != null) {
            n2 = this.getCellRow(component);
            n3 = this.getCellColumn(component);
        }
        this.removeAll();
        int n4 = this.model.getColumnCount();
        if (this.includeHeader) {
            this.setLayout(new TableLayout(this.model.getRowCount() + 1, n4));
            for (n = 0; n < n4; ++n) {
                String string = this.model.getColumnName(n);
                object = this.createCellImpl(string, -1, n, false);
                TableLayout.Constraint constraint = this.createCellConstraint(string, -1, n);
                this.addComponent(constraint, (Component)object);
            }
        } else {
            this.setLayout(new TableLayout(this.model.getRowCount(), n4));
        }
        for (n = 0; n < this.model.getRowCount(); ++n) {
            for (int i = 0; i < n4; ++i) {
                boolean bl;
                Component component2;
                object = this.model.getValueAt(n, i);
                if (object == null || (component2 = this.createCellImpl(object, n, i, bl = this.model.isCellEditable(n, i))) == null) continue;
                TableLayout.Constraint constraint = this.createCellConstraint(object, n, i);
                int n5 = ((TableLayout)this.getLayout()).getNextRow();
                if (n5 > this.model.getRowCount()) {
                    return;
                }
                this.addComponent(constraint, component2);
                if (n != n2 || i != n3) continue;
                component2.requestFocus();
            }
        }
    }

    protected void paintGlass(Graphics graphics) {
        if (this.drawBorder && this.innerBorder != 0) {
            int n = this.getAbsoluteX();
            int n2 = this.getAbsoluteY();
            graphics.translate(n, n2);
            int n3 = this.model.getRowCount();
            int n4 = this.model.getColumnCount();
            if (this.includeHeader) {
                ++n3;
            }
            graphics.setColor(this.getStyle().getFgColor());
            TableLayout tableLayout = (TableLayout)this.getLayout();
            int n5 = Math.max(this.getWidth(), this.getScrollDimension().getWidth());
            int n6 = Math.max(this.getHeight(), this.getScrollDimension().getHeight());
            if (this.collapseBorder || this.innerBorder != 3 || tableLayout.hasHorizontalSpanning() || tableLayout.hasVerticalSpanning()) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                if (this.innerBorder == 3 || this.innerBorder == 1) {
                    if (tableLayout.hasVerticalSpanning()) {
                        for (n12 = 0; n12 < n3 - 1; ++n12) {
                            for (n11 = 0; n11 < n4; ++n11) {
                                if (n12 + tableLayout.getCellVerticalSpan(n12, n11) - 1 == n3 - 1 || tableLayout.isCellSpannedThroughHorizontally(n12, n11)) continue;
                                n10 = tableLayout.getColumnPosition(n11);
                                n9 = tableLayout.getRowPosition(n12);
                                n8 = tableLayout.getRowPosition(n12 + tableLayout.getCellVerticalSpan(n12, n11)) - n9;
                                n7 = n11 < this.getModel().getColumnCount() - 1 ? tableLayout.getColumnPosition(n11 + 1) - n10 : this.getWidth() - n9;
                                if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(n12)) continue;
                                graphics.drawLine(n10, n9 + n8, n10 + n7, n9 + n8);
                            }
                        }
                    } else {
                        for (n12 = 1; n12 < n3; ++n12) {
                            n11 = tableLayout.getRowPosition(n12);
                            if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(n12 - 1)) continue;
                            graphics.drawLine(0, n11, n5, n11);
                        }
                    }
                }
                if (this.innerBorder == 3 || this.innerBorder == 2) {
                    if (tableLayout.hasHorizontalSpanning()) {
                        for (n12 = 0; n12 < n3; ++n12) {
                            for (n11 = 0; n11 < n4 - 1; ++n11) {
                                if (n11 + tableLayout.getCellHorizontalSpan(n12, n11) - 1 == n4 - 1 || tableLayout.isCellSpannedThroughVertically(n12, n11)) continue;
                                n10 = tableLayout.getColumnPosition(n11);
                                n9 = tableLayout.getRowPosition(n12);
                                n7 = tableLayout.getColumnPosition(n11 + tableLayout.getCellHorizontalSpan(n12, n11)) - n10;
                                n8 = n12 < this.getModel().getRowCount() - 1 ? tableLayout.getRowPosition(n12 + 1) - n9 : this.getHeight() - n9;
                                graphics.drawLine(n10 + n7, n9, n10 + n7, n9 + n8);
                            }
                        }
                    } else {
                        for (n12 = 1; n12 < n4; ++n12) {
                            n11 = tableLayout.getColumnPosition(n12);
                            graphics.drawLine(n11, 0, n11, n6);
                        }
                    }
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    int n13 = tableLayout.getRowPosition(i);
                    int n14 = i + 1 < n3 ? tableLayout.getRowPosition(i + 1) - n13 : this.getY() + n6 - n13 - 2;
                    for (int j = 0; j < n4; ++j) {
                        int n15 = tableLayout.getColumnPosition(j);
                        int n16 = j + 1 < n4 ? tableLayout.getColumnPosition(j + 1) - n15 : this.getX() + n5 - n15 - 2;
                        Component component = tableLayout.getComponentAt(i, j);
                        if (!component.isVisible() || !this.drawEmptyCellsBorder && (component.getWidth() - component.getStyle().getPadding(false, 3) - component.getStyle().getPadding(false, 1) <= 0 || component.getHeight() - component.getStyle().getPadding(false, 0) - component.getStyle().getPadding(false, 2) <= 0)) continue;
                        int n17 = component.getStyle().getMargin(3);
                        int n18 = component.getStyle().getMargin(2);
                        if (j == 0) {
                            n17 *= 2;
                        }
                        if (i == 0) {
                            n18 *= 2;
                        }
                        graphics.drawRect(n15 + component.getStyle().getMargin(1), n13 + component.getStyle().getMargin(0), n16 - 2 - n17, n14 - 2 - n18);
                    }
                }
            }
            graphics.translate(-n, -n2);
        }
    }

    private Component createCellImpl(Object object, int n, int n2, boolean bl) {
        Component component = this.createCell(object, n, n2, bl);
        component.putClientProperty("row", new Integer(n));
        component.putClientProperty("column", new Integer(n2));
        if (component instanceof TextArea) {
            ((TextArea)component).addActionListener(this.listener);
        }
        Style style = component.getSelectedStyle();
        style.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        if (this.drawBorder && this.innerBorder != 0) {
            style.setBorder(null);
            style = component.getUnselectedStyle();
            style.setBorder(null);
        } else {
            style = component.getUnselectedStyle();
        }
        style.setBgTransparency(0);
        style.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        return component;
    }

    protected Component createCell(Object object, int n, int n2, boolean bl) {
        if (n == -1) {
            Label label = new Label((String)object);
            label.setUIID("TableHeader");
            label.setAlignment(this.titleAlignment);
            label.setFocusable(true);
            return label;
        }
        if (bl) {
            TextField textField = new TextField("" + object, -1);
            textField.setLeftAndRightEditingTrigger(false);
            textField.setUIID("TableCell");
            return textField;
        }
        Label label = new Label("" + object);
        label.setUIID("TableCell");
        label.setAlignment(this.cellAlignment);
        label.setFocusable(true);
        return label;
    }

    public void initComponent() {
        if (this.potentiallyDirtyModel) {
            this.updateModel();
            this.potentiallyDirtyModel = false;
        }
        this.model.addDataChangeListener(this.listener);
    }

    public void deinitialize() {
        if (!Display.getInstance().isVirtualKeyboardShowing()) {
            this.potentiallyDirtyModel = true;
            this.model.removeDataChangeListener(this.listener);
        } else {
            this.potentiallyDirtyModel = false;
        }
    }

    public void setModel(TableModel tableModel) {
        this.model = tableModel;
        this.updateModel();
        this.revalidate();
    }

    public TableModel getModel() {
        return this.model;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.repaint();
    }

    public void setInnerBorderMode(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Inner border mode must be one of the INNER_BORDER_* constants");
        }
        this.innerBorder = n;
        this.repaint();
    }

    public int getInnerBorderMode() {
        return this.innerBorder;
    }

    protected boolean shouldDrawInnerBorderAfterRow(int n) {
        return true;
    }

    public void setCollapseBorder(boolean bl) {
        if (this.collapseBorder != bl) {
            this.collapseBorder = bl;
            if (this.horizontalBorderSpacing != 0 || this.verticalBorderSpacing != 0) {
                this.updateMargins();
            }
            this.repaint();
        }
    }

    public void setDrawEmptyCellsBorder(boolean bl) {
        this.drawEmptyCellsBorder = bl;
        this.repaint();
    }

    public void setBorderSpacing(int n, int n2) {
        this.horizontalBorderSpacing = n;
        this.verticalBorderSpacing = n2;
        this.updateMargins();
    }

    private void updateMargins() {
        TableLayout tableLayout = (TableLayout)this.getLayout();
        int n = this.horizontalBorderSpacing;
        int n2 = this.verticalBorderSpacing;
        if (this.collapseBorder) {
            n = 0;
            n2 = 0;
        }
        if (!tableLayout.hasHorizontalSpanning() && !tableLayout.hasVerticalSpanning()) {
            for (int i = 0; i < tableLayout.getRows(); ++i) {
                for (int j = 0; j < tableLayout.getColumns(); ++j) {
                    Component component = null;
                    try {
                        component = tableLayout.getComponentAt(i, j);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (component == null) continue;
                    int n3 = j == 0 ? n : 0;
                    int n4 = i == 0 ? n2 : 0;
                    component.getUnselectedStyle().setMargin(n4, n2, n3, n);
                    component.getSelectedStyle().setMargin(n4, n2, n3, n);
                }
            }
        }
        this.repaint();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int n) {
        this.titleAlignment = n;
        this.repaint();
    }

    public int getCellColumn(Component component) {
        Integer n = (Integer)component.getClientProperty("column");
        if (n != null) {
            return n;
        }
        return -1;
    }

    public int getCellRow(Component component) {
        Integer n = (Integer)component.getClientProperty("row");
        if (n != null) {
            return n;
        }
        return -1;
    }

    public int getCellAlignment() {
        return this.cellAlignment;
    }

    public void setCellAlignment(int n) {
        this.cellAlignment = n;
        this.repaint();
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean bl) {
        this.includeHeader = bl;
    }

    protected TableLayout.Constraint createCellConstraint(Object object, int n, int n2) {
        if (this.includeHeader) {
            ++n;
        }
        TableLayout tableLayout = (TableLayout)this.getLayout();
        return tableLayout.createConstraint(n, n2);
    }

    public String[] getPropertyNames() {
        return new String[]{"data", "header"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$$Ljava$lang$String == null ? (array$$Ljava$lang$String = Table.class$("[[Ljava.lang.String;")) : array$$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Table.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    }

    public Object getPropertyValue(String string) {
        if (string.equals("data")) {
            return ((DefaultTableModel)this.model).data;
        }
        if (string.equals("header")) {
            return ((DefaultTableModel)this.model).columnNames;
        }
        return null;
    }

    public String setPropertyValue(String string, Object object) {
        if (string.equals("data")) {
            this.setModel(new DefaultTableModel(((DefaultTableModel)this.model).columnNames, (String[][])object));
            return null;
        }
        if (string.equals("header")) {
            this.setModel(new DefaultTableModel((String[])object, ((DefaultTableModel)this.model).data));
            return null;
        }
        return super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Listener
    implements DataChangedListener,
    ActionListener {
        Listener() {
        }

        public final void dataChanged(int n, int n2) {
            Object object = Table.this.model.getValueAt(n, n2);
            boolean bl = Table.this.model.isCellEditable(n, n2);
            Component component = Table.this.createCellImpl(object, n, n2, bl);
            TableLayout tableLayout = (TableLayout)Table.this.getLayout();
            TableLayout.Constraint constraint = Table.this.createCellConstraint(object, n, n2);
            if (Table.this.includeHeader) {
                ++n;
            }
            Component component2 = tableLayout.getComponentAt(n, n2);
            Table.this.removeComponent(component2);
            component2.setVisible(false);
            Table.this.addComponent(constraint, component);
            Table.this.layoutContainer();
            component.requestFocus();
            Table.this.revalidate();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextArea textArea = (TextArea)actionEvent.getSource();
            int n = Table.this.getCellRow(textArea);
            int n2 = Table.this.getCellColumn(textArea);
            Table.this.getModel().setValueAt(n, n2, textArea.getText());
        }
    }
}

