/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    private boolean textElement;
    private String name;
    private Vector children;
    private Element parent;
    private Hashtable attributes;
    boolean isComment;

    protected Element() {
    }

    public Element(String string) {
        this.name = string;
    }

    public Element(String string, boolean bl) {
        this(string);
        this.textElement = bl;
    }

    public boolean isTextElement() {
        return this.textElement;
    }

    public String getTagName() {
        if (this.textElement) {
            throw new IllegalStateException("Text elements do not have a tag name");
        }
        return this.name;
    }

    protected Hashtable getAttributes() {
        return this.attributes;
    }

    protected void setAttribute(Object object, String string) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(object, string);
    }

    public void addChild(Element element) {
        this.setChildParent(element);
        this.children.addElement(element);
    }

    protected void setParent(Element element) {
        this.parent = element;
    }

    public Element getParent() {
        return this.parent;
    }

    public int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    protected Vector getChildren() {
        return this.children;
    }

    protected void setChildren(Vector vector) {
        this.children = vector;
    }

    protected void setTagName(String string) {
        this.name = string;
    }

    protected void setTextElement(boolean bl) {
        this.textElement = bl;
    }

    public Element getChildAt(int n) {
        if (n < 0 || this.children == null || n >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Element)this.children.elementAt(n);
    }

    public Element getFirstChildByTagName(String string) {
        if (this.children == null) {
            return null;
        }
        int n = 0;
        Element element = null;
        while (element == null && n < this.children.size()) {
            Element element2 = (Element)this.children.elementAt(n);
            if (!element2.textElement && element2.getTagName().equalsIgnoreCase(string)) {
                element = element2;
                continue;
            }
            ++n;
        }
        return element;
    }

    public Element getElementById(String string) {
        String string2 = this.getAttribute("id");
        if (string2 != null && string2.equals(string)) {
            return this;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element element = (Element)this.children.elementAt(i);
                Element element2 = element.getElementById(string);
                if (element2 == null) continue;
                return element2;
            }
        }
        return null;
    }

    private void getDescendantsByTagNameInternal(Vector vector, String string, int n) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element element = (Element)this.children.elementAt(i);
                if (n > 0) {
                    element.getDescendantsByTagNameInternal(vector, string, n - 1);
                }
                if (element.textElement || !element.getTagName().equalsIgnoreCase(string)) continue;
                vector.addElement(element);
            }
        }
    }

    public Vector getDescendantsByTagName(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return null;
        }
        Vector vector = new Vector();
        this.getDescendantsByTagNameInternal(vector, string, n);
        return vector;
    }

    public Vector getDescendantsByTagName(String string) {
        return this.getDescendantsByTagName(string, Integer.MAX_VALUE);
    }

    public Vector getChildrenByTagName(String string) {
        return this.getDescendantsByTagName(string, 1);
    }

    private void getTextDescendantsInternal(Vector vector, String string, boolean bl, int n) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Element element = (Element)this.children.elementAt(i);
            if (n > 0) {
                element.getTextDescendantsInternal(vector, string, bl, n - 1);
            }
            if (!element.textElement) continue;
            if (string != null) {
                int n2;
                String string2 = element.getText();
                if (!bl) {
                    string2 = string2.toLowerCase();
                }
                if ((n2 = string2.indexOf(string)) == -1) continue;
                vector.addElement(element);
                continue;
            }
            vector.addElement(element);
        }
    }

    public Vector getTextDescendants(String string, boolean bl, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return null;
        }
        if (!bl && string != null) {
            string = string.toLowerCase();
        }
        Vector vector = new Vector();
        this.getTextDescendantsInternal(vector, string, bl, n);
        return vector;
    }

    public Vector getTextDescendants(String string, boolean bl) {
        return this.getTextDescendants(string, bl, Integer.MAX_VALUE);
    }

    public Vector getTextChildren(String string, boolean bl) {
        return this.getTextDescendants(string, bl, 1);
    }

    public boolean contains(Element element) {
        if (this == element) {
            return true;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element element2 = (Element)this.children.elementAt(i);
                if (!element2.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    public int setAttribute(String string, String string2) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have attributes");
        }
        this.setAttribute((Object)string, string2);
        return -1;
    }

    public void removeAttribute(String string) {
        this.removeAttribute((Object)string);
    }

    protected void removeAttribute(Object object) {
        if (this.attributes != null) {
            this.attributes.remove(object);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    private void setChildParent(Element element) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have children");
        }
        if (element.getParent() != null) {
            throw new IllegalStateException("An Element can't have two parents.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        element.setParent(this);
    }

    public void removeChildAt(int n) {
        if (n < 0 || this.children == null || n >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Element element = (Element)this.children.elementAt(n);
        element.setParent(null);
        this.children.removeElementAt(n);
    }

    public int getChildIndex(Element element) {
        int n = -1;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (element != this.children.elementAt(i)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public void insertChildAt(Element element, int n) {
        this.setChildParent(element);
        this.children.insertElementAt(element, n);
    }

    public void replaceChild(Element element, Element element2) {
        if (this.children != null) {
            this.setChildParent(element2);
            int n = this.children.indexOf(element);
            if (n != -1) {
                this.children.insertElementAt(element2, n);
                this.removeChildAt(n + 1);
                return;
            }
        }
        throw new IllegalArgumentException("The oldChild element specified must be this element's child");
    }

    public String getText() {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can get text");
        }
        return this.name;
    }

    public void setText(String string) {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can set text");
        }
        this.name = string;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String string) {
        String string2 = string;
        if (!this.textElement) {
            string2 = string2 + "<" + this.getTagName();
            if (this.attributes != null) {
                Enumeration enumeration = this.attributes.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = (String)this.attributes.get(string3);
                    string2 = string2 + " " + string3 + "='" + string4 + "'";
                }
            }
            string2 = string2 + ">\n";
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    string2 = string2 + ((Element)this.children.elementAt(i)).toString(string + ' ');
                }
            }
            string2 = string2 + string + "</" + this.getTagName() + ">\n";
        } else {
            string2 = string2 + "'" + this.name + "'\n";
        }
        return string2;
    }
}

