/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import core.ListModel;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import framework.XMLNode;
import framework.XMLParser;
import java.util.Hashtable;

public class ChatManager
implements ActionListener,
NetworkListener {
    XMLParser _xmlParser;
    Container cntChat;
    Command cmdSendChat;
    Command cmdLeaveChat;
    Command cmdStartChat;
    Command cmdBack;
    TextField txtChatField;
    String _cgID = null;
    Common _common;
    ListModel _listModel;
    Form _frmChatWindow;
    Form _frmOnlineList;
    int _operation = -1;
    public static final int SHOW_ONLINE_LIST = 1;
    public static final int SHOW_CHAT_WINDOW = 2;
    public static final int SEND_CHAT = 3;
    public static final int LEAVE_CHAT = 4;

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == 1) {
            if (string == null) {
                return;
            }
            this._listModel.buildList(string, "uid", "name", null, false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            this._frmOnlineList = new Form();
            this._frmOnlineList.setTitle("Online People");
            this._frmOnlineList.setScrollable(false);
            this._frmOnlineList.setLayout(new BorderLayout());
            this._frmOnlineList.addComponent("North", (Component)this._listModel.getList());
            this.cmdStartChat = new Command("Start Chat");
            this._frmOnlineList.addCommand(this.cmdStartChat);
            this.cmdBack = new Command("Back");
            this._frmOnlineList.addCommand(this.cmdBack);
            this._frmOnlineList.addCommandListener(this);
            this._common.showForm(this._frmOnlineList);
        } else if (this._operation == 2) {
            if (string == null || string.indexOf("<err>") != -1) {
                this._common.showDialog(string, 0);
                return;
            }
            this._xmlParser = XMLParser.parse(string);
            this._cgID = this._xmlParser.getTagValue("cgid");
            this._frmChatWindow = new Form("Chatting...");
            this._frmChatWindow.setLayout(new BoxLayout(2));
            this.cntChat = new Container();
            this.cntChat.setLayout(new BoxLayout(2));
            this.cntChat.setScrollable(true);
            this.txtChatField = new TextField();
            this.txtChatField.setConstraint(0);
            this._frmChatWindow.addComponent(this.txtChatField);
            this._frmChatWindow.addComponent(this.cntChat);
            this.cmdSendChat = new Command("Send");
            this.cmdLeaveChat = new Command("Leave Chat");
            this._frmChatWindow.addCommand(this.cmdSendChat);
            this._frmChatWindow.addCommand(this.cmdLeaveChat);
            this._frmChatWindow.addCommandListener(this);
            this._common.showForm(this._frmChatWindow);
            new Thread(){

                public void run() {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    while (ChatManager.this._cgID != null) {
                        try {
                            String string = Network.get(Common._baseURL + "m_chat.php?getchatmsgs=1&cgid=" + ChatManager.this._cgID, true);
                            if (string != null && string.indexOf("<err>") == -1) {
                                ChatManager.this._xmlParser = XMLParser.parse(string);
                                String string2 = null;
                                String string3 = null;
                                String string4 = null;
                                for (int i = 0; i < ChatManager.this._xmlParser._nodes.size(); ++i) {
                                    XMLNode xMLNode = (XMLNode)ChatManager.this._xmlParser._nodes.elementAt(i);
                                    if (xMLNode.getTag().equals("msgid")) {
                                        string2 = xMLNode.getValue();
                                    } else if (xMLNode.getTag().equals("msg")) {
                                        string3 = xMLNode.getValue();
                                    } else if (xMLNode.getTag().equals("name")) {
                                        string4 = xMLNode.getValue();
                                    }
                                    if (string3 == null || string4 == null) continue;
                                    if (hashtable.get(string2) == null) {
                                        ChatManager.this.cntChat.addComponent(new Label(string4 + ": " + string3));
                                        hashtable.put(string2, "");
                                    }
                                    string4 = null;
                                    string3 = null;
                                    string2 = null;
                                }
                                ChatManager.this._frmChatWindow.repaint();
                            }
                            1.sleep(10000L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }.start();
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    public void showOnlineList() {
        this._common.setCurrentWindow(Common.CHATLIST);
        this._cgID = null;
        this._operation = 1;
        this._common.showProgress();
        this._listModel.fetchList("m_chat.php?getlist=1", "uid", "name", null, false, this);
    }

    public ChatManager(Common common) {
        this._common = common;
        this._listModel = new ListModel(common);
    }

    public void startChatService() {
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String string;
                            if ((string = Network.get(Common._baseURL + "m_chat.php?getchatid=1", true)) != null && string.indexOf("<err>") == -1) {
                                ChatManager.this._xmlParser = XMLParser.parse(string);
                                String string2 = ChatManager.this._xmlParser.getTagValue("cgid");
                                String string3 = ChatManager.this._xmlParser.getTagValue("name");
                                if (string2 != null && !string2.equals(ChatManager.this._cgID)) {
                                    ChatManager.this._common.showDialog("Chat request from " + string3, 0);
                                }
                            }
                            2.sleep(30000L);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void showChatWindow(String string) {
        this._operation = 2;
        this._common.showProgress();
        Network.get2(Common._baseURL + "m_chat.php?chatwith=1&targetuid=" + string, true, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdLeaveChat) {
            this._operation = 4;
            this._common.showProgress();
            Network.get2(Common._baseURL + "m_chat.php?leave=1&cgid=" + this._cgID, false, this);
            this._common.hideProgress();
            this._common._main.showHome();
            this._cgID = null;
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdSendChat) {
            String string = this.txtChatField.getText();
            this._common.showProgress();
            this._operation = 3;
            Network.post2(Common._baseURL + "m_chat.php", "cgid=" + this._cgID + "&msg=" + string, false, (NetworkListener)this);
            this._common.hideProgress();
            this.txtChatField.setText("");
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdStartChat) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                return;
            }
            this.showChatWindow(string);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }
}

