/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import core.AuthManager;
import core.ChatManager;
import core.HelpManager;
import core.InviteManager;
import core.PhotoManager;
import core.ProfileManager;
import core.SocialManager;
import core.VideoCanvas;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import java.io.IOException;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class MainApp
implements ActionListener,
CommandListener,
NetworkListener {
    VideoControl mVideoControl;
    Player mPlayer;
    byte[] _recentCapture = null;
    public Form frmHome;
    public Form frmMyGroups;
    public Form frmViewer;
    MIDlet midlet;
    TextArea txtFeedback;
    TextArea wText;
    public Command cmdSubmit;
    public Command cmdExit;
    public Command cmdOpen;
    public Command cmdBack;
    public Command cmdDoShare;
    private TextField txtDialogInput;
    Button btnActivities;
    Button btnMyGroups;
    Button btnMyPhotos;
    Button btnMyProfile;
    Button btnFindPeople;
    Button btnChat;
    Button btnTakePhoto;
    Button btnInvite;
    Button btnHelp;
    private static MainApp instance;
    public AuthManager _authManager;
    public ChatManager _chatManager;
    public InviteManager _inviteManager;
    public PhotoManager _photoManager;
    public ProfileManager _profileManager;
    public SocialManager _socialManager;
    public HelpManager _helpManager;
    public Common _common;
    int _operation = -1;
    static int UPLOAD_PHOTO;

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == UPLOAD_PHOTO) {
            if (string == null) {
                this._common.showDialog("Unable to upload the photo, try again", 0);
            } else {
                this._common.showDialog("Photo uploaded", 0);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.showHome();
            }
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    static MainApp getInstance() {
        return instance;
    }

    private void showSplash() {
        Form form = new Form();
        form.setTitle("");
        form.setLayout(new BorderLayout());
        form.getStyle().setBgColor(9428987);
        Image image = null;
        try {
            image = Image.createImage("/tubri4-logo.png");
            Label label = new Label(image);
            label.setAlignment(4);
            form.addComponent("Center", (Component)label);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Label label = new Label("Loading...");
            label.setAlignment(4);
            form.addComponent("Center", (Component)label);
        }
        form.show();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startApp(MIDlet mIDlet) {
        instance = this;
        this.midlet = mIDlet;
        try {
            Resources resources = Resources.open("/tubri4.res");
            UIManager.getInstance().setThemeProps(resources.getTheme("abc"));
            this.showSplash();
            this._common = new Common(this);
            this._authManager = new AuthManager(this._common);
            this._chatManager = new ChatManager(this._common);
            this._inviteManager = new InviteManager(this._common);
            this._photoManager = new PhotoManager(this._common);
            this._profileManager = new ProfileManager(this._common);
            this._socialManager = new SocialManager(this._common);
            this._helpManager = new HelpManager(this._common);
            if (this._authManager.isAuthDataAvailable()) {
                if (this._authManager.doLogin() == Common.SUCCESS) {
                    this.prepareHome();
                    this._common.showForm(this.frmHome);
                } else {
                    this._authManager.showLoginForm();
                }
            } else {
                this._authManager.showJoinForm();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this._common.showDialog("Some unexpected error happened, try again", 0);
        }
    }

    public void setOrigin(String string) {
        Common.origin = string;
    }

    public void showHome() {
        this.prepareHome();
        this._common.showForm(this.frmHome);
        if (Common.newVersion != null) {
            this._common.showDialog("A new version (" + Common.newVersion + ") is available at www.tubri.com", 0);
            Common.newVersion = null;
        }
    }

    private void setHomeStyle() {
        Style style = new Style();
        style.setBorder(null);
        style.setBgTransparency(0);
        style.setFont(Font.createSystemFont(64, 0, 8));
        Style style2 = new Style();
        style2.setBorder(Border.createEtchedLowered());
        style2.setBgTransparency(0);
        style2.setFont(Font.createSystemFont(64, 1, 8));
        this.btnMyGroups.setUnselectedStyle(style);
        this.btnMyGroups.setSelectedStyle(style2);
        this.btnMyGroups.setAlignment(4);
        this.btnMyGroups.setTextPosition(2);
        this.btnActivities.setUnselectedStyle(style);
        this.btnActivities.setSelectedStyle(style2);
        this.btnActivities.setAlignment(4);
        this.btnActivities.setTextPosition(2);
        this.btnMyPhotos.setUnselectedStyle(style);
        this.btnMyPhotos.setSelectedStyle(style2);
        this.btnMyPhotos.setAlignment(4);
        this.btnMyPhotos.setTextPosition(2);
        this.btnTakePhoto.setUnselectedStyle(style);
        this.btnTakePhoto.setSelectedStyle(style2);
        this.btnTakePhoto.setAlignment(4);
        this.btnTakePhoto.setTextPosition(2);
        this.btnFindPeople.setUnselectedStyle(style);
        this.btnFindPeople.setSelectedStyle(style2);
        this.btnFindPeople.setAlignment(4);
        this.btnFindPeople.setTextPosition(2);
        this.btnChat.setUnselectedStyle(style);
        this.btnChat.setSelectedStyle(style2);
        this.btnChat.setAlignment(4);
        this.btnChat.setTextPosition(2);
        this.btnMyProfile.setUnselectedStyle(style);
        this.btnMyProfile.setSelectedStyle(style2);
        this.btnMyProfile.setAlignment(4);
        this.btnMyProfile.setTextPosition(2);
        this.btnInvite.setUnselectedStyle(style);
        this.btnInvite.setSelectedStyle(style2);
        this.btnInvite.setAlignment(4);
        this.btnInvite.setTextPosition(2);
        this.btnHelp.setUnselectedStyle(style);
        this.btnHelp.setSelectedStyle(style2);
        this.btnHelp.setAlignment(4);
        this.btnHelp.setTextPosition(2);
    }

    private void prepareHome() {
        if (this.frmHome != null) {
            return;
        }
        this.frmHome = new Form();
        this.frmHome.setTitle("Tubri");
        try {
            this.btnActivities = new Button("Activities", Image.createImage("/activities.png"));
            this.btnMyGroups = new Button("My Labels", Image.createImage("/mygroups.png"));
            this.btnMyPhotos = new Button("My Photos", Image.createImage("/photos.png"));
            this.btnTakePhoto = new Button("Take Photo", Image.createImage("/takephoto.png"));
            this.btnFindPeople = new Button("Find People", Image.createImage("/people.png"));
            this.btnChat = new Button("Chat", Image.createImage("/chat.png"));
            this.btnMyProfile = new Button("My Profile", Image.createImage("/profile.png"));
            this.btnInvite = new Button("Invite People", Image.createImage("/invite.png"));
            this.btnHelp = new Button("Help", Image.createImage("/help.png"));
        }
        catch (Exception exception) {
            this._common.showDialog("Unable to start. Restart/reinstall the app.", 0);
            return;
        }
        this.setHomeStyle();
        this.btnActivities.addActionListener(this);
        this.btnMyPhotos.addActionListener(this);
        this.btnMyGroups.addActionListener(this);
        this.btnTakePhoto.addActionListener(this);
        this.btnFindPeople.addActionListener(this);
        this.btnChat.addActionListener(this);
        this.btnMyProfile.addActionListener(this);
        this.btnInvite.addActionListener(this);
        this.btnHelp.addActionListener(this);
        this.frmHome.addComponent(this.btnActivities);
        this.frmHome.addComponent(this.btnMyGroups);
        this.frmHome.addComponent(this.btnMyPhotos);
        this.frmHome.addComponent(this.btnTakePhoto);
        this.frmHome.addComponent(this.btnFindPeople);
        this.frmHome.addComponent(this.btnChat);
        this.frmHome.addComponent(this.btnMyProfile);
        this.frmHome.addComponent(this.btnInvite);
        this.frmHome.addComponent(this.btnHelp);
        int n = com.sun.lwuit.Display.getInstance().getDisplayWidth();
        int n2 = this.btnActivities.getPreferredW() + 20;
        int n3 = n / n2;
        int n4 = 9 / n3;
        this._common.debug("Setting layout to " + n4 + ", " + n3);
        this.frmHome.setLayout(new GridLayout(n4, n3));
        this.frmHome.addCommand(new Command(""));
        this.cmdExit = new Command("Exit");
        this.frmHome.addCommand(this.cmdExit);
        this.frmHome.addCommandListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdExit) {
            this.midlet.notifyDestroyed();
        } else if (actionEvent.getSource() == this.btnFindPeople) {
            this._profileManager.showFindPeople();
        } else if (actionEvent.getSource() == this.btnChat) {
            this._chatManager.showOnlineList();
        } else if (actionEvent.getSource() == this.btnMyProfile) {
            this._profileManager.showProfilePage(-1);
        } else if (actionEvent.getSource() == this.btnHelp) {
            this._helpManager.showHelp();
        } else if (actionEvent.getSource() == this.btnInvite) {
            try {
                this._inviteManager.showInviteSources();
            }
            catch (Exception exception) {
                this._common.showDialog("Some error, try again", 0);
            }
        } else if (actionEvent.getSource() == this.btnTakePhoto) {
            this.showCaptureForm();
        } else if (actionEvent.getSource() == this.btnMyGroups) {
            this._socialManager.showMyLabels();
        } else if (actionEvent.getSource() == this.btnActivities) {
            this._socialManager.showActivities();
        } else if (actionEvent.getSource() == this.btnMyPhotos) {
            this._photoManager.showMyPhotoAlbums();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Upload")) {
            this._operation = UPLOAD_PHOTO;
            Network.post2(Common._baseURL + "m_uploadphoto.php", this._recentCapture, true, (NetworkListener)this);
        }
    }

    public void commandAction(javax.microedition.lcdui.Command command, Displayable displayable) {
        if (command.getLabel().equals("Capture")) {
            try {
                this._recentCapture = this.mVideoControl.getSnapshot(null);
                this.mPlayer.close();
                Form form = new Form();
                form.setTitle("Upload Photo");
                form.setLayout(new BoxLayout(2));
                form.addComponent(new Label("Upload photo to Tubri"));
                form.addCommand(new Command("Upload"));
                form.addCommand(new Command("Cancel"));
                form.addCommandListener(this);
                this._common.showForm(form);
            }
            catch (Exception exception) {
                this._common.showDialog("Error in taking the photo, try again", 0);
            }
        } else if (command.getLabel().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }

    private void showCaptureForm() {
        try {
            if (System.getProperty("supports.video.capture").equals("false")) {
                this._common.showDialog("Sorry, your phone is not allowing Tubri to use camera!", 0);
                return;
            }
            this.mPlayer = Manager.createPlayer((String)"capture://video");
            this.mPlayer.realize();
            this.mVideoControl = (VideoControl)this.mPlayer.getControl("VideoControl");
            VideoCanvas videoCanvas = new VideoCanvas(this.mVideoControl);
            videoCanvas.addCommand(new javax.microedition.lcdui.Command("Capture", 4, 1));
            videoCanvas.addCommand(new javax.microedition.lcdui.Command("Back", 2, 2));
            videoCanvas.setCommandListener(this);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)videoCanvas);
            this.mPlayer.start();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            this._common.showDialog("Sorry, your phone is not allowing Tubri to use camera!", 0);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    static {
        UPLOAD_PHOTO = 1;
    }
}

