/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Painter;
import java.util.Vector;

class RunnableWrapper
implements Runnable {
    private static final Object THREADPOOL_LOCK = new Object();
    private static Vector threadPool = new Vector();
    private static int threadCount = 0;
    private static int maxThreadCount = 5;
    private static int availableThreads = 0;
    private boolean done = false;
    private Runnable internal;
    private int type;
    private RuntimeException err;
    private Form parentForm;
    private Painter paint;
    private boolean reverse;

    public RunnableWrapper(Form form, Painter painter, boolean bl) {
        this.parentForm = form;
        this.paint = painter;
        this.reverse = bl;
    }

    public RunnableWrapper(Runnable runnable, int n) {
        this.internal = runnable;
        this.type = n;
    }

    public RuntimeException getErr() {
        return this.err;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.parentForm != null) {
            if (this.paint == null) {
                Display.getInstance().setCurrent(this.parentForm, this.reverse);
                return;
            }
            Dialog dialog = (Dialog)this.parentForm;
            while (!dialog.isDisposed()) {
                try {
                    Object object = Display.lock;
                    synchronized (object) {
                        Display.lock.wait(40L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this.parentForm.getStyle().setBgPainter(this.paint);
        } else {
            switch (this.type) {
                case 0: {
                    this.internal.run();
                    this.done = true;
                    Object object = Display.lock;
                    synchronized (object) {
                        Display.lock.notify();
                        break;
                    }
                }
                case 1: {
                    try {
                        this.internal.run();
                    }
                    catch (RuntimeException runtimeException) {
                        this.err = runtimeException;
                    }
                    break;
                }
                case 2: {
                    while (!this.done) {
                        Object object = Display.lock;
                        synchronized (object) {
                            try {
                                Display.lock.wait(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    Display.getInstance().mainEDTLoop();
                    break;
                }
                case 4: {
                    while (!Display.getInstance().lwuitExited) {
                        Runnable runnable = null;
                        Object object = THREADPOOL_LOCK;
                        synchronized (object) {
                            if (threadPool.size() > 0) {
                                runnable = (Runnable)threadPool.elementAt(0);
                                threadPool.removeElementAt(0);
                            } else {
                                try {
                                    ++availableThreads;
                                    THREADPOOL_LOCK.wait();
                                    --availableThreads;
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                        if (runnable == null) continue;
                        runnable.run();
                    }
                    break;
                }
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushToThreadPool(Runnable runnable) {
        Object object;
        if (availableThreads == 0 && threadCount < maxThreadCount) {
            object = new Thread((Runnable)new RunnableWrapper(null, 4), "invokeAndBlock" + ++threadCount);
            ((Thread)object).start();
        }
        object = THREADPOOL_LOCK;
        synchronized (object) {
            threadPool.addElement(runnable);
            THREADPOOL_LOCK.notify();
        }
    }
}

