/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

public class Motion {
    static final int LINEAR = 0;
    static final int SPLINE = 1;
    int motionType;
    private static final int FRICTION = 2;
    private int sourceValue;
    private int destinationValue;
    private int duration;
    private long startTime;
    private float initVelocity;
    private float friction;
    private int lastReturnedValue;
    private long currentMotionTime = -1L;

    protected Motion(int n, int n2, int n3) {
        this.sourceValue = n;
        this.destinationValue = n2;
        this.duration = n3;
        this.lastReturnedValue = n;
    }

    protected Motion(int n, float f, float f2) {
        this.sourceValue = n;
        this.initVelocity = f;
        this.friction = f2;
        this.duration = (int)(Math.abs(f) / f2);
    }

    public static Motion createLinearMotion(int n, int n2, int n3) {
        Motion motion = new Motion(n, n2, n3);
        motion.motionType = 0;
        return motion;
    }

    public static Motion createSplineMotion(int n, int n2, int n3) {
        Motion motion = new Motion(n, n2, n3);
        motion.motionType = 1;
        return motion;
    }

    public static Motion createFrictionMotion(int n, int n2, float f, float f2) {
        Motion motion = new Motion(n, f, f2);
        motion.destinationValue = n2;
        motion.motionType = 2;
        return motion;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long getCurrentMotionTime() {
        if (this.currentMotionTime < 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.currentMotionTime;
    }

    public void setCurrentMotionTime(long l) {
        this.currentMotionTime = l;
        if (this.lastReturnedValue == this.destinationValue) {
            this.lastReturnedValue = this.sourceValue;
        }
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public boolean isFinished() {
        if (this.currentMotionTime < 0L) {
            return this.getCurrentMotionTime() > (long)this.duration || this.destinationValue == this.lastReturnedValue;
        }
        return this.getCurrentMotionTime() > (long)this.duration || this.destinationValue == this.lastReturnedValue;
    }

    private int getSplineValue() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float f = this.duration;
        float f2 = (int)this.getCurrentMotionTime();
        if (this.currentMotionTime > -1L) {
            f2 -= (float)this.startTime;
            f -= (float)this.startTime;
        }
        f2 = Math.min(f2, f);
        int n = Math.abs(this.destinationValue - this.sourceValue);
        float f3 = f / 2.0f;
        float f4 = (float)n / (f3 * f3);
        int n2 = this.sourceValue < this.destinationValue ? (f2 > f3 ? this.sourceValue + (int)(f4 * (-f3 * f3 + 2.0f * f3 * f2 - f2 * f2 / 2.0f)) : this.sourceValue + (int)(f4 * f2 * f2 / 2.0f)) : ((f2 = f - f2) > f3 ? this.destinationValue + (int)(f4 * (-f3 * f3 + 2.0f * f3 * f2 - f2 * f2 / 2.0f)) : this.destinationValue + (int)(f4 * f2 * f2 / 2.0f));
        return n2;
    }

    public int getValue() {
        if (this.currentMotionTime > -1L && this.startTime > this.getCurrentMotionTime()) {
            return this.sourceValue;
        }
        switch (this.motionType) {
            case 1: {
                this.lastReturnedValue = this.getSplineValue();
                break;
            }
            case 2: {
                this.lastReturnedValue = this.getFriction();
                break;
            }
            default: {
                this.lastReturnedValue = this.getLinear();
            }
        }
        return this.lastReturnedValue;
    }

    private int getLinear() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float f = this.duration;
        float f2 = (int)this.getCurrentMotionTime();
        if (this.currentMotionTime > -1L) {
            f2 -= (float)this.startTime;
            f -= (float)this.startTime;
        }
        int n = this.destinationValue - this.sourceValue;
        int n2 = (int)((float)this.sourceValue + f2 / f * (float)n);
        if (this.destinationValue < this.sourceValue) {
            return Math.max(this.destinationValue, n2);
        }
        return Math.min(this.destinationValue, n2);
    }

    private int getFriction() {
        int n = (int)this.getCurrentMotionTime();
        int n2 = 0;
        n2 = (int)(Math.abs(this.initVelocity) * (float)n - this.friction * ((float)n * (float)n / 2.0f));
        if (this.initVelocity < 0.0f) {
            n2 *= -1;
        }
        n2 += this.sourceValue;
        if (this.destinationValue > this.sourceValue) {
            return Math.min(n2, this.destinationValue);
        }
        return Math.max(n2, this.destinationValue);
    }

    public int getSourceValue() {
        return this.sourceValue;
    }

    public int getDestinationValue() {
        return this.destinationValue;
    }

    public void setSourceValue(int n) {
        this.sourceValue = n;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    public int getDuration() {
        return this.duration;
    }
}

