/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class ContainerList
extends Container {
    private CellRenderer renderer = new DefaultListCellRenderer();
    private ListModel model;
    private Listeners listener;
    private EventDispatcher dispatcher = new EventDispatcher();
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$com$sun$lwuit$list$CellRenderer;

    public ContainerList() {
        this(new DefaultListModel());
    }

    public ContainerList(ListModel listModel) {
        this.init(listModel);
    }

    private void init(ListModel listModel) {
        this.setModel(listModel);
        this.setUIID("ContainerList");
        this.setScrollableY(true);
    }

    public ContainerList(Layout layout, ListModel listModel) {
        super(layout);
        this.init(listModel);
    }

    public void setRenderer(CellRenderer cellRenderer) {
        this.renderer = cellRenderer;
        this.repaint();
    }

    public CellRenderer getRenderer() {
        return this.renderer;
    }

    private void updateComponentCount() {
        block4: {
            int n;
            int n2 = this.getComponentCount();
            if (n2 == (n = this.model.getSize())) break block4;
            if (n2 < n) {
                for (int i = n2; i < n; ++i) {
                    this.addComponent(new Entry());
                }
            } else {
                while (this.getComponentCount() > n) {
                    this.removeComponent(this.getComponentAt(this.getComponentCount() - 1));
                }
            }
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public void addActionListener(ActionListener actionListener) {
        this.dispatcher.addListener(actionListener);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.dispatcher.removeListener(actionListener);
    }

    protected void initComponent() {
        int n;
        if (this.model != null && (n = this.model.getSelectedIndex()) > 0) {
            this.getComponentAt(n).requestFocus();
        }
    }

    public void setModel(ListModel listModel) {
        if (this.model != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
        this.model = listModel;
        this.updateComponentCount();
        if (listModel.getSelectedIndex() > 0) {
            this.getComponentAt(listModel.getSelectedIndex()).requestFocus();
        }
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public Object getSelectedItem() {
        int n = this.model.getSelectedIndex();
        if (n > -1) {
            return this.model.getItemAt(n);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return new String[]{"ListItems", "Renderer"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ContainerList.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$com$sun$lwuit$list$CellRenderer == null ? (class$com$sun$lwuit$list$CellRenderer = ContainerList.class$("com.sun.lwuit.list.CellRenderer")) : class$com$sun$lwuit$list$CellRenderer};
    }

    public Object getPropertyValue(String string) {
        if (string.equals("ListItems")) {
            Object[] objectArray = new Object[this.model.getSize()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.model.getItemAt(i);
            }
            return objectArray;
        }
        if (string.equals("Renderer")) {
            return this.getRenderer();
        }
        return null;
    }

    public String setPropertyValue(String string, Object object) {
        if (string.equals("ListItems")) {
            this.setModel(new DefaultListModel((Object[])object));
            return null;
        }
        if (string.equals("Renderer")) {
            this.setRenderer((CellRenderer)object);
            return null;
        }
        return super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int n, int n2) {
            ContainerList.this.updateComponentCount();
        }

        public void selectionChanged(int n, int n2) {
            ContainerList.this.getComponentAt(n2).requestFocus();
        }
    }

    class Entry
    extends Component {
        private int offset;

        Entry() {
            this.setFocusable(true);
        }

        public void initComponent() {
            this.offset = this.getParent().getComponentIndex(this);
        }

        protected void focusGained() {
            ContainerList.this.model.setSelectedIndex(this.offset);
        }

        public void paintBackground(Graphics graphics) {
        }

        public void paintBorder(Graphics graphics) {
        }

        public void paint(Graphics graphics) {
            Component component = ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus());
            component.setX(this.getX());
            component.setY(this.getY());
            component.setWidth(this.getWidth());
            component.setHeight(this.getHeight());
            component.paintComponent(graphics);
        }

        public void pointerReleased(int n, int n2) {
            super.pointerReleased(n, n2);
            if (!this.isDragActivated()) {
                ContainerList.this.dispatcher.fireActionEvent(new ActionEvent(ContainerList.this, n, n2));
            }
        }

        public void keyReleased(int n) {
            super.keyReleased(n);
            if (Display.getInstance().getGameAction(n) == 8) {
                ContainerList.this.dispatcher.fireActionEvent(new ActionEvent(ContainerList.this, n));
            }
        }

        public Dimension calcPreferredSize() {
            return ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus()).getPreferredSize();
        }
    }
}

