/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class EventDispatcher {
    private boolean blocking = false;
    private Vector listeners;
    private Object[] pending;
    private Object pendingEvent;
    private static boolean fireStyleEventsOnNonEDT = false;
    private final Runnable callback = new CallbackClass();

    public static void setFireStyleEventsOnNonEDT(boolean bl) {
        fireStyleEventsOnNonEDT = bl;
    }

    public synchronized void addListener(Object object) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(object)) {
            this.listeners.addElement(object);
        }
    }

    public Vector getListenerVector() {
        return this.listeners;
    }

    public synchronized void removeListener(Object object) {
        if (this.listeners != null) {
            this.listeners.removeElement(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChangeEvent(int n, int n2) {
        DataChangedListener[] dataChangedListenerArray;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            dataChangedListenerArray = new DataChangedListener[this.listeners.size()];
            for (int i = 0; i < dataChangedListenerArray.length; ++i) {
                dataChangedListenerArray[i] = (DataChangedListener)this.listeners.elementAt(i);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireDataChangeSync(dataChangedListenerArray, n2, n);
        } else {
            this.pending = dataChangedListenerArray;
            this.pendingEvent = new int[]{n2, n};
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStyleChangeEvent(String string, Style style) {
        StyleListener[] styleListenerArray;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            styleListenerArray = new StyleListener[this.listeners.size()];
            for (int i = 0; i < styleListenerArray.length; ++i) {
                styleListenerArray[i] = (StyleListener)this.listeners.elementAt(i);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireStyleChangeSync(styleListenerArray, string, style);
        } else if (fireStyleEventsOnNonEDT) {
            this.pending = styleListenerArray;
            this.pendingEvent = new Object[]{string, style};
            Display.getInstance().callSerially(new CallbackClass());
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireDataChangeSync(DataChangedListener[] dataChangedListenerArray, int n, int n2) {
        for (int i = 0; i < dataChangedListenerArray.length; ++i) {
            dataChangedListenerArray[i].dataChanged(n, n2);
        }
    }

    private void fireStyleChangeSync(StyleListener[] styleListenerArray, String string, Style style) {
        for (int i = 0; i < styleListenerArray.length; ++i) {
            styleListenerArray[i].styleChanged(string, style);
        }
    }

    private void fireSelectionSync(SelectionListener[] selectionListenerArray, int n, int n2) {
        for (int i = 0; i < selectionListenerArray.length; ++i) {
            selectionListenerArray[i].selectionChanged(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActionEvent(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            actionListenerArray = new ActionListener[this.listeners.size()];
            for (int i = 0; i < actionListenerArray.length; ++i) {
                actionListenerArray[i] = (ActionListener)this.listeners.elementAt(i);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireActionSync(actionListenerArray, actionEvent);
        } else {
            this.pending = actionListenerArray;
            this.pendingEvent = actionEvent;
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionEvent(int n, int n2) {
        SelectionListener[] selectionListenerArray;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            selectionListenerArray = new SelectionListener[this.listeners.size()];
            for (int i = 0; i < selectionListenerArray.length; ++i) {
                selectionListenerArray[i] = (SelectionListener)this.listeners.elementAt(i);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireSelectionSync(selectionListenerArray, n, n2);
        } else {
            this.pending = selectionListenerArray;
            this.pendingEvent = new int[]{n, n2};
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireActionSync(ActionListener[] actionListenerArray, ActionEvent actionEvent) {
        for (int i = 0; i < actionListenerArray.length; ++i) {
            if (actionEvent.isConsumed()) continue;
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocus(Component component) {
        FocusListener[] focusListenerArray;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            focusListenerArray = new FocusListener[this.listeners.size()];
            for (int i = 0; i < focusListenerArray.length; ++i) {
                focusListenerArray[i] = (FocusListener)this.listeners.elementAt(i);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireFocusSync(focusListenerArray, component);
        } else {
            this.pending = focusListenerArray;
            this.pendingEvent = component;
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireFocusSync(FocusListener[] focusListenerArray, Component component) {
        if (component.hasFocus()) {
            for (int i = 0; i < focusListenerArray.length; ++i) {
                focusListenerArray[i].focusGained(component);
            }
        } else {
            for (int i = 0; i < focusListenerArray.length; ++i) {
                focusListenerArray[i].focusLost(component);
            }
        }
    }

    public boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean bl) {
        this.blocking = bl;
    }

    static /* synthetic */ Object[] access$202(EventDispatcher eventDispatcher, Object[] objectArray) {
        eventDispatcher.pending = objectArray;
        return objectArray;
    }

    class CallbackClass
    implements Runnable {
        private Object[] iPending;
        private Object iPendingEvent;

        public CallbackClass() {
            if (!EventDispatcher.this.blocking) {
                this.iPendingEvent = EventDispatcher.this.pendingEvent;
                this.iPending = EventDispatcher.this.pending;
            }
        }

        public final void run() {
            if (!Display.getInstance().isEdt()) {
                throw new IllegalStateException("This method should not be invoked by external code!");
            }
            if (EventDispatcher.this.blocking) {
                this.iPendingEvent = EventDispatcher.this.pendingEvent;
                this.iPending = EventDispatcher.this.pending;
            }
            if (this.iPending instanceof ActionListener[]) {
                EventDispatcher.this.fireActionSync((ActionListener[])this.iPending, (ActionEvent)this.iPendingEvent);
                return;
            }
            if (this.iPending instanceof FocusListener[]) {
                EventDispatcher.this.fireFocusSync((FocusListener[])this.iPending, (Component)this.iPendingEvent);
                return;
            }
            if (this.iPending instanceof DataChangedListener[]) {
                EventDispatcher.this.fireDataChangeSync((DataChangedListener[])this.iPending, ((int[])this.iPendingEvent)[0], ((int[])this.iPendingEvent)[1]);
                return;
            }
            if (this.iPending instanceof SelectionListener[]) {
                EventDispatcher.this.fireSelectionSync((SelectionListener[])this.iPending, ((int[])this.iPendingEvent)[0], ((int[])this.iPendingEvent)[1]);
                return;
            }
            if (this.iPending instanceof StyleListener[]) {
                Object[] objectArray = (Object[])this.iPendingEvent;
                EventDispatcher.this.fireStyleChangeSync((StyleListener[])this.iPending, (String)objectArray[0], (Style)objectArray[1]);
                EventDispatcher.this.pendingEvent = null;
                EventDispatcher.access$202(EventDispatcher.this, null);
                return;
            }
        }
    }
}

