/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import core.ListModel;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import framework.XMLParser;

public class SocialManager
implements ActionListener,
NetworkListener {
    XMLParser _xmlParser;
    Common _common;
    ListModel _listModel;
    Command cmdOpen;
    Command cmdBack;
    String _currSID;
    String _currGID;
    Form _frmMyLabels;
    Form _frmActivities;
    int _operation = -1;
    static int SHOW_LABELS = 1;
    static int SHOW_ACTIVITIES = 2;
    static int VIEW_STATUS = 3;
    static int POST_COMMENT = 4;
    static int POST_STATUS = 5;
    static int SHOW_LABEL_FEED = 6;

    public SocialManager(Common common) {
        this._common = common;
        this._listModel = new ListModel(common);
        this.cmdOpen = new Command("Open");
        this.cmdBack = new Command("Back");
    }

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == SHOW_LABELS) {
            this._listModel.buildList(string, "gid", "name", "size", false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            this._frmMyLabels = new Form();
            this._frmMyLabels.setTitle("My Labels");
            this._frmMyLabels.setScrollable(false);
            this._frmMyLabels.setLayout(new BorderLayout());
            this._frmMyLabels.addComponent("North", (Component)this._listModel.getList());
            this._frmMyLabels.addCommand(this.cmdOpen);
            this._frmMyLabels.addCommand(this.cmdBack);
            this._frmMyLabels.addCommandListener(this);
            this._common.showForm(this._frmMyLabels);
            this._common.backStack.push(this._frmMyLabels);
        } else if (this._operation == SHOW_ACTIVITIES) {
            this._listModel.buildList(string, "actid", "act", "tstamp", false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            this._frmActivities = new Form();
            this._frmActivities.setTitle("Activities");
            this._frmActivities.setScrollable(false);
            this._frmActivities.setLayout(new BorderLayout());
            if (this._listModel.getList().size() == 0) {
                this._frmActivities.addComponent("North", (Component)new Label("No recent activity"));
            } else {
                this._frmActivities.addComponent("North", (Component)this._listModel.getList());
            }
            this._frmActivities.addCommand(new Command(""));
            this._frmActivities.addCommand(this.cmdBack);
            this._frmActivities.addCommandListener(this);
            this._common.showForm(this._frmActivities);
        } else if (this._operation == VIEW_STATUS) {
            this._listModel.buildList(string, "cid", "ctext", null, false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            Form form = new Form();
            form.setTitle("Comment");
            form.setScrollable(false);
            form.setLayout(new BorderLayout());
            form.addComponent("North", (Component)this._listModel.getList());
            form.addCommand(this.cmdOpen);
            form.addCommand(this.cmdBack);
            form.addCommandListener(this);
            form.addCommand(new Command("Comment"));
            form.addCommand(this.cmdBack);
            form.addCommandListener(this);
            this._common.showForm(form);
        } else if (this._operation == POST_COMMENT) {
            if (string.indexOf("<msg>ok") != -1) {
                this._common.showDialog("Comment posted, refresh the screen to view", 0);
                this._common.backStack.removeAllElements();
            } else {
                this._common.showDialog("Unable to post your comment, try again", 0);
            }
        } else if (this._operation == POST_STATUS) {
            if (string.indexOf("<msg>ok") != -1) {
                this._common.showDialog("Update is posted, refresh the screen to view", 0);
                this._common.backStack.removeAllElements();
            } else {
                this._common.showDialog("Unable to post your update, try again", 0);
            }
        } else if (this._operation == SHOW_LABEL_FEED) {
            this._listModel.buildList(string, "sid", "stext", "uname", false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            Form form = new Form();
            form.setTitle("Label Feed");
            form.setScrollable(false);
            form.setLayout(new BorderLayout());
            form.addComponent("North", (Component)this._listModel.getList());
            form.addCommand(this.cmdOpen);
            form.addCommand(this.cmdBack);
            form.addCommandListener(this);
            form.addCommand(new Command("View"));
            form.addCommand(new Command("Share Update"));
            this._common.showForm(form);
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    public void showMyLabels() {
        this._common.setCurrentWindow(Common.MYGROUPS);
        this._operation = SHOW_LABELS;
        this._common.showProgress();
        this._listModel.fetchList("m_groups.php", "gid", "name", "size", false, this);
    }

    public void showActivities() {
        this._common.setCurrentWindow(Common.ACTIVITIES);
        this._operation = SHOW_ACTIVITIES;
        this._common.showProgress();
        this._listModel.fetchList("m_activities.php", "actid", "act", "tstamp", false, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("View")) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                this._common.showDialog("Unable to show this social update, try again", 0);
                return;
            }
            this._operation = VIEW_STATUS;
            this._common.showProgress();
            this._listModel.fetchList("m_groups.php?sid=" + string, "cid", "ctext", null, false, this);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Comment")) {
            this._common.showInputDialog("Write Comment");
            String string = this._common.txtDialogInput.getText();
            if (string == null || string.trim().equals("")) {
                return;
            }
            this._operation = POST_COMMENT;
            this._common.showProgress();
            Network.post2(Common._baseURL + "m_groups.php", "comment=" + string + "&gid=" + this._currGID + "&sid=" + this._currSID, true, (NetworkListener)this);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Share Update")) {
            this._common.showInputDialog("Share an Update");
            String string = this._common.txtDialogInput.getText();
            if (string == null || string.trim().equals("")) {
                return;
            }
            this._operation = POST_STATUS;
            this._common.showProgress();
            Network.post2(Common._baseURL + "m_groups.php", "status=" + string + "&gid=" + this._currGID, true, (NetworkListener)this);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdOpen) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                this._common.showDialog("Unable to open this item, try again1", 0);
            } else {
                this._operation = SHOW_LABEL_FEED;
                this._common.showProgress();
                this._listModel.fetchList("m_groups.php?gid=" + string, "sid", "stext", "uname", false, this);
            }
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }
}

