/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameCanvas
extends HALCanvas {
    int CELL_ANY_NUMBER;
    private static final boolean _$676 = true;
    static byte DISPLAYSIZE;
    static int HALFDISPLAY;
    final int RESULT_DUPLICATE;
    final int RESULT_HINT;
    final int RESULT_NOSOLUTION;
    final int RESULT_SOLVED;
    final int RESULT_UNKNOWN;
    static int SMALLSQUARE_X;
    static int SMALLSQUARE_Y;
    public static byte SQUARE_SIZE_X;
    static byte SQUARE_SIZE_Y;
    boolean cellSolved = false;
    byte doubleSize = 1;
    int errorCol = -1;
    int errorRow = -1;
    int errorSquare = -1;
    static Object foo;
    public boolean getHint = false;
    public boolean interrupted = false;
    private int[] _$1201;
    Image[] mini;
    MenuScreen ms;
    Image[] original = new Image[16];
    public boolean pencilMarks = false;
    int selCellX = 0;
    int selCellY = 0;
    int selSquareX = 0;
    int selSquareY = 0;
    Image[] solved = new Image[16];
    boolean solvingInProgress = false;
    int solvingResult = 0;
    Square[][] sudoku;

    static {
        foo = new Object();
        SQUARE_SIZE_X = 1;
        SQUARE_SIZE_Y = (byte)3;
        DISPLAYSIZE = (byte)19;
        HALFDISPLAY = DISPLAYSIZE / 2;
        SMALLSQUARE_X = (DISPLAYSIZE - 1) / SQUARE_SIZE_X;
        SMALLSQUARE_Y = (DISPLAYSIZE - 1) / SQUARE_SIZE_Y;
    }

    public GameCanvas(MenuScreen menuScreen) {
        this.mini = new Image[16];
        this._$1201 = new int[4];
        this.RESULT_DUPLICATE = 2;
        this.RESULT_NOSOLUTION = 3;
        this.RESULT_SOLVED = 1;
        this.RESULT_UNKNOWN = 4;
        this.RESULT_HINT = 5;
        this.ms = menuScreen;
        this.setFullScreenMode(true);
        int n = -1;
        try {
            if (this.height > 240 && this.width > 240) {
                this.doubleSize = (byte)2;
                n = 0;
                while (n < 16) {
                    this.solved[n] = Image.createImage((String)("/s" + (n + 1) + "L.png"));
                    this.original[n] = Image.createImage((String)("/o" + (n + 1) + "L.png"));
                    this.mini[n] = Image.createImage((String)("/m" + (n + 1) + "L.png"));
                    ++n;
                }
            } else {
                n = 0;
                while (n < 16) {
                    this.solved[n] = Image.createImage((String)("/s" + (n + 1) + ".png"));
                    this.original[n] = Image.createImage((String)("/o" + (n + 1) + ".png"));
                    this.mini[n] = Image.createImage((String)("/m" + (n + 1) + ".png"));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in loading images: " + n);
        }
    }

    void Solve() {
        System.out.println("Starting solving...");
        this.solvingInProgress = true;
        this.repaint();
        new SolverThread().run();
    }

    static /* synthetic */ void access$000(GameCanvas gameCanvas) {
        gameCanvas._$1247();
    }

    static /* synthetic */ void access$100(GameCanvas gameCanvas) {
        gameCanvas._$1249();
    }

    static /* synthetic */ void access$200(GameCanvas gameCanvas) {
        gameCanvas._$1250();
    }

    static /* synthetic */ void access$300(GameCanvas gameCanvas) {
        gameCanvas._$1251();
    }

    private void _$1250() {
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        if (this.sudoku[n][n2].cells[n3][n4] >> 25 != 0) {
                            int n5 = this.sudoku[n][n2].cells[n3][n4] & 0xFFF;
                            int n6 = 0;
                            while (n6 < SQUARE_SIZE_X) {
                                int n7 = 0;
                                while (n7 < SQUARE_SIZE_Y) {
                                    if ((n6 != n || n7 != n3) && this.sudoku[n6][n2].cells[n7][n4] >> 24 > 0 && (this.sudoku[n6][n2].cells[n7][n4] & 0xFFF) == (this.sudoku[n][n2].cells[n3][n4] & 0xFFF)) {
                                        System.out.println("Error, duplicate number found in row " + (n2 * SQUARE_SIZE_Y + n4));
                                        this.errorRow = n2 * SQUARE_SIZE_Y + n4;
                                        this.solvingResult = 2;
                                    }
                                    ++n7;
                                }
                                ++n6;
                            }
                            int n8 = 0;
                            while (n8 < SQUARE_SIZE_Y) {
                                int n9 = 0;
                                while (n9 < SQUARE_SIZE_X) {
                                    if ((n8 != n2 || n9 != n4) && this.sudoku[n][n8].cells[n3][n9] >> 24 > 0 && (this.sudoku[n][n8].cells[n3][n9] & 0xFFF) == (this.sudoku[n][n2].cells[n3][n4] & 0xFFF)) {
                                        System.out.println("Error, duplicate number found in col " + (n * SQUARE_SIZE_Y + n3));
                                        this.errorCol = n * SQUARE_SIZE_Y + n3;
                                        this.solvingResult = 2;
                                        return;
                                    }
                                    ++n9;
                                }
                                ++n8;
                            }
                            int n10 = 0;
                            while (n10 < SQUARE_SIZE_Y) {
                                int n11 = 0;
                                while (n11 < SQUARE_SIZE_X) {
                                    if ((n10 != n3 || n11 != n4) && this.sudoku[n][n2].cells[n10][n11] >> 24 > 0 && (this.sudoku[n][n2].cells[n10][n11] & 0xFFF) == (this.sudoku[n][n2].cells[n3][n4] & 0xFFF)) {
                                        System.out.println("Error, duplicate number " + (this.sudoku[n][n2].cells[n10][n11] & 0xFFF) + " found in square " + (n * SQUARE_SIZE_X + n2));
                                        this.errorSquare = n * SQUARE_SIZE_X + n2;
                                        this.solvingResult = 2;
                                        return;
                                    }
                                    ++n11;
                                }
                                ++n10;
                            }
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void _$1251() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < SQUARE_SIZE_X) {
            int n7 = 0;
            while (n7 < SQUARE_SIZE_Y) {
                n5 = 0;
                n4 = 0;
                while (n4 < SQUARE_SIZE_Y) {
                    n3 = 0;
                    while (n3 < SQUARE_SIZE_X) {
                        n5 |= this.sudoku[n6][n4].cells[n7][n3];
                        ++n3;
                    }
                    ++n4;
                }
                if ((n5 & 0xFFFFFF) != this.CELL_ANY_NUMBER) {
                    System.out.println("No solution in column " + (n6 * SQUARE_SIZE_X + n7) + " " + n5);
                    this.errorCol = n6 * SQUARE_SIZE_X + n7;
                    this.solvingResult = 3;
                    return;
                }
                ++n7;
            }
            ++n6;
        }
        n5 = 0;
        while (n5 < SQUARE_SIZE_Y) {
            n4 = 0;
            while (n4 < SQUARE_SIZE_X) {
                n3 = 0;
                n2 = 0;
                while (n2 < SQUARE_SIZE_X) {
                    n = 0;
                    while (n < SQUARE_SIZE_Y) {
                        n3 |= this.sudoku[n2][n5].cells[n][n4];
                        ++n;
                    }
                    ++n2;
                }
                if ((n3 & 0xFFFFFF) != this.CELL_ANY_NUMBER) {
                    System.out.println("No solution in row " + (n5 * SQUARE_SIZE_Y + n4) + " " + n3);
                    this.errorRow = n5 * SQUARE_SIZE_Y + n4;
                    this.solvingResult = 3;
                    return;
                }
                ++n4;
            }
            ++n5;
        }
        n3 = 0;
        while (n3 < SQUARE_SIZE_Y) {
            n2 = 0;
            while (n2 < SQUARE_SIZE_X) {
                n = 0;
                int n8 = 0;
                while (n8 < SQUARE_SIZE_X) {
                    int n9 = 0;
                    while (n9 < SQUARE_SIZE_Y) {
                        n |= this.sudoku[n2][n3].cells[n9][n8];
                        ++n9;
                    }
                    ++n8;
                }
                if ((n & 0xFFFFFF) != this.CELL_ANY_NUMBER) {
                    System.out.println("No solution in square " + (n3 * SQUARE_SIZE_Y + n2) + " " + n);
                    this.errorSquare = n3 * SQUARE_SIZE_Y + n2;
                    this.solvingResult = 3;
                    return;
                }
                ++n2;
            }
            ++n3;
        }
    }

    private void _$1245(int n, int n2, int n3, int n4) {
        if (this.sudoku[n][n2].cells[n3][n4] >> 25 > 0) {
            return;
        }
        int n5 = this.sudoku[n][n2].cells[n3][n4] & 0xFFF;
        int n6 = 0;
        while (n6 < SQUARE_SIZE_X) {
            int n7 = 0;
            while (n7 < SQUARE_SIZE_Y) {
                if ((n6 != n || n7 != n3) && this.sudoku[n6][n2].cells[n7][n4] >> 24 == 0) {
                    n5 &= ~(this.sudoku[n6][n2].cells[n7][n4] & 0xFFF);
                }
                ++n7;
            }
            ++n6;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((n5 >> n9 & 1) == 1) {
                ++n8;
            }
            ++n9;
        }
        if (n8 == 1) {
            System.out.println("single place found in row " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + this.sudoku[n][n2].cells[n3][n4]);
            this.sudoku[n][n2].cells[n3][n4] = 0x4000000 + n5;
            this.cellSolved = true;
            this._$1244(n, n2, n3, n4);
            return;
        }
        int n10 = n5;
        n5 = this.sudoku[n][n2].cells[n3][n4] & 0xFFF;
        int n11 = 0;
        while (n11 < SQUARE_SIZE_Y) {
            int n12 = 0;
            while (n12 < SQUARE_SIZE_X) {
                if ((n11 != n2 || n12 != n4) && this.sudoku[n][n11].cells[n3][n12] >> 24 == 0) {
                    n5 &= ~(this.sudoku[n][n11].cells[n3][n12] & 0xFFF);
                }
                ++n12;
            }
            ++n11;
        }
        n8 = 0;
        int n13 = 0;
        while (n13 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((n5 >> n13 & 1) == 1) {
                ++n8;
            }
            ++n13;
        }
        if (n8 == 1) {
            System.out.println("single place found in col " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + this.sudoku[n][n2].cells[n3][n4]);
            this.sudoku[n][n2].cells[n3][n4] = 0x4000000 + n5;
            this._$1244(n, n2, n3, n4);
            this.cellSolved = true;
            return;
        }
        n10 &= n5;
        n5 = this.sudoku[n][n2].cells[n3][n4] & 0xFFF;
        int n14 = 0;
        while (n14 < SQUARE_SIZE_Y) {
            int n15 = 0;
            while (n15 < SQUARE_SIZE_X) {
                if ((n14 != n3 || n15 != n4) && this.sudoku[n][n2].cells[n14][n15] >> 24 == 0) {
                    n5 &= ~(this.sudoku[n][n2].cells[n14][n15] & 0xFFF);
                }
                ++n15;
            }
            ++n14;
        }
        n8 = 0;
        int n16 = 0;
        while (n16 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((n5 >> n16 & 1) == 1) {
                ++n8;
            }
            ++n16;
        }
        if (n8 == 1) {
            System.out.println("single place found in square " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + this.sudoku[n][n2].cells[n3][n4]);
            this.sudoku[n][n2].cells[n3][n4] = 0x4000000 + n5;
            this._$1244(n, n2, n3, n4);
            this.cellSolved = true;
            return;
        }
        n5 &= n10;
        int n17 = 0;
        while (n17 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((n5 >> n17 & 1) == 1) {
                ++n8;
            }
            ++n17;
        }
        if (n8 == 1) {
            System.out.println("single value remaining for cell " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + this.sudoku[n][n2].cells[n3][n4]);
            this.sudoku[n][n2].cells[n3][n4] = 0x4000000 + n5;
            this._$1244(n, n2, n3, n4);
            this.cellSolved = true;
            return;
        }
    }

    private void _$1249() {
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        this._$1245(n, n2, n3, n4);
                        this.repaint();
                        if (this.cellSolved && this.getHint) {
                            System.out.println("checkSingularity hint found");
                            this._$1201[0] = n;
                            this._$1201[1] = n2;
                            this._$1201[2] = n3;
                            this._$1201[3] = n4;
                            return;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean _$1241(int n, int n2, int n3, int n4) {
        if (this.sudoku[n][n2].cells[n3][n4] >> 25 > 0) {
            return true;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((this.sudoku[n][n2].cells[n3][n4] >> n6 & 1) == 1) {
                ++n5;
            }
            ++n6;
        }
        if (n5 > 1) {
            return false;
        }
        System.out.println("Solved cell " + n + " " + n2 + " " + n3 + " " + n4 + " " + this.sudoku[n][n2].cells[n3][n4]);
        int[] nArray = this.sudoku[n][n2].cells[n3];
        int n7 = n4;
        nArray[n7] = nArray[n7] | 0x4000000;
        this.cellSolved = true;
        return true;
    }

    public void cleanUp() {
    }

    void clearAll() {
        this.sudoku = new Square[SQUARE_SIZE_X][SQUARE_SIZE_Y];
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                this.sudoku[n][n2] = new Square();
                this.sudoku[n][n2].cells = new int[SQUARE_SIZE_Y][SQUARE_SIZE_X];
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        this.sudoku[n][n2].cells[n3][n4] = this.CELL_ANY_NUMBER;
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.errorRow = -1;
        this.errorCol = -1;
        this.errorSquare = -1;
        this.solvingResult = 0;
    }

    private int _$1216(int n) {
        int n2 = 0;
        while (n2 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
            if ((n >> n2 & 1) == 1) {
                return n2 + 1;
            }
            ++n2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        if (!this.solvingInProgress) {
            if (this.solvingResult != 0) {
                if (this.solvingResult == 2 || this.solvingResult == 3 || this.solvingResult == 4) {
                    if (n == HALKeypad.KEY_BACK) {
                        this.ms.showInfo();
                    } else if (n == HALKeypad.KEY_SELECT) {
                        this.solvingResult = 0;
                        this.repaint();
                    }
                    return;
                }
                this.solvingResult = 0;
                this.repaint();
            }
            if (n == 49) {
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 11 ? 0x2000400 : 0x2000001;
                this.repaint();
                return;
            }
            if (n == 50) {
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 12 ? 0x2000800 : 0x2000002;
                this.repaint();
                return;
            }
            if (n == 51) {
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 13 ? 0x2001000 : 0x2000004;
                this.repaint();
                return;
            }
            if (n == 52) {
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 14 ? 0x2002000 : 0x2000008;
                this.repaint();
                return;
            }
            if (n == 53) {
                if (SQUARE_SIZE_X * SQUARE_SIZE_Y < 5) {
                    return;
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 15 ? 0x2004000 : 0x2000010;
                this.repaint();
                return;
            }
            if (n == 54) {
                if (SQUARE_SIZE_X * SQUARE_SIZE_Y < 6) {
                    return;
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 16 ? 0x2008000 : 0x2000020;
                this.repaint();
                return;
            }
            if (n == 55) {
                if (SQUARE_SIZE_X * SQUARE_SIZE_Y < 7) {
                    return;
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = 0x2000040;
                this.repaint();
                return;
            }
            if (n == 56) {
                if (SQUARE_SIZE_X * SQUARE_SIZE_Y < 8) {
                    return;
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = 0x2000080;
                this.repaint();
                return;
            }
            if (n == 57) {
                if (SQUARE_SIZE_X * SQUARE_SIZE_Y < 9) {
                    return;
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = 0x2000100;
                this.repaint();
                return;
            }
            if (n == 48) {
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] >> 25 > 0) {
                    this.resetUnsolved();
                }
                if (this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] == 0x2000001 && SQUARE_SIZE_X * SQUARE_SIZE_Y >= 10) {
                    this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = 0x2000200;
                } else {
                    this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.CELL_ANY_NUMBER;
                    this.resetUnsolved();
                }
                this.repaint();
                return;
            }
            if (n == HALKeypad.KEY_SELECT) {
                this.ms.showGameMenu();
                return;
            }
            if (n == HALKeypad.KEY_BACK) {
                this.ms.showSolveMenu();
                return;
            }
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    if (this.selCellY == 0) {
                        this.selSquareY = (this.selSquareY + SQUARE_SIZE_Y - 1) % SQUARE_SIZE_Y;
                        this.selCellY = SQUARE_SIZE_X - 1;
                    } else {
                        --this.selCellY;
                    }
                    this.repaint();
                    return;
                }
                case 6: {
                    if (this.selCellY == SQUARE_SIZE_X - 1) {
                        this.selSquareY = (this.selSquareY + SQUARE_SIZE_Y + 1) % SQUARE_SIZE_Y;
                        this.selCellY = 0;
                    } else {
                        ++this.selCellY;
                    }
                    this.repaint();
                    return;
                }
                case 2: {
                    if (this.selCellX == 0) {
                        this.selSquareX = (this.selSquareX + SQUARE_SIZE_X - 1) % SQUARE_SIZE_X;
                        this.selCellX = SQUARE_SIZE_Y - 1;
                    } else {
                        --this.selCellX;
                    }
                    this.repaint();
                    return;
                }
                case 5: {
                    if (this.selCellX == SQUARE_SIZE_Y - 1) {
                        this.selSquareX = (this.selSquareX + SQUARE_SIZE_X + 1) % SQUARE_SIZE_X;
                        this.selCellX = 0;
                    } else {
                        ++this.selCellX;
                    }
                    this.repaint();
                    return;
                }
                case 8: {
                    this.sudoku[this.selSquareX][this.selSquareY].cells[this.selCellX][this.selCellY] = this.CELL_ANY_NUMBER;
                    this.resetUnsolved();
                    this.repaint();
                    return;
                }
            }
        } else {
            if (n == HALKeypad.KEY_BACK) {
                this.solvingInProgress = false;
                this.repaint();
                return;
            }
            Object object = foo;
            synchronized (object) {
                foo.notify();
            }
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    boolean loadSettings() {
        byte[] byArray = SingleItemDB.load("Sudoku");
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            SQUARE_SIZE_X = dataInputStream.readByte();
            SQUARE_SIZE_Y = dataInputStream.readByte();
            DISPLAYSIZE = dataInputStream.readByte();
            this.pencilMarks = dataInputStream.readBoolean();
            this.resetToSize(SQUARE_SIZE_X, SQUARE_SIZE_Y);
            int n = 0;
            while (n < SQUARE_SIZE_X) {
                int n2 = 0;
                while (n2 < SQUARE_SIZE_Y) {
                    int n3 = 0;
                    while (n3 < SQUARE_SIZE_Y) {
                        int n4 = 0;
                        while (n4 < SQUARE_SIZE_X) {
                            this.sudoku[n][n2].cells[n3][n4] = dataInputStream.readInt();
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            MenuScreen.debug = MenuScreen.debug + "Exception loading settings: " + exception.toString() + "\n";
            return false;
        }
        return true;
    }

    public void newGame() {
        Display.getDisplay((MIDlet)GameMidlet.instance).setCurrent((Displayable)this);
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)0, (int)0));
        int n = graphics.getFont().getHeight();
        int n2 = this.getHeight() - n;
        int n3 = this.getWidth();
        int n4 = DISPLAYSIZE * this.selCellX + this.selSquareX * SQUARE_SIZE_Y * DISPLAYSIZE + DISPLAYSIZE / 2;
        int n5 = DISPLAYSIZE * this.selCellY + this.selSquareY * SQUARE_SIZE_X * DISPLAYSIZE + DISPLAYSIZE / 2;
        int n6 = n4 - n3 / 2;
        int n7 = n5 - n2 / 2;
        if (n3 >= DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X + 10) {
            n6 = DISPLAYSIZE * SQUARE_SIZE_X * SQUARE_SIZE_Y / 2 - n3 / 2;
        } else if (n6 <= -5) {
            n6 = -5;
        } else if (n6 + n3 > DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X + 5) {
            n6 = DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X - n3 + 5;
        }
        if (n2 >= DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X + 10) {
            n7 = DISPLAYSIZE * SQUARE_SIZE_X * SQUARE_SIZE_Y / 2 - n2 / 2;
        } else if (n7 <= -5) {
            n7 = -5;
        } else if (n7 + n2 > DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X + 5) {
            n7 = DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X - n2 + 5;
        }
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setClip(0, 0, n3, n2);
        graphics.setColor(0, 192, 0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.translate(0 - graphics.getTranslateX(), 0 - graphics.getTranslateY());
        graphics.translate(-n6, -n7);
        graphics.setColor(0, 0, 0);
        if (this.solvingResult == 2) {
            if (this.errorSquare > -1) {
                graphics.setColor(255, 128, 128);
                graphics.fillRect(DISPLAYSIZE * SQUARE_SIZE_X * (this.errorSquare % 3), DISPLAYSIZE * SQUARE_SIZE_X * (this.errorSquare / 3), DISPLAYSIZE * SQUARE_SIZE_X, DISPLAYSIZE * SQUARE_SIZE_Y);
                graphics.setColor(0, 0, 0);
            }
            if (this.errorRow > -1) {
                graphics.setColor(255, 128, 128);
                graphics.fillRect(0, DISPLAYSIZE * this.errorRow, DISPLAYSIZE * SQUARE_SIZE_X * SQUARE_SIZE_Y, (int)DISPLAYSIZE);
                graphics.setColor(0, 0, 0);
            }
            if (this.errorCol > -1) {
                graphics.setColor(255, 128, 128);
                graphics.fillRect(DISPLAYSIZE * this.errorCol, 0, (int)DISPLAYSIZE, DISPLAYSIZE * SQUARE_SIZE_X * SQUARE_SIZE_Y);
                graphics.setColor(0, 0, 0);
            }
        }
        if (this.getHint && this.solvingResult == 5) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(DISPLAYSIZE * this._$1201[2] + this._$1201[0] * SQUARE_SIZE_Y * DISPLAYSIZE + 1, DISPLAYSIZE * this._$1201[3] + this._$1201[1] * SQUARE_SIZE_X * DISPLAYSIZE + 1, (int)DISPLAYSIZE, (int)DISPLAYSIZE);
            graphics.setColor(200, 200, 200);
        }
        int n8 = 0;
        while (n8 < SQUARE_SIZE_X * SQUARE_SIZE_Y + 1) {
            if (n8 % SQUARE_SIZE_Y == 0) {
                graphics.setColor(0, 0, 0);
            } else {
                graphics.setColor(200, 200, 200);
            }
            graphics.drawLine(n8 * DISPLAYSIZE, 0, n8 * DISPLAYSIZE, DISPLAYSIZE * SQUARE_SIZE_X * SQUARE_SIZE_Y);
            ++n8;
        }
        int n9 = 0;
        while (n9 < SQUARE_SIZE_X * SQUARE_SIZE_Y + 1) {
            if (n9 % SQUARE_SIZE_X == 0) {
                graphics.setColor(0, 0, 0);
            } else {
                graphics.setColor(200, 200, 200);
            }
            graphics.drawLine(0, n9 * DISPLAYSIZE, DISPLAYSIZE * SQUARE_SIZE_Y * SQUARE_SIZE_X, n9 * DISPLAYSIZE);
            ++n9;
        }
        int n10 = 0;
        while (n10 < SQUARE_SIZE_X) {
            int n11 = 0;
            while (n11 < SQUARE_SIZE_Y) {
                int n12 = 0;
                while (n12 < SQUARE_SIZE_Y) {
                    int n13 = 0;
                    while (n13 < SQUARE_SIZE_X) {
                        try {
                            if ((this.sudoku[n10][n11].cells[n12][n13] >> 25 & 1) == 1) {
                                graphics.drawImage(this.original[this._$1216(this.sudoku[n10][n11].cells[n12][n13]) - 1], DISPLAYSIZE * n12 + n10 * SQUARE_SIZE_Y * DISPLAYSIZE + 1 + HALFDISPLAY, DISPLAYSIZE * n13 + n11 * SQUARE_SIZE_X * DISPLAYSIZE + 1 + HALFDISPLAY, 2 | 1);
                            } else if ((this.sudoku[n10][n11].cells[n12][n13] >> 26 & 1) == 1) {
                                graphics.drawImage(this.solved[this._$1216(this.sudoku[n10][n11].cells[n12][n13]) - 1], DISPLAYSIZE * n12 + n10 * SQUARE_SIZE_Y * DISPLAYSIZE + 1 + HALFDISPLAY, DISPLAYSIZE * n13 + n11 * SQUARE_SIZE_X * DISPLAYSIZE + 1 + HALFDISPLAY, 2 | 1);
                            } else if (this.pencilMarks) {
                                int n14 = 0;
                                while (n14 < SQUARE_SIZE_X) {
                                    int n15 = 0;
                                    while (n15 < SQUARE_SIZE_Y) {
                                        if ((this.sudoku[n10][n11].cells[n12][n13] >> n14 * SQUARE_SIZE_Y + n15 & 1) == 1) {
                                            graphics.drawImage(this.mini[n14 * SQUARE_SIZE_Y + n15], DISPLAYSIZE * n12 + n10 * SQUARE_SIZE_Y * DISPLAYSIZE + 1 + SMALLSQUARE_Y * n15, DISPLAYSIZE * n13 + n11 * SQUARE_SIZE_X * DISPLAYSIZE + 1 + SMALLSQUARE_X * n14, 0x10 | 4);
                                        }
                                        ++n15;
                                    }
                                    ++n14;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n13;
                    }
                    ++n12;
                }
                ++n11;
            }
            ++n10;
        }
        if (!this.solvingInProgress) {
            graphics.setColor(255, 0, 0);
            graphics.drawRect(DISPLAYSIZE * this.selCellX + this.selSquareX * SQUARE_SIZE_Y * DISPLAYSIZE + 1, DISPLAYSIZE * this.selCellY + this.selSquareY * SQUARE_SIZE_X * DISPLAYSIZE + 1, DISPLAYSIZE - 2, DISPLAYSIZE - 2);
            graphics.setColor(0, 0, 0);
            graphics.translate(0 - graphics.getTranslateX(), 0 - graphics.getTranslateY());
            graphics.setClip(0, 0, n3, this.getHeight());
            if (HALKeypad.SELECT_ON_LEFT) {
                if (this.solvingResult == 3 || this.solvingResult == 2 || this.solvingResult == 4) {
                    graphics.drawString(Texts.str[46], this.getWidth(), this.getHeight(), 8 | 0x20);
                    graphics.drawString(Texts.str[1], 1, this.getHeight(), 4 | 0x20);
                } else {
                    graphics.drawString(Texts.str[10], this.getWidth(), this.getHeight(), 8 | 0x20);
                    graphics.drawString(Texts.str[9], 1, this.getHeight(), 4 | 0x20);
                }
            } else if (this.solvingResult == 3 || this.solvingResult == 2 || this.solvingResult == 4) {
                graphics.drawString(Texts.str[46], 1, this.getHeight(), 4 | 0x20);
                graphics.drawString(Texts.str[1], this.getWidth(), this.getHeight(), 8 | 0x20);
            } else {
                graphics.drawString(Texts.str[10], 1, this.getHeight(), 4 | 0x20);
                graphics.drawString(Texts.str[9], this.getWidth(), this.getHeight(), 8 | 0x20);
            }
        } else {
            graphics.translate(0 - graphics.getTranslateX(), 0 - graphics.getTranslateY());
            graphics.setClip(0, 0, n3, this.getHeight());
            graphics.setColor(0, 0, 0);
            if (HALKeypad.SELECT_ON_LEFT) {
                graphics.drawString(Texts.str[13], this.getWidth(), this.getHeight(), 8 | 0x20);
            } else {
                graphics.drawString(Texts.str[13], 1, this.getHeight(), 4 | 0x20);
            }
        }
        if (this.solvingResult == 3) {
            this._$1229(Texts.str[47], graphics);
        } else if (this.solvingResult == 2) {
            this._$1229(Texts.str[48], graphics);
        } else if (this.solvingResult == 1) {
            this._$1229(Texts.str[49], graphics);
        } else if (this.solvingResult == 4) {
            this._$1229(Texts.str[50], graphics);
        }
    }

    void resetBoard() {
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        if (this.sudoku[n][n2].cells[n3][n4] >> 25 != 1) {
                            this.sudoku[n][n2].cells[n3][n4] = this.CELL_ANY_NUMBER;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.errorRow = -1;
        this.errorCol = -1;
        this.errorSquare = -1;
        this.solvingResult = 0;
    }

    void resetToSize(int n, int n2) {
        SQUARE_SIZE_X = (byte)n;
        SQUARE_SIZE_Y = (byte)n2;
        DISPLAYSIZE = SQUARE_SIZE_X * SQUARE_SIZE_Y > 9 && this.pencilMarks ? (byte)(this.doubleSize * 25) : (byte)(this.doubleSize * 19);
        HALFDISPLAY = DISPLAYSIZE / 2;
        SMALLSQUARE_X = (DISPLAYSIZE - 1) / SQUARE_SIZE_X;
        SMALLSQUARE_Y = (DISPLAYSIZE - 1) / SQUARE_SIZE_Y;
        this.sudoku = new Square[SQUARE_SIZE_X][SQUARE_SIZE_Y];
        try {
            this.CELL_ANY_NUMBER = 0;
            int n3 = 0;
            while (n3 < SQUARE_SIZE_X * SQUARE_SIZE_Y) {
                this.CELL_ANY_NUMBER = (this.CELL_ANY_NUMBER << 1) + 1;
                ++n3;
            }
            int n4 = 0;
            while (n4 < SQUARE_SIZE_X) {
                int n5 = 0;
                while (n5 < SQUARE_SIZE_Y) {
                    this.sudoku[n4][n5] = new Square();
                    int n6 = 0;
                    while (n6 < SQUARE_SIZE_Y) {
                        int n7 = 0;
                        while (n7 < SQUARE_SIZE_X) {
                            this.sudoku[n4][n5].cells[n6][n7] = this.CELL_ANY_NUMBER;
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n5;
                }
                ++n4;
            }
            this.selSquareX = 0;
            this.selSquareY = 0;
            this.selCellX = 0;
            this.selCellY = 0;
            this.resetBoard();
        }
        catch (Exception exception) {
            System.out.println("Exception in filling squares: " + exception);
        }
    }

    void resetUnsolved() {
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        if (this.sudoku[n][n2].cells[n3][n4] >> 25 == 0) {
                            this.sudoku[n][n2].cells[n3][n4] = this.CELL_ANY_NUMBER;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.errorRow = -1;
        this.errorCol = -1;
        this.errorSquare = -1;
        this.solvingResult = 0;
    }

    void saveSettings() {
        if (SQUARE_SIZE_X == 1) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(SQUARE_SIZE_X);
            dataOutputStream.writeByte(SQUARE_SIZE_Y);
            dataOutputStream.writeByte(DISPLAYSIZE);
            dataOutputStream.writeBoolean(this.pencilMarks);
            int n = 0;
            while (n < SQUARE_SIZE_X) {
                int n2 = 0;
                while (n2 < SQUARE_SIZE_Y) {
                    int n3 = 0;
                    while (n3 < SQUARE_SIZE_Y) {
                        int n4 = 0;
                        while (n4 < SQUARE_SIZE_X) {
                            dataOutputStream.writeInt(this.sudoku[n][n2].cells[n3][n4]);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            dataOutputStream.close();
            SingleItemDB.save("Sudoku", byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            MenuScreen.debug = MenuScreen.debug + "Exception saving settings: " + exception.toString() + "\n";
        }
    }

    private void _$1229(String string, Graphics graphics) {
        int n = graphics.getFont().getHeight();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(this.getWidth() / 2 - graphics.getFont().stringWidth(string) / 2 - 5, this.getHeight() / 2 - n * 2 / 3, graphics.getFont().stringWidth(string) + 10, n * 3 / 2);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(this.getWidth() / 2 - graphics.getFont().stringWidth(string) / 2 - 5, this.getHeight() / 2 - n * 2 / 3, graphics.getFont().stringWidth(string) + 10, n * 3 / 2);
        graphics.drawString(string, this.getWidth() / 2, this.getHeight() / 2 + n * 2 / 3, 1 | 0x20);
    }

    private void _$1247() {
        this.solvingResult = 1;
        this.cellSolved = false;
        int n = 0;
        while (n < SQUARE_SIZE_X) {
            int n2 = 0;
            while (n2 < SQUARE_SIZE_Y) {
                int n3 = 0;
                while (n3 < SQUARE_SIZE_Y) {
                    int n4 = 0;
                    while (n4 < SQUARE_SIZE_X) {
                        this._$1236(n, n2, n3, n4);
                        this.repaint();
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        int n5 = 0;
        while (n5 < SQUARE_SIZE_X) {
            int n6 = 0;
            while (n6 < SQUARE_SIZE_Y) {
                int n7 = 0;
                while (n7 < SQUARE_SIZE_Y) {
                    int n8 = 0;
                    while (n8 < SQUARE_SIZE_X) {
                        boolean bl = this._$1241(n5, n6, n7, n8);
                        if (!bl) {
                            this.solvingResult = 0;
                        }
                        this.repaint();
                        if (this.cellSolved && this.getHint) {
                            this._$1201[0] = n5;
                            this._$1201[1] = n6;
                            this._$1201[2] = n7;
                            this._$1201[3] = n8;
                            return;
                        }
                        ++n8;
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    private void _$1236(int n, int n2, int n3, int n4) {
        if (this.sudoku[n][n2].cells[n3][n4] >> 25 > 0) {
            return;
        }
        int n5 = 0;
        while (n5 < SQUARE_SIZE_X) {
            int n6 = 0;
            while (n6 < SQUARE_SIZE_Y) {
                if ((n5 != n || n6 != n3) && this.sudoku[n5][n2].cells[n6][n4] >> 25 > 0) {
                    int[] nArray = this.sudoku[n][n2].cells[n3];
                    int n7 = n4;
                    nArray[n7] = nArray[n7] & ~(this.sudoku[n5][n2].cells[n6][n4] & 0xFFF);
                }
                ++n6;
            }
            ++n5;
        }
        int n8 = 0;
        while (n8 < SQUARE_SIZE_Y) {
            int n9 = 0;
            while (n9 < SQUARE_SIZE_X) {
                if ((n8 != n2 || n9 != n4) && this.sudoku[n][n8].cells[n3][n9] >> 25 > 0) {
                    int[] nArray = this.sudoku[n][n2].cells[n3];
                    int n10 = n4;
                    nArray[n10] = nArray[n10] & ~(this.sudoku[n][n8].cells[n3][n9] & 0xFFF);
                }
                ++n9;
            }
            ++n8;
        }
        int n11 = 0;
        while (n11 < SQUARE_SIZE_Y) {
            int n12 = 0;
            while (n12 < SQUARE_SIZE_X) {
                if ((n11 != n3 || n12 != n4) && this.sudoku[n][n2].cells[n11][n12] >> 25 > 0) {
                    int[] nArray = this.sudoku[n][n2].cells[n3];
                    int n13 = n4;
                    nArray[n13] = nArray[n13] & ~(this.sudoku[n][n2].cells[n11][n12] & 0xFFF);
                }
                ++n12;
            }
            ++n11;
        }
    }

    void togglePencilMarks() {
        boolean bl = this.pencilMarks = !this.pencilMarks;
        if (DISPLAYSIZE == 25 * this.doubleSize && !this.pencilMarks) {
            DISPLAYSIZE = (byte)(this.doubleSize * 19);
        } else if (DISPLAYSIZE == 19 * this.doubleSize && this.pencilMarks && SQUARE_SIZE_X * SQUARE_SIZE_Y > 9) {
            DISPLAYSIZE = (byte)(this.doubleSize * 25);
        }
        HALFDISPLAY = DISPLAYSIZE / 2;
        SMALLSQUARE_X = (DISPLAYSIZE - 1) / SQUARE_SIZE_X;
        SMALLSQUARE_Y = (DISPLAYSIZE - 1) / SQUARE_SIZE_Y;
    }

    private void _$1244(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < SQUARE_SIZE_X) {
            int n6 = 0;
            while (n6 < SQUARE_SIZE_Y) {
                if ((n5 != n || n6 != n3) && this.sudoku[n5][n2].cells[n6][n4] >> 24 == 0) {
                    int[] nArray = this.sudoku[n5][n2].cells[n6];
                    int n7 = n4;
                    nArray[n7] = nArray[n7] & (this.sudoku[n5][n2].cells[n6][n4] & 0xF000 | ~(this.sudoku[n][n2].cells[n3][n4] & 0xFFF));
                }
                ++n6;
            }
            ++n5;
        }
        int n8 = 0;
        while (n8 < SQUARE_SIZE_Y) {
            int n9 = 0;
            while (n9 < SQUARE_SIZE_X) {
                if ((n8 != n2 || n9 != n4) && this.sudoku[n][n8].cells[n3][n9] >> 24 == 0) {
                    int[] nArray = this.sudoku[n][n8].cells[n3];
                    int n10 = n9;
                    nArray[n10] = nArray[n10] & (this.sudoku[n][n8].cells[n3][n9] & 0xF000 | ~(this.sudoku[n][n2].cells[n3][n4] & 0xFFF));
                }
                ++n9;
            }
            ++n8;
        }
        int n11 = 0;
        while (n11 < SQUARE_SIZE_Y) {
            int n12 = 0;
            while (n12 < SQUARE_SIZE_X) {
                if ((n11 != n3 || n12 != n4) && this.sudoku[n][n2].cells[n11][n12] >> 24 == 0) {
                    int[] nArray = this.sudoku[n][n2].cells[n11];
                    int n13 = n12;
                    nArray[n13] = nArray[n13] & (this.sudoku[n][n2].cells[n11][n12] & 0xF000 | ~(this.sudoku[n][n2].cells[n3][n4] & 0xFFF));
                }
                ++n12;
            }
            ++n11;
        }
    }

    class SolverThread
    extends Thread {
        SolverThread() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            do lbl-1000:
            // 3 sources

            {
                GameCanvas.access$000(GameCanvas.this);
                GameCanvas.this.serviceRepaints();
                if (GameCanvas.this.cellSolved && GameCanvas.this.getHint) {
                    GameCanvas.this.solvingResult = 5;
                    GameCanvas.this.solvingInProgress = false;
                    return;
                }
                if (GameCanvas.this.cellSolved) ** GOTO lbl-1000
                GameCanvas.access$100(GameCanvas.this);
                if (GameCanvas.this.solvingResult == 0) {
                    GameCanvas.access$200(GameCanvas.this);
                }
                if (GameCanvas.this.solvingResult == 0) {
                    GameCanvas.access$300(GameCanvas.this);
                }
                GameCanvas.this.serviceRepaints();
                if (!GameCanvas.this.cellSolved || !GameCanvas.this.getHint) continue;
                GameCanvas.this.solvingResult = 5;
                GameCanvas.this.solvingInProgress = false;
                return;
            } while (GameCanvas.this.cellSolved);
            if (GameCanvas.this.solvingResult == 0) {
                GameCanvas.this.solvingResult = 4;
            }
            GameCanvas.this.solvingInProgress = false;
            GameCanvas.this.repaint();
        }
    }

    class Square {
        int[][] cells = new int[SQUARE_SIZE_Y][SQUARE_SIZE_X];

        Square() {
        }
    }
}

