/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.DataFormatException;
import jazzlib.StreamManipulator;

public class InflaterHuffmanTree {
    private static final int MAX_BITLEN = 15;
    private short[] tree;
    public static InflaterHuffmanTree defLitLenTree;
    public static InflaterHuffmanTree defDistTree;
    private static final String bit4Reverse = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";

    public InflaterHuffmanTree(byte[] byArray) throws DataFormatException {
        this.buildTree(byArray);
    }

    private void buildTree(byte[] byArray) throws DataFormatException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        for (n8 = 0; n8 < byArray.length; ++n8) {
            n7 = byArray[n8];
            if (n7 <= 0) continue;
            int n9 = n7;
            nArray[n9] = nArray[n9] + 1;
        }
        n8 = 0;
        n7 = 512;
        for (n6 = 1; n6 <= 15; ++n6) {
            nArray2[n6] = n8;
            n8 += nArray[n6] << 16 - n6;
            if (n6 < 10) continue;
            n5 = nArray2[n6] & 0x1FF80;
            n4 = n8 & 0x1FF80;
            n7 += n4 - n5 >> 16 - n6;
        }
        if (n8 != 65536) {
            throw new DataFormatException("Code lengths don't add up properly.");
        }
        this.tree = new short[n7];
        n6 = 512;
        for (n5 = 15; n5 >= 10; --n5) {
            n4 = n8 & 0x1FF80;
            for (n3 = n2 = (n8 -= nArray[n5] << 16 - n5) & 0x1FF80; n3 < n4; n3 += 128) {
                this.tree[InflaterHuffmanTree.bitReverse((int)n3)] = (short)(-n6 << 4 | n5);
                n6 += 1 << n5 - 9;
            }
        }
        for (n5 = 0; n5 < byArray.length; ++n5) {
            n4 = byArray[n5];
            if (n4 == 0) continue;
            n2 = nArray2[n4];
            n3 = InflaterHuffmanTree.bitReverse(n2);
            if (n4 <= 9) {
                do {
                    this.tree[n3] = (short)(n5 << 4 | n4);
                } while ((n3 += 1 << n4) < 512);
            } else {
                int n10 = this.tree[n3 & 0x1FF];
                int n11 = 1 << (n10 & 0xF);
                n10 = -(n10 >> 4);
                do {
                    this.tree[n10 | n3 >> 9] = (short)(n5 << 4 | n4);
                } while ((n3 += 1 << n4) < n11);
            }
            nArray2[n4] = n2 + (1 << 16 - n4);
        }
    }

    public int getSymbol(StreamManipulator streamManipulator) throws DataFormatException {
        int n2;
        if ((streamManipulator.bits_in_buffer >= 9 ? streamManipulator.buffer & 0x1FF : (n2 = streamManipulator.window_start != streamManipulator.window_end ? (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 0x1FF : -1)) >= 0) {
            short s2 = this.tree[n2];
            if (s2 >= 0) {
                streamManipulator.buffer >>>= s2 & 0xF;
                streamManipulator.bits_in_buffer -= s2 & 0xF;
                return s2 >> 4;
            }
            int n3 = -(s2 >> 4);
            int n4 = s2 & 0xF;
            if ((streamManipulator.bits_in_buffer >= n4 ? streamManipulator.buffer & (1 << n4) - 1 : (n2 = streamManipulator.window_start != streamManipulator.window_end ? (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n4) - 1 : -1)) >= 0) {
                s2 = this.tree[n3 | n2 >> 9];
                streamManipulator.buffer >>>= s2 & 0xF;
                streamManipulator.bits_in_buffer -= s2 & 0xF;
                return s2 >> 4;
            }
            int n5 = streamManipulator.getAvailableBits();
            n2 = streamManipulator.bits_in_buffer >= n5 ? streamManipulator.buffer & (1 << n5) - 1 : (streamManipulator.window_start != streamManipulator.window_end ? (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n5) - 1 : -1);
            s2 = this.tree[n3 | n2 >> 9];
            if ((s2 & 0xF) <= n5) {
                streamManipulator.buffer >>>= s2 & 0xF;
                streamManipulator.bits_in_buffer -= s2 & 0xF;
                return s2 >> 4;
            }
            return -1;
        }
        int n6 = streamManipulator.getAvailableBits();
        n2 = streamManipulator.bits_in_buffer >= n6 ? streamManipulator.buffer & (1 << n6) - 1 : (streamManipulator.window_start != streamManipulator.window_end ? (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n6) - 1 : -1);
        short s3 = this.tree[n2];
        if (s3 >= 0 && (s3 & 0xF) <= n6) {
            streamManipulator.buffer >>>= s3 & 0xF;
            streamManipulator.bits_in_buffer -= s3 & 0xF;
            return s3 >> 4;
        }
        return -1;
    }

    static short bitReverse(int n2) {
        return (short)(bit4Reverse.charAt(n2 & 0xF) << 12 | bit4Reverse.charAt(n2 >> 4 & 0xF) << 8 | bit4Reverse.charAt(n2 >> 8 & 0xF) << 4 | bit4Reverse.charAt(n2 >> 12));
    }

    static {
        try {
            byte[] byArray = new byte[288];
            int n2 = 0;
            while (n2 < 144) {
                byArray[n2++] = 8;
            }
            while (n2 < 256) {
                byArray[n2++] = 9;
            }
            while (n2 < 280) {
                byArray[n2++] = 7;
            }
            while (n2 < 288) {
                byArray[n2++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(byArray);
            byArray = new byte[32];
            int n3 = 0;
            while (n3 < 32) {
                byArray[n3++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(byArray);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }
}

